
MAX_PATTERN equ 9
ENDMARK equ 128

KeyF1addr equ 64+#C000+28*64+26+#800*5 ; 1
KeyF2addr equ 64+#C000+29*64+30+#800*0 ; 2
KeyF3addr equ 64+#C000+28*64+34+#800*5 ; 3
KeyF4addr equ 64+#C000+26*64+25+#800*5 ; 4
KeyF5addr equ 64+#C000+26*64+30+#800*5 ; 5
KeyF6addr equ 64+#C000+26*64+35+#800*5 ; 6
KeyF7addr equ 64+#C000+24*64+26+#800*5 ; 7
KeyF8addr equ 64+#C000+24*64+30+#800*0 ; 8
KeyF9addr equ 64+#C000+24*64+34+#800*5 ; 9

      VIRGULE equ 64
POINT_VIRGULE equ 66
         PIPE equ 68

; === menu ===
; 1 demarrer
; 2 code
; 3 a propos
; 3 credits
; use numeric pad


; routine d'affichage de sprites 8x16









buildsna
bankset 0
org #38
ei:ret

run #100
org #100
ld hl,#C9FB : ld (#38),hl
ld sp,#100
ei
call razScr
ld hl,cubicScreenCRTC : call crtc_setup

call scankeyboard.init
call doFontConversion
call setColorz
ld hl,cell_motsEnFete : ld de,#0003 : call displayStringCell

ld hl,str_init01 : ld de,1+#C000+5*64        : call displayString
ld hl,str_init02 : ld de,1+#C000+6*64+4*#800 : call displayString
ld hl,str_init03 : ld de,0+#C000+8*64        : call displayString

ld hl,str_init04 : ld de,0+#C000+11*64        : call displayString
ld hl,str_init05 : ld de,0+#C000+12*64+4*#800 : call displayString
ld hl,str_init06 : ld de,0+#C000+14*64        : call displayString

ld hl,str_init07 : ld de,0+#C000+17*64        : call displayString
ld hl,str_init08 : ld de,0+#C000+18*64+4*#800 : call displayString
ld hl,str_init09 : ld de,0+#C000+20*64        : call displayString

ld hl,str_init10 : ld de,1+#C000+23*64        : call displayString
ld hl,str_init11 : ld de,0+#C000+24*64+4*#800 : call displayString
ld hl,str_init12 : ld de,0+#C000+26*64        : call displayString


.space call scankeyboard


ld hl,keyboardmap : xor a : ld b,10
.testTouche or (hl) : inc hl : djnz .testTouche
or a : jr z,.space
call refreshChoices.waitKeyboard
jp newGame


razScr
ld bc,#7F01 : out (c),c : ld a,#58 : out (c),a
inc c : out (c),c : out (c),a
inc c : out (c),c : out (c),a
ld hl,#C000 : xor a
.razScr repeat 8 : ld (hl),a : inc l : rend : jr nz,.razScr : inc h : jr nz,.razScr
;...
setColorz
ld hl,#4B46 : ld de,#5840
ld bc,#7F03
out (c),c : out (c),l : dec c
out (c),c : out (c),h : dec c
out (c),c : out (c),e : dec c
out (c),c : out (c),d : ld c,#10
out (c),c : out (c),d
ret



novbl ld b,#F5 : .loop in a,(c) : rra : jr c,.loop
vbl ld b,#F5 : .loop in a,(c) : rra : jr nc,.loop : ret

cubicScreenCRTC defb 6,32,1,32,2,42,7|0x80,34

doFontConversion
ld hl,fontChar
ld de,fontCharCell
ld b,hi(convertFont)
exx
ld bc,fontChar{26}+18-fontChar
.prepFont exx : ld c,(hl) : ld a,(bc) : ld (de),a : inc hl : inc de : exx : dec bc : ld a,b : or c : jr nz,.prepFont
ret

align 256
convertFont
repeat 256,x,0
	p1=x&%10001000
	p2=x&%1000100
	p3=x&%100010
	p4=x&%10001
	if !p1 : p1=%10001000 : endif
	if !p2 : p2=%1000100 : endif
	if !p3 : p3=%100010 : endif
	if !p4 : p4=%10001 : endif
	defb p1|p2|p3|p4
rend

align 256
charAddress
yoffset=0 ; pour se centrer (sprite de 3 bytes sur 18 lignes
repeat 15 ; 12 lignes de 20 pixels
	xoffset=0 ; on peut pas partir de 1.5 ...
	repeat 16 ; 16 grandes cases de 4 octets
		scrAdr=#C000+xoffset+(yoffset>>3)*64+(yoffset%8)*0x800
		defw scrAdr
		xoffset+=4
	rend
	repeat 16 : defw 0 : rend
	yoffset+=16
rend

align 2
charLine
yoffset=0 ; pour se centrer (sprite de 3 bytes sur 18 lignes
repeat 15 ; 12 lignes de 20 pixels
	scrAdr=#C000+(yoffset>>3)*64+(yoffset%8)*0x800
	defw scrAdr
	yoffset+=16
rend

include 'arkosSetupCRTC.asm'

align 256
fontChar
repeat 27,cpos,0
	fontChar{cpos}
	incbin 'terminalFont8x9.bin',cpos*20,18
	if ($&0xFF)>256-18 : align 256 : print 'adjust',cpos : endif
rend

align 256
fontOffset
repeat 27,x,0
defw fontChar{x}
rend

align 256
fontCharCell
repeat 27,cpos,0
	fontCharCell{cpos}
	incbin 'terminalFont8x9.bin',cpos*20,18
	if ($&0xFF)>256-18 : align 256 : print 'adjust',cpos : endif
rend

align 256
fontOffsetCell
repeat 27,x,0
defw fontCharCell{x}
rend

; A=char
; DE=Y/X
displayCharCell
sla e : sla e : sla e : srl de : srl de : ld hl,charAddress : add hl,de
ld e,(hl) : inc l : ld d,(hl) ; DE=destination on screen
displayCharCellAt ; run this with DE already set!
ld h,hi(fontOffsetCell) : ld l,a : ld a,(hl) : inc l : ld h,(hl) : ld l,a ; HL=char address

inc e : ld a,#FF : ld (de),a : inc e : ld (de),a : dec e : dec e
ld a,d : add 8 : ld d,a : jr nc,.pushNextPP
ld a,64 : add e : ld e,a : ld a,d : adc #C0 : ld d,a
.pushNextPP

ld a,(de) : or %110011 : ld (de),a : inc e : ld a,#FF : ld (de),a : inc e : ld (de),a : inc e : ld a,(de) : or %11001100 : ld (de),a : dec e : dec e : dec e
ld a,d : add 8 : ld d,a : jr nc,.pushNextP
ld a,64 : add e : ld e,a : ld a,d : adc #C0 : ld d,a
.pushNextP

ld b,9
.pushLine
ld a,(de) : or %110011 : ld (de),a : inc e : ld a,(hl) : inc l : ld (de),a : inc e : ld a,(hl) : inc l : ld (de),a : inc e : ld a,(de) : or %11001100 : ld (de),a : dec e : dec e : dec e
ld a,d : add 8 : ld d,a : jr nc,.pushNext
ld a,64 : add e : ld e,a : ld a,d : adc #C0 : ld d,a
.pushNext
djnz .pushLine

; LastLine
ld a,(de) : or %110011 : ld (de),a : inc e : ld a,#FF : ld (de),a : inc e : ld (de),a : inc e : ld a,(de) : or %11001100 : ld (de),a : dec e : dec e : dec e
ld a,d : add 8 : ld d,a : jr nc,.pushNextD
ld a,64 : add e : ld e,a : ld a,d : adc #C0 : ld d,a
.pushNextD
inc e : ld a,#FF : ld (de),a : inc e : ld (de),a
ret


; A=char
; DE=screen destination
displayChar
ld h,hi(fontOffset) : ld l,a : ld a,(hl) : inc l : ld h,(hl) : ld l,a ; HL=char address
ld b,8
.pushLine
ld a,(hl) : inc l : ld (de),a : inc e : ld a,(hl) : inc l : ld (de),a : dec e
ld a,d : add 8 : ld d,a : jr nc,.pushNext
ld a,64 : add e : ld e,a : ld a,d : adc #C0 : ld d,a
.pushNext
djnz .pushLine
ld a,(hl) : inc l : ld (de),a : inc e : ld a,(hl) : ld (de),a ; LastLine
ret



; HL=string
; DE=screen destination
displayString
ld a,(hl) : add a : ret c : push de,hl
call displayChar
pop hl,de : inc hl : inc e : inc e : jr displayString

; HL=string
; DE=X/Y
displayStringCell
ld a,(hl) : add a : ret c : push de,hl
call displayCharCell
pop hl,de : inc hl : inc e : jr displayStringCell






;*************************************************************
                            newGame
;*************************************************************
ld hl,lexiLevel1 : ld (lexiCurrentLevel),hl
;*************************************************************
                           initGame
;*************************************************************
ld sp,#100
xor a : ld (niveauAide),a
ld hl,(lexiCurrentLevel)
ld a,(hl) : cp PIPE : jp z,winZeGame


ld ix,levelUP.levelADR : ld iy,levelUP.levelSTR : ld de,hl
.trouveNiveau ld hl,(ix+0) : ld a,h : or l : jr z,.retourNormale : sbc hl,de : jr z,.messageNiveau : inc ix : inc ix : inc iy : inc iy : jr .trouveNiveau
.messageNiveau
call razScr
ld hl,(iy+0) : ld de,#C000+64*15+18 : call displayString
ld bc,2 : .msgWait halt : djnz .msgWait : dec c : jr nz,.msgWait

.retourNormale
ld hl,(lexiCurrentLevel)
ld a,VIRGULE : ld b,0
.countChoices cp (hl) : jr z,.countDone : inc hl : inc b : jr .countChoices : .countDone
ld a,b : ld (nbChoices),a
; en fonction du nombre de lettres on affiche un panneau de controle different + infos pour la saisie
ld hl,buildChoiceList : add a : ld e,a : ld d,0 : add hl,de : ld a,(hl) : inc l : ld h,(hl) : ld l,a : jp (hl)
retourInitChoice

ld hl,tailleEntrees : ld de,hl : inc de : ld bc,21 : ld (hl),0 : ldir ; raz entries + extra zero
; parsing des mots pour construire le visuel
ld iy,tailleEntrees : ld xl,0
ld hl,(lexiCurrentLevel) : ld d,0 : ld a,(nbChoices) : inc a : ld e,a : add hl,de ; se positionner sur le premier mot
; compter les longueurs
.scanEntrees  ld b,0
.scanEntree   ld a,(hl) : cp POINT_VIRGULE : jr z,.scanTermine : cp VIRGULE : jr z,.scanEntreeOK : inc b : inc hl : jr .scanEntree
.scanEntreeOK ld (iy+0),b : inc xl : inc iy : inc hl : jr .scanEntrees
.scantermine  ld (iy+0),b : inc xl ; dernière entrée
ld a,xl : ld (nombreMots),a
ld a,b : ld (longueurMax),a ; car la longueur MAX peut être inférieure au nombre de lettres

; build HUD cell positions
.buildHUDcellPositions
ld de,#C000+23*64 : ld a,(longueurMax) : sub 3 : add a : ld c,a : ld a,26 : sub c : add e : ld e,a
ld hl,hud1addr : ld bc,4 : ld a,(longueurMax)
.loop
	ld (hl),e : inc hl
	ld (hl),d : inc hl
	ex hl,de : add hl,bc : ex hl,de
	dec a : jr nz,.loop

ld hl,(lexiCurrentLevel) : ld de,referencePattern : ld b,0 : ld a,(nbChoices) : ld c,a : ldir ; copier le motif de jeu
ld a,(nbChoices) : ld b,a : ld a,MAX_PATTERN : sub b : jr z,.skipRaz : ld b,a : xor a : .razNext ld (de),a : inc de : djnz .razNext ; normalement inutile mais...   ceinture/bretelles!
.skipRaz
call initBoard

;*************************************************************
                           gameLoop
;*************************************************************
call controleClavier

ld hl,tailleEntrees : ld b,21 : xor a
.controleGagne or (hl) : inc hl : djnz .controleGagne
or a : jp z,niveauSuivant

jp gameLoop


;*************************************************************
                        niveauSuivant
;*************************************************************
ld hl,#C000+22*64
ld c,80
.razLines xor a : ld b,64 : push hl
.razLine ld (hl),a : inc l : djnz .razLine : pop hl
ld a,h : add 8 : ld h,a : jr nc,.next
ld a,64 : add l : ld l,a : ld a,#C0 : adc h : ld h,a : res 3,h 
.next
dec c : jr nz,.razLines

ld ix,(bravoList)
ld hl,(ix+0) : ld (bravoList),hl
ld hl,(ix+2) : ld de,#C000+27*64+13 : call displayString

ld bc,2
.rewait halt : djnz .rewait : dec c : jr nz,.rewait

.GOTOleSuivant
ld hl,(lexiCurrentLevel)
.scanEnd ld a,(hl) : cp POINT_VIRGULE : jr z,.leSuivant : inc hl : jr .scanEnd
.leSuivant
inc hl : ld a,(hl) : cp PIPE : jr z,winZeGame
ld (lexiCurrentLevel),hl
jp initGame

;*************************************************************
                           winZeGame
;*************************************************************
ld hl,lexiLevel1 : ld (lexiCurrentLevel),hl
; afficher une fin
call razScr
ld hl,str_win01 : ld de,0+#C000+16*64+2        : call displayString
; menu
ld bc,5
.waiteur halt : djnz .waiteur : dec c : jr nz,.waiteur
jp #100

;*************************************************************
                        controleClavier
;*************************************************************
;.automate ld a,0 : inc a : and 3 : ld (.automate+1),a : jp nz,aideAuJoueur : jp niveauSuivant.GOTOleSuivant
call scankeyboard
ld hl,(KeyF1char) : ld a,(hl) : cp #FF : jr z,.skipF1 : ld a,(KEY_F1_BYTE) : and KEY_F1_BIT : jp nz,addCharToHud : .skipF1
ld hl,(KeyF2char) : ld a,(hl) : cp #FF : jr z,.skipF2 : ld a,(KEY_F2_BYTE) : and KEY_F2_BIT : jp nz,addCharToHud : .skipF2
ld hl,(KeyF3char) : ld a,(hl) : cp #FF : jr z,.skipF3 : ld a,(KEY_F3_BYTE) : and KEY_F3_BIT : jp nz,addCharToHud : .skipF3
ld hl,(KeyF4char) : ld a,(hl) : cp #FF : jr z,.skipF4 : ld a,(KEY_F4_BYTE) : and KEY_F4_BIT : jp nz,addCharToHud : .skipF4
ld hl,(KeyF5char) : ld a,(hl) : cp #FF : jr z,.skipF5 : ld a,(KEY_F5_BYTE) : and KEY_F5_BIT : jp nz,addCharToHud : .skipF5
ld hl,(KeyF6char) : ld a,(hl) : cp #FF : jr z,.skipF6 : ld a,(KEY_F6_BYTE) : and KEY_F6_BIT : jp nz,addCharToHud : .skipF6
ld hl,(KeyF7char) : ld a,(hl) : cp #FF : jr z,.skipF7 : ld a,(KEY_F7_BYTE) : and KEY_F7_BIT : jp nz,addCharToHud : .skipF7
ld hl,(KeyF8char) : ld a,(hl) : cp #FF : jr z,.skipF8 : ld a,(KEY_F8_BYTE) : and KEY_F8_BIT : jp nz,addCharToHud : .skipF8
ld hl,(KeyF9char) : ld a,(hl) : cp #FF : jr z,.skipF9 : ld a,(KEY_F9_BYTE) : and KEY_F9_BIT : jp nz,addCharToHud : .skipF9
ld a,(KEY_SPACE_BYTE) : and KEY_SPACE_BIT : jp nz,verificationMot
ld a,(KEY_ENTER_BYTE) : and KEY_ENTER_BIT : jp nz,verificationMot
ld a,(KEY_RETURN_BYTE) : and KEY_RETURN_BIT : jp nz,verificationMot
ld a,(KEY_TAB_BYTE) : and KEY_TAB_BIT : jp nz,niveauSuivant.GOTOleSuivant
ld a,(KEY_ESC_BYTE) : and KEY_ESC_BIT : jp nz,levelUP
ld a,(KEY_H_BYTE) : and KEY_H_BIT : jp nz,aideAuJoueur
ret

addCharToHud
ld a,(hl) ; on récupère la valeur de la touche
ld (hl),0 : push hl ; d'abord on met à zéro pour effacer la touche
ld hl,(workPosition) : ld (hl),a : inc hl : ld (workPosition),hl ; on ajoute au HUD
call refreshChoices ; update display
pop hl : ld (hl),#FF ; et ensuite on inhibe après affichage!!!
ld hl,workPattern : ld d,0 : ld a,(longueurMax) : dec a : ld e,a : add hl,de : ld a,(hl) : or a : ret z
jp verificationMot

include 'keyboard.asm'

;*************************************************************
			verificationMot
;*************************************************************
; comparer le contenu du HUD avec les entrées
ld hl,(lexiCurrentLevel) : ld d,0 : ld a,(nbChoices) : ld e,a : inc e : add hl,de ; HL=debut des mots

ld xl,-1
.recompare
ld de,workPattern : inc xl
.compareMot ld a,(de) : cp (hl) : jr nz,.difference : inc de : inc hl : jr .compareMot ; petera toujours car la fin du mot est une virgule, un point-virgule et de l'autre côté un zéro
.difference ld a,(de) : or a : jr z,.finHud
; pas la fin du HUD, passer au mot suivant et recommencer
.motSuivant ld a,(hl) : inc hl : cp VIRGULE : jr z,.recompare : cp POINT_VIRGULE : jr z,.rienTrouve : jr .motSuivant

.finHud
ld a,(hl) : cp VIRGULE : jr z,.cestOK : cp POINT_VIRGULE : jr nz,.motSuivant ; fin du HUD mais pas d'un mot, on recommence (trop court!)
.cestOK
; XL=numéro du mot!!!
; se repositionner sur le début du mot
dec hl
.retourAuDebut ld a,(hl) : cp VIRGULE : jr z,.debutOK : dec hl : jr .retourAuDebut
.debutOK : inc hl ; HL=debut du mot
ld iy,tailleEntrees : ld a,xl : add yl : ld yl,a : ld a,yh : adc 0 : ld yh,a ; (IY) contient la longueur du mot
ld a,(iy+0) : or a : jp z,.rienTrouve ; zéro == déjà trouvé
ld xh,0 : add ix,ix : ld de,posEntrees : add ix,de : ld de,(ix+0) ; DE=position ecran du mot

.afficherMotEnPlace ld a,(hl) : push de,hl : call displayCharCellAt : pop hl,de : inc de : inc de : inc de : inc de : inc hl : dec (iy+0) : jr nz,.afficherMotEnPlace

.rienTrouve
; reset du HUD, des buffers
ld hl,referencePattern : ld de,currentPattern : ld bc,MAX_PATTERN : ldir
ld hl,workPattern : ld de,workPattern+1 : ld (hl),0 : ld bc,MAX_PATTERN-1 : ldir
ld hl,workPattern : ld (workPosition),hl
; reset affichage
jp refreshChoices


;*************************************************************
                         aideAuJoueur
;*************************************************************
ld ix,(lexiCurrentLevel) : ld d,0 : ld a,(nbChoices) : ld e,a : inc e : add ix,de ; IX=debut des mots
ld iy,tailleEntrees
xor a : exa
.reLoop
ld a,0 : niveauAide=$-1
cp (iy+0) : jr nc,.nextWord
; le mot a venir n'est pas trop court
add xl : ld xl,a : ld a,xh : adc 0 : ld xh,a : ld hl,posEntrees : exa : ld c,a : exa : ld b,0 : add hl,bc : add hl,bc : ld e,(hl) : inc hl : ld d,(hl)
ld h,0 : ld a,(niveauAide) : ld l,a : add hl,hl : add hl,hl : add hl,de : ex hl,de ; DE=position de la lettre
ld a,(ix+0) : call displayCharCellAt
.nextWord
ld a,POINT_VIRGULE : cp (ix+0) : jr z,.finAide
ld a,VIRGULE : cp (ix+0) : jr z,.nextNext
inc ix
jr .nextWord
.nextNext
inc ix
exa : inc a : exa ; increment word index
inc iy
jr .reLoop

.finAide
ld a,(niveauAide)
inc a
ld (niveauAide),a
ld c,a : ld a,(longueurMax) : cp c
jp z,niveauSuivant
; desactiver les mots aussi longs que l'aide : C
ld hl,tailleEntrees : ld b,21
.disableEntries ld a,(hl) : cp c : jr nz,.disableNext : ld (hl),0 : .disableNext inc hl : djnz .disableEntries
call refreshChoices
ret

;*************************************************************
			  initBoard
;*************************************************************
call razScr

ld hl,referencePattern : ld de,currentPattern : ld bc,MAX_PATTERN : ldir
ld hl,workPattern : ld de,workPattern+1 : ld (hl),0 : ld bc,MAX_PATTERN-1 : ldir
ld hl,workPattern : ld (workPosition),hl

ld iy,tailleEntrees
ld ix,charLine
ld de,posEntrees
ld a,(nombreMots) : cp 11 : jp c,.dixOuMoins
;=====================================================
; deux colonnes!
;=====================================================
.deuxColonnes
ld a,32 : ld (leCentre),a ; defaut
ld a,(nombreMots) : srl a : ld (hauteurColonne),a
dec a ; connaitre la longueur du dernier mot de la première colonne
push iy : pop hl : add l : ld l,a : ld a,h : adc 0 : ld h,a : ld a,(hl) : ld (longueurColonneGauche),a
ld a,(hauteurColonne) : add a : dec a : push iy : pop hl : add l : ld l,a : ld a,h : adc 0 : ld h,a : ld a,(hl) : ld (longueurColonneDroite),a

ld hl,longueurColonneGauche : sub (hl) : jp z,.MaxCentre ; colonnes de même largeur
ld b,a : ld a,32 : sub b : sub b : ld (leCentre),a

.MaxCentre
; centrage vertical
ld a,(nombreMots) : and 1 : ld b,a
ld a,(hauteurColonne) : add b ; hauteur totale
ld b,a : ld a,11 : sub b : srl a : jr z,.doubleDix
.doubleCentre inc ix : inc ix : dec a : jr nz,.doubleCentre
.doubleDix
push ix ; la deuxième colonne repartira de la même position Y
ld a,(hauteurColonne)
.doubleLoopGauche
; ajuster la position en fonction de la longueur
exa
ld a,(iy+0) : inc iy : add a : add a : ld c,a : ld a,(leCentre) : sub c
ld hl,(ix+0) : inc ix : inc ix : add l : ld l,a : ex hl,de : ld (hl),e : inc l : ld (hl),d : inc hl : ex hl,de
exa : dec a : jr nz,.doubleLoopGauche

.doDroite
ld a,(longueurColonneDroite) : cp 8 : ld a,(leCentre) : jr c,.add2
cp 32 : jr z,.auCentre
.add2
add 2 : ld (leCentre),a ; petit espace
.auCentre
pop ix
ld a,(hauteurColonne)
.doubleLoopDroite
exa
ld a,(leCentre) : inc iy ; on doit sauter dans les longueurs même si on ne s'en sert pas ici...
ld hl,(ix+0) : inc ix : inc ix : add l : ld l,a : ex hl,de : ld (hl),e : inc l : ld (hl),d : inc hl : ex hl,de
exa : dec a : jr nz,.doubleLoopdroite
; reste-il une dernière case? factocode
jp .dixPile

;=====================================================
; une seule colonne
;=====================================================
.dixOuMoins ; centrer dans les deux axes!
ld b,a : ld a,11 : sub b : srl a : jr z,.dixPile
.dixCentre inc ix : inc ix : dec a : jr nz,.dixCentre
.dixPile
; ajuster la position en fonction de la longueur
ld a,(iy+0) : inc iy : or a : jr z,.endPosColonnes : sub 3 : add a : ld c,a : ld a,26 : sub c
ld hl,(ix+0) : inc ix : inc ix : add l : ld l,a : ex hl,de : ld (hl),e : inc l : ld (hl),d : inc hl : ex hl,de
jr .dixPile
.endPosColonnes

;--------------------------
; afficher les cases vides
;--------------------------
ld ix,posEntrees
ld iy,tailleEntrees
.afficheMap
ld a,(iy+0) : or a : jr z,.mapOK : inc iy
ld de,(ix+0) : inc ix : inc ix : ld b,a
.afficheSubMap ld a,0 : push bc,de : call displayCharCellAt : pop de,bc : ld hl,4 : add hl,de : ex hl,de : djnz .afficheSubMap
jr .afficheMap

.mapOK
call refreshChoices ; update
ret

leCentre defb 0
hauteurColonne defb 0
longueurColonneGauche defb 0
longueurColonneDroite defb 0


;*************************************************************
                        refreshChoices
;*************************************************************
ld hl,(KeyF1char) : ld a,(hl) : cp #FF : jr z,.skipF1 : ld de,KeyF1addr : call displayCharCellAt : .skipF1
ld hl,(KeyF2char) : ld a,(hl) : cp #FF : jr z,.skipF2 : ld de,KeyF2addr : call displayCharCellAt : .skipF2
ld hl,(KeyF3char) : ld a,(hl) : cp #FF : jr z,.skipF3 : ld de,KeyF3addr : call displayCharCellAt : .skipF3
ld hl,(KeyF4char) : ld a,(hl) : cp #FF : jr z,.skipF4 : ld de,KeyF4addr : call displayCharCellAt : .skipF4
ld hl,(KeyF5char) : ld a,(hl) : cp #FF : jr z,.skipF5 : ld de,KeyF5addr : call displayCharCellAt : .skipF5
ld hl,(KeyF6char) : ld a,(hl) : cp #FF : jr z,.skipF6 : ld de,KeyF6addr : call displayCharCellAt : .skipF6
ld hl,(KeyF7char) : ld a,(hl) : cp #FF : jr z,.skipF7 : ld de,KeyF7addr : call displayCharCellAt : .skipF7
ld hl,(KeyF8char) : ld a,(hl) : cp #FF : jr z,.skipF8 : ld de,KeyF8addr : call displayCharCellAt : .skipF8
ld hl,(KeyF9char) : ld a,(hl) : cp #FF : jr z,.skipF9 : ld de,KeyF9addr : call displayCharCellAt : .skipF9

ld ix,hud1addr : ld a,(longueurMax)
ld iy,workPattern
.displayHUD
exa : ld de,(ix+0) : inc ix : inc ix : ld a,(iy+0) : inc iy : call displayCharCellAt : exa
dec a : jr nz,.displayHUD
.waitKeyboard
call scankeyboard
ld hl,keyboardmap : xor a : ld b,10
.testeAll or (hl) : inc hl : djnz .testeAll
or a : jr nz,.waitKeyboard
ret

;*************************************************************
                          waitInput
;*************************************************************


testChoice ; valider l'input, eventuellement afficher le mot trouve, reset l'affichage du board de saisie

KeyF1char defw 0
KeyF2char defw 0
KeyF3char defw 0
KeyF4char defw 0
KeyF5char defw 0
KeyF6char defw 0
KeyF7char defw 0
KeyF8char defw 0
KeyF9char defw 0


nbChoices   defb 0
longueurMax defb 0
nombreMots  defb 0

align 2 : buildChoiceList defw 0,0,0,buildChoice3,buildChoice4,buildChoice5,buildChoice6,buildChoice7,buildChoice8,buildChoice9

; toutes les cases inactivées par défaut
resetBuild
ld hl,dummy : ld (KeyF9char),hl : ld (KeyF1char),hl : ld (KeyF2char),hl : ld (KeyF3char),hl : ld (KeyF4char),hl : ld (KeyF6char),hl : ld (KeyF7char),hl : ld (KeyF8char),hl : ld (KeyF5char),hl
ld hl,hud1addr : ld de,hud1addr+1 : ld (hl),0 : ld bc,MAX_PATTERN*2-1 : ldir
ret

buildChoice3 call resetBuild : ld hl,currentPattern : ld (KeyF8char),hl : inc hl : ld (KeyF3char),hl : inc hl : ld (KeyF1char),hl : jp retourInitChoice
buildChoice4 call resetBuild : ld hl,currentPattern : ld (KeyF9char),hl : inc hl : ld (KeyF7char),hl : inc hl : ld (KeyF3char),hl : inc hl : ld (KeyF1char),hl : jp retourInitChoice
buildChoice5 call resetBuild : ld hl,currentPattern : ld (KeyF9char),hl : inc hl : ld (KeyF7char),hl : inc hl : ld (KeyF3char),hl : inc hl : ld (KeyF1char),hl : inc hl : ld (KeyF5char),hl : jp retourInitChoice
buildChoice6 call resetBuild : ld hl,currentPattern : ld (KeyF9char),hl : inc hl : ld (KeyF7char),hl : inc hl : ld (KeyF3char),hl : inc hl : ld (KeyF1char),hl : inc hl : ld (KeyF8char),hl : inc hl : ld (KeyF2char),hl : jp retourInitChoice
buildChoice7 call resetBuild : ld hl,currentPattern : ld (KeyF9char),hl : inc hl : ld (KeyF7char),hl : inc hl : ld (KeyF3char),hl : inc hl : ld (KeyF1char),hl : inc hl : ld (KeyF8char),hl : inc hl : ld (KeyF2char),hl : inc hl : ld (KeyF5char),hl : inc hl : jp retourInitChoice
buildChoice8 call resetBuild : ld hl,currentPattern : ld (KeyF9char),hl : inc hl : ld (KeyF7char),hl : inc hl : ld (KeyF3char),hl : inc hl : ld (KeyF1char),hl : inc hl : ld (KeyF8char),hl : inc hl : ld (KeyF2char),hl : inc hl : ld (KeyF4char),hl : inc hl : ld (KeyF6char),hl : jp retourInitChoice
buildChoice9 call resetBuild : ld hl,currentPattern : ld (KeyF9char),hl : inc hl : ld (KeyF7char),hl : inc hl : ld (KeyF3char),hl : inc hl : ld (KeyF1char),hl : inc hl : ld (KeyF8char),hl : inc hl : ld (KeyF2char),hl : inc hl : ld (KeyF4char),hl : inc hl : ld (KeyF6char),hl : inc hl : ld (KeyF5char),hl : jp retourInitChoice


referencePattern defs MAX_PATTERN     ; 8 lettres max => statique pendant le niveau
currentPattern   defs MAX_PATTERN     ; 8 lettres max => lettres disponibles qui disparaissent
workPattern      defs MAX_PATTERN+1,0 ; 8 lettres max => lettres qui apparaissent au fur et à mesure de la saisie et sont amenées à être comparées
workPosition     defw workPattern     ; nextChar position
dummy            defb #FF
dummySpace       defb 0

hud1addr defw 0
hud2addr defw 0
hud3addr defw 0
hud4addr defw 0
hud5addr defw 0
hud6addr defw 0
hud7addr defw 0
hud8addr defw 0
hud9addr defw 0

align 2
tailleEntrees defs 22,0 ; +extra-zero
posEntrees defs 42

charset ' ',0
repeat 26,x,0
charset x+'a',x+1
charset x+'A',x+1
rend
charset ',',VIRGULE
charset ';',POINT_VIRGULE
charset '|',PIPE

str_init01    defb 'utiliza  el   teclado  numerico',ENDMARK
str_init02    defb 'para crear tu palabra e utiliza',ENDMARK
str_init03    defb 'la espaciadora para validar',ENDMARK

str_init04    defb 'esc siguiente nivel de dificult',ENDMARK
str_init05    defb 'tab          pantalla siguiente',ENDMARK
str_init06    defb 'h        mostrar algunas letras',ENDMARK

str_init07    defb 'las palabras  pueden  ser verbos',ENDMARK
str_init08    defb 'conjugados  o  abreviaturas  asi',ENDMARK
str_init09    defb 'como nombres de ciudades',ENDMARK

str_init10    defb '  ',ENDMARK
str_init11    defb '         pulsa una tecla',ENDMARK
str_init12    defb ' ',ENDMARK

str_level1    defb 'primer level',ENDMARK
str_level2    defb 'segundo level',ENDMARK
str_level3    defb 'tercer level',ENDMARK
str_level4    defb 'cuarto level',ENDMARK
str_level5    defb 'quinto level',ENDMARK
str_level6    defb 'sexto level',ENDMARK
str_level7    defb 'septimo level',ENDMARK
str_level8    defb 'octavo level',ENDMARK
str_level9    defb 'noveno level',ENDMARK
str_level10   defb 'decimo level',ENDMARK

bravoList defw .init
.init
defw $+4,str_bravo01
defw $+4,str_bravo02
defw $+4,str_bravo03
defw $+4,str_bravo04
defw $+4,str_bravo05
defw $+4,str_bravo06
defw $+4,str_bravo07
defw $+4,str_bravo08
defw $+4,str_bravo09
defw $+4,str_bravo10
defw $+4,str_bravo11
defw $+4,str_bravo12
defw $+4,str_bravo13
defw $+4,str_bravo14
defw $+4,str_bravo15
defw .init,str_bravo16

str_bravo01   defb 'bravo nivel superado',ENDMARK
str_bravo02   defb '     bien hecho',ENDMARK
str_bravo03   defb ' excelente trabajo',ENDMARK
str_bravo04   defb 'lo estas haciendo genial',ENDMARK
str_bravo05   defb '    enhorabuena',ENDMARK
str_bravo06   defb '  siguiente paso',ENDMARK
str_bravo07   defb '  va como la seda',ENDMARK
str_bravo08   defb '  demasiado facil',ENDMARK
str_bravo09   defb '       gg',ENDMARK
str_bravo10   defb 'costando mucho el juego',ENDMARK
str_bravo11   defb '   que campeon',ENDMARK
str_bravo12   defb '     muy bien',ENDMARK
str_bravo13   defb 'avanzas invencible',ENDMARK
str_bravo14   defb 'perfecto y sin esfuerzo',ENDMARK
str_bravo15   defb 'guau eres la leche',ENDMARK
str_bravo16   defb '    tranquilo',ENDMARK

str_win01 defb '  acabas de terminar el juego',ENDMARK

;*****************************************
;  single char not indexed the same way
;*****************************************
cell_motsEnFete defb 'lexi forge',ENDMARK






; for displaying single char...
repeat 26,x,0
charset x+'a',(x+1)*2
charset x+'A',(x+1)*2
rend

;*******************************
            levelUP
;*******************************
ld ix,.levelADR
ld de,(lexiCurrentLevel)
.trouveLevel
ld hl,(ix+0) : ld a,h : or l : jp z,#100
sbc hl,de : jr z,.onVeutLeSuivant : jr nc,.isNext : .onVeutLeSuivant
inc ix : inc ix
jr .trouveLevel
.isNext
ld hl,(ix+0) : ld (lexiCurrentLevel),hl
ld b,100 : halt : djnz $
jp initGame

.levelADR
defw lexiLevel1
defw lexiLevel2
defw lexiLevel3
defw lexiLevel4
defw lexiLevel5
defw lexiLevel6
defw lexiLevel7
defw lexiLevel8
defw lexiLevel9
defw lexiLevel10
defw 0

.levelSTR
defw str_level1
defw str_level2
defw str_level3
defw str_level4
defw str_level5
defw str_level6
defw str_level7
defw str_level8
defw str_level9
defw str_level10

lexiCurrentLevel defw lexiLevel1 ; prévoir un reset?



lexiLevel1
defb 'ACO,CAO,COA,OCA;'
defb 'AER,ARE,ERA,RAE,REA;'
defb 'AES,AES,ASE,ESA,SEA;'
defb 'AET,ATE,ETA,TEA;'
defb 'AIR,IRA,RAI,RIA;'
defb 'ANO,ANO,NAO,ONA;'
defb 'AOP,OPA,PAO,POA;'
defb 'AOR,ARO,ORA,ROA;'
defb 'AOS,ASO,OAS,OSA,SAO;'
defb 'AOT,ATO,TAO,TOA;'
defb 'DIO,DIO,IDO,OID;'
defb 'EIR,IRE,REI,RIE;'
defb 'ELO,LEO,LOE,OLE;'
defb 'EOR,ERO,ORE,REO,ROE;'
defb 'EOS,ESO,OES,OSE,SEO;'
defb 'EOV,EVO,OVE,VEO;'
defb 'ILO,LIO,OIL,OLI;'
defb 'IOR,OIR,ORI,RIO,ROI;'

lexiLevel2
defb 'ACOZ,AZO,CAO,CAZ,COA,COZ,OCA,CAZO,ZOCA;'
defb 'ACRU,CAR,RUA,RUC,URA,CURA,RUCA,URCA;'
defb 'ACNU,AUN,CAN,UNA,CUAN,CUNA,NUCA;'
defb 'ADEJ,AJE,DEA,JEA,DEJA,JADE,JEDA;'
defb 'ADIV,DIA,IDA,VIA,VID,DIVA,VIDA;'
defb 'ADLO,LOA,ODA,OLA,DOLA,LADO,LOAD;'
defb 'ADMO,AMO,DOM,MOA,ODA,DOMA,MODA;'
defb 'AAPR,APA,ARA,PAR,ARPA,PARA,RAPA;'
defb 'AARS,ARA,ASA,RAS,ARAS,ASAR,RASA;'
defb 'AART,ARA,ATA,ARTA,ATAR,RATA,TARA;'
defb 'AAST,ASA,ATA,TAS,ASTA,ATAS,SATA,TASA;'
defb 'ABCO,BAO,BOA,CAO,COA,OCA,BOCA,CABO,COBA;'
defb 'ABEL,ALE,BEL,BLE,LEA,BALE,BELA,LABE;'
defb 'ABOT,ATO,BAO,BOA,TAO,TOA,BATO,BOTA,TABO,TOBA;'
defb 'ACEM,AME,CAE,CEA,MEA,ACME,CEMA,MACE,MECA;'
defb 'ACEO,CAE,CAO,CEA,CEO,COA,ECO,OCA;'
defb 'ABER,ARE,BAR,ERA,RAE,REA,ABRE,BREA;'
defb 'ABIS,ASI,BIS,IBA,ISA,BISA,IBAS,ISBA;'
defb 'ACET,ATE,CAE,CEA,ETA,TAC,TEA,CATE,TACE,TECA;'
defb 'ACHI,AHI,CAI,CHA,CIA,ACHI,CHAI,CHIA;'
defb 'ACHO,AHO,CAO,CHA,CHO,COA,HAO,OCA,CHAO;'
defb 'ACIP,API,CAI,CAP,CIA,PIA,CAPI,PACI,PICA;'
defb 'ACIR,CAI,CAR,CIA,IRA,RAI,RIA,CARI,CIAR,CRIA,RICA;'
defb 'ACIS,ASI,CAI,CAS,CIA,ISA,SIC,CAIS,CASI,CIAS;'
defb 'ACIT,CAI,CIA,TAC,TIA,TIC,CITA,TICA;'
defb 'ACJO,AJO,CAO,COA,OCA,CAJO,COJA,JACO;'



lexiLevel3
defb 'ABOR,ARO,BAO,BAR,BOA,ORA,ROA,ROB,ABRO,BARO,BROA,OBRA,RABO,ROBA;'
defb 'ACES,AES,ASE,CAE,CAS,CEA,CES,ESA,SEA,CAES,CASE,CEAS,CESA,ESCA,SECA;'
defb 'ACLO,CAL,CAO,CLO,COA,COL,LOA,OCA,OLA,CALO,COLA,LACO,LOCA,OCAL;'
defb 'ACOR,ARO,CAO,CAR,COA,COR,OCA,ORA,ROA,ARCO,CARO,CORA,CROA,OCRA,ORCA,RACO,ROCA;'
defb 'ACOS,ASO,CAO,CAS,COA,OAS,OCA,OSA,SAO,ASCO,CAOS,CASO,COAS,COSA,OCAS,OSCA,SACO,SOCA;'
defb 'ADER,ARE,DAR,DEA,ERA,RAD,RAE,REA,RED,ADRE,ARDE,DARE,DREA,EDRA,ERAD,RAED,REDA;'
defb 'AEIR,ARE,ERA,IRA,IRE,RAE,RAI,REA,REI,RIA,RIE,AIRE,EIRA,ERIA,REIA;'
defb 'AELS,AES,ALE,ASE,ESA,LAS,LEA,LES,SAL,SEA,SEL,LEAS,LESA,SALE;'
defb 'AEMS,AES,AME,ASE,ESA,MAS,MEA,MES,SEA,AMES,MASE,MEAS,MESA,SEMA;'
defb 'AENS,AES,ASE,ESA,NAS,NEA,SAN,SEA,SEN,ASEN,NEAS,SANE,SEAN,SENA;'
defb 'AEOS,AES,ASE,ASO,ESA,ESO,OAS,OES,OSA,OSE,SAO,SEA,SEO,ASEO,OSEA;'
defb 'AEPR,ARE,EPA,ERA,PAR,PEA,PRE,RAE,REA,ARPE,PARE,PERA,PREA,RAPE;'
defb 'AERS,AES,ARE,ASE,ERA,ESA,RAE,RAS,REA,RES,SEA,SER,ARES,ERAS,RAES,RASE,REAS,SERA;'
defb 'AEST,AES,ASE,ATE,ESA,ETA,SEA,SET,TAS,TEA,TES,ATES,ESTA,ETAS,SETA,TASE,TEAS,TESA;'
defb 'AILS,ALI,ASI,ISA,LAS,LIA,LIS,SAL,SIL,ALIS,ISLA,LAIS,LIAS,LISA,SALI;'
defb 'AIOR,ARO,IRA,OIA,OIR,ORA,ORI,RAI,RIA,RIO,ROA,ROI,AIRO,ARIO,OIRA,ROIA;'
defb 'AIRS,ASI,IRA,ISA,RAI,RAS,RIA,ASIR,IRAS,RASI,RIAS,RISA,SARI,SIRA;'
defb 'ALMO,AMO,LOA,MAL,MOA,MOL,OLA,ALMO,AMOL,LAMO,LOMA,MALO,MOLA,OLMA;'
defb 'ALOR,ARO,LAR,LOA,OLA,ORA,ROA,ROL,ARLO,LOAR,LORA,ORAL,ORLA,RALO,ROLA;'
defb 'ALOS,ASO,LAS,LOA,LOS,OAS,OLA,OSA,SAL,SAO,SOL,LASO,LOAS,LOSA,OLAS,SALO,SOLA;'
defb 'ALOT,ATO,LOA,OLA,TAL,TAO,TOA,TOL,ALTO,ATOL,LATO,LOTA,TALO,TOLA;'
defb 'AMOR,AMO,ARO,MAR,MOA,MOR,ORA,ROA,AMOR,ARMO,MARO,MORA,RAMO,ROMA;'
defb 'ANOR,ANO,ARO,NAO,NOR,ONA,ORA,ROA,RON,ARON,NORA,ORAN,ORNA,RANO,ROAN,RONA;'
defb 'ANOS,ANO,ASO,NAO,NAS,NOS,OAS,ONA,OSA,SAN,SAO,SON,ANOS,ASNO,NAOS,NASO,ONAS,OSAN,SANO,SONA;'
defb 'ANOT,ANO,ATO,NAO,ONA,TAN,TAO,TOA,TON,NATO,NOTA,TANO,TOAN,TONA;'
defb 'AOPR,ARO,OPA,ORA,PAO,PAR,POA,POR,PRO,ROA,ARPO,PARO,PORA,PRAO,PROA,RAPO,ROPA;'
defb 'AOPS,ASO,OAS,OPA,OSA,PAO,POA,POS,SAO,APOS,ASPO,OPAS,PASO,POAS,POSA,SAPO,SOPA;'
defb 'AOPT,ATO,OPA,PAO,POA,TAO,TOA,TOP,APTO,OPTA,PATO,POTA,TAPO,TOPA;'
defb 'AORS,ARO,ASO,OAS,ORA,OSA,RAS,ROA,ROS,SAO,SOR,AROS,ORAS,OSAR,RASO,ROAS,ROSA,SORA;'
defb 'AORT,ARO,ATO,ORA,ROA,TAO,TOA,ARTO,OTAR,OTRA,RATO,ROTA,TARO,TOAR,TORA;'
defb 'AOST,ASO,ATO,OAS,OSA,SAO,TAO,TAS,TOA,TOS,OSTA,SATO,SOTA,TAOS,TASO,TOAS,TOSA;'
defb 'CEOR,CEO,COR,ECO,ERO,ORE,REO,ROE,CERO,CORE,CREO,CROE,OCRE,ORCE,ROCE;'
defb 'EIOR,ERO,IRE,OIR,ORE,ORI,REI,REO,RIE,RIO,ROE,ROI,ERIO,OIRE;'
defb 'ELOR,ERO,LEO,LOE,OLE,ORE,REO,ROE,ROL,LERO,OLER,ORLE,ROEL,ROLE;'
defb 'ELOS,ESO,LEO,LES,LOE,LOS,OES,OLE,OSE,SEL,SEO,SOL,LEOS,LESO,LOES,LOSE,OLES,SOLE;'
defb 'ENOR,EON,ERO,NEO,NOR,ORE,REO,ROE,RON,OREN,ORNE,RENO,ROEN,RONE;'
defb 'ENOS,EON,ESO,NEO,NOS,OES,OSE,SEN,SEO,SON,NEOS,OSEN,SENO,SONE;'
defb 'EORS,ERO,ESO,OES,ORE,OSE,REO,RES,ROE,ROS,SEO,SER,SOR,EROS,ORES,REOS,ROES,ROSE,SEOR;'
defb 'EOST,ESO,OES,OSE,SEO,SET,TES,TOE,TOS,ESTO,OSTE,SETO,SOTE,TESO,TOES,TOSE;'



lexiLevel4
defb 'AANS,ANAS,ANSA,ASAN,ASNA,NASA,SANA;'
defb 'ABOR,ABRO,BARO,BROA,OBRA,RABO,ROBA;'
defb 'ACEN,ACNE,CAEN,CANE,CENA,NACE,NECA;'
defb 'ACES,CAES,CASE,CEAS,CESA,ESCA,SECA;'
defb 'ACOR,ARCO,CARO,CORA,CROA,OCRA,ORCA,RACO,ROCA;'
defb 'ACOS,ASCO,CAOS,CASO,COAS,COSA,OCAS,OSCA,SACO,SOCA;'
defb 'ADER,ADRE,ARDE,DARE,DREA,EDRA,ERAD,RAED,REDA;'
defb 'ADLU,ADUL,ALUD,DUAL,DULA,LAUD,LUDA;'
defb 'ADOR,ADOR,ADRO,ARDO,DORA,ORAD,RODA;'
defb 'AEMN,AMEN,MANE,MEAN,MENA,NAME,NEMA;'
defb 'AENT,ANTE,ATEN,ENTA,NETA,TANE,TENA;'
defb 'AERS,ARES,ERAS,RAES,RASE,REAS,SERA;'
defb 'AEST,ATES,ESTA,ETAS,SETA,TASE,TEAS,TESA;'
defb 'AILS,ALIS,ISLA,LAIS,LIAS,LISA,SALI;'
defb 'AINS,ANIS,ANSI,ASIN,NIAS,SAIN,SIAN;'
defb 'AIRS,ASIR,IRAS,RASI,RIAS,RISA,SARI,SIRA;'
defb 'ALMO,ALMO,AMOL,LAMO,LOMA,MALO,MOLA,OLMA;'
defb 'ALNO,ALNO,ALON,LANO,LOAN,LONA,NOLA;'
defb 'ALOR,ARLO,LOAR,LORA,ORAL,ORLA,RALO,ROLA;'
defb 'ALOS,LASO,LOAS,LOSA,OLAS,SALO,SOLA;'
defb 'ALOT,ALTO,ATOL,LATO,LOTA,TALO,TOLA;'
defb 'AMOR,AMOR,ARMO,MARO,MORA,RAMO,ROMA;'
defb 'ANOR,ARON,NORA,ORAN,ORNA,RANO,ROAN,RONA;'
defb 'ANOS,ANOS,ASNO,NAOS,NASO,ONAS,OSAN,SANO,SONA;'
defb 'AOPR,ARPO,PARO,PORA,PRAO,PROA,RAPO,ROPA;'
defb 'AOPS,APOS,ASPO,OPAS,PASO,POAS,POSA,SAPO,SOPA;'
defb 'AOPT,APTO,OPTA,PATO,POTA,TAPO,TOPA;'
defb 'AORS,AROS,ORAS,OSAR,RASO,ROAS,ROSA,SORA;'
defb 'AORT,ARTO,OTAR,OTRA,RATO,ROTA,TARO,TOAR,TORA;'
defb 'AOST,OSTA,SATO,SOTA,TAOS,TASO,TOAS,TOSA;'
defb 'CEOR,CERO,CORE,CREO,CROE,OCRE,ORCE,ROCE;'
defb 'DEOR,DORE,EDRO,ODRE,REDO,RODE,ROED;'
defb 'ELOS,LEOS,LESO,LOES,LOSE,OLES,SOLE;'
defb 'EORS,EROS,ORES,REOS,ROES,ROSE,SEOR;'
defb 'EOST,ESTO,OSTE,SETO,SOTE,TESO,TOES,TOSE;'


lexiLevel5
defb 'AACNS,ACAS,ANAS,ANCA,ANSA,ASAN,ASCA,ASNA,CANA,CASA,NACA,NASA,SACA,SANA,ANCAS,CANAS,CANSA,CASAN,NACAS,SACAN;'
defb 'AADNR,ADAN,ADRA,ANDA,ARAD,ARAN,ARDA,ARNA,DANA,DARA,NADA,RADA,RANA,RAND,ADRAN,ANDAR,ARDAN,DANAR,DARAN,NADAR,RANDA;'
defb 'AAEST,AETA,ASEA,ASTA,ATAS,ATEA,ATES,ESTA,ETAS,SATA,SETA,TASA,TASE,TEAS,TESA,AETAS,ATASE,ATEAS,ATESA,SAETA;'
defb 'AANRS,ANAS,ANSA,ARAN,ARAS,ARNA,ASAN,ASAR,ASNA,NASA,RANA,RASA,SANA,ANSAR,ARNAS,RANAS,RASAN,SANAR,SARAN,SARNA;'
defb 'ABERS,ABES,ABRE,ARES,BASE,BESA,BREA,ERAS,RAES,RASE,REAS,SABE,SERA,ABRES,BARES,BESAR,BREAS,SABER,SABRE,SERBA;'
defb 'ACELR,ACLE,ACRE,ALCE,ARCE,AREL,ARLE,CAER,CALE,CELA,CERA,CREA,ERAL,LACE,LERA,REAL,CALER,CAREL,CELAR,LACRE,RACEL;'
defb 'ACEMS,ACME,AMES,CAES,CASE,CEAS,CEMA,CESA,ESCA,MACE,MASE,MEAS,MECA,MESA,SECA,SEMA,ACMES,CEMAS,MACES,MECAS;'
defb 'ACENT,ACNE,ANTE,ATEN,CAEN,CANE,CATE,CENA,CENT,ENTA,NACE,NECA,NETA,TACE,TANE,TECA,TENA,CANTE,CATEN,TACEN,TENCA;'
defb 'ACEPS,ASPE,CAES,CAPE,CASE,CEAS,CEPA,CESA,ESCA,PACE,PASE,PEAS,PECA,PESA,SECA,SEPA,CAPES,CEPAS,PACES,PECAS,PESCA;'
defb 'ACIRS,ASIR,CAIS,CARI,CASI,CIAR,CIAS,CRAS,CRIA,IRAS,RASI,RIAS,RICA,RISA,SARI,SIRA,CARIS,CRIAS,RICAS,RISCA;'
defb 'ACLMO,ALMO,AMOL,CALO,COLA,COMA,LACO,LAMO,LOCA,LOMA,MACO,MALO,MOCA,MOLA,OCAL,OLMA,CALMO,CLAMO,COLMA,COMAL;'
defb 'ACLOT,ACTO,ALTO,ATOL,CALO,CATO,COLA,COTA,LACO,LATO,LOCA,LOTA,OCAL,TACO,TALO,TOCA,TOLA,CLOTA,LACTO,TALCO,TLACO;'
defb 'ACMOS,AMOS,ASCO,CAOS,CASO,COAS,COMA,COSA,MACO,MASO,MOCA,OCAS,OSCA,SACO,SOCA,SOMA,COMAS,MASCO,MOCAS,MOSCA;'
defb 'ACOSV,ASCO,CAOS,CASO,CAVO,COAS,COSA,COVA,OCAS,OSCA,OVAS,SACO,SOCA,VACO,VASO,VOSA,CAVOS,COVAS,VACOS,VASCO;'
defb 'ADGOR,ADOR,ADRO,AGRO,ARDO,DOGA,DORA,GARO,GODA,GRAO,GROA,ORAD,RODA,ROGA,DRAGO,DROGA,GORDA,GRADO,GROAD,ROGAD;'
defb 'ADOPR,ADOR,ADRO,ARDO,ARPO,DOPA,DORA,ORAD,PARO,PODA,PORA,PRAO,PROA,RAPO,RODA,ROPA,DOPAR,PARDO,PODAR,PODRA,PRADO;'
defb 'ADORS,ADOR,ADRO,ARDO,AROS,DORA,ODAS,ORAD,ORAS,OSAD,OSAR,RASO,ROAS,RODA,ROSA,SODA,SORA,DORAS,RODAS,SARDO,SORDA;'
defb 'AEGRU,AGRE,AGUE,AGUR,AUGE,GRUA,GURA,RAGU,REGA,RUGA,RUGE,UGRE,UREA,URGE,ARGUE,EGUAR,GARUE,GUARE,GUERA,RUEGA;'
defb 'AEILS,ALIE,ALIS,ISLA,LAIS,LEAS,LEIA,LESA,LIAS,LIES,LISA,SALE,SALI,AISLE,ALIES,ALISE,ASILE,ILESA,LEAIS,LEIAS,LIASE;'
defb 'AEINS,ANIS,ANSI,ASEN,ASIN,NEAS,NEIS,NIAS,NIES,SAIN,SANE,SEAN,SENA,SIAN,SIEN,ANISE,ANSIE,SAINE,SANIE,SIENA;'
defb 'AEIPS,APIS,ASPE,PAIS,PASE,PEAS,PEIA,PESA,PIAS,PIES,PISA,PISE,SEPA,SIPE,ESPIA,PEAIS,PEIAS,PESIA,PIASE,SEPIA;'
defb 'AEJOR,AJEO,AOJE,JARO,JERA,JORA,OJAR,OJEA,OREA,RAJE,RAJO,REJA,REJO,ROJA,AJERO,AJORE,OJEAR,OJERA,ORAJE,OREJA,ROJEA;'
defb 'AEJOT,AJEO,AOJE,ATEO,ATOE,JATE,JATO,JETA,JETO,JOTA,JOTE,OJEA,OTEA,TAJE,TAJO,TEJA,TEJO,AJOTE,ATOJE,JATEO,TAJEO;'
defb 'AEJST,AJES,ATES,ESTA,ETAS,JASE,JATE,JEAS,JETA,SAJE,SETA,TAJE,TASE,TEAS,TEJA,TESA,JATES,JETAS,TAJES,TEJAS;'
defb 'AELPR,AREL,ARLE,ARPE,ERAL,LERA,PALE,PARE,PEAL,PELA,PERA,PREA,RAPE,REAL,LEPRA,PAREL,PARLE,PELAR,PERAL,PERLA;'
defb 'AEMNT,AMEN,ANTE,ATEN,ENTA,MANE,MATE,MEAN,MENA,META,NAME,NEMA,NETA,TANE,TEMA,TENA,MATEN,MENTA,METAN,TEMAN;'
defb 'AEMST,AMES,ATES,ESTA,ETAS,MASE,MATE,MEAS,MESA,META,SEMA,SETA,TASE,TEAS,TEMA,TESA,MASTE,MATES,MESTA,METAS,TEMAS;'
defb 'AENPS,ASEN,ASPE,NEAS,PASE,PEAN,PEAS,PENA,PESA,SANE,SEAN,SENA,SEPA,ASPEN,PANES,PASEN,PENAS,PENSA,PESAN,SEPAN;'
defb 'AENRS,AREN,ARES,ASEN,ERAN,ERAS,NEAS,RAEN,RAES,RASE,REAS,SANE,SEAN,SENA,SERA,ARNES,NARES,RASEN,SERAN,SERNA;'
defb 'AEPST,ASPE,ATES,ESTA,ETAS,PASE,PATE,PEAS,PESA,PETA,SEPA,SETA,TAPE,TASE,TEAS,TESA,PASTE,PATES,PETAS,TAPES;'
defb 'AGIOR,AGIO,AGRO,AIRO,ARIO,GARO,GIRA,GIRO,GRAO,GROA,IRGA,IRGO,OIGA,OIRA,ROGA,ROIA,AGRIO,GARIO,ORGIA,RAIGO,ROIGA;'
defb 'AGLOR,AGRO,ALGO,ARLO,GALO,GARO,GOLA,GRAO,GROA,LAGO,LOAR,LORA,ORAL,ORLA,RALO,ROGA,ROLA,GARLO,LARGO,LOGAR,LOGRA;'
defb 'AGLOS,ALGO,ASGO,GALO,GLAS,GOLA,LAGO,LASO,LOAS,LOSA,OLAS,SAGO,SALO,SOGA,SOLA,ALGOS,GALOS,GLOSA,GOLAS,LAGOS,SALGO;'
defb 'AGNOR,AGRO,ARON,GANO,GAON,GARO,GRAN,GRAO,GROA,NORA,ORAN,ORNA,RANO,ROAN,ROGA,RONA,ANGOR,ARGON,GRANO,GROAN,RANGO;'
defb 'AILMS,ALIM,ALIS,AMIS,ISLA,LAIS,LAMI,LIAS,LIMA,LISA,MALI,MIAS,MISA,SALI,SIMA,ALIMS,ISLAM,LIMAS,MALIS,MISAL;'
defb 'AILOT,ALIO,ALTO,ATOL,IOTA,LATI,LATO,LITA,LITO,LOTA,OLIA,TALO,TILA,TILO,TOLA,ILOTA,ITALO,LATIO,OTILA,TALIO;'
defb 'AILPS,ALIS,APIS,ISLA,LAIS,LIAS,LIPA,LISA,PAIS,PALI,PIAL,PIAS,PILA,PISA,SALI,SLIP,LIPAS,PALIS,PASIL,PILAS,PLISA;'
defb 'AIMNO,AMIN,IMAN,MANI,MANO,MIAN,MINA,MINO,MOAI,MONA,MONI,NOMA,OIAN,AMINO,ANIMO,IMANO,MANIO,MIANO,MIONA,OMANI,OMINA;'
defb 'AIOPT,APIO,APTO,IOTA,OPTA,PATI,PATO,PITA,PITO,POTA,TAPO,TIPA,TIPO,TOPA,APITO,ATIPO,PATIO,PITAO,TAPIO,TOPIA;'
defb 'AIPRS,APIS,ASIR,IRAS,PAIS,PARI,PIAR,PIAS,PIRA,PISA,RASI,RIAS,RISA,SARI,SIRA,PARIS,PARSI,PIRAS,PISAR,PRISA,RISPA;'
defb 'AJNOS,AJOS,ANOS,ASNO,JANO,JASO,JOSA,NAJO,NAOS,NASO,ONAS,OSAN,SAJO,SANO,SOJA,SONA,JANOS,NAJOS,SAJON,SANJO;'
defb 'ALOPR,ARLO,ARPO,LAPO,LOAR,LORA,ORAL,ORLA,PALO,PARO,PORA,PRAO,PROA,RALO,RAPO,ROLA,ROPA,PALOR,PARLO,POLAR,PROAL;'
defb 'ALOPS,APOS,ASPO,LAPO,LASO,LOAS,LOSA,OLAS,OPAS,PALO,PASO,POAS,POSA,SALO,SAPO,SOLA,SOPA,LAPOS,LAPSO,PALOS,SOPLA;'
defb 'AMNOS,AMOS,ANOS,ASNO,MANO,MASO,MONA,NAOS,NASO,NOMA,ONAS,OSAN,SANO,SOMA,SONA,MANOS,MANSO,MASON,MONAS,NOMAS;'
defb 'AMOST,AMOS,MASO,MATO,MOTA,OSTA,SATO,SOMA,SOTA,TAMO,TAOS,TASO,TOAS,TOMA,TOSA,MASTO,MATOS,MOTAS,TAMOS,TOMAS;'
defb 'AORTU,ARTO,AUTO,OTAR,OTRA,RATO,ROTA,RUTA,RUTO,TARO,TOAR,TORA,TOUR,TURA,URAO,URTA,ATURO,AUTOR,TAURO,URATO;'
defb 'ARSTU,RUAS,RUSA,RUTA,SURA,TAUS,TRAS,TURA,TUSA,URAS,URTA,USAR,UTAS,ASTUR,RUSTA,RUTAS,SURTA,TRUSA,TUSAR,URTAS;'
defb 'BCEOR,BECO,BOER,BREO,CEBO,CERO,CORE,CREO,CROE,OBRE,OCRE,ORBE,ORCE,ROBE,ROCE,BRECO,BROCE,CEBRO,COBRE,CORBE;'
defb 'CDEOR,CEDO,CERO,CORE,CREO,CROE,DOCE,DORE,EDRO,OCRE,ODRE,ORCE,REDO,ROCE,RODE,ROED,CEDRO,CERDO,CREDO,DECOR;'
defb 'CELOS,CELO,CEOS,CESO,COLE,COSE,ECOS,LECO,LEOS,LESO,LOES,LOSE,OCLE,OLES,SECO,SOLE,CELOS,COLES,LECOS,OCLES;'
defb 'CEORT,CERO,CORE,COTE,CREO,CROE,OCRE,ORCE,OTRE,RETO,ROCE,ROTE,TERO,TOCE,TREO,CETRO,CORTE,RECTO,TERCO,TORCE,TROCE;'
defb 'DELOR,DOLE,DORE,EDRO,LEDO,LERO,LORD,ODRE,OLED,OLER,ORLE,REDO,RODE,ROED,ROEL,ROLE,DOLER,LERDO,REDOL,ROLDE;'
defb 'EIORS,ERIO,EROS,IRES,OIRE,ORES,ORIS,REIS,REOS,RIES,RIOS,RISO,ROES,ROSE,SEOR,SIRO,ERIOS,OREIS,ORIES,ROEIS,SERIO;'
defb 'ELOST,ESTO,LEOS,LESO,LOES,LOSE,LOTE,OLES,OSTE,SETO,SOLE,SOTE,TESO,TOES,TOLE,TOSE,ESTOL,LOTES,SOLTE,TOLES;'
defb 'EOPRS,EPOS,EROS,ORES,PEOR,PERO,PESO,POSE,PRES,PROS,REOS,REPO,REPS,ROES,ROSE,SEOR,SOPE,PEROS,PESOR,PRESO,REPOS;'
defb 'IORST,ORIS,OTRI,RIOS,RISO,RITO,SIRO,SITO,TIOS,TIRO,TOSI,TRIO,TRIS,OTRIS,RITOS,ROSTI,TIROS,TIRSO,TRIOS,TRISO;'


lexiLevel6
defb 'AACRS,ARCAS,ASCAR,CARAS,CASAR,CRASA,RASCA,SACAR,SACRA;'
defb 'AADIR,ADIAR,AIRAD,ARDIA,ARIDA,DARIA,IRADA,RADIA,RAIDA,RIADA;'
defb 'ABIRS,ABRIS,BARIS,BIRAS,BISAR,BRISA,RABIS,RIBAS,SABIR;'
defb 'ABLOR,ALBOR,ARBOL,BOLAR,BORLA,LABOR,LABRO,RALBO,ROBLA;'
defb 'ABORS,BAROS,BOSAR,BROAS,OBRAS,RABOS,ROBAS,SABOR,SOBAR,SOBRA,SORBA;'
defb 'ACELN,ALCEN,ANCLE,CALEN,CELAN,CENAL,LACEN,LANCE,LENCA,NECLA;'
defb 'ACENR,ARCEN,CARNE,CENAR,CERNA,CREAN,NACER,NACRE,RENCA;'
defb 'ACENS,ACNES,CANES,CANSE,CASEN,CENAS,CENSA,CESAN,NACES,NECAS,SECAN;'
defb 'ACEOR,ACERO,ACORE,ACROE,CAREO,COREA,RACEO,REOCA,ROCEA;'
defb 'ACERS,ACRES,ARCES,CARES,CERAS,CESAR,CREAS,CRESA,SACRE,SECAR;'
defb 'ACLOR,ALCOR,CALOR,CARLO,CLARO,CLORA,COLAR,CORAL,CORLA,LACRO;'
defb 'ACNOS,CANOS,CANSO,CASON,CONAS,COSAN,NACOS,NOCAS,SACON,SANCO;'
defb 'ACNOT,CANTO,CATON,CONTA,COTAN,TACON,TANCO,TOCAN,TONCA;'
defb 'ACORS,ARCOS,CAROS,CORAS,CORSA,CRASO,CROAS,OCRAS,ORCAS,RACOS,RASCO,ROCAS,ROSCA,SACRO;'
defb 'ACOST,ACTOS,CASTO,CATOS,COSTA,COTAS,TACOS,TASCO,TOCAS,TOSCA;'
defb 'ADERS,ADRES,ARDES,DARES,DREAS,EDRAS,RADES,REDAS,SARDE,SEDAR;'
defb 'ADIOR,ARDIO,ARIDO,DORIA,IRADO,ODIAR,RADIO,RAIDO,RODIA,ROIDA;'
defb 'ADLOR,DOLAR,DORAL,LADRO,LARDO,LODRA,ORLAD,RODAL,ROLAD,ROLDA;'
defb 'ADNOR,DONAR,DORAN,DORNA,NARDO,ONDRA,ORNAD,RADON,RONAD,RONDA;'
defb 'AEILS,AISLE,ALIES,ALISE,ASILE,ILESA,LEAIS,LEIAS,LIASE;'
defb 'AEINV,AVENI,AVIEN,AVINE,ENVIA,NIEVA,NIVEA,VEIAN,VENIA;'
defb 'AEIRS,AIRES,AREIS,ARIES,ASIRE,EIRAS,ERAIS,ERIAS,RAEIS,REIAS,SERIA;'
defb 'AELOR,ALERO,ARELO,LOARE,LOREA,OLEAR,OLERA,ORALE,RALEO,ROELA;'
defb 'AELOT,ALETO,ALOTE,ALTEO,ATOLE,ELATO,ETOLA,LATEO,LOTEA;'
defb 'AEMNO,AMENO,AMONE,EMANO,MAENO,MANEO,MEANO,MEONA,MONEA,NOEMA;'
defb 'AEMOR,AMERO,AROME,MAREO,MOARE,MOREA,RAMEO,REAMO,ROMEA;'
defb 'AENRT,ENTRA,RENTA,RETAN,TANER,TAREN,TERNA,TRAEN,TRENA;'
defb 'AENST,ANTES,ESTAN,NETAS,SATEN,SENTA,TANES,TASEN,TENAS,TENSA,TESAN;'
defb 'AEOST,ATEOS,ATESO,ATOES,OSETA,OTEAS,SAETO,TEOSA,TOASE,TOESA;'
defb 'AEPRS,APRES,ARPES,PARES,PERAS,PERSA,PESAR,PREAS,PRESA,RAPES,RASPE,SERPA;'
defb 'AEPRT,PARTE,PATER,PERTA,PETAR,PETRA,RAPTE,REPTA,TRAPE,TREPA;'
defb 'AERST,ARTES,ASTER,ESTAR,RESTA,RETAS,TARES,TERSA,TESAR,TRAES;'
defb 'AGIRU,ARGUI,GRUIA,GUARI,GUIAR,GUIRA,IGUAR,RIGUA,RUGIA,URGIA;'
defb 'AGORS,AGROS,ARGOS,GAROS,GRAOS,GRASO,GROAS,GROSA,RASGO,ROGAS,SARGO;'
defb 'AILOS,AISLO,ALISO,ASILO,LIOSA,LOAIS,OLAIS,OLIAS,SALIO,SOLIA;'
defb 'AIMNO,AMINO,ANIMO,IMANO,MANIO,MIANO,MIONA,OMANI,OMINA;'
defb 'ALMOS,ALMOS,LOMAS,MALOS,MASLO,MOLAS,MOLSA,OLMAS,SALMO;'
defb 'ALORS,ARLOS,LORAS,LOSAR,ORLAS,RALOS,ROLAS,ROSAL,SOLAR;'
defb 'ALOST,ALTOS,LASTO,LATOS,LOTAS,SALTO,SOLTA,TALOS,TOLAS;'
defb 'ANORT,ANTRO,NOTAR,RATON,ROTAN,TANOR,TONAR,TORNA,TRONA;'
defb 'ANOST,NATOS,NOTAS,SANTO,SONTA,SOTAN,TANOS,TONAS,TOSAN;'
defb 'AOPRS,ASPRO,PAROS,POSAR,PRAOS,PROAS,PROSA,RAPOS,RASPO,ROPAS,SOPAR;'
defb 'AOPRT,OPTAR,PARTO,PORTA,POTAR,POTRA,RAPTO,TOPAR,TRAPO,TROPA;'
defb 'AORST,ARTOS,ASTRO,OSTRA,OTRAS,RATOS,ROSTA,ROTAS,SOTAR,TARSO,TORAS;'
defb 'CENOR,CERNO,CERON,COREN,CROEN,ORCEN,RENCO,ROCEN,RONCE;'
defb 'CEORS,CEROS,CORES,CORSE,COSER,CRESO,CROES,OCRES,ORCES,ROCES,SORCE;'
defb 'ENORS,NORES,ORNES,RENOS,RONES,ROSEN,SENOR,SERON,SORNE;'
defb 'ENORT,ENTRO,NORTE,RENTO,ROTEN,TENOR,TERNO,TONER,TORNE,TRENO,TRONE;'
defb 'ENOST,NETOS,NOTES,SENTO,SOTEN,TENSO,TESON,TONES,TOSEN;'
defb 'EORST,ESTOR,ESTRO,OTRES,RESTO,RETOS,ROSTE,ROTES,TEROS,TERSO,TORES,TOSER,TREOS;'


lexiLevel7 ; 6 lettres
defb 'AAABCL,ACAL,ALBA,ALCA,BACA,BALA,CALA,LACA,ABACA,ABALA,ACABA,ALABA,CABAL,ABACAL,ALBACA,BALACA,CABALA,CALABA,LACABA;'
defb 'AAABCN,ANCA,BACA,BANA,CANA,NABA,NACA,ABACA,ABANA,ACABA,ACANA,BACAN,BANCA,ACABAN,BACANA,CABANA,CANABA;'
defb 'AAABCS,ACAS,ASCA,BACA,BASA,CASA,SACA,ABACA,ACABA,ASABA,ASACA,BACAS,BASCA,CABAS,ABACAS,ACABAS,CASABA,SACABA;'
defb 'AAABDL,ABAD,ALBA,BADA,BALA,DABA,DALA,LADA,ABADA,ABALA,ADALA,ALABA,ALADA,BADAL,BALAD,BALDA,ABALAD,ALABAD,ALBADA,ALDABA,BALADA;'
defb 'AAABJR,ABAR,ABRA,AJAR,BAJA,JABA,JARA,RABA,RAJA,ABAJA,AJABA,AJARA,ARABA,BAJAR,JABRA,JARBA,ABAJAR,BAJARA,BARAJA,RAJABA;'
defb 'AAABJS,AJAS,BAJA,BASA,JABA,JASA,SAJA,ABAJA,AJABA,ASABA,BAJAS,JABAS,ABAJAS,AJABAS,JASABA,SAJABA;'
defb 'AAABLN,ALAN,ALBA,ALNA,ANAL,BALA,BANA,LANA,NABA,ABALA,ABANA,ALABA,ALANA,BALAN,BANAL,NABAL,NABLA,ABALAN,ALABAN,ALBANA,LANABA;'
defb 'AAABLR,ABAR,ABRA,ALAR,ALBA,ARLA,BALA,RABA,RALA,ABALA,ALABA,ALBAR,ARABA,BALAR,LABRA,RABAL,RALBA,ABALAR,ALABAR,ARLABA,BALARA;'
defb 'AAABLT,ALBA,ALTA,ATAL,BALA,BATA,LATA,TABA,TALA,ABALA,ABATA,ALABA,ATABA,BALTA,TABAL,TABLA,ATABAL,ATABLA,BALATA,TALABA;'
defb 'AAABNS,ANAS,ANSA,ASAN,ASNA,BANA,BASA,NABA,NASA,SANA,ABANA,ASABA,BANAS,BASAN,BASNA,NABAS,ABANAS,ASABAN,SABANA,SANABA;'
defb 'AAACMR,AMAR,ARCA,ARMA,CAMA,CARA,MACA,MARA,RAMA,ACAMA,ACARA,AMARA,MACAR,MARCA,ACAMAR,AMARCA,CAMARA,CARAMA,MACARA,MARACA;'
defb 'AAABNT,ANTA,ATAN,BANA,BATA,NABA,NATA,TABA,TANA,ABANA,ABATA,ANATA,ATABA,ATANA,BATAN,ABATAN,ATABAN,BATANA,TANABA;'
defb 'AAABRS,ABAR,ABRA,ARAS,ASAR,BASA,RABA,RASA,ABRAS,ARABA,ARASA,ASABA,ASARA,BASAR,BRASA,RABAS,SABRA,ABRASA,ARABAS,BASARA,RASABA;'
defb 'AAABST,ASTA,ATAS,BASA,BATA,SATA,TABA,TASA,ABATA,ASABA,ATABA,BASTA,BATAS,TABAS,ABASTA,ABATAS,ATABAS,TASABA;'
defb 'AAACDT,ACTA,ATAD,CADA,CATA,DACA,DATA,TACA,ACATA,ATACA,ATADA,CATAD,ACATAD,ATACAD,CATADA,TACADA;'
defb 'AAACPR,ARCA,ARPA,CAPA,CARA,PACA,PARA,RAPA,ACARA,APARA,CAPAR,CARPA,PARCA,APARCA,CAPARA,CARAPA,PARACA;'
defb 'AAADMS,AMAD,AMAS,ASAD,ASMA,DAMA,MASA,SAMA,ADAMA,AMADA,AMASA,ASADA,DAMAS,MASAD,ADAMAS,AMADAS,AMASAD,MASADA;'
defb 'AAADPT,APTA,ATAD,DATA,PATA,TAPA,ATADA,ATAPA,TAPAD,ADAPTA,ATAPAD,PATADA,TAPADA;'
defb 'AAAGMR,AGRA,AMAR,ARMA,GAMA,GARA,MAGA,MARA,RAMA,AMAGA,AMARA,GARMA,GRAMA,MAGRA,MARGA,AGRAMA,AMAGAR,AMARGA,GARAMA;'
defb 'AAAMNR,AMAN,AMAR,ARAN,ARMA,ARNA,MANA,MARA,RAMA,RANA,AMANA,AMARA,ARANA,ARMAN,MANAR,AMANAR,AMARAN,MANARA,MARANA;'
defb 'AAAMNT,AMAN,ANTA,ATAN,MANA,MATA,NATA,TANA,AMANA,AMATA,ANATA,ATANA,MANTA,MATAN,AMANTA,AMATAN,ATAMAN,TAMANA;'
defb 'AAAMRT,AMAR,ARMA,ARTA,ATAR,MARA,MATA,RAMA,RATA,TARA,AMARA,AMATA,ATARA,MARTA,MATAR,TARMA,TRAMA,AMATAR,MATARA,TAMARA,TARAMA;'
defb 'AAAPRR,ARAR,ARPA,ARRA,PARA,RAPA,RARA,APARA,ARARA,ARPAR,PARAR,PARRA,RAPAR,APARAR,APARRA,ARPARA,ARRAPA,PARARA,RAPARA;'
defb 'AABBER,ABAR,ABRA,ABRE,AREA,BABA,BEBA,BREA,RABA,ARABE,BABEA,BARBA,BARBE,ERABA,RABEA,BABEAR,BABERA,BARBEA,BREABA,REBABA;'
defb 'AABSSU,ASAS,BASA,BUAS,SUBA,USAS,ABUSA,BASAS,BAUSA,SUABA,SUBAS,USABA,ABUSAS,BAUSAS,SUABAS,USABAS;'
defb 'AACCHO,CACA,CACO,CHAO,COCA,HACA,ACOCA,CACAO,CACHA,CACHO,CHACA,CHACO,CHOCA,COCHA,ACACHO,ACHACO,ACHOCA,ACOCHA;'
defb 'AACGIU,AGUA,AUCA,CAGA,CAIA,GUIA,AGUAI,CAIGA,CIGUA,GUACA,AGUCIA,CAIGUA,GUACIA,GUAICA;'
defb 'AADOSS,ASAD,ASAS,ODAS,OSAD,OSAS,SAOS,SODA,SOSA,ADOSA,ASADO,OSADA,SOASA,SODAS,ADOSAS,ASADOS,OSADAS,SOASAD;'
defb 'AAADPR,ADRA,ARAD,ARDA,ARPA,DARA,PARA,RADA,RAPA,APARA,ARADA,ARPAD,PARAD,PARDA,RAPAD,APARAD,ARPADA,PARADA,RAPADA;'
defb 'AAERRR,ARAR,AREA,ARRA,ARRE,ERAR,ERRA,RAER,RARA,ARARE,ARREA,ERARA,ERRAR,RAERA,RAREA,REARA,ARREAR,ERRARA,RAREAR,REARAR;'
defb 'ABBEMO,AMBO,BEBA,BEBO,BOBA,ABOBE,BABEO,BEMBA,BEMBO,BOBEA,BOMBA,BOMBE,ABOMBE,BAMBEO,BOMBEA,EMBOBA;'
defb 'ABEEJN,AJEE,AJEN,ANEE,BAJE,BANE,ENEA,JAEN,JANE,JEBE,NEJA,AJEBE,AJEEN,ANEJE,BAJEE,BAJEN,ENEJA,BAJEEN,ENJABE,ENJEBA,JENABE;'
defb 'ACCHSU,CHAS,CHAU,CHUA,CHUS,CUCA,CUSA,CACHU,CHUAS,CHUCA,CUCAS,CUCHA,CUSCA,CACHUS,CHUCAS,CHUSCA,CUCHAS;'
defb 'ACDDEI,ADIE,CADI,CAED,CAID,CEDA,CEDI,CIAD,DECI,DICE,EDAD,IDEA,CEDIA,DECAI,DECIA,DECID,IDEAD,CADDIE,CEDIDA,DECIDA,DEDICA;'
defb 'ACDDIU,CADI,CAID,CIAD,DUDA,ACUDI,ADUCI,CUIDA,DIUCA,ACUDID,ADUCID,CIUDAD,CUIDAD;'
defb 'ACIILR,CALI,CARI,CIAR,CRIA,IRIA,IRIL,LIAR,LIRA,RAIL,RIAL,RICA,RILA,LICIA,LIRIA,RICIA,CILIAR,CIRIAL,LIRICA,RICIAL;'
defb 'ADIIMT,DIMA,DIMI,DITA,MIAD,MIDA,MITA,TIMA,DIMIA,IMITA,MITAD,TIMAD,ADMITI,DIMITA,IMITAD,TIMIDA;'
defb 'AEEHLN,ALEE,ANEE,ENEA,HALE,HELA,HELE,LANE,LEAN,LEEN,LENA,LENE,ALEEN,ENEAL,HALEN,HELEA,HENAL,ALHENE,ANHELE,HELEAN,HELENA;'
defb 'AEIQSU,AQUE,AQUI,QUIA,QUIS,USIA,EQUIS,ESQUI,QUIAS,QUISA,QUISE,SAQUE,SIQUE,ASEQUI,ASIQUE,ESQUIA,SEQUIA;'
defb 'AEMOPP,AMPO,APEO,MAPO,MOPA,PAPE,PAPO,PEPA,POMA,POPA,POPE,MAPEO,PAPEO,POEMA,POMPA,EMPAPO,EMPOPA,PAMPEO,POMPEA;'
defb 'AEOQSU,AQUE,ASEO,OQUE,OSEA,QUEO,AQUEO,QUESO,SAQUE,AQUEOS,AQUESO,ASQUEO,SAQUEO;'
defb 'AMOOSS,AMOS,MASO,OSAS,OSOS,SAOS,SOMA,SOMO,SOSA,SOSO,ASOMO,OMASO,OSOSA,SOASO,SOMAS,SOMOS,ASMOSO,ASOMOS,OMASOS,OSAMOS;'
defb 'CDEESU,CEDE,CESE,CUES,CUSE,DESE,ECUS,SECE,SEDE,SUDE,UCED,CEDES,DUCES,EDUCE,EDUCES,ESCUDE,SEDUCE,SUCEDE;'
defb 'CEELNU,CELE,CENE,CUNE,LEEN,LENE,LUCE,UNCE,CELEN,CUELE,CULEE,CULEN,CUNEE,LUCEN,LUENE,LUNEE,CUELEN,CULEEN,ENCULE,ENLUCE;'
defb 'CEENNO,CENE,CENO,ENEO,NECO,NENE,NEON,ONCE,CENEN,CONEE,NECEO,ONCEE,ONECE,CONEEN,ENCONE,NENECO,ONCEEN,ONECEN;'
defb 'CIILOT,CITO,COTI,LITO,TICO,TILO,CILIO,LICIO,LITIO,ICTIOL,LICITO,LITICO,TILICO;'
defb 'DEELSU,DELE,DESE,ELES,LEED,LEES,LUDE,LUES,SEDE,SUDE,DELES,DUELE,ELUDE,LEUDE,LUDES,SUELE,DUELES,ELUDES,LEUDES,SUELDE;'
defb 'DEENNO,DONE,EDEN,ENDE,ENEO,NENE,NEON,ONDE,DONEE,DONEN,ONDEE,DONEEN,ENDENO,ENDONE,ONDEEN;'
defb 'DEIIRS,DEIS,DIRE,IRES,IRIS,REID,REIS,RIES,DIESI,IREIS,IRIDE,IRISE,DIREIS,EDRISI,IRIDES,RESIDI;'
defb 'EEENRV,EREN,NEVE,RENE,REVE,VEER,VERE,REVEN,ENERVE,ENVERE,REVENE,VENERE;'
defb 'EEERST,ERES,ESER,ESTE,ETER,RESE,RETE,SEER,SERE,SETE,TESE,TRES,ESTER,RESTE,RETES,TERSE,ESTERE,ETERES,RESTEE,RETESE,SERETE;'
defb 'EEFIRR,ERRE,FREI,FRIE,REIR,RIFE,FERIE,FERIR,FERRE,FREIR,REIRE,RIERE,FIERRE,FREIRE,FRIERE,REFERI,REFREI,REFRIE;'
defb 'EEGIMR,EMIR,GEMI,GIME,GIRE,MERE,MIRE,REGI,REME,RIGE,RIME,ERIGE,GEMIR,MIGRE,EMERGI,EMIGRE,GEMIRE,REMIGE;'
defb 'EEHINR,EREN,HENI,HERI,HINE,NIRE,RENE,RENI,RIEN,RINE,ENRIE,HENIR,HIERE,REHEN,REINE,HENIRE,HERNIE,HIEREN,HINERE;'
defb 'EEIMPR,EMIR,MERE,MIRE,PEER,PERI,PIRE,REME,RIME,EMPRE,PRIME,IMPERE,PERIME,PREMIE,PRIMEE;'
defb 'EEINNV,NENE,NEVE,VENI,VINE,ENVIE,NIEVE,NINEE,VIENE,ENVIEN,ENVINE,NIEVEN,VIENEN;'
defb 'EEINSS,ENES,ESES,NEIS,NIES,SEIS,SENE,SESI,SIEN,SIES,SISE,SEISE,SENES,SESEN,SISEE,SISEN,NEISES,SEISEN,SIENES,SISEEN;'
defb 'EEISTT,ESTE,SETE,TESE,TEST,TETE,TITE,SIETE,TESTE,TETES,TISTE,TITEE,TITES,ETITES,TETEIS,TISTEE,TITEES;'
defb 'EEOPRR,ERRE,ERRO,OREE,PEER,PEOR,PERO,REPO,ROER,RORE,OPERE,PERRO,ROERE,PERERO,PERORE,PERREO,PORREE,REPEOR;'
defb 'EGILSU,GUIE,IGLU,LIES,LUES,LUIS,GILES,GUIES,GUISE,GULES,IGLUS,LEGUI,LIGUE,SEGUI,SIGUE,IGLUES,LEGUIS,LIGUES,SILGUE;'
defb 'EINNOV,NEON,NEVO,NINO,NOVE,OVEN,OVNI,VENI,VINE,VINO,ENVIO,NIEVO,NINEO,NIVEO,NOVEN,NOVIE,ENVINO,ENVION,INNOVE,NOVIEN,VENINO;'
defb 'EIOQTU,OQUE,QUEO,QUIO,QUITE,QUITO,TIQUE,TOQUE,TOQUI,QUIETO,QUIOTE,TEQUIO,TIQUEO;'
defb 'ILMOTU,LIMO,LITO,LUTO,MITO,MOLI,MULO,MUTO,TILO,TIMO,TUMO,UTIL,LITUO,MOTIL,MULTO,TIMOL,TULIO,MITULO,MULITO,MUTILO,ULTIMO;'
defb 'ILOPRT,LITO,OTRI,PILO,PIRO,PITO,RILO,RITO,TILO,TIPO,TIRO,TRIO,TROL,LITRO,POLIR,TOPIL,TORIL,PILTRO,POTRIL,TRIPLO,TRIPOL;'
defb 'INOOSV,NOVO,OVIO,OVNI,OVOS,SINO,SONO,VINO,VISO,VOSO,NOVIO,OVINO,OVNIS,SONIO,VINOS,VISON,NIVOSO,NOVIOS,OVINOS,VINOSO;'

lexiLevel8 ; 7 lettres
defb 'AABCERS,ABRACES,ACERBAS,BACERAS,BECARAS,BRACEAS,CABARES,CABERAS,CABREAS,CARABES,CEBARAS,CREABAS,ESCARBA,RECABAS;'
defb 'AACDENR,ACENDRA,ARENCAD,CANDARE,CARDENA,CARENAD,CARNEAD,CERANDA,CERNADA,CRANEAD,ENARCAD,ENCADAR,ENCARAD,RECADAN;'
defb 'AACENNR,ARENCAN,CANAREN,CARENAN,CARNEAN,CENARAN,CRANEAN,ENANCAR,ENARCAN,ENCANAR,ENCARAN,ENCARNA,NACERAN,NANCEAR;'
defb 'AADENST,ASENTAD,DANASTE,DATASEN,DESATAN,DESNATA,ENASTAD,ENTADAS,ESTANAD,NADASTE,SENTADA,TANDEAS,TENADAS,TENSADA;'
defb 'AADERST,ADESTRA,ADRASTE,DATARES,DATERAS,DESATAR,DESTARA,ESTRADA,RESTADA,RETADAS,RETASAD,TARDASE,TARDEAS,TERSADA;'
defb 'AAEGLRS,ALEGRAS,ALGARES,GALERAS,GARLASE,GELARAS,GLASEAR,LAGARES,LARGASE,LEGARAS,REGALAS,RESALGA,SALEGAR,SALGARE;'
defb 'AAEIMNR,AMARINE,AMINARE,ANIMARE,ARMENIA,IMANARE,MANERIA,MANIERA,MARINEA,MEARIAN,MENARIA,MIANARE,NAMERIA,REANIMA;'
defb 'AAEIRST,AIRASTE,ARIETAS,ATAIRES,ATAREIS,ATERIAS,ATIESAR,ATRAEIS,ATRESIA,ESTARIA,ETARIAS,RATEAIS,REATAIS,TESARIA;'
defb 'AAELRST,ALASTRE,ALERTAS,ALTARES,ALTERAS,ARLASTE,LASTARE,LATERAS,RELATAS,RESALTA,SALTARE,SALTEAR,SALTERA,TALARES;'
defb 'AAEPRRS,APARRES,APERRAS,APRESAR,ARPARES,ARRAPES,PARARES,PARRASE,RAPARES,RASPARE,RASPEAR,REPARAS,REPASAR,SEPARAR;'
defb 'ACEENRT,CARENTE,CARTEEN,ENCARTE,ENCETAR,ENTECAR,ENTERCA,RECATEN,RECENTA,RECETAN,RETACEN,TERCENA,TERENCA,TRECENA;'
defb 'ACEIORS,ACOREIS,CASERIO,COREAIS,COSERIA,COSIERA,ESCARIO,ESCORIA,ICAREOS,OCIARES,REACIOS,RECOSIA,ROCIASE,SOCAIRE;'
defb 'ACEORRS,ACORRES,ARROCES,CAREROS,CORARES,CORREAS,CORSEAR,CROARES,ESCORAR,RACEROS,RACORES,ROCERAS,ROSCARE,SOCARRE;'
defb 'ACERSTU,CUARTES,CURASTE,ERUCTAS,ESCRUTA,ESTUCAR,ETRUSCA,RUCASTE,SECUTAR,TEUCRAS,TRUCASE,TRUECAS,TUERCAS,TURECAS;'
defb 'ADEENRS,DESENAR,DRENASE,EDRASEN,ENREDAS,ENSERAD,RANDEES,REDASEN,REDENAS,RENDASE,RESENAD,SEDAREN,SENDERA,SERENAD;'
defb 'ADELORS,DESLOAR,DESOLAR,DOLARES,DOLERAS,DORALES,LADEROS,LODERAS,REDOLAS,RODALES,RODELAS,ROLDASE,ROSEDAL,SOLDARE;'
defb 'ADEMNOR,DEMORAN,DOMAREN,DOMENAR,ENMADRO,ENROMAD,MEANDRO,MERANDO,MODERAN,MODERNA,MONDARE,MONEDAR,REMANDO,REMONDA;'
defb 'AEENSST,ASESTEN,ENASTES,ENTESAS,ESTANES,ESTENAS,SATENES,SENTASE,SESENTA,SESTEAN,SETENAS,TANESES,TENSASE,TESASEN;'
defb 'AEINPRS,ASPIREN,ESPINAR,ESPIRAN,NISPERA,PIERNAS,PINARES,PINERAS,PIRASEN,PISAREN,PRENAIS,RAPINES,REPINAS,REPISAN;'
defb 'ADENOST,ATONDES,DENOSTA,DENOTAS,DESNATO,DETONAS,DONASTE,DOTASEN,ENTADOS,ESTANDO,SENTADO,TANDEOS,TENSADO,TESANDO;'
defb 'AEIMNST,AMISTEN,ESTIMAN,IMANTES,ISTMENA,MANISTE,MATINES,MENTAIS,MENTIAS,MIENTAS,MINASTE,MITANES,SAMNITE,TIMASEN;'
defb 'ADEORST,ADESTRO,DATEROS,DESTARO,DORASTE,DOTARES,ESTORDA,ESTRADO,RESTADO,RETADOS,RODASTE,SORTEAD,TERSADO,TODERAS;'
defb 'AEERSST,ASTERES,ESTERAS,ESTRESA,RASETES,RESTASE,RESTEAS,RETASES,RETESAS,SESTEAR,TERESAS,TERSASE,TESARES,TESERAS;'
defb 'AEEGNRS,ARGENES,EGRESAN,ENGRASE,GANERES,GENERAS,GRANEES,NEGARES,NEGREAS,NESGARE,REGANES,REGASEN,RENEGAS,RENGASE,SEGAREN;'
defb 'AEENRRT,ATERREN,ENERTAR,ENTERAR,ENTERRA,ENTRARE,ERRANTE,RENTARE,RENTERA,RETAREN,RETRAEN,TARREEN,TERNERA,TERREAN,TERRENA;'
defb 'AEFINRS,AFRENIS,AFRINES,ENFRIAS,ESNIFAR,FERINAS,FINARES,FRANEIS,FRENAIS,INFERAS,NAFREIS,REFINAS,RIFASEN,RIFENAS,SERAFIN;'
defb 'ADEMNOS,ANDEMOS,DANEMOS,DESMANO,DESMONA,DOMASEN,DOMENAS,MEDANOS,MENADOS,MENDOSA,MESANDO,MONDASE,MONEDAS,NADEMOS,NOMADES;'
defb 'AEGINRS,AGRISEN,ENGRIAS,GIRASEN,GRANEIS,GRISEAN,INGRESA,REGANIS,RENGAIS,RESIGAN,RESIGNA,RINGASE,SERINGA,SIGNARE,SINGARE;'
defb 'AENNORT,ENTONAR,ENTORAN,ENTORNA,ENTRANO,ENTRONA,NATERON,NORTEAN,NORTENA,NOTAREN,RATONEN,RETONAN,TANERON,TONAREN,TORNEAN;'
defb 'ACELORS,ALCORES,CALEROS,CALORES,CLAREOS,CLORASE,COLARES,COLERAS,CORALES,CORLASE,CORLEAS,ESCOLAR,LACEROS,LOCERAS,RECOLAS;'
defb 'AACELRS,ACLARES,ALACRES,CALARES,CALARSE,CALERAS,CELARAS,CLAREAS,ESCALAR,LACARES,LACERAS,LACRASE,LASCARE,RECALAS,SECARAL;'
defb 'AACERST,ACERTAS,ARCASTE,CARATES,CARETAS,CARTEAS,CATARES,CATERAS,CERASTA,ESTACAR,RECATAS,RESCATA,RETACAS,TARACES,TASCARE;'
defb 'AACNORS,ACORNAS,ACRONAS,ANARCOS,ANCORAS,ARCANOS,CANAROS,CANORAS,CARNOSA,CARONAS,CASARON,CORANAS,RACANOS,RASCONA,SACARON;'
defb 'AACORST,ACORTAS,ACOSTAR,ACTORAS,ATRACOS,CARATOS,CAROTAS,CASTORA,CATAROS,COARTAS,COSTARA,COTARAS,CROATAS,TARASCO,TOCARAS;'
defb 'ACEMORS,CAMEROS,CEROMAS,COMERAS,CREAMOS,CREMOSA,CROMASE,ESCOMAR,MACEROS,MARCEOS,MOCARES,MORCASE,MOSCARE,RECAMOS,RECOMAS;'
defb 'AEOPRSS,APRESOS,ASPEROS,ESPORAS,ESPOSAR,PASEROS,POSARES,POSERAS,PROSEAS,REPASOS,REPOSAS,SEPAROS,SOPARES,SOPERAS,SOPESAR;'
defb 'AEIMRST,ERMITAS,ESTIMAR,MERITAS,MIRASTE,MISTARE,MITRASE,REMITAS,RIMASTE,RITMASE,TERMIAS,TIMARES,TRAMEIS,TREMAIS,TREMIAS;'
lexiLevel9

defb 'AAABBELR,ABALARE,ABALEAR,ALABARE,ALABEAR,ALARABE,ALBEABA,ALBEARA,ARELABA,BABEARA,BALEABA,BALEARA,LABRABA,RABEABA,RALBABA,RALEABA,REBLABA,ALEBRABA;'
defb 'AAACCHNR,ACACHAN,ACACHAR,ACHACAN,ACHACAR,ACHANCA,ACHARAN,ANCHARA,ARACHAN,CACHANA,CACHARA,CARACHA,CHACANA,CHACARA,CHANCAR,ACHANCAR,CACHARAN,CHANCARA;'
defb 'AAADDNOR,ADONADA,ADORADA,ADORNAD,ADRANDO,ANDADOR,ANDRADA,ANDRADO,ANORADA,ARANADO,DANADOR,DARDANA,DARDANO,NADADOR,RANDADA,RANDADO,RONDADA,ADORNADA,ANDADORA,DANADORA,NADADORA;'
defb 'AAAEFNRR,AFANARE,AFEARAN,AFERRAN,ARANARE,ARANERA,ARENARA,ARFARAN,ARFAREN,ENRAFAR,FAENARA,FARREAN,FRANERA,FRENARA,NAFRARA,NAFRARE,RAFEARA,ENRAFARA,RAFEARAN;'
defb 'AAAFILNR,AFARIAN,AFILARA,AFINARA,AFRAILA,ALFARAN,ALFARIA,ALIARAN,ALIFARA,ALINARA,ANILARA,FANARIA,FILARAN,INFLARA,LANARIA,RAFAILA,RAFANIA,AFILARAN,AFRAILAN,ALFARIAN;'
defb 'AAAGMNRR,AGARRAN,AGRAMAN,AGRAMAR,AMARGAN,AMARGAR,AMARRAN,ARMARAN,GAMARRA,GARRAMA,GRAMARA,GRANARA,MANGARA,MARANAR,MARGARA,MARRAGA,MARRANA,GARRAMAN,GRAMARAN,MARGARAN;'
defb 'AAAIIMNR,AMAINAR,AMARIAN,AMARINA,AMINARA,ANIMARA,IMANARA,MANARIA,MANIRIA,MARIANA,MIANARA,MIARIAN,MINARIA,MINIARA,AMINARIA,ANIMARIA,IMANARIA,MIANARIA;'
defb 'AAALNRST,ALASTRA,ASALTAN,ASALTAR,ATRASAN,LANARAS,LASTARA,LASTRAN,SALARAN,SALTANA,SALTARA,TALARAN,TALARAS,TANARAS,TARSANA,TASARAN,ALASTRAN,LASTARAN,SALTARAN;'
defb 'AAAMPRST,AMPARAS,APARTAS,APASTAR,APASTRA,ATRAMPA,ATRAPAS,MATARAS,PARATAS,PASMARA,PASTARA,SARMATA,SATRAPA,TAMARAS,TAPARAS,TARAMAS,TRAMPAS,ATRAMPAS;'
defb 'AAANRSTU,ARTUNAS,ASUNTAR,ATRASAN,ATUNARA,ATUSARA,AUNARAS,NATURAS,SATURAN,TANARAS,TARSANA,TASARAN,TUNARAS,TUSARAN,UNTARAS,ASUNTARA,ATUNARAS,ATUSARAN;'
defb 'AAAPRSST,APARTAS,APASTAR,APASTAS,APASTRA,APSARAS,ASPARAS,ATRAPAS,ATRASAS,PARATAS,PASARAS,PASTARA,SATRAPA,TAPARAS,TARASAS,TASARAS,APASTRAS,PASTARAS,SATRAPAS,TRASPASA;'
defb 'AABBDERS,BABERAS,BARBASE,BARBEAD,BARBEAS,BARDASE,BRASEAD,BREABAS,BREADAS,DESBABA,DESRABA,EDRABAS,ESBARAD,REBABAS,REBASAD,REDABAS,DESBABAR,DESBARBA;'
defb 'AABCEIMS,ACABEIS,ACAMEIS,ACIEMAS,CAMBAIS,CAMBASE,CAMBEIS,CAMBIAS,CAMBIES,CASIMBA,CISMABA,EMBAIAS,EMBICAS,MACABIS,MACEAIS,MAICEAS,MEABAIS,CAMBIASE,MACABIES;'
defb 'AABDILSS,ABSIDAL,ABSIDAS,BADILAS,BALADIS,BALDAIS,BALDIAS,BISADAS,DIABLAS,LIBADAS,SABIDAS,SABILAS,SALDAIS,SALIDAS,SILABAD,SILABAS,SILBADA,SILBADAS;'
defb 'AABELMNU,ABENULA,ALBUMEN,AMBULAN,AMBULEN,AMUEBLA,AMUELAN,AUNABLE,EMBALAN,EMBAULA,EMULABA,LUNEABA,MANUELA,MELABAN,MUEBLAN,AMUEBLAN,EMBAULAN,EMULABAN,MANUABLE;'
defb 'AABGILOR,ABOLIRA,ABRIOLA,AGOBIAR,ALBORGA,ARABIGO,BAILAOR,BOGARIA,BOLAGAR,BRIGOLA,GAIBOLA,GALIBAR,GARBOLI,LOBRIGA,LOGRABA,OBLIGAR,ALBARIGO,GLORIABA,OBLIGARA;'
defb 'AABHNORS,AHORNAS,BARANOS,BASARON,HABANOS,HARONAS,HONRABA,HORNABA,ORNABAS,RABANOS,RABONAS,RONABAS,ROSABAN,SAHORNA,SOBARAN,SORNABA,HONRABAS,HORNABAS;'
defb 'AABIORSV,BAVAROS,BRAVIAS,BRAVIOS,BRAVOSA,ISOBARA,OBVIARA,ORABAIS,OVABAIS,OVARAIS,OVARIAS,RABIOSA,SOBARIA,VIBORAS,VIRABAS,ABRASIVO,BRAVOSIA,OBVIARAS;'
defb 'AABLLORS,ABOLLAR,ABOLLAS,ABOLSAR,ARBOLAS,ARSOLLA,BARLOAS,BOLLARA,BROLLAS,LABAROS,LABORAL,LABORAS,LLORABA,ORLABAS,ROLABAS,ROLLABA,BOLLARAS,LLORABAS,ROLLABAS,SALOBRAL;'
defb 'AABMRRSU,ABRUMAR,ABRUMAS,ABURRAS,AMURRAS,ARRUMAS,ARRUMBA,BRUMARA,MARABUS,MURABAS,MURARAS,RUMBARA,SABURRA,SAMURRA,ARRUMBAS,BRAMURAS,BRUMARAS,RUMBARAS;'
defb 'AABORRSS,ABORRAS,ARROBAS,BARROSA,OBRARAS,RABOSAS,ROBARAS,RORABAS,ROSABAS,ROSARAS,SABROSA,SARROSA,SOBARAS,SOBRARA,SOBRASA,SORRABA,BARROSAS,SOBRARAS,SOBRASAR,SORRABAS;'
defb 'AACCDEER,ACAECER,ACCEDER,ACEDARE,ACEDERA,ACERCAD,ACRECED,CACAREE,CACEARE,CARECED,CECEADA,CECEARA,CEDACEA,CERCADA,DECAERA,DECAREA,ACCEDERA,CEDACEAR;'
defb 'AACDEFLS,ACALDES,ADELFAS,CALDEAS,CELADAS,DEFALCA,ESCALAD,ESCALDA,ESCALFA,ESCLAFA,FALACES,FALCASE,FALDEAS,FALSEAD,SALCEDA,SECADAL,DEFALCAS,DESFALCA,ESCALFAD,ESCLAFAD;'
defb 'AACEFHNR,ACHAREN,AFRECHA,ANCHARE,CHAFARE,ECHARAN,FACHARE,FACHEAN,FACHEAR,FARACHE,FECHARA,RACHEAN,RANCHEA,AFRECHAN,CHAFAREN,FACHAREN,FARACHEN,FECHARAN;'
defb 'AACFIORS,ACORAIS,AFASICO,AFOCAIS,AFORAIS,AFORCAS,AFOSCAR,AFRICAS,AFRICOS,ASOCIAR,CARIOSA,COSARIA,FOSARIA,FRACASO,OCIARAS,OFRICAS,ORFICAS,AFORCAIS;'
defb 'AACGNORR,ACORNAR,ACORRAN,AGARRON,ANCORAR,ANGORRA,ARCARON,ARRANCO,ARROGAN,CAGARON,CARRAON,CARRONA,CORARAN,CROARAN,GROARAN,ROGARAN,RONCARA,CARGARON;'
defb 'AACHRRSU,ACHURAR,ACHURAS,ARRUCHA,ASURCAR,CHARRAS,CHARRUA,CHURRAS,CURARAS,CURSARA,HURRACA,RUCARAS,RUCHARA,SURCARA,URRACAS,ARRUCHAS,CHARRUAS,RUCHARAS;'
defb 'AACLLMOS,ACOLLAS,AMOLLAS,CALAMOS,CALLAOS,CALLOSA,CALMOSA,CALOMAS,CLAMOSA,CLOASMA,COALLAS,LACAMOS,MACOLLA,MALCASO,MALOCAS,SOLLAMA,CALLAMOS,MACOLLAS;'
defb 'AACMNNOR,AMORCAN,ANCORAN,CAMARON,CANAMON,CANARON,CORMANA,MACARON,MANARON,MARANON,MOCARAN,MONARCA,NACARON,NAMORAN,NORMANA,ROMANAN,MANCARON,MANCORNA;'
defb 'AACNOORR,ACARONO,ACORNAR,ACORRAN,ANCORAR,ARCARON,ARRANCO,CARRAON,CARRONA,CARRONO,CORARAN,CORARON,CORONAR,CORROAN,CROARAN,CROARON,RONCARA,ACORARON,CORONARA;'
defb 'AACOPRRS,ACORRAS,APORCAR,APORCAS,ARRAPOS,ARROPAS,ARROSCA,CAPARRO,CARRAOS,COPARAS,CORARAS,CROARAS,PACORAS,ROSCARA,SOCAPAR,SOCARRA,SORRAPA,CAPARROS;'
defb 'AACRRSTU,ARRUTAS,ASURCAR,ATURRAS,CASTRAR,CATURRA,CUARTAR,CUARTAS,CURARAS,CURSARA,CUTARRA,RUCARAS,RUTARAS,SATURAR,SURCARA,TRUCARA,URRACAS,CATURRAS,CUTARRAS,TRUCARAS;'
defb 'AADDEISV,ASEDIAD,ASEIDAD,AVADEIS,DADIVAS,DESAVIA,DESVAIA,DESVAID,DESVIAD,EVADAIS,EVADIAS,EVADIDA,IDEADAS,VADEAIS,VEDADAS,VISEADA,DESAVIAD,DESVAIDA,DESVIADA,EVADIDAS;'
defb 'AADEFLNR,ADRENAL,ALADREN,ALFAREN,ALFENAR,ENFADAR,ENFALDA,ENFARDA,ENLARDA,ENRAFAD,FALDEAN,FALDEAR,FALDERA,FLANERA,FRANELA,FRENADA,LARDEAN,ENFALDAR;'
defb 'AADFIMOR,ADORMIA,AFIRMAD,AMORFIA,DIFAMAR,DIMORFA,DIORAMA,DOMARIA,FARADIO,FIADORA,FIRMADA,FIRMADO,FORAIDA,FORMADA,MIADORA,MOFARIA,MORFADA,AFIRMADO;'
defb 'AADGLOPS,AGOLPAD,AGOLPAS,GALAPOS,GALOPAD,GALOPAS,GLOSADA,PAGADOS,PAGALOS,PAGODAS,PALADOS,PLAGADO,PLAGOSA,POLADAS,SALGADO,SOLAPAD,SOPLADA,PLAGADOS;'
defb 'AADIIMNS,AINDIAS,AMINAIS,ANIDAIS,ANIDIAS,ANIMAIS,DIMANAS,DINAMIA,IMANAIS,MANDAIS,MANIAIS,MANIDAS,MIANAIS,MINADAS,MINIADA,DIMANAIS,DINAMIAS,MINIADAS;'
defb 'AADJORST,ARTADOS,ATROJAD,ATROJAS,DOTARAS,JASADOR,RAJADOS,RODAJAS,SAJADOR,TAJADOR,TAJADOS,TARADOS,TARJADO,TASADOR,TORADAS,TROJADA,JOSTRADA,TARJADOS;'
defb 'AADLLMOS,AMOLDAS,AMOLLAD,AMOLLAS,DOLAMAS,LLAMADO,LOMADAS,MALDOSA,MALLADO,MOLADAS,SALLADO,SALMADO,SALOMAD,SOLLAMA,DALLAMOS,LLAMADOS,MALLADOS,SOLLAMAD;'
defb 'AADMNOOR,AMONADO,ANORADO,ARMANDO,AROMADO,DOMARAN,DOMARON,MADRONA,MADRONO,MARDANO,MONDARA,MORANDO,MORONDA,NAMORAD,NORMADA,NORMADO,ROMANAD,ANADROMO,AROMANDO,NAMORADO,ROMANADO;'
defb 'AADNOPSU,APUNADO,ASPANDO,AUNADOS,AUPADOS,AUPANDO,PADUANO,PANADOS,PANUDAS,PANUDOS,PASANDO,PAUSADO,PUNADAS,PUNADOS,SOPANDA,APUNADOS,PADUANOS,PAUSANDO;'
defb 'AADOPRSZ,ARPADOS,ASPADOR,DOPARAS,PADRAZO,PARADOS,PASADOR,PODARAS,PROSADA,RAPADOS,RAPSODA,RASPADO,RAZADOS,ROZADAS,ZAPADOR,ZARPADO,ZARPOSA,PADRAZOS,ZARPADOS;'
defb 'AADRRSTU,ARDURAS,ARRUTAD,ARRUTAS,ATURDAS,ATURRAD,ATURRAS,DATURAS,DURARAS,RASTRAD,RASURAD,RUTARAS,SATURAD,SATURAR,TARRUDA,TRASUDA,TURRADA,TARRUDAS,TRASUDAR,TURRADAS;'
defb 'AAEEFNST,AFEASEN,AFEASTE,ANEASTE,ANFETAS,ASAETEN,ATANESE,ATENEAS,ESTAFAN,ESTAFEN,FAENASE,FANASTE,FESTEAN,NATEASE,NEFASTA,SAETEAN,FAENASTE,FANTASEE;'
defb 'AAEFILRT,AFEITAR,AFIELAR,AFILARE,AFLETAR,AFRAILE,ALARIFE,ALETRIA,ALIFERA,FALTARE,FIELTRA,FLETARA,FLIRTEA,FRAILEA,LATERIA,LATIERA,TREFILA,FILATERA,FLETARIA;'
defb 'AAEGJNRR,AGARREN,ARENGAR,ENGARRA,GARREAN,GRAJEAN,GRAJEAR,GRAJERA,GRANARE,GRANEAR,GRANJEA,JARREAN,RAJAREN,REGANAR,REGARAN,RENGARA,GRANJEAR,GRANJERA;'
defb 'AAEHMRSU,AHUESAR,AHUMARE,AHUMASE,AHUSARE,AMURASE,HUMARAS,HUMARES,HUMEARA,HUMERAS,HUSMARA,HUSMARE,HUSMEAR,REASUMA,SAHUMAR,AHUMARES,HUMEARAS,HUSMEARA,SAHUMARE;'
defb 'AAEIPPSS,APEPSIA,APIPASE,ASEPSIA,ASPEAIS,PAPASES,PAPEAIS,PAPISAS,PASEAIS,PASPAIS,PASPASE,PASPEIS,PASPIES,PIPASES,PISPASE,PISPEAS,SAPEAIS,APEPSIAS,APIPASES,PAPASEIS;'
defb 'AAELLNOR,ALEARON,ALEONAR,ALOLARE,ANOLARE,ENROLLA,LLANEAR,LLANERA,LLANERO,LLENARA,LOLEARA,OLEARAN,RALEONA,RELLANA,RELLANO,ALELARON,ALOLAREN,LOLEARAN,ORELLANA;'
defb 'AAEMNRTZ,ENMATAR,ENTAMAR,ENTRAMA,MANTEAR,MANTERA,MATAREN,MATERNA,MAZAREN,MAZNARE,MENAZAR,MENTARA,REMATAN,RETAZAN,TARMENA,TAZAREN,TEMARAN,MARZANTE;'
defb 'AAENPQRU,ANQUEAR,ANQUERA,APARQUE,APUNARE,APUNEAR,APURENA,AQUERAN,ARQUEAN,AUPAREN,PAQUEAN,PAQUEAR,PAQUERA,PARQUEA,PERUANA,RAQUEAN,APARQUEN,PARQUEAN;'
defb 'AAEORRTT,ATORARE,OTATERA,RETORTA,RETRATA,RETRATO,TARAREO,TARTARO,TARTERA,TATAREO,TOREARA,TORRETA,TORTEAR,TORTERA,TRATARE,TROTARA,TROTARE,TARTAREO,TORTEARA;'
defb 'AAERSSTZ,ARTESAS,ASESTAR,ATRASES,ESTARAS,ESTARZA,ESTRAZA,RASASTE,RETASAS,RETAZAS,TARASES,TASARES,TAZARES,TAZASES,TESARAS,TRAZASE,ZARATES,ESTARZAS,ESTRAZAS,TRAZASES;'
defb 'AAFGIORS,AFOGAIS,AFORAIS,AGORAIS,AGRAFOS,FIGAROS,FISGARA,FORIGAS,FOSARIA,FRAGOSA,FROGAIS,GARFIOS,GARIFAS,GARIFOS,GOFRAIS,GRAFIAS,GRAFIOS,OSIFRAGA;'
defb 'AAFIILRS,AFILAIS,AFILIAR,AFILIAS,FALARIS,FIARAIS,FIARIAS,FILARAS,FILARIA,FILIARA,FRAILIA,LIARAIS,LIARIAS,LIFARAS,LISIARA,FILARAIS,FILARIAS,FILIARAS,FRAILIAS;'




lexiLevel10  ; 8/8 lettres
defb 'ACDEORS,ACORDES,ARCEDOS,CERDOSA,CODERAS,CORSEAD,CREADOS,DECORAS,DESCARO,DORACES,ESCARDO,ESCODAR,ESCORAD,RECADOS,RECODAS,SECADOR;'
defb 'ACEERST,ACETRES,CARTEES,CERASTE,CERATES,CESTERA,CREASTE,ECARTES,ERECTAS,ESTARCE,RECATES,RECETAS,RECTASE,RESCATE,RETACES,SECRETA;'
defb 'AAEMNRS,AMESNAR,ARMASEN,ENMARAS,ENRAMAS,MANARES,MANERAS,MANSEAR,MANSERA,MARANES,MASAREN,MENARAS,MESARAN,RAMNEAS,REMANAS,REMANSA;'
defb 'AENORRT,ARROTEN,ENTORAR,NORTEAR,RETARON,RETONAR,RETORNA,RETRONA,RORANTE,ROTAREN,TORNARE,TORNEAR,TORNERA,TORREAN,TRONARE,TRONERA;'
defb 'EEINRST,ENTREIS,ESTIREN,ESTRENI,ESTRIEN,ESTRINE,INERTES,INSERTE,INTERES,RENISTE,RENTEIS,RESENTI,RETENIS,RETINES,SENTIRE,TINERES;'
defb 'AEMNORS,ARMONES,ENROMAS,MANEROS,MARONES,MESARON,MONERAS,MORANES,MORASEN,MORENAS,NAMORES,NORMASE,RAMNEOS,RAMONES,REMANSO,ROMANES;'
defb 'AEMNORT,ARMENTO,ENMOTAR,ENTRAMO,MANTERO,MATERNO,MENTORA,MONTARE,MONTEAR,MONTERA,REMONTA,RETAMON,RETOMAN,TARMENO,TEMARON,TOMAREN;'
defb 'ABEILRS,ABRILES,BARILES,BIRLASE,BISELAR,BRIALES,LABREIS,LIBARES,LIBERAS,LIBRASE,LIBREAS,RABILES,RAIBLES,RALBEIS,REBLAIS,SILBARE;'
defb 'ABENORS,BANEROS,BARONES,BERONAS,BESARON,BORNEAS,BRENOSA,ENSOBRA,OBRASEN,RABONES,REBANOS,REBOSAN,RESOBAN,ROBASEN,SOBAREN,SOBRENA;'
defb 'AEENRSV,ARVENSE,ENERVAS,ENVARES,ENVERAS,ENVESAR,ESVAREN,NERVEAS,NEVARES,NEVERAS,RAVENES,REVENAS,REVESAN,VENERAS,VERANES,VERSEAN;'
defb 'AABELRS,ALARBES,ALBARES,ALEBRAS,ARABLES,BALARES,BALSEAR,BALSERA,LABRASE,RABALES,RALBASE,REBALSA,RESBALA,SABLEAR,SABLERA,SALABRE;'
defb 'ADENORT,ADENTRO,DENOTAR,DETONAR,DOTAREN,ENTORAD,ENTRADO,NORTEAD,RENTADO,RETANDO,RETONAD,RODANTE,TANDERO,TANEDOR,TORNEAD,TRENADO;'
defb 'AEMORST,AMOSTRE,ESTROMA,MAESTRO,MAROTES,MATEROS,MORASTE,MOSTEAR,MOTERAS,REMOSTA,REMOTAS,RETAMOS,RETOMAS,TAREMOS,TOMARES,TRAEMOS,TREMOSA;'
defb 'AAEPRSS,APRESAS,ARPASES,ASPARES,ASPERAS,PARASES,PARESAS,PASARES,PASERAS,PESARAS,RAPASES,RASPASE,RASPEAS,REPASAS,SAPERAS,SARAPES,SEPARAS;'
defb 'AEEPRST,APRESTE,ESPARTE,ESPETAR,ESTEPAR,ESTREPA,PARTEES,PATERES,PERETAS,PETARES,PETERAS,PETREAS,REPASTE,REPTASE,RESPETA,TRAPEES,TREPASE;'
defb 'AEERRST,ARRESTE,ATERRES,ERRASTE,ESTERAR,RASTREE,RESTARE,RESTEAR,RETARES,RETESAR,RETRAES,RETRASE,SERRETA,TARREES,TERREAS,TERSARE,TRAERES;'
defb 'AACELNR,ACLAREN,ANCLARE,ANCLEAR,ARANCEL,CALAREN,CANELAR,CANERLA,CELARAN,CLAREAN,CRANEAL,ENCALAR,LACAREN,LACERAN,LANCEAR,LANCERA,RECALAN;'
defb 'ACEINRS,ARCINES,CARINES,CENIRAS,CERINAS,CERNAIS,CERNIAS,CIERNAS,CINERAS,CRIASEN,CRINASE,ENRISCA,INCRASE,NARICES,RANCIES,RECINAS,SINCERA;'
defb 'ACEIRST,CARITES,CATIRES,CERITAS,CIERTAS,CIRATES,CITARES,CRIASTE,ESCRITA,ESTARCI,RECITAS,RECTAIS,RETICAS,TERCIAS,TICERAS,TRACEIS,TRISECA;'
defb 'ACDENOS,ASCONDE,CANEDOS,CENADOS,CENSADO,CESANDO,CODENAS,CONDESA,DECANOS,DESCANO,DOCENAS,ESCANDO,ESCODAN,ESCONAD,ESCONDA,NOCEDAS,SECANDO;'
defb 'ABEORST,ABORTES,ABSORTE,BASTERO,BATEROS,BOSTEAR,BOTARES,BROTASE,ESTORBA,OBRASTE,OBSTARE,REBATOS,REBOTAS,RETOBAS,ROBASTE,TABORES,TOBARES,TOBERAS;'
defb 'AAERRST,ARRATES,ARRESTA,ARTERAS,ATERRAS,ERRATAS,ETARRAS,RASTREA,RATERAS,RESTARA,RETARAS,RETASAR,RETRASA,TARARES,TARREAS,TERSARA,TRAERAS,TRASERA;'
defb 'ABELORS,ALBEROS,ALBORES,ARBOLES,BALEROS,BALSERO,BARLOES,BOLARES,BOLERAS,BOLSEAR,BOLSERA,LABORES,LOBERAS,REBALSO,RESBALO,ROBLASE,SABLERO,SALOBRE;'
defb 'AEENPRS,APRENSE,APRESEN,ESPERAN,NESPERA,PENARES,PENERAS,PENSARE,PERNEAS,PESAREN,PRENASE,RASPEEN,REPASEN,REPENSA,REPESAN,RESEPAN,SEPAREN,SERPEAN;'
defb 'AENRSTU,ESTURAN,NEUTRAS,NUESTRA,RESUNTA,REUNTAS,RUANTES,RUNASTE,RUSENTA,RUTASEN,RUTENAS,SATUREN,TRUENAS,TUNARES,TUNERAS,TURNASE,TUSAREN,UNTARES;'
defb 'AEMNOST,AMENTOS,AMONTES,ENMOSTA,ENMOTAS,MANETOS,MANTEOS,MATONES,METANOS,MONTASE,MONTEAS,MONTESA,MOSTEAN,SOMATEN,SOMETAN,TANEMOS,TOMASEN,TONEMAS;'
defb 'AEENRST,ENSARTE,ENTERAS,ENTESAR,ENTRASE,ESTERAN,ESTRENA,ETERNAS,RENETAS,RENTASE,RESTANE,RESTEAN,RETASEN,RETESAN,SENTARE,SETENAR,TANERES,TENSARE,TESAREN;'
defb 'AEIPRST,ESPITAR,ESTRIPA,PARISTE,PERISTA,PERITAS,PIRASTE,PISTARE,PISTEAR,PISTERA,PITARES,PITERAS,PRIETAS,RAPTEIS,REPITAS,REPTAIS,TAPIRES,TRASPIE,TREPAIS;'
defb 'AENOPRT,APORTEN,APRETON,APRONTE,ATROPEN,ENTRAPO,OPTAREN,PATERNO,PERNOTA,PETARON,PONTEAR,PORTEAN,PORTENA,POTAREN,POTERNA,POTREAN,PRENOTA,TOPAREN,TREPANO;'
defb 'ADEMORS,ADREMOS,ARDEMOS,DAMEROS,DAREMOS,DEMORAS,DESAMOR,DESARMO,DESRAMO,DOMARES,EDRAMOS,MADEROS,MADORES,MEDROSA,MERADOS,MERDOSA,MODERAS,MOREDAS,REDAMOS,REDOMAS;'
defb 'AELORST,ALERTOS,ALTEROS,ALTORES,ARLOTES,LATEROS,LOTERAS,ORLASTE,RELATOS,RESALTO,ROLASTE,ROTALES,SALTERO,SOLETAR,SOLTARE,SOLTERA,TALEROS,TOLERAS,TORALES,TRASLOE;'
defb 'AAENRST,ANTERAS,ASENTAR,ATRASEN,ENASTAR,ENSARTA,ESTANAR,ESTARAN,ESTARNA,RASANTE,RESTANA,RETASAN,SANTERA,SENTARA,TANARES,TANERAS,TARASEN,TASAREN,TENSARA,TESARAN;'
defb 'ACENORT,ACORTEN,ARCONTE,CANTERO,CARETON,CARTONE,COARTEN,CONTARE,CONTERA,CONTRAE,CORNETA,COTAREN,CRETONA,ENCARTO,ENTORCA,RECATON,RECONTA,RETOCAN,TOCAREN,TROCEAN;'
defb 'AACEIRS,ACAREIS,ACERAIS,ACERIAS,ARICASE,ASICARE,CAERIAS,CAREAIS,CARIASE,CARISEA,CASERIA,CESARIA,ESCARIA,ICAREAS,RACEAIS,RAICEAS,REACIAS,RECAIAS,SACIARE,SECARIA;'



defb PIPE ; end marker => win the game





charset


print 'fin des donnees ',{hex}$


save 'spec.bin',#100,$-#100



