
MAX_PATTERN equ 9
ENDMARK equ 128

KeyF1addr equ 64+#C000+28*64+26+#800*5 ; 1
KeyF2addr equ 64+#C000+29*64+30+#800*0 ; 2
KeyF3addr equ 64+#C000+28*64+34+#800*5 ; 3
KeyF4addr equ 64+#C000+26*64+25+#800*5 ; 4
KeyF5addr equ 64+#C000+26*64+30+#800*5 ; 5
KeyF6addr equ 64+#C000+26*64+35+#800*5 ; 6
KeyF7addr equ 64+#C000+24*64+26+#800*5 ; 7
KeyF8addr equ 64+#C000+24*64+30+#800*0 ; 8
KeyF9addr equ 64+#C000+24*64+34+#800*5 ; 9

      VIRGULE equ 64
POINT_VIRGULE equ 66
         PIPE equ 68


buildsna
bankset 0
org #38
ei:ret

run #100
org #100
ld hl,#C9FB : ld (#38),hl
ld sp,#100
ei
call razScr
ld hl,cubicScreenCRTC : call crtc_setup

call scankeyboard.init
call doFontConversion
call setColorz
ld hl,cell_motsEnFete : ld de,#0003 : call displayStringCell

ld hl,str_init01 : ld de,1+#C000+5*64        : call displayString
ld hl,str_init02 : ld de,1+#C000+6*64+4*#800 : call displayString
ld hl,str_init03 : ld de,0+#C000+8*64        : call displayString

ld hl,str_init04 : ld de,0+#C000+11*64        : call displayString
ld hl,str_init05 : ld de,0+#C000+12*64+4*#800 : call displayString
ld hl,str_init06 : ld de,0+#C000+14*64        : call displayString

ld hl,str_init07 : ld de,0+#C000+17*64        : call displayString
ld hl,str_init08 : ld de,0+#C000+18*64+4*#800 : call displayString
ld hl,str_init09 : ld de,0+#C000+20*64        : call displayString

ld hl,str_init10 : ld de,1+#C000+23*64        : call displayString
ld hl,str_init11 : ld de,0+#C000+24*64+4*#800 : call displayString
ld hl,str_init12 : ld de,0+#C000+26*64        : call displayString


.space call scankeyboard

ld a,(KEY_B_BYTE) : and KEY_B_BIT : jr nz,.niveauBonus

ld hl,keyboardmap : xor a : ld b,10
.testTouche or (hl) : inc hl : djnz .testTouche
or a : jr z,.space
call refreshChoices.waitKeyboard
jp newGame

.niveauBonus
ld hl,lexiBonus : ld (lexiCurrentLevel),hl
jp initGame


razScr
ld bc,#7F01 : out (c),c : ld a,#58 : out (c),a
inc c : out (c),c : out (c),a
inc c : out (c),c : out (c),a
ld hl,#C000 : xor a
.razScr repeat 8 : ld (hl),a : inc l : rend : jr nz,.razScr : inc h : jr nz,.razScr
;...
setColorz
ld hl,#4B46 : ld de,#5840
ld bc,#7F03
out (c),c : out (c),l : dec c
out (c),c : out (c),h : dec c
out (c),c : out (c),e : dec c
out (c),c : out (c),d : ld c,#10
out (c),c : out (c),d
ret



novbl ld b,#F5 : .loop in a,(c) : rra : jr c,.loop
vbl ld b,#F5 : .loop in a,(c) : rra : jr nc,.loop : ret

cubicScreenCRTC defb 6,32,1,32,2,42,7|0x80,34

doFontConversion
ld hl,fontChar
ld de,fontCharCell
ld b,hi(convertFont)
exx
ld bc,fontChar{26}+18-fontChar
.prepFont exx : ld c,(hl) : ld a,(bc) : ld (de),a : inc hl : inc de : exx : dec bc : ld a,b : or c : jr nz,.prepFont
ret

align 256
convertFont
repeat 256,x,0
	p1=x&%10001000
	p2=x&%1000100
	p3=x&%100010
	p4=x&%10001
	if !p1 : p1=%10001000 : endif
	if !p2 : p2=%1000100 : endif
	if !p3 : p3=%100010 : endif
	if !p4 : p4=%10001 : endif
	defb p1|p2|p3|p4
rend

align 256
charAddress
yoffset=0 ; pour se centrer (sprite de 3 bytes sur 18 lignes
repeat 15 ; 12 lignes de 20 pixels
	xoffset=0 ; on peut pas partir de 1.5 ...
	repeat 16 ; 16 grandes cases de 4 octets
		scrAdr=#C000+xoffset+(yoffset>>3)*64+(yoffset%8)*0x800
		defw scrAdr
		xoffset+=4
	rend
	repeat 16 : defw 0 : rend
	yoffset+=16
rend

align 2
charLine
yoffset=0 ; pour se centrer (sprite de 3 bytes sur 18 lignes
repeat 15 ; 12 lignes de 20 pixels
	scrAdr=#C000+(yoffset>>3)*64+(yoffset%8)*0x800
	defw scrAdr
	yoffset+=16
rend

include 'arkosSetupCRTC.asm'

align 256
fontChar
repeat 27,cpos,0
	fontChar{cpos}
	incbin 'terminalFont8x9.bin',cpos*20,18
	if ($&0xFF)>256-18 : align 256 : print 'adjust',cpos : endif
rend

align 256
fontOffset
repeat 27,x,0
defw fontChar{x}
rend

align 256
fontCharCell
repeat 27,cpos,0
	fontCharCell{cpos}
	incbin 'terminalFont8x9.bin',cpos*20,18
	if ($&0xFF)>256-18 : align 256 : print 'adjust',cpos : endif
rend

align 256
fontOffsetCell
repeat 27,x,0
defw fontCharCell{x}
rend

; A=char
; DE=Y/X
displayCharCell
sla e : sla e : sla e : srl de : srl de : ld hl,charAddress : add hl,de
ld e,(hl) : inc l : ld d,(hl) ; DE=destination on screen
displayCharCellAt ; run this with DE already set!
ld h,hi(fontOffsetCell) : ld l,a : ld a,(hl) : inc l : ld h,(hl) : ld l,a ; HL=char address

inc e : ld a,#FF : ld (de),a : inc e : ld (de),a : dec e : dec e
ld a,d : add 8 : ld d,a : jr nc,.pushNextPP
ld a,64 : add e : ld e,a : ld a,d : adc #C0 : ld d,a
.pushNextPP

ld a,(de) : or %110011 : ld (de),a : inc e : ld a,#FF : ld (de),a : inc e : ld (de),a : inc e : ld a,(de) : or %11001100 : ld (de),a : dec e : dec e : dec e
ld a,d : add 8 : ld d,a : jr nc,.pushNextP
ld a,64 : add e : ld e,a : ld a,d : adc #C0 : ld d,a
.pushNextP

ld b,9
.pushLine
ld a,(de) : or %110011 : ld (de),a : inc e : ld a,(hl) : inc l : ld (de),a : inc e : ld a,(hl) : inc l : ld (de),a : inc e : ld a,(de) : or %11001100 : ld (de),a : dec e : dec e : dec e
ld a,d : add 8 : ld d,a : jr nc,.pushNext
ld a,64 : add e : ld e,a : ld a,d : adc #C0 : ld d,a
.pushNext
djnz .pushLine

; LastLine
ld a,(de) : or %110011 : ld (de),a : inc e : ld a,#FF : ld (de),a : inc e : ld (de),a : inc e : ld a,(de) : or %11001100 : ld (de),a : dec e : dec e : dec e
ld a,d : add 8 : ld d,a : jr nc,.pushNextD
ld a,64 : add e : ld e,a : ld a,d : adc #C0 : ld d,a
.pushNextD
inc e : ld a,#FF : ld (de),a : inc e : ld (de),a
ret


; A=char
; DE=screen destination
displayChar
ld h,hi(fontOffset) : ld l,a : ld a,(hl) : inc l : ld h,(hl) : ld l,a ; HL=char address
ld b,8
.pushLine
ld a,(hl) : inc l : ld (de),a : inc e : ld a,(hl) : inc l : ld (de),a : dec e
ld a,d : add 8 : ld d,a : jr nc,.pushNext
ld a,64 : add e : ld e,a : ld a,d : adc #C0 : ld d,a
.pushNext
djnz .pushLine
ld a,(hl) : inc l : ld (de),a : inc e : ld a,(hl) : ld (de),a ; LastLine
ret



; HL=string
; DE=screen destination
displayString
ld a,(hl) : add a : ret c : push de,hl
call displayChar
pop hl,de : inc hl : inc e : inc e : jr displayString

; HL=string
; DE=X/Y
displayStringCell
ld a,(hl) : add a : ret c : push de,hl
call displayCharCell
pop hl,de : inc hl : inc e : jr displayStringCell






;*************************************************************
                            newGame
;*************************************************************
ld hl,lexiLevel1 : ld (lexiCurrentLevel),hl
;*************************************************************
                           initGame
;*************************************************************
ld sp,#100
xor a : ld (niveauAide),a
ld hl,(lexiCurrentLevel)
ld a,(hl) : cp PIPE : jp z,winZeGame


ld ix,levelUP.levelADR : ld iy,levelUP.levelSTR : ld de,hl
.trouveNiveau ld hl,(ix+0) : ld a,h : or l : jr z,.retourNormale : sbc hl,de : jr z,.messageNiveau : inc ix : inc ix : inc iy : inc iy : jr .trouveNiveau
.messageNiveau
call razScr
ld hl,(iy+0) : ld de,#C000+64*15+18 : call displayString
ld bc,2 : .msgWait halt : djnz .msgWait : dec c : jr nz,.msgWait

.retourNormale
ld hl,(lexiCurrentLevel)
ld a,VIRGULE : ld b,0
.countChoices cp (hl) : jr z,.countDone : inc hl : inc b : jr .countChoices : .countDone
ld a,b : ld (nbChoices),a
; en fonction du nombre de lettres on affiche un panneau de controle different + infos pour la saisie
ld hl,buildChoiceList : add a : ld e,a : ld d,0 : add hl,de : ld a,(hl) : inc l : ld h,(hl) : ld l,a : jp (hl)
retourInitChoice

ld hl,tailleEntrees : ld de,hl : inc de : ld bc,21 : ld (hl),0 : ldir ; raz entries + extra zero
; parsing des mots pour construire le visuel
ld iy,tailleEntrees : ld xl,0
ld hl,(lexiCurrentLevel) : ld d,0 : ld a,(nbChoices) : inc a : ld e,a : add hl,de ; se positionner sur le premier mot
; compter les longueurs
.scanEntrees  ld b,0
.scanEntree   ld a,(hl) : cp POINT_VIRGULE : jr z,.scanTermine : cp VIRGULE : jr z,.scanEntreeOK : inc b : inc hl : jr .scanEntree
.scanEntreeOK ld (iy+0),b : inc xl : inc iy : inc hl : jr .scanEntrees
.scantermine  ld (iy+0),b : inc xl ; dernière entrée
ld a,xl : ld (nombreMots),a
ld a,b : ld (longueurMax),a ; car la longueur MAX peut être inférieure au nombre de lettres

; build HUD cell positions
.buildHUDcellPositions
ld de,#C000+23*64 : ld a,(longueurMax) : sub 3 : add a : ld c,a : ld a,26 : sub c : add e : ld e,a
ld hl,hud1addr : ld bc,4 : ld a,(longueurMax)
.loop
	ld (hl),e : inc hl
	ld (hl),d : inc hl
	ex hl,de : add hl,bc : ex hl,de
	dec a : jr nz,.loop

ld hl,(lexiCurrentLevel) : ld de,referencePattern : ld b,0 : ld a,(nbChoices) : ld c,a : ldir ; copier le motif de jeu
ld a,(nbChoices) : ld b,a : ld a,MAX_PATTERN : sub b : jr z,.skipRaz : ld b,a : xor a : .razNext ld (de),a : inc de : djnz .razNext ; normalement inutile mais...   ceinture/bretelles!
.skipRaz
call initBoard

;*************************************************************
                           gameLoop
;*************************************************************
call controleClavier

ld hl,tailleEntrees : ld b,21 : xor a
.controleGagne or (hl) : inc hl : djnz .controleGagne
or a : jp z,niveauSuivant

jp gameLoop


;*************************************************************
                        niveauSuivant
;*************************************************************
ld hl,#C000+22*64
ld c,80
.razLines xor a : ld b,64 : push hl
.razLine ld (hl),a : inc l : djnz .razLine : pop hl
ld a,h : add 8 : ld h,a : jr nc,.next
ld a,64 : add l : ld l,a : ld a,#C0 : adc h : ld h,a : res 3,h 
.next
dec c : jr nz,.razLines

ld ix,(bravoList)
ld hl,(ix+0) : ld (bravoList),hl
ld hl,(ix+2) : ld de,#C000+27*64+13 : call displayString

ld bc,2
.rewait halt : djnz .rewait : dec c : jr nz,.rewait

.GOTOleSuivant
ld hl,(lexiCurrentLevel)
.scanEnd ld a,(hl) : cp POINT_VIRGULE : jr z,.leSuivant : inc hl : jr .scanEnd
.leSuivant
inc hl : ld a,(hl) : cp PIPE : jr z,winZeGame
ld (lexiCurrentLevel),hl
jp initGame

;*************************************************************
                           winZeGame
;*************************************************************
ld hl,lexiLevel1 : ld (lexiCurrentLevel),hl
; afficher une fin
call razScr
ld hl,str_win01 : ld de,0+#C000+16*64+2        : call displayString
; menu
ld bc,5
.waiteur halt : djnz .waiteur : dec c : jr nz,.waiteur
jp #100

;*************************************************************
                        controleClavier
;*************************************************************
;.automate ld a,0 : inc a : and 3 : ld (.automate+1),a : jp nz,aideAuJoueur : jp niveauSuivant.GOTOleSuivant
call scankeyboard
ld hl,(KeyF1char) : ld a,(hl) : cp #FF : jr z,.skipF1 : ld a,(KEY_F1_BYTE) : and KEY_F1_BIT : jp nz,addCharToHud : .skipF1
ld hl,(KeyF2char) : ld a,(hl) : cp #FF : jr z,.skipF2 : ld a,(KEY_F2_BYTE) : and KEY_F2_BIT : jp nz,addCharToHud : .skipF2
ld hl,(KeyF3char) : ld a,(hl) : cp #FF : jr z,.skipF3 : ld a,(KEY_F3_BYTE) : and KEY_F3_BIT : jp nz,addCharToHud : .skipF3
ld hl,(KeyF4char) : ld a,(hl) : cp #FF : jr z,.skipF4 : ld a,(KEY_F4_BYTE) : and KEY_F4_BIT : jp nz,addCharToHud : .skipF4
ld hl,(KeyF5char) : ld a,(hl) : cp #FF : jr z,.skipF5 : ld a,(KEY_F5_BYTE) : and KEY_F5_BIT : jp nz,addCharToHud : .skipF5
ld hl,(KeyF6char) : ld a,(hl) : cp #FF : jr z,.skipF6 : ld a,(KEY_F6_BYTE) : and KEY_F6_BIT : jp nz,addCharToHud : .skipF6
ld hl,(KeyF7char) : ld a,(hl) : cp #FF : jr z,.skipF7 : ld a,(KEY_F7_BYTE) : and KEY_F7_BIT : jp nz,addCharToHud : .skipF7
ld hl,(KeyF8char) : ld a,(hl) : cp #FF : jr z,.skipF8 : ld a,(KEY_F8_BYTE) : and KEY_F8_BIT : jp nz,addCharToHud : .skipF8
ld hl,(KeyF9char) : ld a,(hl) : cp #FF : jr z,.skipF9 : ld a,(KEY_F9_BYTE) : and KEY_F9_BIT : jp nz,addCharToHud : .skipF9
ld a,(KEY_SPACE_BYTE) : and KEY_SPACE_BIT : jp nz,verificationMot
ld a,(KEY_ENTER_BYTE) : and KEY_ENTER_BIT : jp nz,verificationMot
ld a,(KEY_RETURN_BYTE) : and KEY_RETURN_BIT : jp nz,verificationMot
ld a,(KEY_TAB_BYTE) : and KEY_TAB_BIT : jp nz,niveauSuivant.GOTOleSuivant
ld a,(KEY_ESC_BYTE) : and KEY_ESC_BIT : jp nz,levelUP
ld a,(KEY_H_BYTE) : and KEY_H_BIT : jp nz,aideAuJoueur
ret

addCharToHud
ld a,(hl) ; on récupère la valeur de la touche
ld (hl),0 : push hl ; d'abord on met à zéro pour effacer la touche
ld hl,(workPosition) : ld (hl),a : inc hl : ld (workPosition),hl ; on ajoute au HUD
call refreshChoices ; update display
pop hl : ld (hl),#FF ; et ensuite on inhibe après affichage!!!
ld hl,workPattern : ld d,0 : ld a,(longueurMax) : dec a : ld e,a : add hl,de : ld a,(hl) : or a : ret z
jp verificationMot

include 'keyboard.asm'

;*************************************************************
			verificationMot
;*************************************************************
; comparer le contenu du HUD avec les entrées
ld hl,(lexiCurrentLevel) : ld d,0 : ld a,(nbChoices) : ld e,a : inc e : add hl,de ; HL=debut des mots

ld xl,-1
.recompare
ld de,workPattern : inc xl
.compareMot ld a,(de) : cp (hl) : jr nz,.difference : inc de : inc hl : jr .compareMot ; petera toujours car la fin du mot est une virgule, un point-virgule et de l'autre côté un zéro
.difference ld a,(de) : or a : jr z,.finHud
; pas la fin du HUD, passer au mot suivant et recommencer
.motSuivant ld a,(hl) : inc hl : cp VIRGULE : jr z,.recompare : cp POINT_VIRGULE : jr z,.rienTrouve : jr .motSuivant

.finHud
ld a,(hl) : cp VIRGULE : jr z,.cestOK : cp POINT_VIRGULE : jr nz,.motSuivant ; fin du HUD mais pas d'un mot, on recommence (trop court!)
.cestOK
; XL=numéro du mot!!!
; se repositionner sur le début du mot
dec hl
.retourAuDebut ld a,(hl) : cp VIRGULE : jr z,.debutOK : dec hl : jr .retourAuDebut
.debutOK : inc hl ; HL=debut du mot
ld iy,tailleEntrees : ld a,xl : add yl : ld yl,a : ld a,yh : adc 0 : ld yh,a ; (IY) contient la longueur du mot
ld a,(iy+0) : or a : jp z,.rienTrouve ; zéro == déjà trouvé
ld xh,0 : add ix,ix : ld de,posEntrees : add ix,de : ld de,(ix+0) ; DE=position ecran du mot

.afficherMotEnPlace ld a,(hl) : push de,hl : call displayCharCellAt : pop hl,de : inc de : inc de : inc de : inc de : inc hl : dec (iy+0) : jr nz,.afficherMotEnPlace

.rienTrouve
; reset du HUD, des buffers
ld hl,referencePattern : ld de,currentPattern : ld bc,MAX_PATTERN : ldir
ld hl,workPattern : ld de,workPattern+1 : ld (hl),0 : ld bc,MAX_PATTERN-1 : ldir
ld hl,workPattern : ld (workPosition),hl
; reset affichage
jp refreshChoices


;*************************************************************
                         aideAuJoueur
;*************************************************************
ld ix,(lexiCurrentLevel) : ld d,0 : ld a,(nbChoices) : ld e,a : inc e : add ix,de ; IX=debut des mots
ld iy,tailleEntrees
xor a : exa
.reLoop
ld a,0 : niveauAide=$-1
cp (iy+0) : jr nc,.nextWord
; le mot a venir n'est pas trop court
add xl : ld xl,a : ld a,xh : adc 0 : ld xh,a : ld hl,posEntrees : exa : ld c,a : exa : ld b,0 : add hl,bc : add hl,bc : ld e,(hl) : inc hl : ld d,(hl)
ld h,0 : ld a,(niveauAide) : ld l,a : add hl,hl : add hl,hl : add hl,de : ex hl,de ; DE=position de la lettre
ld a,(ix+0) : call displayCharCellAt
.nextWord
ld a,POINT_VIRGULE : cp (ix+0) : jr z,.finAide
ld a,VIRGULE : cp (ix+0) : jr z,.nextNext
inc ix
jr .nextWord
.nextNext
inc ix
exa : inc a : exa ; increment word index
inc iy
jr .reLoop

.finAide
ld a,(niveauAide)
inc a
ld (niveauAide),a
ld c,a : ld a,(longueurMax) : cp c
jp z,niveauSuivant
; desactiver les mots aussi longs que l'aide : C
ld hl,tailleEntrees : ld b,21
.disableEntries ld a,(hl) : cp c : jr nz,.disableNext : ld (hl),0 : .disableNext inc hl : djnz .disableEntries
call refreshChoices
ret

;*************************************************************
			  initBoard
;*************************************************************
call razScr

ld hl,referencePattern : ld de,currentPattern : ld bc,MAX_PATTERN : ldir
ld hl,workPattern : ld de,workPattern+1 : ld (hl),0 : ld bc,MAX_PATTERN-1 : ldir
ld hl,workPattern : ld (workPosition),hl

ld iy,tailleEntrees
ld ix,charLine
ld de,posEntrees
ld a,(nombreMots) : cp 11 : jp c,.dixOuMoins
;=====================================================
; deux colonnes!
;=====================================================
.deuxColonnes
ld a,32 : ld (leCentre),a ; defaut
ld a,(nombreMots) : srl a : ld (hauteurColonne),a
dec a ; connaitre la longueur du dernier mot de la première colonne
push iy : pop hl : add l : ld l,a : ld a,h : adc 0 : ld h,a : ld a,(hl) : ld (longueurColonneGauche),a
ld a,(hauteurColonne) : add a : dec a : push iy : pop hl : add l : ld l,a : ld a,h : adc 0 : ld h,a : ld a,(hl) : ld (longueurColonneDroite),a

ld hl,longueurColonneGauche : sub (hl) : jp z,.MaxCentre ; colonnes de même largeur
ld b,a : ld a,32 : sub b : sub b : ld (leCentre),a

.MaxCentre
; centrage vertical
ld a,(nombreMots) : and 1 : ld b,a
ld a,(hauteurColonne) : add b ; hauteur totale
ld b,a : ld a,11 : sub b : srl a : jr z,.doubleDix
.doubleCentre inc ix : inc ix : dec a : jr nz,.doubleCentre
.doubleDix
push ix ; la deuxième colonne repartira de la même position Y
ld a,(hauteurColonne)
.doubleLoopGauche
; ajuster la position en fonction de la longueur
exa
ld a,(iy+0) : inc iy : add a : add a : ld c,a : ld a,(leCentre) : sub c
ld hl,(ix+0) : inc ix : inc ix : add l : ld l,a : ex hl,de : ld (hl),e : inc l : ld (hl),d : inc hl : ex hl,de
exa : dec a : jr nz,.doubleLoopGauche

.doDroite
ld a,(longueurColonneDroite) : cp 8 : ld a,(leCentre) : jr c,.add2
cp 32 : jr z,.auCentre
.add2
add 2 : ld (leCentre),a ; petit espace
.auCentre
pop ix
ld a,(hauteurColonne)
.doubleLoopDroite
exa
ld a,(leCentre) : inc iy ; on doit sauter dans les longueurs même si on ne s'en sert pas ici...
ld hl,(ix+0) : inc ix : inc ix : add l : ld l,a : ex hl,de : ld (hl),e : inc l : ld (hl),d : inc hl : ex hl,de
exa : dec a : jr nz,.doubleLoopdroite
; reste-il une dernière case? factocode
jp .dixPile

;=====================================================
; une seule colonne
;=====================================================
.dixOuMoins ; centrer dans les deux axes!
ld b,a : ld a,11 : sub b : srl a : jr z,.dixPile
.dixCentre inc ix : inc ix : dec a : jr nz,.dixCentre
.dixPile
; ajuster la position en fonction de la longueur
ld a,(iy+0) : inc iy : or a : jr z,.endPosColonnes : sub 3 : add a : ld c,a : ld a,26 : sub c
ld hl,(ix+0) : inc ix : inc ix : add l : ld l,a : ex hl,de : ld (hl),e : inc l : ld (hl),d : inc hl : ex hl,de
jr .dixPile
.endPosColonnes

;--------------------------
; afficher les cases vides
;--------------------------
ld ix,posEntrees
ld iy,tailleEntrees
.afficheMap
ld a,(iy+0) : or a : jr z,.mapOK : inc iy
ld de,(ix+0) : inc ix : inc ix : ld b,a
.afficheSubMap ld a,0 : push bc,de : call displayCharCellAt : pop de,bc : ld hl,4 : add hl,de : ex hl,de : djnz .afficheSubMap
jr .afficheMap

.mapOK
call refreshChoices ; update
ret

leCentre defb 0
hauteurColonne defb 0
longueurColonneGauche defb 0
longueurColonneDroite defb 0


;*************************************************************
                        refreshChoices
;*************************************************************
ld hl,(KeyF1char) : ld a,(hl) : cp #FF : jr z,.skipF1 : ld de,KeyF1addr : call displayCharCellAt : .skipF1
ld hl,(KeyF2char) : ld a,(hl) : cp #FF : jr z,.skipF2 : ld de,KeyF2addr : call displayCharCellAt : .skipF2
ld hl,(KeyF3char) : ld a,(hl) : cp #FF : jr z,.skipF3 : ld de,KeyF3addr : call displayCharCellAt : .skipF3
ld hl,(KeyF4char) : ld a,(hl) : cp #FF : jr z,.skipF4 : ld de,KeyF4addr : call displayCharCellAt : .skipF4
ld hl,(KeyF5char) : ld a,(hl) : cp #FF : jr z,.skipF5 : ld de,KeyF5addr : call displayCharCellAt : .skipF5
ld hl,(KeyF6char) : ld a,(hl) : cp #FF : jr z,.skipF6 : ld de,KeyF6addr : call displayCharCellAt : .skipF6
ld hl,(KeyF7char) : ld a,(hl) : cp #FF : jr z,.skipF7 : ld de,KeyF7addr : call displayCharCellAt : .skipF7
ld hl,(KeyF8char) : ld a,(hl) : cp #FF : jr z,.skipF8 : ld de,KeyF8addr : call displayCharCellAt : .skipF8
ld hl,(KeyF9char) : ld a,(hl) : cp #FF : jr z,.skipF9 : ld de,KeyF9addr : call displayCharCellAt : .skipF9

ld ix,hud1addr : ld a,(longueurMax)
ld iy,workPattern
.displayHUD
exa : ld de,(ix+0) : inc ix : inc ix : ld a,(iy+0) : inc iy : call displayCharCellAt : exa
dec a : jr nz,.displayHUD
.waitKeyboard
call scankeyboard
ld hl,keyboardmap : xor a : ld b,10
.testeAll or (hl) : inc hl : djnz .testeAll
or a : jr nz,.waitKeyboard
ret

;*************************************************************
                          waitInput
;*************************************************************


testChoice ; valider l'input, eventuellement afficher le mot trouve, reset l'affichage du board de saisie

KeyF1char defw 0
KeyF2char defw 0
KeyF3char defw 0
KeyF4char defw 0
KeyF5char defw 0
KeyF6char defw 0
KeyF7char defw 0
KeyF8char defw 0
KeyF9char defw 0


nbChoices   defb 0
longueurMax defb 0
nombreMots  defb 0

align 2 : buildChoiceList defw 0,0,0,buildChoice3,buildChoice4,buildChoice5,buildChoice6,buildChoice7,buildChoice8,buildChoice9

; toutes les cases inactivées par défaut
resetBuild
ld hl,dummy : ld (KeyF9char),hl : ld (KeyF1char),hl : ld (KeyF2char),hl : ld (KeyF3char),hl : ld (KeyF4char),hl : ld (KeyF6char),hl : ld (KeyF7char),hl : ld (KeyF8char),hl : ld (KeyF5char),hl
ld hl,hud1addr : ld de,hud1addr+1 : ld (hl),0 : ld bc,MAX_PATTERN*2-1 : ldir
ret

buildChoice3 call resetBuild : ld hl,currentPattern : ld (KeyF8char),hl : inc hl : ld (KeyF3char),hl : inc hl : ld (KeyF1char),hl : jp retourInitChoice
buildChoice4 call resetBuild : ld hl,currentPattern : ld (KeyF9char),hl : inc hl : ld (KeyF7char),hl : inc hl : ld (KeyF3char),hl : inc hl : ld (KeyF1char),hl : jp retourInitChoice
buildChoice5 call resetBuild : ld hl,currentPattern : ld (KeyF9char),hl : inc hl : ld (KeyF7char),hl : inc hl : ld (KeyF3char),hl : inc hl : ld (KeyF1char),hl : inc hl : ld (KeyF5char),hl : jp retourInitChoice
buildChoice6 call resetBuild : ld hl,currentPattern : ld (KeyF9char),hl : inc hl : ld (KeyF7char),hl : inc hl : ld (KeyF3char),hl : inc hl : ld (KeyF1char),hl : inc hl : ld (KeyF8char),hl : inc hl : ld (KeyF2char),hl : jp retourInitChoice
buildChoice7 call resetBuild : ld hl,currentPattern : ld (KeyF9char),hl : inc hl : ld (KeyF7char),hl : inc hl : ld (KeyF3char),hl : inc hl : ld (KeyF1char),hl : inc hl : ld (KeyF8char),hl : inc hl : ld (KeyF2char),hl : inc hl : ld (KeyF5char),hl : inc hl : jp retourInitChoice
buildChoice8 call resetBuild : ld hl,currentPattern : ld (KeyF9char),hl : inc hl : ld (KeyF7char),hl : inc hl : ld (KeyF3char),hl : inc hl : ld (KeyF1char),hl : inc hl : ld (KeyF8char),hl : inc hl : ld (KeyF2char),hl : inc hl : ld (KeyF4char),hl : inc hl : ld (KeyF6char),hl : jp retourInitChoice
buildChoice9 call resetBuild : ld hl,currentPattern : ld (KeyF9char),hl : inc hl : ld (KeyF7char),hl : inc hl : ld (KeyF3char),hl : inc hl : ld (KeyF1char),hl : inc hl : ld (KeyF8char),hl : inc hl : ld (KeyF2char),hl : inc hl : ld (KeyF4char),hl : inc hl : ld (KeyF6char),hl : inc hl : ld (KeyF5char),hl : jp retourInitChoice


referencePattern defs MAX_PATTERN     ; 8 lettres max => statique pendant le niveau
currentPattern   defs MAX_PATTERN     ; 8 lettres max => lettres disponibles qui disparaissent
workPattern      defs MAX_PATTERN+1,0 ; 8 lettres max => lettres qui apparaissent au fur et à mesure de la saisie et sont amenées à être comparées
workPosition     defw workPattern     ; nextChar position
dummy            defb #FF
dummySpace       defb 0

hud1addr defw 0
hud2addr defw 0
hud3addr defw 0
hud4addr defw 0
hud5addr defw 0
hud6addr defw 0
hud7addr defw 0
hud8addr defw 0
hud9addr defw 0

align 2
tailleEntrees defs 22,0 ; +extra-zero
posEntrees defs 42

charset ' ',0
repeat 26,x,0
charset x+'a',x+1
charset x+'A',x+1
rend
charset ',',VIRGULE
charset ';',POINT_VIRGULE
charset '|',PIPE

str_init01    defb 'utilisez le pave numerique pour',ENDMARK
str_init02    defb 'composer votre mot et la touche',ENDMARK
str_init03    defb 'espace pour valider un mot court',ENDMARK

str_init04    defb 'esc    passer au niveau suivant',ENDMARK
str_init05    defb 'tab    passer le tableau',ENDMARK
str_init06    defb 'h      afficher quelques lettres',ENDMARK

str_init07    defb 'les mots peuvent etre des verbes',ENDMARK
str_init08    defb 'conjugues   des  sigles  ou  des',ENDMARK
str_init09    defb 'noms de villes connues',ENDMARK

str_init10    defb '  appuyez sur une touche pour',ENDMARK
str_init11    defb 'demarrer au niveau facile ou sur',ENDMARK
str_init12    defb 'la touche b pour le niveau bonus',ENDMARK

str_level1    defb 'premier niveau',ENDMARK
str_level2    defb 'deuxieme niveau',ENDMARK
str_level3    defb 'troisieme niveau',ENDMARK
str_level4    defb 'quatrieme niveau',ENDMARK
str_level5    defb 'cinquieme niveau',ENDMARK
str_level6    defb 'sixieme niveau',ENDMARK
str_level7    defb 'septieme niveau',ENDMARK
str_level8    defb 'huitieme niveau',ENDMARK
str_level9    defb 'neuvieme niveau',ENDMARK
str_level10   defb 'dernier niveau',ENDMARK
str_bonus     defb ' niveau bonus',ENDMARK

bravoList defw .init
.init
defw $+4,str_bravo01
defw $+4,str_bravo02
defw $+4,str_bravo03
defw $+4,str_bravo04
defw $+4,str_bravo05
defw $+4,str_bravo06
defw $+4,str_bravo07
defw $+4,str_bravo08
defw $+4,str_bravo09
defw $+4,str_bravo10
defw $+4,str_bravo11
defw $+4,str_bravo12
defw $+4,str_bravo13
defw $+4,str_bravo14
defw $+4,str_bravo15
defw .init,str_bravo16

str_bravo01   defb 'bravo niveau reussi',ENDMARK
str_bravo02   defb '     bien joue',ENDMARK
str_bravo03   defb ' excellent travail',ENDMARK
str_bravo04   defb ' tu assures grave',ENDMARK
str_bravo05   defb '  felicitations',ENDMARK
str_bravo06   defb ' prochaine etape',ENDMARK
str_bravo07   defb '  ca passe creme',ENDMARK
str_bravo08   defb '   trop facile',ENDMARK
str_bravo09   defb '       gg',ENDMARK
str_bravo10   defb 'il prend cher le jeu',ENDMARK
str_bravo11   defb '  quel champion',ENDMARK
str_bravo12   defb '     pepouze',ENDMARK
str_bravo13   defb 'tu avances invincible',ENDMARK
str_bravo14   defb 'nickel et sans forcer',ENDMARK
str_bravo15   defb ' wouah tu dechires',ENDMARK
str_bravo16   defb '    tranquille',ENDMARK

str_win01 defb 'je crois que tu as fini le jeu',ENDMARK

;*****************************************
;  single char not indexed the same way
;*****************************************
cell_motsEnFete defb 'lexi forge',ENDMARK






; for displaying single char...
repeat 26,x,0
charset x+'a',(x+1)*2
charset x+'A',(x+1)*2
rend

;*******************************
            levelUP
;*******************************
ld ix,.levelADR
ld de,(lexiCurrentLevel)
.trouveLevel
ld hl,(ix+0) : ld a,h : or l : jp z,#100
sbc hl,de : jr z,.onVeutLeSuivant : jr nc,.isNext : .onVeutLeSuivant
inc ix : inc ix
jr .trouveLevel
.isNext
ld hl,(ix+0) : ld (lexiCurrentLevel),hl
ld b,100 : halt : djnz $
jp initGame

.levelADR
defw lexiLevel1
defw lexiLevel2
defw lexiLevel3
defw lexiLevel4
defw lexiLevel5
defw lexiLevel6
defw lexiLevel7
defw lexiLevel8
defw lexiLevel9
defw lexiLevel10
defw lexiBonus
defw 0

.levelSTR
defw str_level1
defw str_level2
defw str_level3
defw str_level4
defw str_level5
defw str_level6
defw str_level7
defw str_level8
defw str_level9
defw str_level10
defw str_bonus

lexiCurrentLevel defw lexiLevel1 ; prévoir un reset?


lexiBonus
defb 'AST,TAS,AST;'
defb 'CAT,CAT,TAC,ATC;'
defb 'FANO,FAN,FAON,FANO;'
defb 'AYOR,RAY,ROYA,AYOR;'
defb 'HLIDE,ILE,LED,LIE,HLIDE;'
defb 'KRIS,KIR,RIS,SKI,KIRS,KRIS;'
defb 'LONE,LEO,NOE,LEON,NOEL,LONE;'
defb 'CANOU,CON,COU,ONU,NOUA,CANOU;'
defb 'RODRIK,KIR,RIO,ROI,ORDI,RODRIK;'
defb 'MAGE,AGE,AME,MAG,GAME,MEGA,MAGE;'
defb 'HICKS,CHI,HIC,SCI,SIC,SKI,HICKS;'
defb 'HAKIM,AMI,HAI,HIA,MAI,MAKI,HAKIM;'
defb 'KUKULCAN,ALUN,CLAN,AUCUN,KNACK,KUKULCAN;'
defb 'TOMS,MOS,MOT,MST,OMS,OST,SOT,TOM,MOTS,TOMS;'
defb 'BLOODDBT,BOBO,BOLO,BOOT,DODO,LOTO,BLOODDBT;'
defb 'FREDDYV,DVD,EDF,FED,FER,RDV,VER,EVRY,FREDDYV;'
defb 'DURUTI,DIT,DRU,DUR,DUT,RIT,RUT,TIR,TRI,DURUTI;'
defb 'MADRAM,DAM,MDR,RAM,RDA,ADAM,ARMA,RAMDAM,MADRAM;'
defb 'PHENIX,EPI,NIE,PHI,PIE,PIN,HEIN,PIEN,PINE,PHENIX;'
defb 'KAILOKYRA,KAYAK,KOALA,RALAI,RAYAI,ROYAL,KAILOKYRA;'
defb 'SHORYU,HOU,OUH,RHO,SUR,HORS,OURS,RUSH,SURY,SHORYU;'
defb 'RUNBOWCPC,BURON,CONCU,CORNU,CROWN,PURON,RUNBOWCPC;'
defb 'AKIRA,AIR,AKA,IRA,KIR,RAI,RIA,ARAK,IRAK,RAKI,AKIRA;'
defb 'TOTOCOOL,CLOT,COLO,COLT,COOL,LOCO,LOTO,TOTO,TOTOCOOL;'
defb 'GOLEM,EGO,GEL,GEO,LOG,MOL,OEM,OGM,LOGE,MELO,MOLE,GOLEM;'
defb 'TWOMAG,MAO,MAT,MOT,OGM,OTA,TAG,TAO,TOM,WAT,MAGOT,TWOMAG;'
defb 'HERMOL,HLM,OEM,OHE,OHM,ORL,ROM,MELO,MOLE,ROLE,ROME,HERMOL;'
defb 'GEEKOREX,ERGO,GERE,GORE,GREE,OGRE,OREE,ORGE,GEREE,GEEKOREX;'
defb 'COBEU,BCE,BEC,BEU,BUC,BUE,COU,ECO,ECU,BOUC,BOUE,CUBE,COBEU;'
defb 'BARJACK,ARC,BAC,BAR,CAR,RAB,ARAK,JACK,RACK,RAJA,CABRA,BARJACK;'
defb 'OFFSET,EST,OFF,OSE,OST,OTE,SET,SOT,TES,TOF,TOS,OTES,SOFT,OFFSET;'
defb 'MOONBEAM,AMEN,BOOM,MANO,MEMO,MENA,MOME,MONO,OMAN,NOMMA,NOMME,MOONBEAM;'
defb 'BENNUTS,BUSTE,BUTES,NUENT,SUENT,TENUS,TUBES,TUNES,USENT,BUSENT,BENNUTS;'
defb 'REDBUG,BRU,BUE,DRU,DUE,DUR,GRE,GUE,REG,RUE,DRUE,DURE,GRUE,RUDE,URGE,REDBUG;'
defb 'VELUS,ELU,EUS,LES,LUE,LUS,SEL,SUE,USE,VUE,VUS,ELUS,LUES,SEUL,VELU,VUES,VELUS;'
defb 'DECKARD,ACRE,CAKE,CEDA,DARD,DECA,RACE,RACK,RADE,REAC,CADRE,CRADE,DARDE,DECKARD;'
defb 'GURNEYH,GUE,HUE,NUE,RUE,UNE,YEN,GRUE,HEUR,HUER,NUER,RUNE,URGE,URNE,HENRY,GURNEYH;'
defb 'HINAC,AIN,CHI,HAI,HAN,HIC,HIN,NIA,CAIN,CANI,CHAI,CHIA,INCA,NIAC,CHINA,NICHA,HINAC;'
defb 'CPCITOR,CRIC,CROC,PORC,PORT,ROTI,TRIC,TRIO,TRIP,TROC,TROP,CROIT,OCCIT,PICOT,CPCITOR;'
defb 'YREGGOR,EGO,GEO,GOY,REG,RER,ERGO,GORE,GROG,GYRO,OGRE,ORGE,GORGE,ROYER,GORGER,YREGGOR;'
defb 'ELIOT,ILE,LIE,LIT,LOI,LOT,OIE,OTE,TEL,TOI,ELIT,ILOT,LOTI,TOLE,ILOTE,LOTIE,TOILE,ELIOT;'
defb 'KHOMENOR,HOMO,MONO,ORNE,ROME,HERON,KHMER,MORNE,NORME,RENOM,RHONE,HONORE,HORMONE,KHOMENOR;'
defb 'NORECESS,COREENS,CORNEES,CORSEES,CRESSON,ECORNES,ECOSSER,NECROSE,RONCEES,NECROSES,NORECESS;'
defb 'PIFLYON,FION,FLIP,FLOP,FOIN,INFO,LINO,LION,LOIN,LYON,PION,POIL,POLI,FILON,LOPIN,PILON,PIFLYON;'
defb 'TETOHMU,HUME,MEUH,MOUE,MUET,MUTE,OMET,TETU,TOME,TOUT,TUTO,HOTTE,HUTTE,MOTTE,TOTEM,TOUTE,TETOHMU;'
defb 'NICKYONE,CINE,COIN,COKE,CONE,INNE,KINE,NEON,NICE,NOCE,NOIE,NOYE,ONCE,CONNE,ICONE,YONNE,NICKYONE;'
defb 'GIHEREM,EMERI,ERIGE,GEMIE,GEMIR,GERME,MIGRE,MIREE,REGIE,RIMEE,EMIGRE,GRIMEE,MIGREE,REGIME,GIHEREM;'
defb 'REDRUM,DRU,DUE,DUR,EMU,MDR,MER,MUE,MUR,RER,RUE,URE,DRUE,DURE,MUER,MURE,RUDE,RUER,DURER,MURER,REDRUM;'
defb 'DEMONIAK,AMIDON,DEMAIN,DEMINA,DOMINA,DOMINE,MADONE,MEDIAN,MENDIA,MIKADO,NOMADE,AMIDONE,DOMAINE,DEMONIAK;'
defb 'ZISQUIER,IRIEZ,IRISE,RIIEZ,RUSEZ,SIEUR,SUIEZ,USIEZ,IRISEZ,REQUIS,RISQUE,RUSIEZ,RISQUEZ,RISQUIEZ,ZISQUIER;'
defb 'SLYPEART,PALETS,PARLES,PARTES,PASTEL,PLATES,PLATRE,REPLAT,SATYRE,TREPAS,PLATRES,REPLATS,RESTYLA,SLYPEART;'
defb 'ABALORE,AERA,ALEA,BORE,LABO,LOBE,ORAL,RALA,RALE,ROLE,ARABE,LOBER,ORALE,RABLE,ARABLE,BOREAL,ELABORA,ABALORE;'
defb 'CNGSOFT,CON,FOC,NOS,ONG,ONT,OST,SOC,SON,SOT,TOC,TON,CONS,FOCS,FONT,SNCF,SOFT,SONT,TOCS,FONTS,TONGS,CNGSOFT;'
defb 'XENOMORPH,HERON,MORNE,NORME,PORNO,PROMO,PRONE,RENOM,RHONE,ROMPE,HONORE,PRENOM,PRONOM,HORMONE,ORPHEON,XENOMORPH;'
defb 'PRODATRON,DOPANT,DORANT,ODORAT,PARDON,PATRON,PONDRA,PRONAT,PROTON,RODANT,TONDRA,TORDRA,ODORANT,TORNADO,PRODATRON;'
defb 'ONCLECED,CODE,CONE,DECO,DONC,EDEN,NOCE,NOEL,ONCE,ONDE,CLONE,CODEE,DELCO,ECOLE,ONCLE,CLONEE,ENCODE,CONCEDE,ONCLECED;'
defb 'KENSHIRO,HERON,HEROS,IRONS,NOIES,NOIRE,NOIRS,OSIER,RHINO,RIENS,RIONS,SERIN,SKIER,HERONS,NOIRES,RHINOS,SENIOR,KENSHIRO;'
defb 'RETROPOKE,RETRO,ROTER,ROTOR,TERRE,TOPER,PORTE,OPERER,PERORE,PORTEE,PORTER,PRETER,PRETRE,REPORT,TORERO,REPORTE,RETROPOKE;'
defb 'REDFALCON,CLONERA,CONARDE,CONFERA,DECORNA,DEFLORA,DEFONCA,ENCORDA,FECONDA,FLANDRE,FONCERA,FONDERA,LACERON,LEONARD,RECLONA,REDFALCON;'
defb 'ORKOREADY,ADORE,DORER,ERODA,ODORA,ODORE,ORDRE,RAYER,RODEO,RODER,ADORER,DORERA,REDORA,RERODA,RODERA,ODORERA,REODORA,ORKOREADY;'
defb 'MIGUELSKY,GEMIS,GLUES,GUISE,LIEUS,LIGUE,LIMES,LUGES,MIELS,MILES,MUGIS,MULES,SEUIL,SIGLE,LIGUES,MUESLI,SIMULE,SMILEY,MIGUELSKY;'
defb 'RICOLAOZ,ALOI,CIAO,CIRA,COLA,COLO,COOL,CRIA,LAIC,LIRA,LOCO,LOIR,OCRA,ORAL,RAIL,CLAIR,COLZA,COLORA,CORAIL,COLORAI,COLORIA,RICOLAOZ;'
defb 'MACDEATH,ACTE,CAME,CEDA,CHAT,DAME,DATE,HATE,MACH,MATE,META,ACHAT,ADMET,CADET,ETAMA,HAMAC,MACHE,MATCH,TACHE,ACHETA,CHAMADE,MACDEATH;'
defb 'JBLEDARON,ABONDE,ABORDE,ALBEDO,BANDER,BLONDE,BONDER,BORDEL,BOREAL,BRANLE,BRELAN,DEROBA,ENROBA,ENROLA,LARDON,REBOND,ABONDER,LEONARD,JBLEDARON;'
defb 'LORDHEAVY,ADORE,DROLE,ERODA,HARDE,HORDE,LARDE,LARVE,LAVER,ORALE,OVALE,ROYAL,VOLER,DEVORA,DEVOYA,LOADER,ROYALE,VEROLA,VOLERA,VERDOYA,LORDHEAVY;'
defb 'POULETTE,LOTTE,LOUEE,LOUPE,LUTTE,PLEUT,POELE,POETE,POTEE,POUET,POULE,TETUE,TOUTE,LOUPEE,LUETTE,PELOTE,PLUTOT,POTELE,POULET,TOUPET,TUTELE,POULETTE;'
defb 'DARKSTEPH,APHTES,DEPART,DRAPES,PARTES,PETARD,PHARES,PHASER,PHRASE,PRETAS,RAPTES,SARTHE,SHAKER,SHERPA,SKATER,TARDES,TREPAS,DEPARTS,PETARDS,THESARD,DARKSTEPH;'
defb 'MAITREJOE,AMORTI,EMIRAT,ETAMER,JARTEE,MAITRE,MARIEE,MERITA,MERITE,METIER,MOIREE,OMERTA,OTARIE,RETAME,TRAMEE,TREMIE,AMORTIE,MAJOREE,MATIERE,TIMOREE,MAJORITE,MAITREJOE;'



lexiLevel1

defb 'IRT,RIT,TIR,TRI;'
defb 'ACF,AFC,CAF,CFA,FAC;'
defb 'ARS,ARS,RAS,RSA,SAR;'
defb 'EHU,EUH,HEU,HUE;'
defb 'ACS,CAS,CSA,SAC;'
defb 'EPR,EPR,ERP,PRE;'
defb 'ART,ART,RAT,TAR;'
defb 'BSU,BUS,SUB,USB;'
defb 'ETU,EUT,TUE,UTE;'
defb 'AIL,AIL,LAI,LIA;'
defb 'EIP,EPI,IPE,PIE;'
defb 'APR,ARP,PAR,RAP;'
defb 'EST,EST,SET,TES;'
defb 'APS,ASP,PAS,SAP,SPA;'
defb 'ILS,ILS,LIS,SIL;'
defb 'AFR,ARF,FAR,FRA,RFA;'
defb 'ESU,EUS,SUE,USE;'
defb 'ABC,ABC,BAC,CAB;'
defb 'EIL,ILE,LEI,LIE;'
defb 'OST,OST,SOT,TOS;'

lexiLevel2

defb 'IOSX,ISO,SIX,SOI;'
defb 'CDIP,CDI,CID,DPI,PIC;'
defb 'BCIO,BIC,BIO,CIO,COI,OBI;'
defb 'BOUZ,BOU,BOZ,BUO,ZOB,ZOU;'
defb 'EJSU,EUS,JEU,JUS,SUE,USE;'
defb 'ABPS,ABS,ASP,BAS,PAS,SPA;'
defb 'EKLU,ELU,LEK,LEU,LUE,ULE;'
defb 'DEST,DES,DTS,EST,SDT,SET,TES;'
defb 'AEMM,AME,EMA,EMM,MEM,MMA,MME;'
defb 'ABCP,ABC,BAC,CAB,CAP,PAC,PCB;'
defb 'CEGS,CES,CGS,CSG,ESC,SCE,SEC;'
defb 'BCIP,BIC,BIP,CIP,PCB,PIB,PIC;'
defb 'CMOR,COM,COR,MRC,ORC,ROC,ROM;'
defb 'ABRT,ART,BAR,BAT,RAB,RAT,TAR;'
defb 'AIOR,AIR,IRA,RAI,RIA,RIO,ROI;'
defb 'ABRU,BAR,BAU,BRU,BUA,RAB,RUA;'
defb 'ABCL,ABC,BAC,BAL,CAB,CAL,LAC;'
defb 'AIMO,AMI,MAI,MAO,MOA,MOI,OIM;'
defb 'CDOT,CDO,COD,COT,DOT,DTC,TOC;'
defb 'BEPU,BEP,BEU,BUE,EUP,PEU,PUB,PUE;'
defb 'RSTU,RUS,RUT,SUR,SUT,TUS,URS,URT;'
defb 'CIOR,CIO,COI,COR,CRI,IRC,ORC,RIO,ROC,ROI;'

lexiLevel3

defb 'RTTU,RTT,RUT,TUT,URT,TRUT;'
defb 'ABRZ,BAR,RAB,RAZ,ZAR,ZARB;'
defb 'AIRR,AIR,IRA,RAI,RIA,RIRA;'
defb 'ABST,ABS,BAS,BAT,TAS,BATS;'
defb 'PTTU,PTT,PUT,TPU,TUT,PUTT;'
defb 'AGGI,AGI,GAG,GAI,GIG,GIGA;'
defb 'BCLO,BOL,COL,LOB,LOC,BLOC;'
defb 'OSST,OST,SOS,SOT,TOS,SOTS;'
defb 'BCLU,BUC,CUL,LUC,UCL,CLUB;'
defb 'BDEI,BDE,BIE,DIE,IDE,BIDE;'
defb 'ALNP,LAN,PAL,PAN,PLA,PLAN;'
defb 'ARUZ,RAZ,RUA,UZA,ZAR,AZUR;'
defb 'DEPU,DUE,EUP,PEU,PUE,DUPE;'
defb 'DITU,DIT,DIU,DUT,IUD,DUIT;'
defb 'EEHU,EUE,EUH,HEU,HUE,HUEE;'
defb 'CIRU,CRI,CRU,IRC,URI,CUIR;'
defb 'CEHO,CHE,ECO,HOC,OHE,ECHO;'
defb 'CEIM,CIE,MEC,MIC,MIE,CIME;'
defb 'BEIT,BET,BIE,BIT,TIE,BITE;'
defb 'EERV,ERE,EVE,REE,VER,REVE;'
defb 'EJPU,EUP,JEU,PEU,PUE,JUPE;'
defb 'EJST,EST,JET,SET,TES,JETS;'
defb 'ELSS,LES,SEL,SES,SSL,SELS;'
defb 'ENUV,NUE,UNE,UVE,VUE,VENU;'
defb 'FNOT,FON,ONT,TOF,TON,FONT;'
defb 'OSST,OST,SOS,SOT,TOS,SOTS;'
defb 'IOTT,OIT,TIT,TOI,TOT,TOIT;'
defb 'PRSU,PUR,PUS,RUS,SUR,URS,PURS;'
defb 'CILP,CIL,CIP,CPL,PIC,PLI,CLIP;'
defb 'CIRS,CRI,IRC,RIS,SCI,SIC,CRIS;'
defb 'FITU,FIT,FUI,FUT,TIF,TUF,FUIT;'
defb 'EJTU,EUT,JET,JEU,TUE,UTE,JUTE;'
defb 'CLSU,CUL,LUC,LUS,SUC,UCL,CULS;'
defb 'DIST,DIS,DIT,IST,ITS,SDT,DITS;'
defb 'BPSU,BUS,PUB,PUS,SUB,USB,PUBS;'
defb 'AESV,ASE,ASV,AVE,VAS,VES,VASE;'
defb 'ACFI,CAF,CFA,FAC,FAI,FIA,FIAC;'
defb 'ACLT,CAL,LAC,TAC,TCA,TLA,TALC;'
defb 'ACSS,CAS,CSA,CSS,SAC,SAS,SACS;'
defb 'PRSU,PUR,PUS,RUS,SUR,URS,PURS;'
defb 'PRTU,PUR,PUT,RUT,TPU,URT,RUPT;'
defb 'RSUY,RUS,RUY,SUR,URS,URY,SURY;'
defb 'CDNO,CDO,COD,CON,DON,ONC,DONC;'
defb 'AISS,AIS,SAI,SAS,SIS,SSI,SAIS;'
defb 'CEHI,CHE,CHI,CIE,HIC,HIE,CHIE;'
defb 'DISU,DIS,DIU,DUS,IUD,SUD,DUIS;'
defb 'PRTU,PUR,PUT,RUT,TPU,URT,RUPT;'
defb 'IOPT,OIT,PIT,POT,TIP,TOI,TOP,PIOT;'
defb 'ENPU,EUP,NEP,NUE,PEU,PUE,UNE,PNEU;'
defb 'AFTU,FAT,FUT,TAF,TAU,TUA,TUF,FAUT;'
defb 'ELUX,ELU,EUX,LEU,LUE,LUX,ULE,LUXE;'
defb 'AFIM,AMF,AMI,FAI,FIA,FMI,MAI,FAIM;'
defb 'ENSY,ENS,NES,NEY,SEN,YEN,YES,YENS;'
defb 'ACFS,CAF,CAS,CFA,CSA,FAC,SAC,FACS;'
defb 'CEGR,CRE,ERG,GER,GRC,GRE,REG,GREC;'
defb 'CIRT,CRI,IRC,RIT,TIC,TIR,TRI,TRIC;'
defb 'AMRT,ART,ATM,MAT,RAM,RAT,TAR,TRAM;'
defb 'ABCN,ABC,BAC,BAN,BNC,CAB,CAN,BANC;'
defb 'BEOU,BEU,BOE,BOU,BUE,BUO,OUE,BOUE;'
defb 'AIRU,AIR,IRA,RAI,RIA,RUA,URI,RUAI;'
defb 'BEOZ,BOE,BOZ,OZE,ZEB,ZOB,ZOE,ZOBE;'
defb 'CDIO,CDI,CDO,CID,CIO,COD,COI,IDO,DICO;'
defb 'BCES,BCE,BEC,BES,CES,ESC,SCE,SEC,BECS;'
defb 'CEIS,CES,CIE,ESC,SCE,SCI,SEC,SIC,SCIE;'
defb 'OSTU,OST,OUT,SOT,SOU,SUT,TOS,TUS,OUST;'
defb 'PSTU,PUS,PUT,STP,SUT,TPS,TPU,TUS,STUP;'
defb 'CELS,CES,CLE,ESC,LES,SCE,SEC,SEL,CLES;'
defb 'PSTU,PUS,PUT,STP,SUT,TPS,TPU,TUS,STUP;'
defb 'IMOT,MIT,MOI,MOT,OIM,OIT,TOI,TOM,OMIT;'
defb 'ANRT,ARN,ART,NAT,RAN,RAT,TAN,TAR,TARN;'
defb 'DESU,DES,DUE,DUS,EUS,SUD,SUE,USE,DUES;'
defb 'AEPU,APU,EAU,EUP,PAU,PEU,PUA,PUE,PEAU;'
defb 'IOSV,ISO,OIS,OSI,SOI,VIS,VOI,VOS,VOIS;'
defb 'AESU,ASE,EAU,EUS,SUA,SUE,USA,USE,SEAU;'
defb 'ELUV,ELU,LEU,LEV,LUE,ULE,UVE,VUE,VELU;'
defb 'EOPU,EPO,EUP,OPE,OUE,PEU,POU,PUE,POUE;'
defb 'CEPU,CEP,CPE,CPU,ECU,EUP,PEC,PEU,PUE,PUCE;'
defb 'APRS,ARP,ARS,ASP,PAR,PAS,RAP,RAS,SAR,SPA,PARS;'
defb 'CENS,CES,CNE,CNS,ENS,ESC,NES,NSC,SCE,SEC,SEN,CENS;'

lexiLevel4

defb 'ABEL,ABEL,ABLE,ALBE,BALE,BEAL,BELA;'
defb 'ACER,ACRE,AREC,CARE,CREA,RACE,REAC;'
defb 'AEGL,AGEL,ALGE,EGAL,GAEL,GALE,GELA;'
defb 'AILS,AILS,LAIS,LIAS,LISA,SALI,SIAL,SILA;'
defb 'AINS,AINS,ANIS,ASIN,NAIS,NIAS,SAIN;'
defb 'AIPT,PAIT,PATI,PIAT,PITA,TAPI,TIPA;'
defb 'AIRS,AIRS,ARSI,IRAS,RAIS,RIAS,RISA,SARI;'
defb 'AIRV,AVIR,RAVI,RIVA,VAIR,VARI,VIRA,VRAI;'
defb 'AIST,ASTI,IAST,SAIT,SATI,TAIS,TISA;'
defb 'ARST,ARTS,RATS,SART,STAR,TARS,TSAR;'
defb 'EILS,ELIS,ILES,ISLE,LIES,LISE,SILE;'
defb 'EIRS,ERIS,IERS,IRES,REIS,RIES,RISE,SIRE;'
defb 'EORS,EROS,ORES,ORSE,OSER,ROSE,SORE;'
defb 'EPRU,PEUR,PREU,PUER,PURE,REPU,RUPE;'
defb 'ERSU,RESU,RUES,RUSE,SEUR,SUER,SURE,URES,USER;'

defb 'OSSU,SOS,SOU,SUS,OSSU,SOUS;'
defb 'OTTU,OUT,TOT,TUT,TOUT,TUTO;'
defb 'RSSU,RUS,SUR,SUS,URS,RUSS,SURS,URSS;'
defb 'ABCS,ABC,ABS,BAC,BAS,CAB,CAS,CSA,SAC,BACS,CABS;'
defb 'ABCU,ABC,BAC,BAU,BUA,BUC,CAB,CUBA,UBAC;'
defb 'ABER,ARE,BAR,BEA,BER,RAB,REA,ABER,BARE,RABE;'
defb 'ABRS,ABS,ARS,BAR,BAS,RAB,RAS,SAR,BARS,BRAS,RABS;'
defb 'ABSU,ABS,BAS,BAU,BUA,BUS,SUA,SUB,USA,USB,ABUS,BUAS,BUSA,SUBA;'
defb 'ACEF,ACE,CAF,CEA,CFA,FAC,FEA,CAFE,FACE;'
defb 'ACEN,ACE,ANE,CAN,CEA,CNE,ENA,ACNE,ANCE,CAEN,CANE,NEAC;'
defb 'ACER,ACE,ARC,ARE,CAR,CEA,CRE,REA,ACRE,AREC,CARE,CREA,RACE,REAC;'
defb 'ACEV,ACE,AVC,AVE,CEA,AVEC,CAVE;'
defb 'ACIL,AIL,CAL,CIL,LAC,LAI,LIA,LAIC,LIAC;'
defb 'ACIR,AIR,ARC,CAR,CRI,IRA,IRC,RAI,RIA,CARI,CIRA,CRAI,CRIA;'
defb 'ACLS,CAL,CAS,CSA,LAC,LAS,SAC,SAL,CALS,LACS;'
defb 'ADIV,ADI,AID,AVI,DAI,DIA,DIV,VIA,DIVA,VIDA;'
defb 'ADRU,DRU,DUR,RDA,RUA,ARDU,DARU,DURA;'
defb 'AEGI,AGE,AGI,AIE,GAI,IGE,AGIE,GAIE,GEAI;'
defb 'AEGM,AGE,AME,EMA,AGME,GAME,MAGE,MEGA;'
defb 'AEIL,AIE,AIL,ALE,ILE,LAI,LEI,LIA,LIE,AILE,ELIA,LAIE;'
defb 'AELP,ALE,PAL,PLA,ALEP,ALPE,LAPE,PALE,PELA;'
defb 'AEMR,AME,ARE,EMA,MER,RAM,REA,REM,AMER,ARME,MARE,RAME;'
defb 'AEPR,ARE,ARP,EPR,ERP,PAR,PRE,RAP,REA,APRE,PARE,PERA,RAPE;'
defb 'ACEM,ACE,AME,CAM,CEA,EMA,MAC,MEC,ACME,CAME;'
defb 'AFIT,AIT,FAI,FAT,FIA,FIT,TAF,TIF,FAIT,FIAT;'
defb 'AFIX,AIX,FAI,FAX,FIA,IXA,FAIX,FIXA;'
defb 'AILP,AIL,API,LAI,LIA,PAL,PIA,PLA,PLI,PALI,PILA,PLIA;'
defb 'AILR,AIL,AIR,IRA,LAI,LIA,RAI,RIA,LARI,LIRA,RAIL,RIAL;'
defb 'AILS,AIL,AIS,ILS,LAI,LAS,LIA,LIS,SAI,SAL,SIL,AILS,LAIS,LIAS,LISA,SALI,SIAL,SILA;'
defb 'AIMM,AMI,MAI,AMMI,IMAM,MIAM,MIMA;'
defb 'AIMN,AIN,AMI,ANI,MAI,MAN,MIN,NIA,IMAN,MAIN,MANI,MINA;'
defb 'AIMR,AIR,AMI,IRA,IRM,MAI,RAI,RAM,RIA,RMI,MARI,MIRA,RAMI,RIMA;'
defb 'ABEI,AIE,BAI,BEA,BIE,IBA,BAIE,BEAI;'
defb 'AIMS,AIS,AMI,AMS,MAI,MAS,MIS,SAI,SIM,AMIS,MAIS,MISA,SAMI,SIAM;'
defb 'AINP,AIN,ANI,API,NIA,PAN,PIA,PIN,NIPA,PAIN,PIAN,PINA;'
defb 'AINT,AIN,AIT,ANI,NAT,NIA,TAN,TIN,ANTI,NAIT,NIAT,TAIN,TIAN;'
defb 'AIOT,AIT,OIT,OTA,TAO,TOI,IOTA,OTAI;'
defb 'AIPS,AIS,API,ASP,PAS,PIA,PIS,PSI,SAI,SPA,SPI,ASPI,PAIS,PISA;'
defb 'AIRS,AIR,AIS,ARS,IRA,RAI,RAS,RIA,RIS,SAI,SAR,AIRS,ARSI,IRAS,RAIS,RIAS,RISA,SARI;'
defb 'AIRT,AIR,AIT,ART,IRA,RAI,RAT,RIA,RIT,TAR,TIR,TRI,RAIT,TARI,TIRA,TRIA;'
defb 'AIRV,AIR,AVI,IRA,RAI,RIA,VAR,VIA,AVIR,RAVI,RIVA,VAIR,VARI,VIRA,VRAI;'
defb 'AIST,AIS,AIT,IST,ITS,SAI,TAS,ASTI,IAST,SAIT,SATI,TAIS,TISA;'
defb 'AISV,AIS,ASV,AVI,SAI,VAS,VIA,VIS,AVIS,SIVA,VAIS,VIAS,VISA;'
defb 'AMNO,MAN,MAO,MOA,MON,NOM,MANO,NOMA,OMAN;'
defb 'ANOP,PAN,PON,NOPA,PANO,PAON;'
defb 'ANOT,NAT,ONT,OTA,TAN,TAO,TON,NOTA,OTAN,TAON;'
defb 'AEIR,AIE,AIR,ARE,IER,IRA,IRE,RAI,REA,RIA,RIE,AIRE,RAIE,REAI;'
defb 'ANSU,ANS,NAS,NUA,NUS,SUA,UNS,USA,ANUS,NUAS;'
defb 'APRT,APT,ARP,ART,ATP,PAR,PAT,RAP,RAT,TAP,TAR,PART,PRAT,RAPT,RATP;'
defb 'APST,APT,ASP,ATP,PAS,PAT,SPA,STP,TAP,TAS,TPS,PATS,TAPS;'
defb 'ARSS,ARS,RAS,SAR,SAS,SARS,SRAS;'
defb 'ARST,ARS,ART,RAS,RAT,SAR,TAR,TAS,ARTS,RATS,SART,STAR,TARS,TSAR;'
defb 'ARSU,ARS,RAS,RUA,RUS,SAR,SUA,SUR,URS,USA,RUAS,RUSA,SAUR;'
defb 'BCEU,BCE,BEC,BEU,BUC,BUE,ECU,BECU,CUBE;'
defb 'BEIN,BEN,BIE,BNE,EIN,NIB,NIE,BENI,BIEN,BINE;'
defb 'BEOR,BER,BOE,ORB,ORE,ROB,BOER,BORE,ORBE,ROBE;'
defb 'BETU,BET,BEU,BUE,BUT,EUT,TUB,TUE,UTE,BUTE,TEUB,TUBE;'
defb 'BISU,BIS,BUS,SUB,USB,BUIS,SUBI;'
defb 'BLOS,BOL,LOB,LOS,SOL,BOLS,LOBS;'
defb 'BOSU,BOU,BUO,BUS,SOU,SUB,USB,BOUS,OBUS;'
defb 'BOTU,BOT,BOU,BUO,BUT,OUT,TUB,BOUT,BUTO;'
defb 'CDOU,CDO,COD,COU,DUC,DUO,OUD,COUD,DOCU,DOUC,DUOC;'
defb 'CENO,CNE,CON,ECO,EON,NOE,ONC,ONE,CONE,NOCE,ONCE;'
defb 'CERU,CRE,CRU,ECU,RUE,URE,CRUE,CURE,ECRU,RECU;'
defb 'CESU,CES,ECU,ESC,EUS,SCE,SEC,SUC,SUE,USE,ECUS,SUCE;'
defb 'CLOS,COL,COS,LOC,LOS,SOC,SOL,CLOS,COLS;'
defb 'COPR,COR,ORC,PRO,ROC,RPC,CORP,PORC,PROC;'
defb 'CORS,COR,COS,ORC,ORS,ROC,SOC,SOR,CORS,CROS,ROCS;'
defb 'CORT,COR,COT,ORC,ROC,ROT,TOC,CROT,TROC;'
defb 'CORU,COR,COU,CRU,ORC,ROC,COUR,CROU;'
defb 'CRTU,CRU,RUT,URT,CRUT,TRUC,TURC;'
defb 'DEGO,DEO,EGO,GEO,ODE,DOGE,GODE;'
defb 'DEIR,DIE,IDE,IER,IRE,RIE,DIRE,RIDE;'
defb 'DEMO,DEM,DEO,DOM,MOE,ODE,OEM,DEMO,DOME,MODE;'
defb 'DENU,DUE,DUN,NUD,NUE,UNE,DUNE,NUDE;'
defb 'DERU,DRU,DUE,DUR,RUE,URE,DRUE,DURE,REDU,RUDE;'
defb 'EELV,EVE,LEE,LEV,LEVE,VELE;'
defb 'EERU,ERE,EUE,REE,RUE,URE,EURE,RUEE,UREE;'
defb 'EESU,EUE,EUS,SUE,USE,EUES,SUEE,USEE;'
defb 'EFIL,FEL,FIE,FIL,ILE,LEI,LIE,FIEL,FILE,LIEF;'
defb 'EFLU,ELU,FEL,FEU,LEU,LUE,ULE,FLUE,FUEL;'
defb 'EFMU,EMU,FEM,FEU,MUE,FUME,MEUF;'
defb 'EFNU,FEU,NEF,NUE,UNE,FUNE,NEUF;'
defb 'EGIR,ERG,GER,GRE,IER,IGE,IRE,REG,RIE,GIRE,REGI;'
defb 'EGIT,GIT,IGE,TGI,TIE,GITE,TIGE;'
defb 'EGLU,ELU,GEL,GEU,GLU,GUE,LEU,LUE,ULE,GLUE,LUGE;'
defb 'EGOR,EGO,ERG,GEO,GER,GOR,GRE,ORE,REG,ERGO,GORE,OGRE,ORGE;'
defb 'EILM,ILE,LEI,LIE,MEL,MIE,MIL,LIME,MELI,MIEL,MILE;'
defb 'EILP,EPI,ILE,IPE,LEI,LIE,PIE,PLI,PILE,PLIE;'
defb 'EIOS,ISO,OIE,OIS,OSE,OSI,SOI,OIES,OISE,SOIE;'
defb 'EIPS,EPI,EPS,IPE,PES,PIE,PIS,PSE,PSI,SEP,SPI,EPIS,IPES,PIES,PISE;'
defb 'EIRT,IER,IRE,RIE,RIT,TER,TIE,TIR,TRE,TRI,RITE,TIRE,TRIE;'
defb 'ELST,EST,LES,LET,SEL,SET,SLT,TEL,TES,TLS,LEST,LETS,TELS;'
defb 'ELSU,ELU,EUS,LES,LEU,LUE,LUS,SEL,SUE,ULE,USE,ELUS,LUES,SEUL;'
defb 'EMOT,MET,MOE,MOT,OEM,OTE,TOM,OMET,TOME;'
defb 'ENST,ENS,EST,NES,NET,SEN,SET,TES,NETS,SENT;'
defb 'ENTU,EUT,NET,NUE,TUE,TUN,UNE,UTE,TENU,TUNE;'
defb 'EOPT,EPO,OPE,OTE,PET,POT,TOP,OPTE,POTE,TOPE;'
defb 'EPRU,EPR,ERP,EUP,PEU,PRE,PUE,PUR,RUE,URE,PEUR,PREU,PUER,PURE,REPU;'
defb 'EPST,EPS,EST,PES,PET,PSE,SEP,SET,STP,TES,TPS,PEST,PETS,SEPT;'
defb 'EPTU,EUP,EUT,PET,PEU,PUE,PUT,TPU,TUE,UTE,PEUT,PUTE;'
defb 'ORTU,OUT,ROT,RUT,URT,ROUT,TOUR,TROU,TURO;'
defb 'ESSU,EUS,SES,SUE,SUS,USE,ESUS,SUES,USES;'
defb 'ESTT,EST,SET,TES,TET,TEST,TETS;'
defb 'IMOR,IRM,MOI,OIM,RIO,RMI,ROI,ROM,MIRO,RIOM;'
defb 'IMOS,ISO,MIS,MOI,OIM,OIS,OMS,OSI,SIM,SOI,SOM,MIOS,MISO,MOIS,OMIS;'
defb 'INSU,NUI,NUS,SIN,UNI,UNS,INSU,NUIS,UNIS;'
defb 'IORS,ISO,OIS,ORS,OSI,RIO,RIS,ROI,SOI,SOR,ROIS,ROSI,SOIR;'
defb 'IORT,OIT,RIO,RIT,ROI,ROT,TIR,TOI,TRI,ROTI,TORI,TRIO;'
defb 'IOSU,ISO,OIS,OSI,OUI,SOI,SOU,OUIS,SOUI;'
defb 'OPST,OST,POS,POT,SOT,STP,TOP,TOS,TPS,POST,POTS,SPOT,STOP,TOPS;'
defb 'ORTU,OUT,ROT,RUT,URT,ROUT,TOUR,TROU,TURO;'
defb 'OSSU,SOS,SOU,SUS,OSSU,SOUS;'
defb 'OSTU,OST,OUT,SOT,SOU,SUT,TOS,TUS,OUST;'
defb 'OTTU,OUT,TOT,TUT,TOUT,TUTO;'
defb 'RSSU,RUS,SUR,SUS,URS,RUSS,SURS,URSS;'

lexiLevel5
defb 'AABCS,ABA,ABC,ABS,BAC,BAS,CAB,CAS,CSA,SAC,BACS,BASA,CABS,CASA,SABA,CABAS;'
defb 'AABDR,ABA,ARA,BAR,DBA,RAB,RDA,ADAR,ARDA,BADA,BARA,BARD,RADA,BADRA,BARDA,BRADA;'
defb 'AAEGL,AGA,AGE,AGL,ALE,GAL,GEL,AGEL,ALEA,ALGE,EGAL,GAEL,GALA,GALE,GELA,AGLAE,EGALA;'
defb 'AAEPT,APT,ATA,ATE,ATP,ETA,PAT,PET,TAP,APTE,PATA,PATE,PETA,TAPA,TAPE,APATE,EPATA;'
defb 'AAGLS,AGA,AGL,GAL,LAS,SAL,AGAS,GAAS,GALA,GALS,GLAS,LAAS,SAGA,SALA,GALAS;'
defb 'AARSU,ARA,ARS,RAS,RUA,RUS,SAR,SUA,SUR,URS,USA,ARAS,AURA,RASA,RUAS,RUSA,SAUR,AURAS,SAURA;'
defb 'ABCIL,ABC,AIL,BAC,BAI,BAL,BIC,CAB,CAL,CIL,IBA,LAC,LAI,LIA,ALBI,BAIL,BALI,BILA,LAIC,LIAC,CIBLA;'
defb 'ABDEU,ADE,BAU,BDE,BEA,BEU,BUA,BUE,DBA,DUE,EAU,AUBE,AUDE,BADE,BAUD,BEAU,BAUDE,BUADE,DAUBE;'
defb 'ABEGN,AGE,ANE,BAN,BEA,BEG,BEN,BGE,BNE,ENA,GAN,GEN,AGEN,ANGE,BANE,BGEN,GABE,GANE,GENA,NAGE,BAGNE;'
defb 'ABEUX,AXE,BAU,BAX,BEA,BEU,BUA,BUE,EAU,EUX,AUBE,BAUX,BEAU,EAUX,BEAUX;'
defb 'ACEEL,ACE,ALE,CAL,CEA,CEE,CLE,LAC,LEE,ALCE,CALE,CEEA,CELA,CELE,LACE,ALCEE,CALEE,ECALE,LACEE;'
defb 'ACEFH,ACE,CAF,CAH,CEA,CFA,CHE,FAC,FEA,ACHE,CAFE,CHEF,ECHA,FACE,FACHE;'
defb 'ACEHL,ACE,ALE,CAH,CAL,CEA,CHE,CLE,HEL,LAC,ACHE,ALCE,CALE,CELA,ECHA,HALE,HELA,LACE,CHALE,LACHE,LECHA;'
defb 'ACEMO,ACE,AME,CAM,CEA,COM,ECO,EMA,MAC,MAO,MEC,MOA,MOE,OCA,OEA,OEM,ACME,CAME,COMA,CAMEO;'
defb 'ACFNR,ARC,ARF,ARN,CAF,CAN,CAR,CFA,FAC,FAN,FAR,RAN,RFA,CNAF,CRAN,FARC,FRAC,RANC,FRANC;'
defb 'AABCT,ABA,ABC,ATA,BAC,BAT,CAB,TAC,TCA,ABAT,ACTA,BATA,CATA,TABAC;'
defb 'ACHST,CAH,CAS,CSA,HTA,SAC,SAH,TAC,TAS,TCA,CASH,CAST,CHAS,CHAT,HAST,SCAT,TACS,CHATS;'
defb 'ADEFR,ADE,ARE,ARF,EDF,FAR,FEA,FED,FER,RDA,REA,RFA,ARDE,FADE,FARD,FERA,RADE,RAFE,FADER,FARDE;'
defb 'ADEOR,ADE,ADO,ARE,DEO,ODE,OEA,ORE,RDA,REA,ARDE,DORA,DORE,RADE,RODA,RODE,ADORE,ERODA;'
defb 'ADGIU,ADI,AGI,AID,DAI,DIA,DIU,GAI,GAU,GUI,IUD,AGUI,AIGU,DIGUA,GAUDI,GUIDA;'
defb 'ADLRS,ARS,DAL,DAS,DSL,LAD,LAS,LSD,RAS,RDA,RDS,SAL,SAR,SDA,ADSL,LADS,LARD,RADS,LARDS;'
defb 'ADORT,ADO,ART,DOT,OTA,RAT,RDA,ROT,TAO,TAR,DART,DORA,DORT,DOTA,RODA,ROTA,TARD,TARO,TORD,DORAT,RODAT;'
defb 'AEEGL,AGE,AGL,ALE,GAL,GEE,GEL,LEE,AGEE,AGEL,ALGE,EGAL,GAEL,GALE,GELA,GELE,LEGE,ALEGE,EAGLE,EGALE,GALEE;'
defb 'AEEPR,ARE,ARP,EPR,ERE,ERP,PAR,PRE,RAP,REA,REE,AERE,APRE,PARE,PERA,PERE,RAPE,EPARE,PAREE,RAPEE;'
defb 'AEFUV,AVE,EAU,FEA,FEU,UVE,VAU,VUE,AVEU,AVUE,UVEA,VEAU,VEUF,FAUVE;'
defb 'AEGRR,AGE,ARE,ERG,ERR,GER,GRE,REA,REG,RER,AGER,ARER,ARRE,ERRA,GARE,GERA,GREA,RAGE,RARE,GARER,RAGER;'
defb 'BIPSU,BIP,BIS,BUS,PIB,PIS,PSI,PUB,PUS,SPI,SUB,USB,BIPS,BUIS,PUBS,PUIS,SUBI,PUBIS;'
defb 'AAEGN,AGA,AGE,ANA,ANE,ENA,GAN,GEN,AGEN,ANGE,GANA,GANE,GENA,NAGE,NAGEA;'
defb 'AELOP,ALE,EPO,OEA,OLA,OLE,OLP,OPE,PAL,PLA,ALEP,ALPE,LAPE,LOPE,PALE,PELA,PELO,POLE,OPALE,POELA;'
defb 'AELOR,ALE,ARE,LOR,OEA,OLA,OLE,ORE,ORL,REA,EARL,LARE,LORE,ORAL,ORLE,RALE,REAL,RELA,ROLA,ROLE,ORALE;'
defb 'AELRX,ALE,ARE,ARX,AXE,REA,ALEX,AXEL,AXER,EARL,LARE,RALE,REAL,RELA,RELAX;'
defb 'AEMPU,AME,APU,AUM,EAU,EMA,EMU,EUP,MUA,MUE,PAU,PEU,PME,PUA,PUE,UMP,MEAU,PAME,PEAU,PUMA,PAUME;'
defb 'AEMRR,AME,ARE,EMA,ERR,MER,RAM,REA,REM,RER,AMER,ARER,ARME,ARRE,ERRA,MARE,RAME,RARE,ARMER,MARRE,RAMER;'
defb 'AEOTZ,ATE,AZE,AZT,ETA,OEA,OTA,OTE,OZE,TAO,ZOE,AZET,OTEZ,ZETA,AZOTE;'
defb 'AGNRS,ANS,ARN,ARS,GAN,NAS,RAN,RAS,RGN,SAR,GARS,GRAS,RANG,RANS,SANG,GRANS,RANGS;'
defb 'ACISS,AIS,CAS,CSA,CSS,SAC,SAI,SAS,SCI,SIC,SIS,SSI,CASI,SACS,SAIS,SCIA,SCIAS;'
defb 'AILMP,AIL,AMI,API,LAI,LIA,MAI,MAL,MIL,PAL,PIA,PLA,PLI,LAMP,LIMA,MAIL,MALI,PALI,PILA,PLIA,AMPLI;'
defb 'ACEET,ACE,ATE,CEA,CEE,CTE,ETA,ETE,TAC,TCA,TEE,ACTE,CATE,CEEA,ACETE,ACTEE;'
defb 'AIMNP,AIN,AMI,ANI,API,MAI,MAN,MIN,NIA,PAN,PIA,PIN,IMAN,MAIN,MANI,MINA,NIPA,PAIN,PIAN,PINA,MANIP;'
defb 'AIORV,AIR,AVI,IRA,RAI,RIA,RIO,ROI,VAR,VIA,VOI,AVIR,RAVI,RIVA,VAIR,VARI,VIRA,VOIR,VRAI,AVOIR;'
defb 'AJOTU,OTA,OUT,TAO,TAU,TUA,AJOU,AJUT,AOUT,AUTO,JOTA,JOUA,JUTA,TOUA,AJOUT,JOUAT,JOUTA;'
defb 'AELOV,ALE,AVE,LEV,OEA,OLA,OLE,OVE,VAL,VOL,LAVE,LEVA,LOVA,LOVE,VALO,VELA,VELO,VOLA,VOLE,OVALE;'
defb 'AMNOR,ARN,MAN,MAO,MOA,MON,NOM,RAM,RAN,ROM,ANOR,ARON,MANO,NOMA,OMAN,ORNA,ARMON,MARON,NORMA,RAMON,ROMAN;'
defb 'BCEHU,BCE,BEC,BEU,BUC,BUE,CHE,CHU,ECU,EUH,HEU,HUB,HUE,BECU,CHEU,CHUE,CUBE,ECHU,BUCHE;'
defb 'BCEIL,BCE,BEC,BEL,BIC,BIE,BLE,CIE,CIL,CLE,ILE,LEI,LIE,BILE,CELI,CIEL,ECLI,LICE,CIBLE;'
defb 'BCELS,BCE,BEC,BEL,BES,BLE,CES,CLE,ESC,LES,SCE,SEC,SEL,BECS,BELS,BLES,CLES,CLEBS;'
defb 'BCOSU,BOU,BUC,BUO,BUS,COS,COU,SOC,SOU,SUB,SUC,USB,BOUC,BOUS,BUSC,COUS,CUBO,OBUS,SOUC,BOUCS;'
defb 'EEFRU,ERE,EUE,FEE,FER,FEU,FUR,REE,RUE,URE,URF,EURE,FEER,FERU,FEUE,FREE,FURE,RUEE,UREE,FERUE;'
defb 'BEIOT,BET,BIE,BIO,BIT,BOE,BOT,OBI,OIE,OIT,OTE,TIE,TOI,BIOT,BITE,BOIT,OBEI,OBIT,BIOTE,BOITE,OBEIT;'
defb 'BETUZ,BET,BEU,BUE,BUT,EUT,TUB,TUE,UTE,ZEB,ZUT,BETZ,BUEZ,BUTE,BUZE,TEUB,TUBE,TUEZ,ZEBU,BUTEZ,TUBEZ;'
defb 'BIRSU,BIS,BRU,BUS,RIB,RIS,RUS,SUB,SUR,URI,URS,USB,BRIS,BRUI,BRUS,BUIS,SUBI,SURI,BRUIS,RUBIS,SUBIR;'
defb 'BIRTU,BIT,BRU,BUT,RIB,RIT,RUT,TIR,TRI,TUB,URI,URT,BRUI,BRUT,BRUIT,TRIBU;'
defb 'CDEMO,CDO,COD,COM,DEC,DEM,DEO,DOM,ECO,MEC,MOE,ODE,OEM,CODE,DECO,DEMO,DOME,MCDO,MODE,OCDE,MEDOC;'
defb 'EELMR,ERE,LEE,MEE,MEL,MER,REE,REM,LEME,LERE,MELE,MERE,MERL,REEL,RELE,MELER,MERLE;'
defb 'CEFIR,CIE,CRE,CRI,FER,FIE,IER,IRC,IRE,RIE,RIF,CERF,CIRE,CRIE,ECIR,FIER,FRIC,RECIF;'
defb 'CEIMN,CIE,CNE,EIN,MEC,MIC,MIE,MIN,NEM,NIE,CIME,CINE,MIEN,MINE,NICE,MINCE;'
defb 'CEINP,CEP,CIE,CIP,CNE,CPE,EIN,EPI,IPE,NEP,NIE,PEC,PIC,PIE,PIN,CINE,NICE,PIEN,PINE,PINCE;'
defb 'CFINO,CIO,COI,CON,FIN,FOC,FOI,FON,ION,ONC,COIN,CONF,CONI,FION,FOIN,INFO,NOCIF;'
defb 'DEEIT,DIE,DIT,ETE,IDE,TEE,TIE,DITE,EDIT,IDEE,DEITE,DIETE,EDITE,TIEDE;'
defb 'DEINV,DIE,DIV,EIN,IDE,IVE,NID,NIE,VIE,VIN,DENI,DINE,DIVE,ENVI,INDE,INED,NIDE,VEND,VIDE,VINE,DEVIN;'
defb 'EEFMU,EMU,EUE,FEE,FEM,FEU,MEE,MUE,EMEU,EMUE,FEUE,FUME,MEUF,MUEE,FUMEE;'
defb 'EEMRS,ERE,ERS,MEE,MER,MES,REE,REM,SEM,ERES,ERSE,MEES,MERE,MERS,REES,SEME,SERE,MERES,SEMER;'
defb 'EEPRT,EPR,ERE,ERP,ETE,PET,PRE,REE,TEE,TER,TRE,ETRE,PERE,PETE,PRET,PERET,PERTE,PETER,PRETE;'
defb 'EGIPS,EPI,EPS,GIS,GPS,IGE,IPE,PES,PIE,PIS,PSE,PSI,SEP,SPI,EPIS,IPES,PIES,PIGE,PISE,PIGES;'
defb 'EGMNO,EGO,EON,GEN,GEO,MOE,MON,NEM,NOE,NOM,OEM,OGM,ONE,ONG,GONE,MEON,MGEN,MONE,NOME,GNOME;'
defb 'EHILU,ELU,EUH,HEL,HEU,HIE,HUE,HUI,ILE,LEI,LEU,LIE,LUE,LUI,ULE,HILE,IULE,LIEU,HUILE;'
defb 'EHLRU,ELU,EUH,HEL,HEU,HUE,LEU,LUE,RUE,ULE,URE,URL,HEUR,HUER,HURE,LEUR,LURE,RELU,HURLE;'
defb 'EIKRS,ERS,IER,IRE,KIR,KSI,RIE,RIS,SKI,ERIS,IERS,IRES,KIRS,REIS,RIES,RISE,SIRE,SKIE,SKIER;'
defb 'EILUX,ELU,EUX,ILE,IXE,LEI,LEU,LIE,LUE,LUI,LUX,ULE,XIE,EXIL,IULE,LIEU,LIXE,LUXE,LIEUX;'
defb 'EIMMO,EMM,MEM,MIE,MME,MOE,MOI,OEM,OIE,OIM,EMMI,EMOI,MEMO,MIME,MOIE,MOME,MOMIE;'
defb 'EIMOV,IVE,MIE,MOE,MOI,OEM,OIE,OIM,OVE,VIE,VOI,EMOI,MOIE,VIME,VOIE,VOMI,VOMIE;'
defb 'EIMNU,EIN,EMU,MIE,MIN,MUE,NEM,NIE,NUE,NUI,UNE,UNI,MENU,MIEN,MINE,MUNI,NIUE,NUIE,UNIE,MUNIE;'
defb 'EINSS,EIN,ENS,NES,NIE,SEN,SES,SIN,SIS,SSI,ISSE,NIES,NISE,SEIN,SENS,SIEN,SISE,NISSE,SEINS,SIENS;'
defb 'ELMPU,ELU,EMU,EUP,LEU,LUE,MEL,MUE,PEU,PLU,PME,PUE,ULE,ULM,UMP,LUMP,LUPE,MULE,PEUL,PLUME;'
defb 'EORTV,ORE,OTE,OVE,ROT,RTV,TER,TRE,VER,VET,VTE,OTER,ROTE,TORE,VERT,VETO,VOTE,ORVET,TORVE,VOTER,VOTRE;'
defb 'EPRUV,EPR,ERP,EUP,PEU,PRE,PUE,PUR,RUE,URE,UVE,VER,VUE,PEUR,PREU,PUER,PURE,REPU,REVU,RUPE,PREVU;'
defb 'EIMMS,EMM,MEM,MES,MIE,MIS,MME,MMS,SEM,SIM,EMIS,EMMI,MIES,MIME,MISE,MMES,MIMES;'
defb 'FIRTU,FIT,FUI,FUR,FUT,RIF,RIT,RUT,TIF,TIR,TRI,TUF,URF,URI,URT,FRIT,FUIR,FUIT,RIFT,TURF,FRUIT;'
defb 'ILNOP,ION,LIN,LOI,NIL,OIL,OLP,PIN,PLI,PON,LINO,LION,LOIN,PION,POIL,POLI,LOPIN,PILON;'

lexiLevel6
defb 'AABRS,ARAS,BARA,BARS,BASA,BRAS,RABS,RASA,SABA,ABRAS,ARBAS,BARAS,BRASA,SABRA;'
defb 'AAIPR,AIRA,ARAI,ARIA,PAIR,PARA,PARI,PRIA,RAIA,RAPA,RIPA,PAIRA,PARAI,PARIA,RAPAI,RAPIA;'
defb 'ABEGL,ABEL,ABLE,AGEL,ALBE,ALGE,BALE,BEAL,BELA,EGAL,GABE,GAEL,GALE,GELA,GABLE,GALBE;'
defb 'ABCIR,ABRI,ARBI,BARC,BRAI,BRIA,BRIC,CARI,CIRA,CRAI,CRIA,CRIB,BIRAC,CABRI;'
defb 'ACELR,ACRE,ALCE,AREC,CALE,CARE,CELA,CREA,EARL,LACE,LARE,RACE,RALE,REAC,REAL,RELA,CALER,LACER,RACLE;'
defb 'ADEIR,AIDE,AIRE,ARDE,DARI,DIRA,DIRE,IDEA,RADE,RAID,RAIE,REAI,RIDA,RIDE,ADIRE,AIDER,ARIDE,DRAIE,RADIE,RAIDE;'
defb 'ADINR,ADNR,DARI,DINA,DIRA,DRAN,DRIN,IRAN,NARD,NIDA,RAID,RAIN,RAND,RANI,RIDA,ARDIN,DARIN,DINAR,DRAIN,NADIR,RADIN;'
defb 'AEIPR,AIRE,APRE,EPIA,PAIE,PAIR,PARE,PARI,PERA,PERI,PIRE,PRIA,PRIE,RAIE,RAPE,REAI,RIPA,RIPE,PAIRE,PARIE;'
defb 'AELPR,ALEP,ALPE,APRE,EARL,LAPE,LARE,PALE,PARE,PELA,PERA,RALE,RAPE,REAL,RELA,LAPER,PARLE,PERLA,PRELA;'
defb 'AELSU,ALES,ALEU,ELUA,ELUS,LAUS,LESA,LUES,SALE,SAUL,SEAU,SEUL,ELUAS,SALUE,SAULE;'
defb 'AGIRS,AGIR,AGIS,AIRS,ARSI,GAIS,GARI,GARS,GIRA,GRAS,GRIS,IRAS,RAIS,RIAS,RIGA,RISA,SARI,AGRIS,ARGIS,GIRAS,GRISA;'
defb 'AILNS,AILS,AINS,ANIL,ANIS,ASIN,LAIN,LAIS,LANS,LIAS,LINS,LISA,NAIS,NIAS,SAIN,SALI,SIAL,SILA,LINAS,SALIN;'
defb 'ABCER,ABER,ACRE,AREC,BARC,BARE,CARE,CREA,RABE,RACE,REAC,BARCE,BERCA,BRACE,CABRE,CRABE;'
defb 'EEORS,ERES,EROS,ERSE,OREE,ORES,ORSE,OSEE,OSER,REES,ROSE,SERE,SORE,REOSE,ROSEE;'
defb 'EGORU,ERGO,EURO,GORE,GOUR,GROU,GRUE,GUER,OGRE,ORGE,OUGE,ROUE,URGE,GOURE,ORGEU,ORGUE,ROGUE,ROUGE;'
defb 'EILNS,ELIS,ILES,ISLE,LENS,LIEN,LIES,LINS,LISE,NIES,NISE,SEIN,SIEN,SILE,SNLE,LIENS;'
defb 'EINSU,INSU,NIES,NISE,NIUE,NUES,NUIE,NUIS,SEIN,SIEN,SUIE,UNES,UNIE,UNIS,USNE,NUISE,SINUE,UNIES,USINE;'
defb 'EIRTV,IVRE,RITE,RIVE,TIRE,TRIE,VERT,VIER,VIRE,VITE,REVIT,RIVET,VERTI,VETIR,VITRE;'
defb 'EOPRS,EROS,ORES,ORSE,OSER,PERS,PESO,PORE,POSE,PREO,PRES,PROS,REPS,ROSE,SORE,PERSO,PORES,POSER,PROSE,REPOS,SPORE;'
defb 'ERSSU,ESUS,RESU,RUES,RUSE,RUSS,SERS,SEUR,SUER,SUES,SURE,SURS,URES,URSS,USER,USES,RESSU,RESUS,RUSES,RUSSE,SURES;'
defb 'ABEGR,ABER,AGER,BARE,GABE,GARE,GERA,GREA,RABE,RAGE,BARGE,GABER,GABRE,GARBE,GERBA;'
defb 'IORST,ROIS,ROSI,ROTI,ROTS,SOIR,SOIT,SORT,TIRS,TORI,TORS,TRIO,TRIS,ORIST,ROSIT,ROSTI,ROTIS,SORTI,TRIOS,TROIS;'
defb 'IORSU,ORUS,OUIR,OUIS,OURS,ROIS,ROSI,ROUI,SOIR,SOUI,SURI,ROUIS,SOURI,UROIS,USOIR;'
defb 'OPRST,PORT,POST,POTS,PROS,PROT,ROTS,SORT,SPOT,STOP,TOPS,TORS,TROP,PORTS,SPORT;'


lexiLevel7 ; 6 lettres
defb 'AAIPRT,PAIRAT,PAITRA,PARAIT,PARIAT,PATIRA,PIRATA,RAPAIT,RAPIAT,RAPTAI,TAPIRA,TRAPAI;'
defb 'ACENRS,ANCRES,ARCENS,CARNES,CERNAS,CRANES,CRENAS,ECRANS,ENCRAS,NACRES,NERSAC,RANCES;'
defb 'ACENRT,CANTRE,CARENT,CARNET,CENTRA,CERNAT,CRANTE,CREANT,CRENAT,ENCART,ENCRAT,NECTAR,RACENT,TANCER,TANREC,TRANCE;'
defb 'AEEPRS,EPARES,EPARSE,ESPARE,ESPERA,PAREES,PARSEE,PESERA,RAPEES,REPESA,RESAPE,SARPEE,SEPARE;'
defb 'AEEPRT,APRETE,APTERE,ARPETE,EPATER,ETRAPE,ETREPA,PATERE,PETERA,RAPTEE,REPETA,RETAPE;'
defb 'AEGINR,ANGRIE,ARGEIN,EGRAIN,GAINER,GAREIN,GARNIE,GRAINE,GRENAI,IGNARE,INGERA,REGAIN,REGINA,REGNAI;'
defb 'AEGIRT,AGITER,AIGRET,GARITE,GERAIT,GERTAI,GITERA,GREAIT,REAGIT,REGITA,TIGERA,TRIAGE;'
defb 'AEILPR,LIPARE,PAIRLE,PALIER,PAREIL,PERLAI,PIALER,PILERA,PLAIRE,PLIERA,PRELAI,REPALI,REPILA,REPLIA;'
defb 'AEIMRR,AMERRI,ARIMER,ARRIME,MARIER,MARRIE,MIRERA,RAIMER,RAMIER,REMIRA,RERIMA,RIMERA;'
defb 'AEINRS,ANIERS,ANISER,ARIENS,ARSINE,ASINER,ERNAIS,INSERA,NIERAS,RAINES,RENAIS,RENIAS,RESINA,SERAIN,SERINA,SIRENA;'
defb 'AEINRT,AIRENT,ARETIN,ARTIEN,ENTRAI,INERTA,NAITRE,RAIENT,RATINE,RENAIT,RENIAT,RENTAI,RIANTE,TARINE,TRAINE,TRIANE;'
defb 'AEINRV,ARVIEN,ARVINE,AVENIR,AVINER,ENIVRA,NAVIRE,NERVAI,RAVINE,RENVIA,REVINA,VINERA;'
defb 'AEINST,ENTAIS,ESTAIN,ETAINS,NIATES,SAINTE,SANITE,SATINE,SEINAT,SENAIT,TANISE,TENAIS,TENIAS,TISANE;'
defb 'AEIPRT,ETRIPA,PAITRE,PARITE,PARTIE,PATRIE,PIRATE,PRETAI,REPAIT,REPATI,RETAPI,TAPIER,TAPIRE,TIPERA;'
defb 'AEIRST,AITRES,ARISTE,ETIRAS,ITERAS,RAITES,RESAIT,RESTAI,SATIRE,SERAIT,SERIAT,STARIE,STERAI,TARIES,TERSAI,TIARES,TISERA;'
defb 'AEIRSV,AVISER,RAVIES,RAVISE,REVAIS,REVISA,SEVIRA,SEVRAI,VARIES,VASIER,VERSAI,VISERA,VRAIES;'
defb 'AEMRSU,AMURES,AMUSER,MASURE,MAURES,MESURA,MUERAS,MUSERA,REMUAS,REMUSA,RESUMA,RUAMES;'
defb 'AEPRST,ESPART,PARTES,PATRES,PETRAS,PRESTA,PRETAS,RAPTES,SERPAT,SPARTE,TRAPES,TREPAS;'
defb 'AERSTU,RESTAU,RESUAT,RETUAS,REUSAT,RUATES,SATURE,SAURET,SAUTER,SURATE,TAURES,TUERAS,URATES;'
defb 'AIOPST,APTOIS,OPIATS,OPTAIS,PATIOS,PATOIS,PISOTA,POISAT,POSAIT,POSTAI,POTAIS,TOPAIS;'

lexiLevel8 ; 7 lettres
defb 'AABDERR,BADRERA,BARDERA,BRADERA,DEBARRA,REBADRA,REBARDA,REBRADA;'
defb 'AACEHRT,CATHARE,CHATERA,HECTARA,RACHETA,RECHATA,RETACHA,TACHERA;'
defb 'AACEIRS,ACERAIS,ACIERAS,ACRAISE,ARCAISE,CARSAIE,CASERAI,ECRASAI,RECASAI;'
defb 'AACINRT,ANCRAIT,CARIANT,CARNAIT,CRANAIT,CRANTAI,NACRAIT,RACINAT,RANCAIT,RICANAT;'
defb 'AAENRTT,AERTANT,ENTARTA,ERATANT,NATTERA,RENATTA,TARTANE,TATANER;'
defb 'ABEELST,BATELES,BEATLES,BELATES,BELESTA,BLASTEE,BLATEES,ETABLES,TABLEES;'
defb 'ACEEHRT,ACHETER,CHATREE,HECTARE,RACHETE,RECHATE,RETACHE,TRACHEE;'
defb 'ACEEPRS,ESCAPER,ESCARPE,ESCREPA,ESPACER,RECAPES,RECEPAS,REPACSE,RESCAPE;'
defb 'ACEHINR,ACHRIEN,ARCHINE,CHAINER,CHINERA,NICHERA,RECHINA,RENICHA;'
defb 'ACEIMRS,CAMIERS,CIMERAS,CIRAMES,CREMAIS,CRIAMES,ESCRIMA,RACISME;'
defb 'ACEINRZ,ANCRIEZ,CARNIEZ,CRANIEZ,NACRIEZ,RACINEZ,RANCIEZ,RICANEZ;'
defb 'AEEGMNS,AGMEENS,ENGAMES,GENAMES,MAGNEES,MANEGES,MANGEES,MENAGES,MESANGE;'
defb 'AEEILRT,AILETER,ALTIERE,ATELIER,ELAITER,ELITERA,ETALIER,REALITE;'
defb 'AEENRTV,AVENTER,AVERENT,ENERVAT,ENTERVA,ENTRAVE,EVENTRA,EVERANT,REVANTE,REVENTA,TAVERNE,VENERAT,VENTERA,VETERAN;'
defb 'AEEPRSU,APEURES,APUREES,EPEURAS,PAREUSE,PRESEAU,RAPEUSE,REPAUSE,SERPEAU;'
defb 'AEGINRS,ENGRAIS,GARNIES,GRAINES,GRENAIS,GRESAIN,INGERAS,REGAINS,REGNAIS,RESIGNA,SAIGNER,SERINGA,SIGNERA,SINGERA;'
defb 'AEGNORS,AGREONS,EGARONS,ONAGRES,ORANGES,ORGANES,RAGEONS,RONGEAS,SONGERA;'
defb 'AEILNPT,EPILANT,LAPINET,PATELIN,PETALIN,PIALENT,PLAINTE,PLATINE,PLIANTE;'
defb 'AEILPRS,PAIRLES,PALIERS,PAREILS,PERLAIS,PIERLAS,PILERAS,PLIERAS,PRELAIS,REPALIS,REPILAS,REPLIAS,SPIRALE;'
defb 'AEILORV,LOVERAI,RELOVAI,REVIOLA,REVOILA,REVOLAI,VARIOLE,VEROLAI,VIOLERA,VOILERA,VOLERAI;'
defb 'AEINSST,NASSIET,SAINTES,SANITES,SATINES,SENTAIS,TANISES,TISANES;'
defb 'EEINRRT,INERTER,RENITRE,RENTIER,RERIENT,RETENIR,RETERNI,TERNIER,TERREIN,TERRIEN,TERRINE;'
defb 'EEIRSTV,ESTIVER,ESTRIVE,ETRIVES,RETIVES,REVETIS,REVITES,RIVETES,SERVITE,SIEVERT,TREVISE,VERISTE,VERITES,VERTIES,VITREES;'
defb 'EOPRSTU,PERUSOT,POSTURE,POUTRES,POUTSER,PROUTES,SEPTUOR,TROUPES;'

lexiLevel9 ; 6/8 lettres
defb 'AAAFILST,ALAISA,ALATIF,ALITAS,FASIAT,FATALS,FLATIS,LIFTAS,SALAIT,TAIFAS,TALAIS,ALAISAT,ALATAIS,FALAISA,FALAISAT,FATALISA;'
defb 'AAACENRV,ARCANE,ARNAVE,AVANCA,AVANCE,AVERAN,CANERA,CARENA,CAVERA,CRAVAN,ECARNA,ECARVA,ENCAVA,RECANA,RECAVA,AVANCER,AVANCERA,CARAVANE,REAVANCA;'
defb 'AAACMRSS,AMASSA,ARAMAS,ARASAS,CARMAS,CRAMAS,CRAMSA,CRASSA,MARSAC,MARSAS,MASSAC,RAMSAS,SACRAS,CRAMSAS,MARACAS,MASCARA,RAMASSA,SAMARAS,MACASSAR,MASCARAS,MASSACRA;'
defb 'AAAILRSS,ALAISA,ARASAI,ARASAS,ARISAS,ARSAIS,LAISSA,LASSAI,LIASSA,RALAIS,RASAIS,SALAIS,SALIRA,SARAIS,ALAISAS,ARASAIS,LARISSA,SALARIA,SALIRAS,SALARIAS,SALARISA;'
defb 'AAAIPRRT,PAIRAT,PAITRA,PARAIT,PARIAT,PARTIR,PATIRA,PIRATA,RAPAIT,RAPIAT,RAPTAI,TAPIRA,TARARA,TARIRA,TRAIRA,TRAPAI,PARTIRA,TARARAI,PARAITRA,RAPATRIA;'
defb 'AABCNNOS,ABONNA,ABSCON,BANCOS,BANNAS,BONNAC,CABANS,CANNAS,CANONS,SCANNA,SONNAC,ABONNAS,BACONNA,CABANON,BACONNAS,CABANONS;'
defb 'AABDDEIN,BADINA,BADINE,BANDAI,DEBINA,DEDAIN,DINADE,NAIADE,BADIANE,DANAIDE,DEBANDA,DEBADINA,DEBANDAI;'
defb 'AABEEQRU,ABAQUE,ABEQUA,ABEQUE,ARQUEE,AUBERE,BARQUE,BRAQUA,BRAQUE,RAQUEE,ABEQUER,ABRAQUE,BARAQUE,BARQUEE,BRAQUEE,REBEQUA,ABEQUERA,ABRAQUEE,BARAQUEE;'
defb 'AABEFORU,BAFOUA,BAFOUE,BAROUF,BOUERA,EBROUA,FEBRUA,FOURBA,FOURBE,BAFOUER,BAROUFE,BAFOUERA,REBAFOUA;'
defb 'AABEGRRR,ABERRA,BARERA,BARRER,BEGAAR,BRAGAR,GABARE,GABERA,GARERA,RAGERA,RAGREA,REGARA,BAGARRE,BARRAGE,BARRERA,BRAGARE,GABARER,GABARRE,REBARRA,BAGARRER,BARRAGER;'
defb 'AABEJMNT,AMANTE,AMENAT,BANTAM,BATMAN,BEAMAT,EJAMBA,EMANAT,EMBATA,ENTAMA,BEAMANT,EJAMBAT,ENJAMBA,EJAMBANT,ENJAMBAT;'
defb 'AABELLMS,ALLESA,AMBLAS,AMBLES,BALLAS,BALLES,BEAMAS,BLAMAS,BLAMES,EMBLAS,LABELS,LAMBEL,MALLEA,MALLES,SEMBLA,ALLAMES,EMBALLA,MALLEAS,BALLAMES,EMBALLAS;'
defb 'AABELMMS,AMBLAS,AMBLES,BEAMAS,BLAMAS,BLAMES,EMBLAS,SEMBLA,LAMAMES,AMBLAMES,BLAMAMES;'
defb 'AABGIOTT,AGIOTA,AGITAT,BAGOTA,BATAIT,BATTAI,BOITAT,BOITTA,BOTTAI,GABAIT,GATAIT,GATTAI,GOBAIT,AGIOTAT,AGITATO,BAGOTAI,BAGOTAT,BAGOTTA,BAGOTAIT,BAGOTTAI;'
defb 'AABIILOR,ABOLIR,ABRIAI,AIRIAL,BLAIRA,BOIRAI,RABLAI,RIBLAI,ABOLIRA,BARIOLA,BLAIRAI,ABOLIRAI,BARIOLAI;'
defb 'AACCDENT,ACCEDA,ACCENT,ADENTA,CACADE,CACATE,CANETA,CEDANT,ACCEDAT,CADENCA,CANDACE,DECANAT,DECANTA,ACCEDANT,CADENCAT;'
defb 'AACCDESS,ACCEDA,CACADE,CESSAC,DECASA,ACCEDAS,CASCADE,CASSADE,DECASAS,SACCADE,CASCADES,SACCADES;'
defb 'AACCEIPT,ACAPTE,APIECA,CACATE,CAPAIT,CAPEAI,CAPEAT,CAPIAT,CAPITA,CAPITE,CAPTAI,EPATAI,EPICAT,ACCEPTA,APIECAT,CAPEAIT,ACCEPTAI,CAPACITE;'
defb 'AACCOSTT,ACCOTA,ACCOTS,ATOCAS,CACAOS,CASTAT,COTTAS,TACOTS,TOASTA,ACCOSTA,ACCOTAS,ACCOTAT,ATTACCO,TOCCATA,ACCOSTAT,STACCATO;'
defb 'AACEFFIS,AFFIAS,AFFIES,ECAFAI,ECAFAS,ECAFFA,EFFACA,FACAIS,FACIES,FASCAI,FASCIA,FASCIE,FASEIA,ECAFAIS,ECAFFAI,ECAFFAS,EFFACAI,EFFACAS,ECAFFAIS,EFFACAIS;'
defb 'AACEGLQU,ACAULE,ALAQUE,CALAGE,CALQUA,CALQUE,CLAQUA,CLAQUE,EGAULA,ELAGUA,LACAGE,CAQUAGE,LAQUAGE,CALQUAGE,CLAQUAGE;'
defb 'AACIMNNO,CAIMAN,CAMION,CANNAI,MANIOC,NOMAIN,NOMINA,COANIMA,MACONNA,CAMIONNA,MACONNAI;'
defb 'AACIOSSS,ASSOIS,CASAIS,CASOIS,CASSAI,CASSAS,CASSIS,COASSA,COSSAI,COSSAS,SASSAI,ASSOCIA,CASSAIS,COASSAI,COASSAS,COSSAIS,SAISSAC,ASSACOIS,ASSOCIAS,COASSAIS;'
defb 'AADINOTT,ADONAI,AIDANT,ANTOIT,ATINTA,DATAIT,DATANT,DATION,DOTAIT,DOTANT,IODANT,NATTAI,NOTAIT,TITANA,TONDIT,TONDAIT,ANTIDOTA,DATATION;'
defb 'AADLOPRS,ADORAS,DORSAL,DRAPAS,DROPAS,LARDAS,LOADAS,OPALAS,PALAOS,PARLAS,POLARD,POLARS,SALARD,SALOPA,SOLARD,PARASOL,POLARDA,POLARDS,POLARDAS,SALOPARD;'
defb 'AAEEGSSY,AGASSE,ASSEYE,AYASSE,EGAYAS,EGAYES,ESSAYA,ESSAYE,AGEASSE,EGAYASSE,ESSAYAGE;'
defb 'AAEGOPTT,EPATAT,PAGEAT,PAGEOT,PATATE,POTAGE,TAPAGE,TAPOTA,TAPOTE,TATAGE,PAGEOTA,PAGEOTAT,TAPOTAGE;'
defb 'AAELLMNT,ALLANT,AMANTE,AMENAT,EMANAT,ENTAMA,LAMANT,LAMENT,MALATE,MALLEA,MELANT,MENTAL,NATALE,ALLANTE,LAMENTA,MALLEAT,ALLEMANT,MALLEANT;'
defb 'AAEPQSTU,EPATAS,PAQUAS,PAQUAT,PAQUES,PAQUET,PAUSAT,PUATES,QUETAS,SAQUAT,SAQUET,TAQUAS,TAQUES,TASQUE,TAUPES,PAQUETA,PAQUETS,PAQUATES,PAQUETAS,PATAQUES;'
defb 'AAFFILSU,AFFIAS,AFFILA,AFFLUA,FLUAIS,SALUAI,SIFFLA,SUIFFA,AFFILAS,AFFLUAI,AFFLUAS,FAUFILA,AFFLUAIS,FAUFILAS;'
defb 'AAGIILLU,AIGAIL,AILLAI,ALLIAI,GAULAI,GILLAI,GUILLA,LIGUAI,AGUILLA,AIGLIAU,AIGUAIL,GUILLAI,AGUILLAI,AIGUILLA;'
defb 'AAGIIMRR,AGIRAI,AIGRIR,ARIMAI,ARRIMA,GRIMAI,MAIGRI,MARIAI,MARRAI,MIGRAI,RAIMAI,AIGRIRA,AMAIGRI,ARRIMAI,MAIGRIR,AMAIGRIR,MAIGRIRA,RAMAIGRI;'
defb 'AAGINPPR,GRAINA,GRAPPA,GRIPPA,NAGARI,NAPPAI,PAGINA,PARIAN,RAPINA,RAPPAI,AGRIPPA,GRAPPAI,GRAPPIN,GRAPPINA,PARPAING;'
defb 'AAHMNORT,AHONTA,ARAMON,ARMANT,ARTHON,MANTRA,MARNAT,MATARO,MONTRA,NORMAT,RAMANT,RAMONA,ATHANOR,MARTHON,MOHATRA,RAMONAT,HARAMONT,MARATHON;'
defb 'AAIINQTU,ANUAIT,ANUITA,AUNAIT,NAQUIT,NIQUAI,NIQUAT,QUANTA,QUINTA,TAQUAI,TAQUIN,TIQUAI,ANTIQUA,ANUITAI,NIQUAIT,QUINTAI,TAQUINA,ANTIQUAI,AQUITAIN,TAQUINAI;'
defb 'AANOPPTT,APONTA,NAPPAT,OPTANT,PANTAT,PAPOTA,PATANT,PONTAT,POTANT,TAPANT,TAPOTA,TOPANT,APONTAT,APPONTA,PAPOTAT,APPONTAT,PAPOTANT;'
defb 'AANQRTTU,ARQUAT,AUTANT,QATANT,QUANTA,QUARTA,RAQUAT,RATANT,TANTRA,TAQUAT,TARANT,TARTAN,TRAQUA,ARQUANT,QUARTAN,QUARTAT,RAQUANT,TAQUANT,TRAQUAT,QUARTANT,TRAQUANT;'
defb 'AAOPSSTT,APOSTA,ASSOTA,PASSAT,PATTAS,POSTAS,POSTAT,TAPOTA,TASSAT,TOASTA,TOASTS,TOSSAT,TOSTAS,APOSTAS,APOSTAT,ASSOTAT,POTASSA,TAPOTAS,TOASTAS,APOSTATS,POTASSAT;'
defb 'ABCDORRS,ABORDS,BOCARD,BORDAS,BROCAS,BRODAS,CADORS,CARROS,COBRAS,CORBAS,CORDAS,CROARD,DORCAS,SABORD,SADROC,BROCARD,CROBARD,CROBARS,BROCARDS,CROBARDS;'
defb 'ABCEEKRZ,ACERBE,ACEREZ,BACKEE,BACKER,BACKEZ,BERCEZ,BRAKEZ,BREAKE,CABREE,CABREZ,BREAKEZ,REBACKE,BACKEREZ,REBACKEZ;'
defb 'ABENNORR,ABONNE,ABORNE,ARBORE,ARROBE,BANNER,BERNON,BORNER,BRANNE,BRENON,ENROBA,ORNERA,REORNA,ROANNE,ABONNER,ABORNER,BARONNE,BORNERA,REBORNA,BARONNER,BARRONNE;'
defb 'ACCDDEEI,ACCEDE,ACEDIE,CADDIE,DECADE,DECADI,DECEDA,DECIDA,DECIDE,CADDIEE,DECEDAI,DECICADE,DEDICACE;'
defb 'ACCHIINO,CACOIN,CHANCI,CHICON,CHINAI,COCHAI,COINCA,NICHAI,CHICONI,COINCAI,COINCHA,CONCHIA,COHINIAC,COINCHAI,CONCHIAI;'
defb 'ACDEIMUX,CADMIE,CAUDEX,DECIMA,ECUMAI,EXAUDI,IDEAUX,DECIMAUX,MEDICAUX;'
defb 'ACEEERRR,ACEREE,ACERER,ACERRE,CARREE,CARRER,CREERA,ERRERA,REAERE,RECREA,RECREE,REACERE,REAERER,RECARRE,RECREER,REACERER,RECARREE,RECREERA;'
defb 'ACEEGOSU,AGOUCE,AUGEES,CAGUES,CAUSEE,ECOUAS,ECOUES,SAUCEE,SECOUA,SECOUE,SUAGEE,USAGEE,AGOUCEE,AGOUCES,AGOUCEES,SECOUAGE;'
defb 'ACGILNNT,CANTIN,CIGLAT,CINGLA,CLIGNA,GICLAT,GILANT,GINCLA,LANTIC,LIGNAT,TIGNAC,TINCAL,CIGLANT,CINGLAT,CLIGNAT,GICLANT,LIGNANT,CINGLANT,CLIGNANT;'
defb 'ACIIINST,CASTIN,CATINS,CINAIS,CITAIS,INCISA,INCITA,INITIA,SANCIT,SCIAIT,SCIANT,SINCAI,SINCAT,INCISAI,INCISAT,INCITAI,INCITAS,INITIAS,SINCAIT,INCISAIT,INCITAIS;'
defb 'ACLOPSSY,CLOPAS,PLOYAS,SALOPS,SCALPS,SYSOPA,CALYPSO,COSPLAY,CALYPSOS,COSPLAYS;'
defb 'ADEEEGNT,ADENTE,AGENTE,DEGENA,DEGENE,DENAGE,DENTEE,EDENTA,EDENTE,ENGEAT,ETAGEE,ETENDE,GANTEE,GEANTE,GENETA,GENETE,ADENTEE,DEGANTE,DEGENAT,DEGANTEE,ETENDAGE;'
defb 'ADEGHIPR,DEPRIA,DIAPRE,DIGERA,GARDIE,GRAPHE,HARDIE,HARPIE,PAREID,PIGERA,PRADIE,RAPIDE,RIDAGE,RIPAGE,GRAPHIE,DIGRAPHE,GRAPHIDE;'
defb 'ADEMMOPS,DEPOSA,DOMPAS,DOMPES,MODEMS,POMMAS,POMMES,SPAMME,DOPAMES,POMMADE,DOMPAMES,POMMADES;'
defb 'AEFFIILS,AFFIES,AFFILE,EFFILA,ELIAIS,FELAIS,FILAIS,ILAISE,LIAISE,SIFFLA,SIFFLE,AFFILES,AFFILIE,EFFILAI,EFFILAS,SALIFIE,SIFFLAI,AFFILIES,EFFILAIS,FALSIFIE;'
defb 'AEFIILQU,FALQUE,FEULAI,FLAQUE,FLIQUA,FLIQUE,FUELAI,LAIQUE,QUILAI,FLIQUAI,ILIAQUE,LIQUEFIA,QUALIFIE;'
defb 'AEGHMMOS,GAMMES,GEMMAS,GOMMAS,GOMMES,HEMMAS,HOMMES,MEGOHM,SMEGMA,HOMMAGE,HOMMAGES,MEGAOHMS;'
defb 'AEILOTTT,ELITAT,ETIOLA,ETOILA,ILOTAT,LITOTE,TETAIT,TILTAT,TOILAT,TOLITE,TOTALE,ETIOLAT,ETOILAT,TOILETTA,TOTALITE;'
defb 'AEIOPRUX,AIROUX,APORIE,EPURAI,EUROPA,EXPIRA,OPERAI,POREUX,PRAXIE,PREAUX,PUERAI,RAPEUX,REPAIX,REPUAI,RIPOUX,ROUPIE,ORIPEAU,PEXIORA,POIREAU,ORIPEAUX,POIREAUX;'
defb 'AFIIINRT,FINIRA,FRITAI,INITIA,NITRAI,RIFAIN,FINIRAI,FINIRAIT,NITRIFIA;'
defb 'AGIIRRSU,AIGRIR,AIGRIS,GIRAIS,GRISAI,GRUAIS,RIRAIS,RUGIRA,SAURIR,SURGIR,SURIRA,IRRIGUA,RUGIRAI,RUGIRAS,SURGIRA,SURIRAI,IRRIGUAS,RUGIRAIS,SURGIRAI;'
defb 'CEEILQTU,CLIQUE,CUITEE,ECUEIL,EQUITE,ETIQUE,LIQUET,QUIETE,TUILEE,CLIQUET,CELTIQUE,CLIQUETE;'
defb 'CEHOPSSY,CHESSY,CHOPES,CHOSES,CHOYES,HYSOPE,POCHES,PSYCHE,PSYCHO,SCOPES,SYSOPE,CYPHOSE,HYSOPES,PSYCHES,CYPHOSES,PSYCHOSE;'
defb 'CEMOOPST,COMPTE,COMTES,COOPTE,COPTES,POTOSE,STOEMP,TEMPOS,COMPOSE,COMPOST,COMPOTE,COMPTES,COOPTES,COMPOSTE,COMPOTES;'
defb 'DEIIIOST,DIOISE,EDITOS,IDIOTE,IDIOTS,TIEDIS,IDIOTES,IDIOTIE,IDIOTIES,IDIOTISE;'
defb 'EFORRRUU,FOREUR,FORURE,FOURRE,FROUER,FUREUR,FOURRER,FOURREUR,FOURRURE;'
defb 'EGGNOORS,GERONS,GORGES,GREONS,GROGNE,GROSNE,NEGROS,OREGON,ORONGE,ROGNES,RONGES,SONGER,SONORE,GORGEON,GORGONE,GROGNES,ORONGES,GORGEONS,GORGONES;'
defb 'EIINNSTU,ENNUIS,ENSUIT,NUISIT,SUINTE,TENNIS,UNITES,INSINUE,INUSITE,NUISENT,SINUENT,SUNNITE,TUNISIE,USINENT,SUINTINE,TUNISIEN;'
defb 'EILLLSTU,LEITUS,LISTEL,LUITES,SILLET,TILLES,TUILES,TULLES,TILLEUL,LULLISTE,TILLEULS;'
defb 'EIMOPPRR,MOIRER,ORMIER,POMPER,PRIMER,PROPRE,RIPPER,ROMPRE,OPPRIME,POMPIER,IMPROPRE,OPPRIMER;'
defb 'EJNOORSU,JOUONS,JURONS,OURSON,ROUONS,SEJOUR,SONORE,JOUERONS,REJOUONS;'
defb 'ELNOOSTV,ENVOLS,LEVONS,LOOTES,LOVENT,LOVONS,STOLON,VELONS,VESTON,VETONS,VOLENT,VOLETS,VOLONS,VOLTES,VOTONS,VELTONS,VOLONTE,VOLTONS,VOLETONS,VOLONTES;'
defb 'ELRSTTUU,LUEURS,LUSTRE,LUTTER,LUTTES,SUTURE,TRUSTE,TUEURS,TURLUT,TUTEUR,TUTLER,TUTLES,ULSTER,UTERUS,LUTTEUR,TURLUTE,TUTEURS,LUTTEURS,TURLUTES;'
defb 'GIMNNOOS,GNOMON,MIGNON,MINONS,OGNOIS,OGNONS,OIGNON,SOMONI,MIGNONS,MOIGNON,OIGNONS,GOMINONS,MOIGNONS;'
defb 'CDEELOUZ,CEDULE,CLOUEE,CLOUEZ,COUDEE,COUDEZ,COULEE,COULEZ,CUDELE,DOZULE,ECOLEZ,ECOUEZ,ECOULE,ECULEZ,ELUDEZ,DECLOUE,DECOULE,ECOULEZ,DECLOUEZ,DECOULEZ;'
defb 'CDEOSSUU,COSSUE,COUDES,COUSES,COUSUE,COUSUS,DOUCES,ESCUDO,SOUDES,COUSUES,DECOUSU,ESCUDOS,DECOUSUS;'

lexiLevel10  ; 8/8 lettres
defb 'AACEHIRT,CHATAIRE,CHATERAI,CHATIERA,HECTARAI,RACHETAI,RECHATAI,RECHATIA,RETACHAI,TACHERAI;'
defb 'AACELRST,CALTERAS,CASTRALE,LACTERAS,RACLATES,RECALTAS,RELACTAS,RETACLAS,SCARLATE,TACLERAS;'
defb 'AAEIMRRT,ARMERAIT,RAMERAIT,REARMAIT,REMARIAT,REMATIRA,RERAMAIT,RETRAMAI,TRAMERAI;'
defb 'AAEINRTV,AVARIENT,ENTRAVAI,REAVINAT,REVANTAI,TAVERNAI,VANTERAI,VARIANTE;'
defb 'AAELNPRT,PARENTAL,PARLANTE,PLANTERA,PRENATAL,RELAPANT,REPLANAT,REPLANTA;'
defb 'ABEORSTU,ARBOUTES,BOUTERAS,EBROUTAS,RABOUTES,REABSOUT,REBOUTAS,SABOTEUR;'
defb 'ACEEHRST,CHASERET,CHATREES,CHERATES,HECTARES,RACHETES,RECHATES,REESCHAT,RESECHAT,RETACHES,TRACHEES;'
defb 'ACEELNRT,CALERENT,CENTRALE,CRENELAT,ENTRELAC,LACERENT,RECALENT,RECELANT,RELACENT,TELECRAN;'
defb 'ACEERRSU,CREUSERA,ECRASEUR,ECURERAS,RECAUSER,RECREUSA,RECUSERA,RESAUCER,RESUCERA;'
defb 'ACEINNRT,CANTINER,CARNETIN,ENCIRANT,INCANTER,INCERANT,RACINENT,RICANENT;'
defb 'ADEINRST,DENITRAS,DESARNIT,DESIRANT,REDISANT,RESIDANT,SIDERANT,TEINDRAS,TENDRAIS,TIENDRAS;'
defb 'AEFINSTU,ENFUTAIS,ENSUIFAT,FAUSTIEN,FUNESTAI,FUSAIENT,FUTASIEN,INFATUES;'
defb 'AEFIRSTU,FEUTRAIS,FUITERAS,FURETAIS,FUSERAIT,FUSTERAI,REFUSAIT,REFUTAIS,SURFAITE;'
defb 'AEGINSST,AGISSENT,GASTINES,GINESTAS,GISANTES,SIGNATES,TEASINGS,TIGNASSE;'
defb 'AEGNORTT,ARGOTENT,EGROTANT,ERGOTANT,ETROGNAT,GATERONT,GORETANT,RAGOTENT,TANGOTER;'
defb 'AEILNPRT,PALIRENT,PETRINAL,PLATINER,REPILANT,REPLAINT,REPLANIT,REPLIANT;'
defb 'AEINRRTT,NITRATER,RENITRAT,RENTRAIT,RETIRANT,RETRIANT,TARIRENT,TARTINER;'
defb 'AEINRSST,ASSENTIR,ASSIRENT,ASTREINS,NITRASSE,RETSINAS,SENTIRAS,TARSIENS,TRANSIES,TRESNAIS,TSARIENS,TSARINES;'
defb 'AEINRSSU,REUSINAS,RUINASSE,SAUNIERS,SAURIENS,SINUERAS,URINASSE,USINERAS;'
defb 'CEEINRST,CEINTRES,CENTRISE,CERTINES,CINTREES,CITERNES,CRESTINE,CRETINES,RECEINTS,RESCIENT,SCIERENT;'
defb 'CEEORSSU,COURESSE,COURSEES,ECOSSEUR,OCREUSES,RECOUSES,SECOURES,SOURCEES;'
defb 'CEEORSTU,CROUTEES,ECOURTES,ECROUTES,RECOUTES,RESCOUTE,RESUCOTE,SURCOTEE;'
defb 'CEINORRS,CIRERONS,CORNIERS,CRIERONS,ECRIRONS,RECIRONS,RECRIONS,RONCIERS;'
defb 'CENORSTU,CONTEURS,COURSENT,CURETONS,CUTERONS,ERUCTONS,SOURCENT,SUCERONT;'
defb 'EFNORSTU,FEUTRONS,FORTUNES,FOURNETS,FURETONS,FUSERONT,REFUTONS,SOUFRENT;'

defb PIPE ; end marker => win the game





charset


print 'fin des donnees ',{hex}$


save 'exec.bin',#100,$-#100



