
MAX_PATTERN equ 9
ENDMARK equ 128

KeyF1addr equ 64+#C000+28*64+26+#800*5 ; 1
KeyF2addr equ 64+#C000+29*64+30+#800*0 ; 2
KeyF3addr equ 64+#C000+28*64+34+#800*5 ; 3
KeyF4addr equ 64+#C000+26*64+25+#800*5 ; 4
KeyF5addr equ 64+#C000+26*64+30+#800*5 ; 5
KeyF6addr equ 64+#C000+26*64+35+#800*5 ; 6
KeyF7addr equ 64+#C000+24*64+26+#800*5 ; 7
KeyF8addr equ 64+#C000+24*64+30+#800*0 ; 8
KeyF9addr equ 64+#C000+24*64+34+#800*5 ; 9

      VIRGULE equ 64
POINT_VIRGULE equ 66
         PIPE equ 68

; === menu ===
; 1 demarrer
; 2 code
; 3 a propos
; 3 credits
; use numeric pad


; routine d'affichage de sprites 8x16









buildsna
bankset 0
org #38
ei:ret

run #100
org #100
ld hl,#C9FB : ld (#38),hl
ld sp,#100
ei
call razScr
ld hl,cubicScreenCRTC : call crtc_setup

call scankeyboard.init
call doFontConversion
call setColorz
ld hl,cell_motsEnFete : ld de,#0003 : call displayStringCell

ld hl,str_init01 : ld de,1+#C000+5*64        : call displayString
ld hl,str_init02 : ld de,1+#C000+6*64+4*#800 : call displayString
ld hl,str_init03 : ld de,0+#C000+8*64        : call displayString

ld hl,str_init04 : ld de,0+#C000+11*64        : call displayString
ld hl,str_init05 : ld de,0+#C000+12*64+4*#800 : call displayString
ld hl,str_init06 : ld de,0+#C000+14*64        : call displayString

ld hl,str_init07 : ld de,0+#C000+17*64        : call displayString
ld hl,str_init08 : ld de,0+#C000+18*64+4*#800 : call displayString
ld hl,str_init09 : ld de,0+#C000+20*64        : call displayString

ld hl,str_init10 : ld de,1+#C000+23*64        : call displayString
ld hl,str_init11 : ld de,0+#C000+24*64+4*#800 : call displayString
ld hl,str_init12 : ld de,0+#C000+26*64        : call displayString


.space call scankeyboard


ld hl,keyboardmap : xor a : ld b,10
.testTouche or (hl) : inc hl : djnz .testTouche
or a : jr z,.space
call refreshChoices.waitKeyboard
jp newGame


razScr
ld bc,#7F01 : out (c),c : ld a,#58 : out (c),a
inc c : out (c),c : out (c),a
inc c : out (c),c : out (c),a
ld hl,#C000 : xor a
.razScr repeat 8 : ld (hl),a : inc l : rend : jr nz,.razScr : inc h : jr nz,.razScr
;...
setColorz
ld hl,#4B46 : ld de,#5840
ld bc,#7F03
out (c),c : out (c),l : dec c
out (c),c : out (c),h : dec c
out (c),c : out (c),e : dec c
out (c),c : out (c),d : ld c,#10
out (c),c : out (c),d
ret



novbl ld b,#F5 : .loop in a,(c) : rra : jr c,.loop
vbl ld b,#F5 : .loop in a,(c) : rra : jr nc,.loop : ret

cubicScreenCRTC defb 6,32,1,32,2,42,7|0x80,34

doFontConversion
ld hl,fontChar
ld de,fontCharCell
ld b,hi(convertFont)
exx
ld bc,fontChar{26}+18-fontChar
.prepFont exx : ld c,(hl) : ld a,(bc) : ld (de),a : inc hl : inc de : exx : dec bc : ld a,b : or c : jr nz,.prepFont
ret

align 256
convertFont
repeat 256,x,0
	p1=x&%10001000
	p2=x&%1000100
	p3=x&%100010
	p4=x&%10001
	if !p1 : p1=%10001000 : endif
	if !p2 : p2=%1000100 : endif
	if !p3 : p3=%100010 : endif
	if !p4 : p4=%10001 : endif
	defb p1|p2|p3|p4
rend

align 256
charAddress
yoffset=0 ; pour se centrer (sprite de 3 bytes sur 18 lignes
repeat 15 ; 12 lignes de 20 pixels
	xoffset=0 ; on peut pas partir de 1.5 ...
	repeat 16 ; 16 grandes cases de 4 octets
		scrAdr=#C000+xoffset+(yoffset>>3)*64+(yoffset%8)*0x800
		defw scrAdr
		xoffset+=4
	rend
	repeat 16 : defw 0 : rend
	yoffset+=16
rend

align 2
charLine
yoffset=0 ; pour se centrer (sprite de 3 bytes sur 18 lignes
repeat 15 ; 12 lignes de 20 pixels
	scrAdr=#C000+(yoffset>>3)*64+(yoffset%8)*0x800
	defw scrAdr
	yoffset+=16
rend

include 'arkosSetupCRTC.asm'

align 256
fontChar
repeat 27,cpos,0
	fontChar{cpos}
	incbin 'terminalFont8x9.bin',cpos*20,18
	if ($&0xFF)>256-18 : align 256 : print 'adjust',cpos : endif
rend

align 256
fontOffset
repeat 27,x,0
defw fontChar{x}
rend

align 256
fontCharCell
repeat 27,cpos,0
	fontCharCell{cpos}
	incbin 'terminalFont8x9.bin',cpos*20,18
	if ($&0xFF)>256-18 : align 256 : print 'adjust',cpos : endif
rend

align 256
fontOffsetCell
repeat 27,x,0
defw fontCharCell{x}
rend

; A=char
; DE=Y/X
displayCharCell
sla e : sla e : sla e : srl de : srl de : ld hl,charAddress : add hl,de
ld e,(hl) : inc l : ld d,(hl) ; DE=destination on screen
displayCharCellAt ; run this with DE already set!
ld h,hi(fontOffsetCell) : ld l,a : ld a,(hl) : inc l : ld h,(hl) : ld l,a ; HL=char address

inc e : ld a,#FF : ld (de),a : inc e : ld (de),a : dec e : dec e
ld a,d : add 8 : ld d,a : jr nc,.pushNextPP
ld a,64 : add e : ld e,a : ld a,d : adc #C0 : ld d,a
.pushNextPP

ld a,(de) : or %110011 : ld (de),a : inc e : ld a,#FF : ld (de),a : inc e : ld (de),a : inc e : ld a,(de) : or %11001100 : ld (de),a : dec e : dec e : dec e
ld a,d : add 8 : ld d,a : jr nc,.pushNextP
ld a,64 : add e : ld e,a : ld a,d : adc #C0 : ld d,a
.pushNextP

ld b,9
.pushLine
ld a,(de) : or %110011 : ld (de),a : inc e : ld a,(hl) : inc l : ld (de),a : inc e : ld a,(hl) : inc l : ld (de),a : inc e : ld a,(de) : or %11001100 : ld (de),a : dec e : dec e : dec e
ld a,d : add 8 : ld d,a : jr nc,.pushNext
ld a,64 : add e : ld e,a : ld a,d : adc #C0 : ld d,a
.pushNext
djnz .pushLine

; LastLine
ld a,(de) : or %110011 : ld (de),a : inc e : ld a,#FF : ld (de),a : inc e : ld (de),a : inc e : ld a,(de) : or %11001100 : ld (de),a : dec e : dec e : dec e
ld a,d : add 8 : ld d,a : jr nc,.pushNextD
ld a,64 : add e : ld e,a : ld a,d : adc #C0 : ld d,a
.pushNextD
inc e : ld a,#FF : ld (de),a : inc e : ld (de),a
ret


; A=char
; DE=screen destination
displayChar
ld h,hi(fontOffset) : ld l,a : ld a,(hl) : inc l : ld h,(hl) : ld l,a ; HL=char address
ld b,8
.pushLine
ld a,(hl) : inc l : ld (de),a : inc e : ld a,(hl) : inc l : ld (de),a : dec e
ld a,d : add 8 : ld d,a : jr nc,.pushNext
ld a,64 : add e : ld e,a : ld a,d : adc #C0 : ld d,a
.pushNext
djnz .pushLine
ld a,(hl) : inc l : ld (de),a : inc e : ld a,(hl) : ld (de),a ; LastLine
ret



; HL=string
; DE=screen destination
displayString
ld a,(hl) : add a : ret c : push de,hl
call displayChar
pop hl,de : inc hl : inc e : inc e : jr displayString

; HL=string
; DE=X/Y
displayStringCell
ld a,(hl) : add a : ret c : push de,hl
call displayCharCell
pop hl,de : inc hl : inc e : jr displayStringCell






;*************************************************************
                            newGame
;*************************************************************
ld hl,lexiLevel1 : ld (lexiCurrentLevel),hl
;*************************************************************
                           initGame
;*************************************************************
ld sp,#100
xor a : ld (niveauAide),a
ld hl,(lexiCurrentLevel)
ld a,(hl) : cp PIPE : jp z,winZeGame


ld ix,levelUP.levelADR : ld iy,levelUP.levelSTR : ld de,hl
.trouveNiveau ld hl,(ix+0) : ld a,h : or l : jr z,.retourNormale : sbc hl,de : jr z,.messageNiveau : inc ix : inc ix : inc iy : inc iy : jr .trouveNiveau
.messageNiveau
call razScr
ld hl,(iy+0) : ld de,#C000+64*15+18 : call displayString
ld bc,2 : .msgWait halt : djnz .msgWait : dec c : jr nz,.msgWait

.retourNormale
ld hl,(lexiCurrentLevel)
ld a,VIRGULE : ld b,0
.countChoices cp (hl) : jr z,.countDone : inc hl : inc b : jr .countChoices : .countDone
ld a,b : ld (nbChoices),a
; en fonction du nombre de lettres on affiche un panneau de controle different + infos pour la saisie
ld hl,buildChoiceList : add a : ld e,a : ld d,0 : add hl,de : ld a,(hl) : inc l : ld h,(hl) : ld l,a : jp (hl)
retourInitChoice

ld hl,tailleEntrees : ld de,hl : inc de : ld bc,21 : ld (hl),0 : ldir ; raz entries + extra zero
; parsing des mots pour construire le visuel
ld iy,tailleEntrees : ld xl,0
ld hl,(lexiCurrentLevel) : ld d,0 : ld a,(nbChoices) : inc a : ld e,a : add hl,de ; se positionner sur le premier mot
; compter les longueurs
.scanEntrees  ld b,0
.scanEntree   ld a,(hl) : cp POINT_VIRGULE : jr z,.scanTermine : cp VIRGULE : jr z,.scanEntreeOK : inc b : inc hl : jr .scanEntree
.scanEntreeOK ld (iy+0),b : inc xl : inc iy : inc hl : jr .scanEntrees
.scantermine  ld (iy+0),b : inc xl ; dernière entrée
ld a,xl : ld (nombreMots),a
ld a,b : ld (longueurMax),a ; car la longueur MAX peut être inférieure au nombre de lettres

; build HUD cell positions
.buildHUDcellPositions
ld de,#C000+23*64 : ld a,(longueurMax) : sub 3 : add a : ld c,a : ld a,26 : sub c : add e : ld e,a
ld hl,hud1addr : ld bc,4 : ld a,(longueurMax)
.loop
	ld (hl),e : inc hl
	ld (hl),d : inc hl
	ex hl,de : add hl,bc : ex hl,de
	dec a : jr nz,.loop

ld hl,(lexiCurrentLevel) : ld de,referencePattern : ld b,0 : ld a,(nbChoices) : ld c,a : ldir ; copier le motif de jeu
ld a,(nbChoices) : ld b,a : ld a,MAX_PATTERN : sub b : jr z,.skipRaz : ld b,a : xor a : .razNext ld (de),a : inc de : djnz .razNext ; normalement inutile mais...   ceinture/bretelles!
.skipRaz
call initBoard

;*************************************************************
                           gameLoop
;*************************************************************
call controleClavier

ld hl,tailleEntrees : ld b,21 : xor a
.controleGagne or (hl) : inc hl : djnz .controleGagne
or a : jp z,niveauSuivant

jp gameLoop


;*************************************************************
                        niveauSuivant
;*************************************************************
ld hl,#C000+22*64
ld c,80
.razLines xor a : ld b,64 : push hl
.razLine ld (hl),a : inc l : djnz .razLine : pop hl
ld a,h : add 8 : ld h,a : jr nc,.next
ld a,64 : add l : ld l,a : ld a,#C0 : adc h : ld h,a : res 3,h 
.next
dec c : jr nz,.razLines

ld ix,(bravoList)
ld hl,(ix+0) : ld (bravoList),hl
ld hl,(ix+2) : ld de,#C000+27*64+13 : call displayString

ld bc,2
.rewait halt : djnz .rewait : dec c : jr nz,.rewait

.GOTOleSuivant
ld hl,(lexiCurrentLevel)
.scanEnd ld a,(hl) : cp POINT_VIRGULE : jr z,.leSuivant : inc hl : jr .scanEnd
.leSuivant
inc hl : ld a,(hl) : cp PIPE : jr z,winZeGame
ld (lexiCurrentLevel),hl
jp initGame

;*************************************************************
                           winZeGame
;*************************************************************
ld hl,lexiLevel1 : ld (lexiCurrentLevel),hl
; afficher une fin
call razScr
ld hl,str_win01 : ld de,0+#C000+16*64+2        : call displayString
; menu
ld bc,5
.waiteur halt : djnz .waiteur : dec c : jr nz,.waiteur
jp #100

;*************************************************************
                        controleClavier
;*************************************************************
;.automate ld a,0 : inc a : and 3 : ld (.automate+1),a : jp nz,aideAuJoueur : jp niveauSuivant.GOTOleSuivant
call scankeyboard
ld hl,(KeyF1char) : ld a,(hl) : cp #FF : jr z,.skipF1 : ld a,(KEY_F1_BYTE) : and KEY_F1_BIT : jp nz,addCharToHud : .skipF1
ld hl,(KeyF2char) : ld a,(hl) : cp #FF : jr z,.skipF2 : ld a,(KEY_F2_BYTE) : and KEY_F2_BIT : jp nz,addCharToHud : .skipF2
ld hl,(KeyF3char) : ld a,(hl) : cp #FF : jr z,.skipF3 : ld a,(KEY_F3_BYTE) : and KEY_F3_BIT : jp nz,addCharToHud : .skipF3
ld hl,(KeyF4char) : ld a,(hl) : cp #FF : jr z,.skipF4 : ld a,(KEY_F4_BYTE) : and KEY_F4_BIT : jp nz,addCharToHud : .skipF4
ld hl,(KeyF5char) : ld a,(hl) : cp #FF : jr z,.skipF5 : ld a,(KEY_F5_BYTE) : and KEY_F5_BIT : jp nz,addCharToHud : .skipF5
ld hl,(KeyF6char) : ld a,(hl) : cp #FF : jr z,.skipF6 : ld a,(KEY_F6_BYTE) : and KEY_F6_BIT : jp nz,addCharToHud : .skipF6
ld hl,(KeyF7char) : ld a,(hl) : cp #FF : jr z,.skipF7 : ld a,(KEY_F7_BYTE) : and KEY_F7_BIT : jp nz,addCharToHud : .skipF7
ld hl,(KeyF8char) : ld a,(hl) : cp #FF : jr z,.skipF8 : ld a,(KEY_F8_BYTE) : and KEY_F8_BIT : jp nz,addCharToHud : .skipF8
ld hl,(KeyF9char) : ld a,(hl) : cp #FF : jr z,.skipF9 : ld a,(KEY_F9_BYTE) : and KEY_F9_BIT : jp nz,addCharToHud : .skipF9
ld a,(KEY_SPACE_BYTE) : and KEY_SPACE_BIT : jp nz,verificationMot
ld a,(KEY_ENTER_BYTE) : and KEY_ENTER_BIT : jp nz,verificationMot
ld a,(KEY_RETURN_BYTE) : and KEY_RETURN_BIT : jp nz,verificationMot
ld a,(KEY_TAB_BYTE) : and KEY_TAB_BIT : jp nz,niveauSuivant.GOTOleSuivant
ld a,(KEY_ESC_BYTE) : and KEY_ESC_BIT : jp nz,levelUP
ld a,(KEY_H_BYTE) : and KEY_H_BIT : jp nz,aideAuJoueur
ret

addCharToHud
ld a,(hl) ; on récupère la valeur de la touche
ld (hl),0 : push hl ; d'abord on met à zéro pour effacer la touche
ld hl,(workPosition) : ld (hl),a : inc hl : ld (workPosition),hl ; on ajoute au HUD
call refreshChoices ; update display
pop hl : ld (hl),#FF ; et ensuite on inhibe après affichage!!!
ld hl,workPattern : ld d,0 : ld a,(longueurMax) : dec a : ld e,a : add hl,de : ld a,(hl) : or a : ret z
jp verificationMot

include 'keyboard.asm'

;*************************************************************
			verificationMot
;*************************************************************
; comparer le contenu du HUD avec les entrées
ld hl,(lexiCurrentLevel) : ld d,0 : ld a,(nbChoices) : ld e,a : inc e : add hl,de ; HL=debut des mots

ld xl,-1
.recompare
ld de,workPattern : inc xl
.compareMot ld a,(de) : cp (hl) : jr nz,.difference : inc de : inc hl : jr .compareMot ; petera toujours car la fin du mot est une virgule, un point-virgule et de l'autre côté un zéro
.difference ld a,(de) : or a : jr z,.finHud
; pas la fin du HUD, passer au mot suivant et recommencer
.motSuivant ld a,(hl) : inc hl : cp VIRGULE : jr z,.recompare : cp POINT_VIRGULE : jr z,.rienTrouve : jr .motSuivant

.finHud
ld a,(hl) : cp VIRGULE : jr z,.cestOK : cp POINT_VIRGULE : jr nz,.motSuivant ; fin du HUD mais pas d'un mot, on recommence (trop court!)
.cestOK
; XL=numéro du mot!!!
; se repositionner sur le début du mot
dec hl
.retourAuDebut ld a,(hl) : cp VIRGULE : jr z,.debutOK : dec hl : jr .retourAuDebut
.debutOK : inc hl ; HL=debut du mot
ld iy,tailleEntrees : ld a,xl : add yl : ld yl,a : ld a,yh : adc 0 : ld yh,a ; (IY) contient la longueur du mot
ld a,(iy+0) : or a : jp z,.rienTrouve ; zéro == déjà trouvé
ld xh,0 : add ix,ix : ld de,posEntrees : add ix,de : ld de,(ix+0) ; DE=position ecran du mot

.afficherMotEnPlace ld a,(hl) : push de,hl : call displayCharCellAt : pop hl,de : inc de : inc de : inc de : inc de : inc hl : dec (iy+0) : jr nz,.afficherMotEnPlace

.rienTrouve
; reset du HUD, des buffers
ld hl,referencePattern : ld de,currentPattern : ld bc,MAX_PATTERN : ldir
ld hl,workPattern : ld de,workPattern+1 : ld (hl),0 : ld bc,MAX_PATTERN-1 : ldir
ld hl,workPattern : ld (workPosition),hl
; reset affichage
jp refreshChoices


;*************************************************************
                         aideAuJoueur
;*************************************************************
ld ix,(lexiCurrentLevel) : ld d,0 : ld a,(nbChoices) : ld e,a : inc e : add ix,de ; IX=debut des mots
ld iy,tailleEntrees
xor a : exa
.reLoop
ld a,0 : niveauAide=$-1
cp (iy+0) : jr nc,.nextWord
; le mot a venir n'est pas trop court
add xl : ld xl,a : ld a,xh : adc 0 : ld xh,a : ld hl,posEntrees : exa : ld c,a : exa : ld b,0 : add hl,bc : add hl,bc : ld e,(hl) : inc hl : ld d,(hl)
ld h,0 : ld a,(niveauAide) : ld l,a : add hl,hl : add hl,hl : add hl,de : ex hl,de ; DE=position de la lettre
ld a,(ix+0) : call displayCharCellAt
.nextWord
ld a,POINT_VIRGULE : cp (ix+0) : jr z,.finAide
ld a,VIRGULE : cp (ix+0) : jr z,.nextNext
inc ix
jr .nextWord
.nextNext
inc ix
exa : inc a : exa ; increment word index
inc iy
jr .reLoop

.finAide
ld a,(niveauAide)
inc a
ld (niveauAide),a
ld c,a : ld a,(longueurMax) : cp c
jp z,niveauSuivant
; desactiver les mots aussi longs que l'aide : C
ld hl,tailleEntrees : ld b,21
.disableEntries ld a,(hl) : cp c : jr nz,.disableNext : ld (hl),0 : .disableNext inc hl : djnz .disableEntries
call refreshChoices
ret

;*************************************************************
			  initBoard
;*************************************************************
call razScr

ld hl,referencePattern : ld de,currentPattern : ld bc,MAX_PATTERN : ldir
ld hl,workPattern : ld de,workPattern+1 : ld (hl),0 : ld bc,MAX_PATTERN-1 : ldir
ld hl,workPattern : ld (workPosition),hl

ld iy,tailleEntrees
ld ix,charLine
ld de,posEntrees
ld a,(nombreMots) : cp 11 : jp c,.dixOuMoins
;=====================================================
; deux colonnes!
;=====================================================
.deuxColonnes
ld a,32 : ld (leCentre),a ; defaut
ld a,(nombreMots) : srl a : ld (hauteurColonne),a
dec a ; connaitre la longueur du dernier mot de la première colonne
push iy : pop hl : add l : ld l,a : ld a,h : adc 0 : ld h,a : ld a,(hl) : ld (longueurColonneGauche),a
ld a,(hauteurColonne) : add a : dec a : push iy : pop hl : add l : ld l,a : ld a,h : adc 0 : ld h,a : ld a,(hl) : ld (longueurColonneDroite),a

ld hl,longueurColonneGauche : sub (hl) : jp z,.MaxCentre ; colonnes de même largeur
ld b,a : ld a,32 : sub b : sub b : ld (leCentre),a

.MaxCentre
; centrage vertical
ld a,(nombreMots) : and 1 : ld b,a
ld a,(hauteurColonne) : add b ; hauteur totale
ld b,a : ld a,11 : sub b : srl a : jr z,.doubleDix
.doubleCentre inc ix : inc ix : dec a : jr nz,.doubleCentre
.doubleDix
push ix ; la deuxième colonne repartira de la même position Y
ld a,(hauteurColonne)
.doubleLoopGauche
; ajuster la position en fonction de la longueur
exa
ld a,(iy+0) : inc iy : add a : add a : ld c,a : ld a,(leCentre) : sub c
ld hl,(ix+0) : inc ix : inc ix : add l : ld l,a : ex hl,de : ld (hl),e : inc l : ld (hl),d : inc hl : ex hl,de
exa : dec a : jr nz,.doubleLoopGauche

.doDroite
ld a,(longueurColonneDroite) : cp 8 : ld a,(leCentre) : jr c,.add2
cp 32 : jr z,.auCentre
.add2
add 2 : ld (leCentre),a ; petit espace
.auCentre
pop ix
ld a,(hauteurColonne)
.doubleLoopDroite
exa
ld a,(leCentre) : inc iy ; on doit sauter dans les longueurs même si on ne s'en sert pas ici...
ld hl,(ix+0) : inc ix : inc ix : add l : ld l,a : ex hl,de : ld (hl),e : inc l : ld (hl),d : inc hl : ex hl,de
exa : dec a : jr nz,.doubleLoopdroite
; reste-il une dernière case? factocode
jp .dixPile

;=====================================================
; une seule colonne
;=====================================================
.dixOuMoins ; centrer dans les deux axes!
ld b,a : ld a,11 : sub b : srl a : jr z,.dixPile
.dixCentre inc ix : inc ix : dec a : jr nz,.dixCentre
.dixPile
; ajuster la position en fonction de la longueur
ld a,(iy+0) : inc iy : or a : jr z,.endPosColonnes : sub 3 : add a : ld c,a : ld a,26 : sub c
ld hl,(ix+0) : inc ix : inc ix : add l : ld l,a : ex hl,de : ld (hl),e : inc l : ld (hl),d : inc hl : ex hl,de
jr .dixPile
.endPosColonnes

;--------------------------
; afficher les cases vides
;--------------------------
ld ix,posEntrees
ld iy,tailleEntrees
.afficheMap
ld a,(iy+0) : or a : jr z,.mapOK : inc iy
ld de,(ix+0) : inc ix : inc ix : ld b,a
.afficheSubMap ld a,0 : push bc,de : call displayCharCellAt : pop de,bc : ld hl,4 : add hl,de : ex hl,de : djnz .afficheSubMap
jr .afficheMap

.mapOK
call refreshChoices ; update
ret

leCentre defb 0
hauteurColonne defb 0
longueurColonneGauche defb 0
longueurColonneDroite defb 0


;*************************************************************
                        refreshChoices
;*************************************************************
ld hl,(KeyF1char) : ld a,(hl) : cp #FF : jr z,.skipF1 : ld de,KeyF1addr : call displayCharCellAt : .skipF1
ld hl,(KeyF2char) : ld a,(hl) : cp #FF : jr z,.skipF2 : ld de,KeyF2addr : call displayCharCellAt : .skipF2
ld hl,(KeyF3char) : ld a,(hl) : cp #FF : jr z,.skipF3 : ld de,KeyF3addr : call displayCharCellAt : .skipF3
ld hl,(KeyF4char) : ld a,(hl) : cp #FF : jr z,.skipF4 : ld de,KeyF4addr : call displayCharCellAt : .skipF4
ld hl,(KeyF5char) : ld a,(hl) : cp #FF : jr z,.skipF5 : ld de,KeyF5addr : call displayCharCellAt : .skipF5
ld hl,(KeyF6char) : ld a,(hl) : cp #FF : jr z,.skipF6 : ld de,KeyF6addr : call displayCharCellAt : .skipF6
ld hl,(KeyF7char) : ld a,(hl) : cp #FF : jr z,.skipF7 : ld de,KeyF7addr : call displayCharCellAt : .skipF7
ld hl,(KeyF8char) : ld a,(hl) : cp #FF : jr z,.skipF8 : ld de,KeyF8addr : call displayCharCellAt : .skipF8
ld hl,(KeyF9char) : ld a,(hl) : cp #FF : jr z,.skipF9 : ld de,KeyF9addr : call displayCharCellAt : .skipF9

ld ix,hud1addr : ld a,(longueurMax)
ld iy,workPattern
.displayHUD
exa : ld de,(ix+0) : inc ix : inc ix : ld a,(iy+0) : inc iy : call displayCharCellAt : exa
dec a : jr nz,.displayHUD
.waitKeyboard
call scankeyboard
ld hl,keyboardmap : xor a : ld b,10
.testeAll or (hl) : inc hl : djnz .testeAll
or a : jr nz,.waitKeyboard
ret

;*************************************************************
                          waitInput
;*************************************************************


testChoice ; valider l'input, eventuellement afficher le mot trouve, reset l'affichage du board de saisie

KeyF1char defw 0
KeyF2char defw 0
KeyF3char defw 0
KeyF4char defw 0
KeyF5char defw 0
KeyF6char defw 0
KeyF7char defw 0
KeyF8char defw 0
KeyF9char defw 0


nbChoices   defb 0
longueurMax defb 0
nombreMots  defb 0

align 2 : buildChoiceList defw 0,0,0,buildChoice3,buildChoice4,buildChoice5,buildChoice6,buildChoice7,buildChoice8,buildChoice9

; toutes les cases inactivées par défaut
resetBuild
ld hl,dummy : ld (KeyF9char),hl : ld (KeyF1char),hl : ld (KeyF2char),hl : ld (KeyF3char),hl : ld (KeyF4char),hl : ld (KeyF6char),hl : ld (KeyF7char),hl : ld (KeyF8char),hl : ld (KeyF5char),hl
ld hl,hud1addr : ld de,hud1addr+1 : ld (hl),0 : ld bc,MAX_PATTERN*2-1 : ldir
ret

buildChoice3 call resetBuild : ld hl,currentPattern : ld (KeyF8char),hl : inc hl : ld (KeyF3char),hl : inc hl : ld (KeyF1char),hl : jp retourInitChoice
buildChoice4 call resetBuild : ld hl,currentPattern : ld (KeyF9char),hl : inc hl : ld (KeyF7char),hl : inc hl : ld (KeyF3char),hl : inc hl : ld (KeyF1char),hl : jp retourInitChoice
buildChoice5 call resetBuild : ld hl,currentPattern : ld (KeyF9char),hl : inc hl : ld (KeyF7char),hl : inc hl : ld (KeyF3char),hl : inc hl : ld (KeyF1char),hl : inc hl : ld (KeyF5char),hl : jp retourInitChoice
buildChoice6 call resetBuild : ld hl,currentPattern : ld (KeyF9char),hl : inc hl : ld (KeyF7char),hl : inc hl : ld (KeyF3char),hl : inc hl : ld (KeyF1char),hl : inc hl : ld (KeyF8char),hl : inc hl : ld (KeyF2char),hl : jp retourInitChoice
buildChoice7 call resetBuild : ld hl,currentPattern : ld (KeyF9char),hl : inc hl : ld (KeyF7char),hl : inc hl : ld (KeyF3char),hl : inc hl : ld (KeyF1char),hl : inc hl : ld (KeyF8char),hl : inc hl : ld (KeyF2char),hl : inc hl : ld (KeyF5char),hl : inc hl : jp retourInitChoice
buildChoice8 call resetBuild : ld hl,currentPattern : ld (KeyF9char),hl : inc hl : ld (KeyF7char),hl : inc hl : ld (KeyF3char),hl : inc hl : ld (KeyF1char),hl : inc hl : ld (KeyF8char),hl : inc hl : ld (KeyF2char),hl : inc hl : ld (KeyF4char),hl : inc hl : ld (KeyF6char),hl : jp retourInitChoice
buildChoice9 call resetBuild : ld hl,currentPattern : ld (KeyF9char),hl : inc hl : ld (KeyF7char),hl : inc hl : ld (KeyF3char),hl : inc hl : ld (KeyF1char),hl : inc hl : ld (KeyF8char),hl : inc hl : ld (KeyF2char),hl : inc hl : ld (KeyF4char),hl : inc hl : ld (KeyF6char),hl : inc hl : ld (KeyF5char),hl : jp retourInitChoice


referencePattern defs MAX_PATTERN     ; 8 lettres max => statique pendant le niveau
currentPattern   defs MAX_PATTERN     ; 8 lettres max => lettres disponibles qui disparaissent
workPattern      defs MAX_PATTERN+1,0 ; 8 lettres max => lettres qui apparaissent au fur et à mesure de la saisie et sont amenées à être comparées
workPosition     defw workPattern     ; nextChar position
dummy            defb #FF
dummySpace       defb 0

hud1addr defw 0
hud2addr defw 0
hud3addr defw 0
hud4addr defw 0
hud5addr defw 0
hud6addr defw 0
hud7addr defw 0
hud8addr defw 0
hud9addr defw 0

align 2
tailleEntrees defs 22,0 ; +extra-zero
posEntrees defs 42

charset ' ',0
repeat 26,x,0
charset x+'a',x+1
charset x+'A',x+1
rend
charset ',',VIRGULE
charset ';',POINT_VIRGULE
charset '|',PIPE

str_init01    defb 'use  numeric  keypad  to create',ENDMARK
str_init02    defb 'your   word   and   use   space',ENDMARK
str_init03    defb 'to validate a shorter word',ENDMARK

str_init04    defb 'esc            go to next level',ENDMARK
str_init05    defb 'tab      skip current challenge',ENDMARK
str_init06    defb 'h          display some letters',ENDMARK

str_init07    defb 'words can be conjugated verbs or',ENDMARK
str_init08    defb 'abbreviations  as  well  as city',ENDMARK
str_init09    defb 'names',ENDMARK

str_init10    defb '  ',ENDMARK
str_init11    defb '         press any key',ENDMARK
str_init12    defb '                                ',ENDMARK

str_level1    defb 'first level',ENDMARK
str_level2    defb 'second level',ENDMARK
str_level3    defb 'third level',ENDMARK
str_level4    defb 'fourth level',ENDMARK
str_level5    defb 'fifth level',ENDMARK
str_level6    defb 'sixth level',ENDMARK
str_level7    defb 'seventh level',ENDMARK
str_level8    defb 'eighth level',ENDMARK
str_level9    defb 'ninth level',ENDMARK
str_level10   defb 'tenth level',ENDMARK

bravoList defw .init
.init
defw $+4,str_bravo01
defw $+4,str_bravo02
defw $+4,str_bravo03
defw $+4,str_bravo04
defw $+4,str_bravo05
defw $+4,str_bravo06
defw $+4,str_bravo07
defw $+4,str_bravo08
defw $+4,str_bravo09
defw $+4,str_bravo10
defw $+4,str_bravo11
defw $+4,str_bravo12
defw $+4,str_bravo13
defw $+4,str_bravo14
defw $+4,str_bravo15
defw .init,str_bravo16

str_bravo01   defb '     well done     ',ENDMARK
str_bravo02   defb '     good job',ENDMARK
str_bravo03   defb '  excellent work',ENDMARK
str_bravo04   defb '  you are awesome',ENDMARK
str_bravo05   defb '  congratulations',ENDMARK
str_bravo06   defb '     next step',ENDMARK
str_bravo07   defb '   piece of cake',ENDMARK
str_bravo08   defb '     too easy',ENDMARK
str_bravo09   defb '       gg',ENDMARK
str_bravo10   defb 'struggling the game',ENDMARK
str_bravo11   defb '  what a champion',ENDMARK
str_bravo12   defb '    easy peasy',ENDMARK
str_bravo13   defb 'you are invincible',ENDMARK
str_bravo14   defb 'perfect without trying',ENDMARK
str_bravo15   defb 'wow you re killing it',ENDMARK
str_bravo16   defb '   take it easy',ENDMARK

str_win01 defb 'i think you finish the game   ',ENDMARK

;*****************************************
;  single char not indexed the same way
;*****************************************
cell_motsEnFete defb 'lexi forge',ENDMARK






; for displaying single char...
repeat 26,x,0
charset x+'a',(x+1)*2
charset x+'A',(x+1)*2
rend

;*******************************
            levelUP
;*******************************
ld ix,.levelADR
ld de,(lexiCurrentLevel)
.trouveLevel
ld hl,(ix+0) : ld a,h : or l : jp z,#100
sbc hl,de : jr z,.onVeutLeSuivant : jr nc,.isNext : .onVeutLeSuivant
inc ix : inc ix
jr .trouveLevel
.isNext
ld hl,(ix+0) : ld (lexiCurrentLevel),hl
ld b,100 : halt : djnz $
jp initGame

.levelADR
defw lexiLevel1
defw lexiLevel2
defw lexiLevel3
defw lexiLevel4
defw lexiLevel5
defw lexiLevel6
defw lexiLevel7
defw lexiLevel8
defw lexiLevel9
defw lexiLevel10
defw 0

.levelSTR
defw str_level1
defw str_level2
defw str_level3
defw str_level4
defw str_level5
defw str_level6
defw str_level7
defw str_level8
defw str_level9
defw str_level10

lexiCurrentLevel defw lexiLevel1 ; prévoir un reset?

lexiLevel1
defb 'ACT,ACT,CAT,TAC;'
defb 'ADN,AND,DAN,NAD;'
defb 'AER,ARE,EAR,ERA;'
defb 'AET,ATE,EAT,TEA;'
defb 'AHS,ASH,HAS;'
defb 'ALP,ALP,LAP,PAL;'
defb 'ALS,ALS,LAS,SAL;'
defb 'AMR,ARM,MAR,RAM;'
defb 'AMY,AMY,MAY,MYA,YAM;'
defb 'ANT,ANT,NAT,TAN;'
defb 'APS,ASP,PAS,SAP,SPA;'
defb 'APT,APT,PAT,TAP;'
defb 'ART,ART,RAT,TAR;'
defb 'ASW,SAW,SWA,WAS;'
defb 'BEY,BEY,BYE,YBE;'
defb 'COR,COR,ORC,ROC;'
defb 'DEL,DEL,ELD,LED;'
defb 'DOR,DOR,ORD,ROD;'
defb 'EEK,EEK,EKE,KEE;'
defb 'EIR,IRE,REI,RIE;'
defb 'ELY,LEY,LYE,YLE;'
defb 'ENR,ERN,NER,REN;'
defb 'ENY,NEY,NYE,YEN;'
defb 'EOS,EOS,OES,SOE;'
defb 'ERY,ERY,EYR,RYE,YER;'
defb 'ESY,SEY,SYE,YES;'
defb 'ETW,EWT,TEW,WET;'
defb 'EWY,WEY,WYE,YEW;'
defb 'FOR,FOR,FRO,ORF;'
defb 'IKN,INK,KIN;'
defb 'LOW,LOW,OWL,WOL;'
defb 'NOW,NOW,OWN,WON;'
defb 'NOY,NOY,ONY,YON;'
defb 'NRU,NUR,RUN,URN;'
defb 'ORT,ORT,ROT,TOR;'
defb 'OTW,TOW,TWO,WOT;'



lexiLevel2
defb 'ABCN,BAC,BAN,CAB,CAN,NAB,BANC;'
defb 'ABCR,ARC,BAC,BAR,CAB,CAR,RAB,CRAB;'
defb 'ABCT,ACT,BAC,BAT,CAB,CAT,TAB,TAC;'
defb 'ABDE,BAD,BED,DAB,ABED,BADE,BEAD;'
defb 'ABEN,BAN,BEN,EAN,NAB,NEB,BANE,BEAN;'
defb 'ABET,ATE,BAT,BET,EAT,TAB,TEA,ABET,BATE,BEAT;'
defb 'ABGN,BAG,BAN,GAB,GAN,NAB,NAG,BANG;'
defb 'ABGR,BAG,BAR,GAB,GAR,RAB,RAG,BRAG,GARB,GRAB;'
defb 'ABNR,BAN,BAR,NAB,RAB,RAN,BARN,BRAN;'
defb 'ACEL,ACE,ALE,CAL,LAC,LEA,LACE;'
defb 'ACEM,ACE,CAM,MAC,ACME,CAME,MACE;'
defb 'ACEP,ACE,APE,CAP,PAC,PEA,CAPE,PACE;'
defb 'ACER,ACE,ARC,ARE,CAR,EAR,ERA,ACRE,CARE,RACE;'
defb 'ACET,ACE,ACT,ATE,CAT,EAT,TAC,TEA,CATE,TACE;'
defb 'ACHS,ACH,ASH,HAS,HAS,SAC,CASH;'
defb 'ACLW,AWL,CAL,CAW,LAC,LAW,CLAW;'
defb 'ACMP,CAM,CAP,MAC,MAP,PAC,PAM,CAMP;'
defb 'ADEL,ALE,DAL,DEL,ELD,LAD,LEA,LED,DALE,DEAL,LADE,LEAD;'
defb 'ADEN,AND,DAN,DEN,EAN,END,NAD,DANE,DEAN;'
defb 'ADER,ARE,EAR,ERA,ERD,RAD,RED,DARE,DEAR,RADE,READ;'
defb 'ADGN,AND,DAG,DAN,GAD,GAN,NAD,NAG,DANG;'
defb 'ADEW,AWE,DAW,DEW,WAD,WAE,WED,AWED,DAWE,WADE;'
defb 'ADIR,AID,AIR,RAD,RID,ARID,RAID;'
defb 'ADNR,AND,DAN,NAD,RAD,RAN,DARN,NARD,RAND;'
defb 'ADOR,ADO,DOR,OAD,OAR,ORA,ORD,RAD,ROD,ROAD;'
defb 'ADOS,ADO,OAD,ODS,SAD,SAO,SOD,SODA;'
defb 'ADOT,ADO,DOT,OAD,OAT,TOD,DOAT,TOAD;'
defb 'ADRY,DAY,DRY,RAD,RAY,ADRY,DRAY,YARD;'
defb 'AEFL,ALE,ELF,LEA,FEAL,FLEA,LEAF;'
defb 'AEFN,EAN,FAN,FEN,NEF,FANE,NEAF;'
defb 'AEFR,ARE,EAR,ERA,ERF,FAR,FER,FRA,AFER,FARE,FEAR;'
defb 'AEFT,AFT,ATE,EAT,EFT,FAT,FET,TEA,FATE,FEAT;'
defb 'AEGP,AGE,APE,GAP,PEA,PEG,GAPE,PAGE;'
defb 'AEGS,AGE,GAS,SAG,SEA,SEG,SAGE;'
defb 'AELM,ALE,ELM,LAM,LEA,ALME,AMEL,LAME,LEAM,MALE,MEAL;'
defb 'AELS,ALE,ALS,LAS,LEA,LES,SAL,SEA,SLE,SALE,SEAL;'
defb 'AEMS,SAM,SEA,MASE,MESA,SAME,SEAM;'
defb 'AEMT,ATE,EAT,MAT,MET,TEA,MATE,MEAT,TAME,TEAM;'
defb 'AGHS,ASH,GAS,HAG,HAS,HAS,SAG,GASH,SHAG;'
defb 'AHNT,ANT,HAN,HAT,NAT,TAN,NATH,THAN;'
defb 'AHSW,ASH,HAS,HAS,HAW,SAW,SWA,WAH,WAS,SHAW,WASH;'
defb 'AISV,AIS,SAI,VAS,VIA,VIS,AVIS,SIVA,VISA;'
defb 'AKNR,ARK,KAN,KRA,RAN,KARN,KNAR,RANK;'
defb 'ALMP,ALP,LAM,LAP,MAP,PAL,PAM,LAMP,PALM;'
defb 'ALMS,ALS,LAM,LAS,SAL,SAM,ALMS,SALM,SLAM;'
defb 'ALPS,ALP,ALS,ASP,LAP,LAS,PAL,PAS,SAL,SAP,SPA,SALP,SLAP;'
defb 'ANTU,ANT,NAT,NUT,TAN,TAU,TUN,AUNT,TUNA;'
defb 'APSW,ASP,PAS,PAW,SAP,SAW,SPA,SWA,WAP,WAS,SPAW,SWAP,WASP;'
defb 'ARST,ART,RAS,RAT,SAT,TAR,TAS,SART,STAR,TSAR;'
defb 'BDEN,BED,BEN,DEN,END,NEB,BEND;'
defb 'BNRU,BUN,BUR,NUB,NUR,RUB,RUN,URN,BRUN,BURN;'
defb 'DEIL,DEL,DIE,ELD,IDE,ILE,LED,LID,LIE,DEIL,EILD,IDLE,LIED;'
defb 'DEIT,DIE,DIT,IDE,TED,TID,TIE,DIET,DITE,EDIT,TIDE,TIED;'
defb 'DIKN,DIN,IND,INK,KID,KIN,KIN,DINK,KIND;'
defb 'DOPR,DOP,DOR,ORD,POD,PRO,ROD,DORP,DROP,PROD;'
defb 'EFIL,ELF,FIE,FIL,ILE,LIE,LIF,FILE,LIEF,LIFE;'
defb 'EIST,EST,IES,ITS,SET,SIT,TIE,SITE,TIES;'
defb 'EORT,ORE,ORT,RET,ROE,ROT,TOE,TOR,ROTE,TORE;'
defb 'ERSU,ERS,RES,RUE,SUE,URE,USE,RUSE,SUER,SURE,USER;'
defb 'LOST,LOS,LOT,OST,SOL,SOT,TOL,LOST,SLOT;'
defb 'NORT,NOR,NOT,ORN,ORT,ROT,TON,TOR,RONT,TORN,TRON;'
defb 'NOTW,NOT,NOW,OWN,TON,TOW,TWO,WON,WOT,NOWT,TOWN,WONT;'
defb 'ORTY,ORT,ROT,ROY,TOR,TOY,TRY,YOT,ROTY,RYOT,TORY,TROY,TYRO;'
lexiLevel3
defb 'AEPT,APE,APT,ATE,EAT,PAT,PEA,PET,TAP,TEA,PATE,PEAT,TAPE;'
defb 'AERS,ARE,EAR,ERA,ERS,RAS,RES,SEA,ARSE,ERAS,RASE,SEAR;'
defb 'AERY,ARE,AYE,EAR,ERA,ERY,EYR,RAY,RYE,YEA,YER,AERY,EYRA,YARE,YEAR;'
defb 'AERT,ARE,ART,ATE,EAR,EAT,ERA,RAT,RET,TAR,TEA,ARET,RATE,TARE,TEAR;'
defb 'AEGR,AGE,ARE,EAR,ERA,ERG,GAR,GRE,RAG,AGRE,GARE,GEAR,RAGE;'
defb 'AERW,ARE,AWE,EAR,ERA,RAW,REW,WAE,WAR,AREW,WARE,WEAR;'
defb 'AELP,ALE,ALP,APE,LAP,LEA,LEP,PAL,PEA,LEAP,PALE,PEAL,PELA,PLEA;'
defb 'AELT,ALE,ALT,ATE,EAT,LAT,LEA,LET,TEA,LATE,LEAT,TAEL,TALE,TEAL;'
defb 'AENT,ANT,ATE,EAN,EAT,NAT,NET,TAN,TEA,TEN,ANET,ANTE,ETNA,NEAT,TAEN;'
defb 'AEPR,APE,ARE,EAR,ERA,PAR,PEA,PER,RAP,REP,APER,PARE,PEAR,RAPE,REAP;'
defb 'AERT,ARE,ART,ATE,EAR,EAT,ERA,RAT,RET,TAR,TEA,ARET,RATE,TARE,TEAR;'
defb 'AERY,ARE,AYE,EAR,ERA,ERY,EYR,RAY,RYE,YEA,YER,AERY,EYRA,YARE,YEAR;'
defb 'EIPR,IRE,IRP,PER,PIE,REI,REP,RIE,RIP,IRPE,PERI,PIER,PRIE,RIPE;'
defb 'ENRY,ERN,ERY,EYR,NER,NEY,NYE,REN,RYE,YEN,YER,REYN,YERN,YREN;'


lexiLevel4
defb 'ABELM,ABLE,ALBE,ALME,AMEL,BALE,BALM,BEAL,BEAM,BEMA,BLAE,BLEA,LAMB,LAME,LEAM,MALE,MEAL,AMBLE,BELAM,BLAME;'
defb 'ABELT,ABET,ABLE,ALBE,BALE,BATE,BEAL,BEAT,BELT,BLAE,BLAT,BLEA,BLET,LATE,LEAT,TAEL,TALE,TEAL,ABLET,BLEAT,TABLE;'
defb 'ACDER,ACRE,CADE,CARD,CARE,DACE,DARE,DEAR,RACE,RADE,READ,ACRED,CADER,CADRE,CARED,CEDAR,RACED;'
defb 'ACEHR,ACHE,ACRE,ARCH,CARE,CHAR,EACH,HARE,HEAR,RACE,RACH,RHEA,CHARE,CHEAR,RACHE,REACH;'
defb 'ACELN,ACNE,CANE,CLAN,ELAN,LACE,LANE,LEAN,LENA,NALE,NEAL,ANCLE,CLEAN,LANCE;'
defb 'ACELP,CAPE,CLAP,LACE,LEAP,PACE,PALE,PEAL,PELA,PLEA,CAPEL,CAPLE,CLAPE,PLACE;'
defb 'ACERT,ACRE,ARET,CARE,CART,CATE,RACE,RATE,TACE,TARE,TEAR,CARET,CARTE,CATER,CRATE,CREAT,REACT,TRACE;'
defb 'ADEIM,AMID,DAME,DEMI,DIME,IDEA,IDEM,MADE,MAID,MEAD,MIDA,AIMED,AMIDE,MEDIA;'
defb 'ADERY,ADRY,AERY,DARE,DEAR,DRAY,DREY,DYER,EYRA,RADE,READ,YARD,YARE,YEAD,YEAR,YERD,DEARY,DERAY,RAYED,READY;'
defb 'ADEMR,DAME,DARE,DEAR,DERM,DRAM,MADE,MARE,MEAD,MEAR,MERD,RADE,READ,REAM,ARMED,DERMA,DREAM,RAMED;'
defb 'AEGLR,AGRE,EARL,EGAL,GAEL,GALE,GARE,GEAL,GEAR,LARE,LEAR,RAGE,RALE,REAL,GLARE,LAGER,LARGE,REGAL;'
defb 'AEGNR,AGEN,AGRE,EARN,GANE,GARE,GEAN,GEAR,GENA,GERN,GNAR,NARE,NEAR,RAGE,RANG,RENG,ANGER,ARENG,GRANE,RANGE;'
defb 'AEKST,EAST,KATE,KEST,SAKE,SATE,SEAK,SEAT,SETA,TAKE,TASK,TEAK,SKATE,STAKE,STEAK;'
defb 'AELNP,ELAN,LANE,LEAN,LEAP,LENA,NALE,NAPE,NEAL,NEAP,NEPA,PALE,PANE,PEAL,PEAN,PELA,PLAN,PLEA,ALPEN,PANEL,PENAL,PLANE;'
defb 'AELRY,AERY,AYLE,EARL,EYRA,LARE,LARY,LEAR,LYRA,LYRE,RALE,REAL,RELY,RYAL,YARE,YEAR,EARLY,LAYER,RELAY;'
defb 'AELST,EAST,LAST,LATE,LEAT,LEST,SALE,SALT,SALT,SATE,SEAL,SEAT,SETA,SLAT,STAL,TAEL,TALE,TEAL,ASTEL,LASTE,LATES,LEAST;'
defb 'AEMRT,ARET,MARE,MART,MATE,MEAR,MEAT,RATE,REAM,TAME,TARE,TEAM,TEAR,TERM,TRAM,ARMET,MATER,TAMER,TERMA;'
defb 'AENPS,ANES,APSE,NAPE,NEAP,NEPA,PANE,PEAN,PEAS,PENS,SANE,SEAN,SNAP,SPAE,SPAN,ASPEN,SNAPE,SNEAP,SPANE;'
defb 'AEPRS,APER,APSE,ARSE,ERAS,PARE,PEAR,PEAS,PERS,RAPE,RASE,RASP,REAP,SEAR,SPAE,SPAR,SPER,ASPER,PARSE,PRASE,SPARE,SPEAR;'
defb 'AESTW,EAST,SATE,SEAT,SETA,STAW,STEW,SWAT,TAWS,WASE,WAST,WEST,SWATE,SWEAT,WASTE;'
defb 'AGNOR,AGON,ARGO,GNAR,GOAR,RANG,ROAN,RONG,ANGOR,ARGON,GROAN,NAGOR,ORANG,ORGAN;'
defb 'AILMS,ALMS,LIAS,LIMA,MAIL,MIAS,SAIL,SAIM,SALM,SIMA,SLAM,SLIM,ISLAM,LAISM,SALMI;'
defb 'AINRT,ANTI,IRAN,NART,RAIN,RANI,RANT,TAIN,TARN,TIAR,RIANT,TAIRN,TARIN,TRAIN;'
defb 'APRST,PART,PAST,RAPT,RASP,SART,SPAR,SPAT,STAR,TRAP,TSAR,SPRAT,STRAP,TRAPS;'
defb 'BEIRT,BIER,BIRT,BITE,BRET,BRIT,ITER,REIT,RITE,TIER,TIRE,BITER,BRITE,TRIBE;'
defb 'DEILS,DEIL,DEIS,DIES,EILD,IDES,IDLE,ISLE,LIED,SEID,SELD,SIDE,SILE,SLED,SLID,SIDLE,SLEID,SLIDE;'
defb 'DEILT,DEIL,DIET,DITE,EDIT,EILD,IDLE,LIED,LITE,TEIL,TIDE,TIED,TILE,DELIT,TILDE,TILED;'
defb 'EFILR,FILE,FIRE,LIEF,LIER,LIFE,LIRE,REIF,RIEF,RIFE,RILE,FILER,FLIER,RIFLE;'
defb 'EHOST,HEST,HOSE,HOST,HOTE,SHET,SHOE,SHOT,SOTE,TOSE,TOSH,SHOTE,SOTHE,THOSE;'
defb 'ENOST,NEST,NOES,NOSE,NOST,NOTE,ONES,SENT,SNET,SNOT,SOTE,TONE,TOSE,ONSET,SETON,STONE;'


lexiLevel5
defb 'AABBEL,ABBA,ABBE,ABLE,ALAE,ALBE,BAAL,BABA,BABE,BALE,BEAL,BLAB,BLAE,BLEA,BLEB,BABEL;'
defb 'AABCIR,ARAB,ARIA,CRAB,CRIB,RACA,RAIA,ABACI,ACARI,BARIA,BARIC,CARIB,ARABIC;'
defb 'AABCLS,ALAS,BAAL,BAAS,CAAS,LAAS,SCAB,SLAB,BALSA,BASAL,CABAL,CABAS,CASAL,SABAL,SCALA;'
defb 'AABDEL,ABED,ABLE,ALAE,ALBE,BAAL,BADE,BALD,BALE,BEAD,BEAL,BLAE,BLEA,BLED,DALE,DEAL,LADE,LEAD,ABDAL,BALED,BLADE;'
defb 'AABDRY,ABAY,ADAR,ADRY,ARAB,BARD,BAYA,BRAD,BRAY,DRAB,DRAY,YARD,ABRAY,ARABY,BAYAD,BYARD,DARBY,BAYARD;'
defb 'AABLST,ALAS,BAAL,BAAS,BAST,BLAT,LAAS,LAST,SALT,SALT,SLAB,SLAT,STAB,STAL,TAAS,ATLAS,BALSA,BASAL,BASTA,BLAST,SABAL,BASALT;'
defb 'AACENR,ACNE,ACRE,AREA,ARNA,CANE,CARE,CRAN,EARN,NARE,NEAR,RACA,RACE,RANA,ANEAR,ARACE,ARECA,ARENA,CRANE,NACRE,RANCE,ARCANE;'
defb 'AACLRS,ALAR,ALAS,CAAS,CARL,LAAS,LARS,RACA,SCAR,CASAL,SACAR,SACRA,SCALA,LASCAR,RASCAL,SACRAL,SARLAC,SCALAR;'
defb 'AADEGM,ADAM,AGED,DAME,EGAD,GADE,GAME,MAAD,MADE,MAGE,MEAD,MEGA,ADAGE,GAMED,MADGE,DAMAGE;'
defb 'AADHRS,ADAR,DASH,HAAR,HARD,RASH,SADH,SADR,SARD,SHAD,HARDS,RAASH,SAADH,SHARD,HASARD;'
defb 'AABCEHR,ABEAR,ACERB,ARACE,ARECA,BAHAR,BEACH,BRACE,BRACH,CABER,CHARA,CHARE,CHEAR,RACHE,REACH,BREACH;'
defb 'AABCEMR,ABEAM,ABEAR,ACERB,AMBER,ARACE,ARECA,BRACE,BRAMA,BRAME,BREAM,CABER,CREAM,EMBAR,MACER,CAMBER,CAMERA;'
defb 'AABEHRT,ABATE,ABEAR,BAHAR,BARTH,BATHE,BEATH,BERTH,EARTH,HATER,HEART,RABAT,RATHE,REATA,TABER,ABATER,BATHER,BERTHA,BREATH,RABATE,TRABEA;'
defb 'AABELMR,ABEAM,ABEAR,ABLER,ALARM,AMBER,AMBLE,AREAL,BELAM,BLAME,BLARE,BLEAR,BRAMA,BRAME,BREAM,EARAL,EMBAR,LABRA,MALAR,RAMAL,REALM,AMBLER;'
defb 'AABELOR,ABEAR,ABLER,AREAL,BLARE,BLEAR,BLORE,BOLAR,BOREL,EARAL,LABOR,LABRA,LOBAR,ABORAL,ARABLE,AREOLA,BOREAL;'
defb 'AABELRV,ABEAR,ABLER,AREAL,ARVAL,AVALE,BLARE,BLEAR,BRAVE,EARAL,LABRA,LARVA,LARVE,LAVER,RAVEL,VELAR,ARABLE,LARVAE,VERBAL;'
defb 'AABEPRS,ABASE,ABEAR,AREAS,ASPER,BARSE,PARSE,PRASE,SABER,SABRE,SPARE,SPEAR,ABASER,ABRASE;'
defb 'AABGINR,AGAIN,AGRIN,ARIAN,BAIRN,BARIA,BRAIN,BRING,GRAIN,RIBAN,ARABIN,BAAING,BARING,BARGAIN;'
defb 'AABNOST,ASTON,BANAT,BASAN,BASON,BASTA,BASTO,BATON,BOAST,SABOT,SATAN,BASTON,SONATA;'
defb 'AACDIPR,ACARI,ACRID,ADRIP,APAID,APAIR,CAIRD,CAPRA,CARPI,DARIC,PAARD,PADAR,PICRA,RAPID,CAPRID,CARDIA,PICARD;'
defb 'AACEGRS,ARACE,AREAS,ARECA,ARGAS,CARSE,CRASE,GRACE,SACAR,SACRA,SACRE,SCARE,SCRAG,SEGAR,ACRASE,AGRACE,CAESAR;'
defb 'AACELMP,AMPLE,APACE,CAMEL,CAPEL,CAPLE,CLAMP,CLAPE,MACLE,MAPLE,PALEA,PELMA,PLACE,LECAMA,PALACE;'
defb 'AACERRV,ARACE,AREAR,ARECA,CARVE,CRARE,CRAVE,RACER,RAVER,VAREC,CARVER,CRAVER;'
defb 'AACFINR,ACARI,AFRIC,ARIAN,CAIRN,FACIA,FRANC,INFRA,ARNICA,CARINA,CRANIA,FARCIN,FARINA,NARICA,AFRICAN;'
defb 'AACGIRT,ACARI,ATRIA,CAGIT,CARAT,CIGAR,TAIRA,TIARA,TRICA,ACRITA,AGARIC,TRAGIC;'
defb 'AACHNRY,ARCHY,ARCHY,ARYAN,CHARA,CHARY,RANCH,RAYAH,ANARCH,CANARY,HYRCAN,ANARCHY;'
defb 'AACILSV,ALIAS,AVAIL,CASAL,CAVIL,LAVIC,SAIVA,SALIC,SCALA,SCLAV,SILVA,CLAVIS,SALIVA,SALVIA,SLAVIC;'
defb 'AACILTV,AVAIL,CAVIL,CITAL,ITALA,LAVIC,TICAL,VITAL,ALTAIC,ATAVIC,LAVATIC,VATICAL;'
defb 'AACIMNO,AMAIN,CONIA,MACAO,MAIAN,MANCA,MANIA,NOMIC,ANOMIA,CAIMAN,MANIAC,MANIOC;'
defb 'AADEHLS,AHEAD,HADES,HALED,HALSE,HEALD,LEASH,SAADH,SALAD,SELAH,SHADE,SHALE,SHEAL,SHELD,SLADE,HALSED,LASHED,SALADE;'
defb 'AADGNOR,ADORN,AGORA,ANGOR,ARGON,DAGON,GONAD,GRAND,GROAN,GROND,NAGOR,ORANG,ORGAN,ANGORA,ARANGO,ARGOAN,DRAGON,GARDON,GRANADO;'
defb 'AAEEHRT,EARTH,EATER,ETHER,HATER,HEART,HERTE,RATHE,REATA,RHEAE,THERE,THREE,AERATE,AETHER,HEATER,REHEAT;'
defb 'AAEEPST,PASTE,PATAS,PATEE,PEASE,SEPTA,SETAE,SPATE,SPEET,STEEP,TEASE,PESETA;'
defb 'AAEERRT,AREAR,ARERE,ARRET,EATER,RATER,REATA,TARRE,TERRA,AERATE,ERRATA,TEARER;'
defb 'AAEGIRV,AGAVE,AIGRE,GIVER,GRAVE,RAIAE,VIAGE,VIRGE,ARGIVE,GARVIE,GAVIAE,RAVAGE,RIVAGE;'
defb 'AAEGISV,AEGIS,AGAVE,AVISE,GIVES,SAIGA,SAIVA,SIAGA,SIEVA,VIAGE,GAVIAE,SAVAGE,VISAGE;'
defb 'AAEGLMN,ALGAE,ALMAN,ANGEL,ANGLE,GALEA,GLAMA,GLEAM,GLEAN,LAGAN,LEMAN,MANGE,AGLEAM,ALNAGE,GALENA,LAGENA,MANAGE,MANGLE;'
defb 'AAEIRRS,AIRER,AREAR,AREAS,ARIES,ARISE,ARRAS,ARRIS,RAIAE,RAISE,RISER,SERAI,ARAISE,RAISER,SIERRA;'
defb 'ABBEILN,ABLEN,ALIEN,ALINE,ANILE,BABEL,BIBLE,BINAL,BLAIN,ELAIN,LEBAN,LIANE,INABLE,LEBBAN,NIBBLE;'
defb 'ABBEILR,ABLER,ARIEL,BABEL,BIBLE,BLARE,BLEAR,BRAIL,BRIBE,LABRI,LIBER,LIBRA,RABBI,BAILER,BARBEL,BARBLE,BIBLER,LIBRAE,RABBLE;'
defb 'ABCEHLL,BEACH,BELCH,CABLE,CALLE,CELLA,CHELA,HABLE,LABEL,LACHE,LEACH,BLEACH;'
defb 'ABCEHNO,BACON,BANCO,BEACH,BENCH,BOHEA,BONCE,CANOE,ECHON,HANCE,OBEAH,OCEAN,BEACON;'
defb 'ABCEILV,ALIVE,ALVEI,AVILE,BLIVE,CABLE,CALVE,CAVIL,CLAVE,ILEAC,LAVIC,VIABLE;'
defb 'ABCEIMN,ABIME,AMICE,AMINE,ANIME,BENIM,CABIN,IMBAN,MAINE,MANIE,MINAE,MINCE,CABMEN,ICEMAN;'
defb 'ABCELRX,ABLER,ACERB,BLARE,BLEAR,BRACE,CABER,CABLE,CAREX,CLARE,CLEAR,RACLE,RELAX;'
defb 'ABCENRV,ACERB,BEARN,BRACE,BRAVE,CABER,CARVE,CRANE,CRAVE,NACRE,RANCE,RAVEN,VAREC,CARVEN,CAVERN,CRAVEN;'
defb 'ABCFINR,AFRIC,BAIRN,BARIC,BRAIN,CABIN,CAIRN,CARIB,FRANC,INFRA,RIBAN,FABRIC,FARCIN;'
defb 'ABCHIOR,ABHOR,BARIC,BICHO,BIRCH,BOIAR,BORIC,BRACH,CARIB,CAROB,CHAIR,CHOIR,COBIA,COBRA,ICHOR,ORACH,ORBIC,ROACH,BROACH;'
defb 'ABCHNOR,ABHOR,ACORN,BACON,BANCO,BARON,BRACH,CAROB,COBRA,ORACH,RANCH,ROACH,ANCHOR,ARCHON,BARCON,BRANCH,BROACH,CARBON,CHARON,CORBAN,RANCHO,CHARBON;'
defb 'ABCLORT,ABORT,ACTOR,BLOAT,BOCAL,BOLAR,BRACT,CAROB,CAROL,CLART,COBRA,CORAL,CROAT,LABOR,LOBAR,RABOT,ROTAL,TABOR,CARLOT,COBALT;'
defb 'ABDEEHR,AREED,BARDE,BARED,BEARD,BREAD,BREDE,BREED,DEARE,DEBAR,EARED,HEARD,RHEAE,ADHERE,BEHEAD,HEADER;'
defb 'ABDEERV,AREED,BARDE,BARED,BEARD,BEVER,BRAVE,BREAD,BREDE,BREED,BREVE,DEARE,DEAVE,DEBAR,DRAVE,EARED,EVADE,RAVED,REAVE,ADVERB,BEAVER,BRAVED;'
defb 'ABDEGLM,AMBLE,BADGE,BALED,BELAM,BEMAD,BLADE,BLAME,GABEL,GABLE,GAMED,GLADE,GLEAD,GLEAM,LAMED,MADGE,MEDAL,AMBLED,BEDLAM,BELDAM,BLAMED,GAMBLE;'
defb 'ABDEHLR,ABLER,ALDER,BALED,BARDE,BARED,BEARD,BLADE,BLARE,BLEAR,BREAD,DEBAR,HABLE,HALED,HARLE,HEALD,HEARD,BALDER,BLARED,HARELD,HERALD,HERBAL;'
defb 'ABDEOST,ABODE,ADOBE,BASED,BASTE,BASTO,BATED,BEAST,BESOT,BETSO,BOAST,SABOT,SATED,SEBAT,STADE,STEAD,TABES,ABDEST,BASTED,BESTAD,BOATED,BOASTED;'

lexiLevel6
defb 'ABEGIMN,ABIME,AMINE,ANIME,BEGAN,BEGIN,BEING,BENIM,BIGAM,GAMIN,IMAGE,IMBAN,MAINE,MANGE,MANIE,MINAE,MINGE,BAGMEN,BAIGNE,ENIGMA,BEAMING;'
defb 'ABEHIRS,ABIES,ARIES,ARISE,BARSE,BIRSE,BRASH,EARSH,HIRES,RAISE,RIBES,SABER,SABRE,SAHEB,SAHIB,SERAI,SHARE,SHEAR,SHIRE,BRAISE,RABIES,BEARISH;'
defb 'ABEHLNT,ABLEN,ABLET,ABNET,BATHE,BEATH,BLEAT,BLENT,ENTAL,ETHAL,HABLE,HATEL,LATHE,LEANT,LEBAN,TABLE,THANE,LABENT,THEBAN,THENAL,BENTHAL;'
defb 'ABEILSZ,ABIES,AISLE,BAIZE,BASIL,BLASE,BLAZE,EBLIS,SABLE,SALEB,SIZEL,SLAIE,BALIZE,ISABEL,SIZABLE;'
defb 'ABELLRU,ABLER,ALLER,ALURE,BLARE,BLEAR,BULLA,BUREL,LABEL,RUBLE,UREAL,ALLURE,BULLAE,LAUREL,RUBELLA,RULABLE;'
defb 'ABELMMR,ABLER,AMBER,AMBLE,BELAM,BLAME,BLARE,BLEAR,BRAME,BREAM,EMBAR,LEMMA,MELAM,REALM,AMBLER,BLAMER,EMBALM,MARBLE,RAMBLE,RAMMEL,MEMBRAL;'
defb 'ABELNTU,ABLEN,ABLET,ABNET,BLEAT,BLENT,BLUNT,ENTAL,LEANT,LEBAN,LUNET,TABLE,TUBAL,BATULE,BUTANE,LABENT,LUNATE,NEBULA,UNABLE,UNBEAT,UNBELT,ABLUENT;'
defb 'ABEMNSU,ABUSE,AMUSE,BEAUS,MANES,MANSE,MANUS,MUSAE,USNEA,ABSUME,UNSEAM,SUNBEAM;'
defb 'ABGINOT,BATON,BIGOT,GIANT,INGOT,NABIT,TONGA,BAGNIO,BATING,GABION,OBTAIN,BOATING;'
defb 'ABMORTU,ABORT,ABOUT,AMORT,AMOUR,BROMA,BRUTA,RABOT,RUMBO,TABOR,TRABU,TUMOR,TURBO,UMBRA,OUTBAR,RUBATO,TABOUR,TAMBOUR;'
defb 'ABNORTY,ABORT,ARNOT,ATONY,AYONT,BARON,BATON,BOYAR,BRANT,OTARY,RABOT,RANTY,RATON,RAYON,TABOR,TRONA,TYRAN,AROYNT,BARONY,BARTON,BOTANY,NOTARY;'
defb 'ABNRSTU,ARNUT,ASTUN,BRANT,BRAST,BRUNT,BRUTA,BURNT,BURSA,BURST,STARN,STURB,SUANT,SUTRA,TRABU,UNBAR,URBAN,USANT,ABURST,SATURN,TURBAN;'
defb 'ABOPRST,ABORT,APORT,BASTO,BOAST,BRAST,PORTA,PSORA,RABOT,ROAST,SABOT,SAPOR,SARPO,SOPRA,SPORT,SPRAT,STRAP,STROP,TABOR,TRAPS,PASTOR,ABSORPT;'
defb 'ACCILNO,ALOIN,ANOIL,CALIN,COLIC,COLIN,CONIA,CONIC,ACCOIL,CALICO,CLONIC,LACCIN,CONICAL,LACONIC;'
defb 'ACDEKLT,ACTED,CADET,CAKED,CATEL,CLAKE,CLEAT,DEALT,DELTA,ECLAT,ECTAD,ECTAL,LACED,LATED,TALED,CALKED,LACKED,TACKED,TACKLE,TALKED,TACKLED;'
defb 'ACDELLR,ACRED,ALDER,ALLER,CADER,CADRE,CALLE,CARED,CEDAR,CELLA,CLARE,CLEAR,LACED,LADLE,RACED,RACLE,CALLED,CALLER,CELLAR,CRADLE,RECALL;'
defb 'ACEENOT,ACTON,ATONE,CANOE,CANTO,CENTO,EATEN,ENACT,ENATE,OATEN,OCEAN,CATENE,COATEE,OCTANE,OCTENE,TENACE,ACETONE;'
defb 'ACEHIMP,AMICE,CHAMP,CHAPE,CHEAP,CHIME,MEACH,MICHE,PEACH,PICEA,CHAMPE,HAEMIC,IMPEACH;'
defb 'ACEIQRU,AURIC,CRAIE,CURIA,ERICA,ERUCA,QUAIR,QUICA,QUICE,QUIRE,CAIQUE,CIRQUE,ACQUIRE;'
defb 'ACEJRTT,ATTER,CARET,CARTE,CATER,CRATE,CREAT,REACT,TACET,TRACE,TRACT,TREAT,TRAJET,TRAJECT;'
defb 'ACFILRY,AFRIC,CALIF,CLARY,CRAIL,CRYAL,FAIRY,FARCY,FILAR,FRAIL,LYRIC,FAIRLY,RACILY,CLARIFY;'
defb 'ACGILNS,ALIGN,CALIN,CANIS,CLANG,CLING,GANIL,GLANS,LIGAN,LINGA,SALIC,SIGLA,SLAIN,SLANG,SLING,SNAIL,ANGLIC,CASING,GLACIS,LACING,SIGNAL,SCALING;'
lexiLevel7 ; 6 lettres
defb 'ACGINST,AGIST,ANTIC,CAGIT,CANIS,GIANT,SAINT,SATIN,SCANT,STAIN,STANG,STIAN,STING,ACTING,CASING,SATING,CASTING;'
defb 'ACGIRST,AGIST,ARIST,ASTIR,CAGIT,CIGAR,GRIST,SCRAG,SCRAT,SCRIT,STAIR,STRIA,TARSI,TISAR,TRAIS,TRIAS,TRICA,GRATIS,TRAGIC,GASTRIC;'
defb 'ACHIMRS,CAMIS,CHAIR,CHARM,CHASM,CHIRM,CIMAR,CRASH,IHRAM,MARCH,MARSH,SCRIM,SHRAM,SIMAR,CHIASM,CHRISM,MARISH,RACHIS,SMIRCH,CHARISM;'
defb 'ACOSTTU,CATSO,COAST,COSTA,SCATT,SCOAT,SCOUT,SCUTA,STOAT,STOUT,TASCO,TASTO,TATOU,TOAST,OUTACT,OUTCAST;'
defb 'ADDEHLN,ADDLE,DADLE,ELAND,HALED,HEALD,LADDE,LADED,LADEN,NADDE,DANDLE,HANDED,HANDLE,LANDED,HANDLED;'
defb 'ADEEFLT,ALFET,DEALT,DELFT,DELTA,ELATE,FATED,FETAL,FETED,FLEET,FLETE,LAFTE,LATED,TALED,TEADE,DEFEAT,DELATE,ELATED,FELTED,LEAFED,LEAFET,DEFLATE;'
defb 'ADEEHSW,DASWE,EASED,HADES,HAWED,HAWSE,HEWED,SAWED,SEWED,SHADE,SWEDE,DASEWE,WASHED,ASHWEED;'
defb 'ADEEKNW,AKENE,AKNEE,AWNED,KNEAD,KNEED,NAKED,WAKED,WAKEN,WANED,WENDE,WEAKEN,WEANED,WAKENED;'
defb 'ADEILMM,AILED,AIMED,AMIDE,IDEAL,LAMED,LEMMA,LIMED,MEDAL,MEDIA,MELAM,LAMMED,MAILED,MAIMED,MEDIAL,DILEMMA;'
defb 'ADNPSTU,ADUST,ASTUN,DAUNT,NAPUS,SPUTA,STAND,STUPA,SUANT,UNAPT,UNSAD,USANT,DUSTPAN,UPSTAND;'
defb 'ADORSTW,ARTOW,DOWST,ROAST,SOWAR,STRAW,STROW,SWARD,SWART,SWORD,TARDO,TROAD,WORST,DARTOS,TOWARD,WASTOR,TOWARDS;'
defb 'AEEGLTV,AGLET,EAGLE,ELATE,GAVEL,GLAVE,GLEET,LEAVE,LEVET,VALET,EAGLET,LEGATE,TEAGLE,VELATE,GAVELET,VEGETAL;'
defb 'AEFILOT,ALFET,ALIFE,ALOFT,FETAL,FLITE,FLOAT,FLOTA,FLOTE,FOLIA,LAFTE,FOETAL,FOLIATE;'
defb 'AEFLRUW,ALURE,AWFUL,FALWE,FAULE,FERAL,FEUAR,FLARE,FLEAR,LAWER,UREAL,WAFER,FERULA,REWFUL,WAREFUL;'
defb 'AGMNSTU,AGNUS,ASTUN,GAMUT,GAUNT,MANUS,MUNGA,SAGUM,SANGU,STANG,STUNG,SUANT,TUGAN,USANT,ANGUST,MUSANG,MUSTANG;'
defb 'BCENORU,BONCE,BORNE,BOURN,CORBE,CORNU,COURB,CRONE,OUNCE,BOUNCE,BOURNE,CONURE,ROUNCE,UNROBE,BOUNCER;'
defb 'BDEOOST,BESOT,BETSO,BOOSE,BOOST,BOOTS,SOOTE,STOOD,BOOTED,BOOTES,SOOTED,BOOSTED;'
defb 'BGORSTU,BOGUS,BURST,BUSTO,GROUT,GURTS,GUSTO,ROUST,SOURT,STOUR,STURB,SUTOR,TORUS,TURBO,ROBUST;'
defb 'CELNOOS,CLOSE,COLON,COSEN,LOOSE,NOOSE,NOSEL,NOSLE,OONES,SCOLE,SCONE,SOCLE,SOLEN,SOLON,CLOSEN,LOOSEN,CONSOLE;'
defb 'CIMNORS,CROIS,MINOR,MINOS,MORIC,MORIN,NOMIC,ORCIN,OSMIC,ROMIC,ROSIN,SCION,SCORN,SCRIM,SIROC,MICRON,CRIMSON;'
defb 'CINRSTU,CRUST,CURST,CUTIN,CUTIS,ICTUS,INCUR,INCUS,INUST,RUNIC,RUTIC,RUTIN,SCRIT,SINTU,SUINT,TUNIC,USNIC,CITRUS,RICTUS,RUSTIC,INCRUST;'
defb 'DEGINNP,DEIGN,DIGNE,GNIDE,INNED,PIEND,PINED,ENDING,GINNED,PINGED,PINNED,PENDING;'
defb 'EEHMORT,ETHER,HERTE,HOMER,MEETH,METER,METRE,OTHER,THEME,THERE,THREE,THROE,HERETO,METEOR,MOTHER,REMOTE,THEOREM;'
defb 'EFHINST,FEINT,FETIS,INSET,NISTE,SEINT,SHENT,SHIFT,SHINE,SITHE,SNIFT,SNITE,STEIN,THIEF,THINE,FETISH,INFEST,SITHEN,SNITHE,NETFISH;'



lexiLevel8 ; 7 lettres
defb 'AABCEKR,ABACK,ABEAR,ACERB,ARACE,ARECA,BAKER,BRACE,BRACK,BRAKE,BREAK,CABER,CRAKE,CREAK,BACKER,BACKARE;'
defb 'AABCELN,ABLEN,ALBAN,ANCLE,BANAL,CABAL,CABLE,CANAL,CLEAN,LANCE,LEBAN,ANLACE,BALANCE;'
defb 'AABCELP,APACE,CABAL,CABLE,CAPEL,CAPLE,CLAPE,PALEA,PLACE,BECLAP,PALACE,CAPABLE,PACABLE;'
defb 'AABCELT,ABATE,ABLET,ALATE,BLEAT,CABAL,CABLE,CATEL,CLEAT,ECLAT,ECTAL,ETAAC,TABLE,ACETAL,CABLET,ACTABLE;'
defb 'AABCILM,ABACI,CABAL,CLAIM,CLIMB,LABIA,LAMIA,MALIC,BAALIM,CALAMI,CAMAIL,CIMBAL,LAMAIC,CAMBIAL;'
defb 'AABCORT,ABORT,ACTOR,AORTA,BRACT,CARAT,CAROB,COBRA,CROAT,RABAT,RABOT,TABOR,ABATOR,RABATO,ABACTOR,ACROBAT;'
defb 'AABCRSU,ASURA,BURSA,CABAS,CARUS,SACAR,SACRA,SCAUR,SCRUB,ABACUS,ACARUS,SCARAB,CARABUS;'
defb 'AABDDER,ABEAR,ADDER,ADRAD,AREAD,BARDE,BARED,BEARD,BREAD,DARED,DEBAR,DREAD,RADDE,ABRADE,ADREAD,BADDER,BARDED,ABRADED;'
defb 'AABDEHS,ABASE,ABASH,AHEAD,BASED,HADES,SAADH,SAHEB,SHADE,ABASED,BEDASH,ABASHED;'
defb 'AABDELT,ABATE,ABDAL,ABLET,ALATE,BALED,BATED,BLADE,BLEAT,DEALT,DELTA,LATED,TABLE,TALED,ABATED,ALATED,DATABLE;'
defb 'AABDERV,ABEAR,AREAD,BARDE,BARED,BEARD,BRAVE,BREAD,DEBAR,DRAVE,RAVED,ABRADE,ADVERB,BRAVED,VEADAR,BRAVADE;'
defb 'AABDIMR,BARIA,BRAID,BRAMA,DAMAR,DRAMA,IMBAR,MADIA,MARAI,RABID,ABRAID,BAIRAM,BARMAID;'
defb 'AABEELT,ABATE,ABELE,ABLET,ALATE,ALBEE,BETEL,BLEAT,ELATE,TABLE,BELATE,EATABLE;'
defb 'AABELMN,ABEAM,ABLEN,ALBAN,ALMAN,AMBLE,BANAL,BELAM,BLAME,LEBAN,LEMAN,MANABLE,NAMABLE;'
defb 'AABELPR,ABEAR,ABLER,AREAL,BLARE,BLEAR,EARAL,LABRA,LEPRA,PALEA,PARLE,PEARL,ARABLE,EARLAP,PARABLE;'
defb 'AABELSV,ABASE,AVALE,BALSA,BASAL,BLASE,SABAL,SABLE,SALEB,SALVE,SLAVE,SAVABLE;'
defb 'AABELTU,ABATE,ABLET,ALATE,BLEAT,TABLE,TUBAL,ABLAUT,BATEAU,BATULE,TABULA,TABLEAU,TABULAE;'
defb 'AABEOST,ABASE,ABATE,BASTA,BASTE,BASTO,BEAST,BESOT,BETSO,BOAST,SABOT,SEBAT,TABES,SEABOAT;'
defb 'AABERTT,ABATE,ABEAR,ATTAR,ATTER,BATTA,BRETT,RABAT,REATA,TABER,TREAT,ABATER,BATTER,RABATE,TABRET,TRABEA,TABARET;'
defb 'AABERTU,ABATE,ABEAR,AURAE,BRUTA,BRUTE,RABAT,REATA,REBUT,TABER,TRABU,TUBER,URATE,ABATER,ARBUTE,AURATE,BATEAU,RABATE,TRABEA,ABATURE;'
defb 'AACDILR,ACARI,ACRID,CAIRD,CALID,CRAIL,DARIC,DRAIL,LAIRD,LIARD,ALCAID,CARDIA,RACIAL,RADIAL,RADICAL;'
defb 'AADDERW,ADDER,ADRAD,AREAD,AWARD,AWARE,DARED,DREAD,RADDE,WADED,WADER,ADREAD,ADWARD,WARDED,AWARDED;'
defb 'BEEFILR,BELIE,BRIEF,FERIE,FIBER,FIBRE,FIBRE,FILER,FLEER,FLIER,IFERE,LIBER,REBEL,REFEL,RIFLE,BELIEF,FRIBLE,RELIEF,FEBRILE;'
defb 'BEEORSV,BEROE,BEVER,BOREE,BREVE,BROSE,EROSE,OBESE,SERVE,SEVER,SOBER,SOREE,VERSE,VERSO,SOEVER,OBSERVE,OBVERSE,VERBOSE;'
defb 'BEEORWY,BEERY,BEROE,BOREE,BORWE,BOWER,BOYER,EWERY,WEBER,BOWERY,BOWYER,OBEYER,EYEBROW;'
defb 'BEGGLOR,BLORE,BOGLE,BOREL,GLOBE,GLORE,GORGE,GREGO,LOGGE,OGLER,BOGGLE,LOGGER,BOGGLER,BROGGLE;'
defb 'BEHIRST,BERTH,BESIT,BIRSE,BIRTH,BITER,BREST,BRITE,HIRES,RIBES,SHIRE,SHIRT,SITHE,THEIR,TRIBE,BESTIR,BISTER,BISTRE,HERBIST;'
defb 'CCEINOS,CISCO,CONIC,COSEN,EOSIN,NOISE,SCION,SCONE,SECCO,SINCE,CONICS,COSINE,OSCINE,SCENIC,SCONCE,CONCISE;'
defb 'CDDIORS,CROIS,DIDOS,DORIC,DORIS,SCRID,SCROD,SIROC,SODIC,DISORD,ROSCID,SORDID,DISCORD;'
defb 'CDEERSW,CERED,CERES,CREED,CREES,SCREE,SCREW,SECRE,SEWED,SEWER,SWEDE,SWERD,WEDER,DECREW,SCREED,SCREWED;'
defb 'CDEIORV,CIDER,CORVE,COVED,COVER,CREDO,CRIED,DICER,DIVER,DORIC,DRIVE,DROVE,RIVED,ROVED,VEDRO,VICED,VIREO,VOICE,DEVOIR,VOICED,VOIDER,DIVORCE;'
defb 'CEEELPR,CLEPE,CREEL,CREEP,CREPE,LEERE,LEPER,LEPRE,PEECE,PEELE,PERCE,PEREL,REPEL,PEELER,PRECEL,CREEPLE;'
lexiLevel9 ; 6/8 lettres
defb 'CEEILNS,CENSE,EISEL,ELSIN,INCLE,LISNE,NIECE,SCENE,SECLE,SEINE,SICLE,SINCE,SLICE,SENILE,SILENE,LICENSE,SELENIC,SILENCE;'
defb 'CEELORT,CLOTE,COLET,CREEL,CRETE,ELECT,ERECT,LEROT,OELET,RECTO,TERCE,CEROTE,COLTER,CREOLE,LECTOR,TERCEL,ELECTOR,ELECTRO;'
defb 'CEELOPR,CLEPE,CREEL,CREEP,CREPE,CROPE,ELOPE,LEPER,LEPRE,LOPER,PERCE,PEREL,PLOCE,POLER,REPEL,CREOLE,ELOPER,PRECEL,OPERCLE;'
defb 'CEFILRU,CRUEL,CURLE,FILER,FLIER,LUCRE,RELIC,RIFLE,ULCER,FURILE,IREFUL,FERULIC,LUCIFER;'
defb 'CEFINOR,CERIN,CRONE,FINER,FORCE,INFER,NOIER,NORIE,ORCIN,COINER,CONFER,FOREIN,NORICE,ORCEIN,RECOIN,CONIFER;'
defb 'CEHIKNT,CEINT,CETIN,CHINE,CHINK,ETHIC,KETCH,KITHE,NICHE,TENCH,THICK,THINE,THINK,ETHNIC,KNITCH,TICKEN,KITCHEN,THICKEN;'
defb 'CEHIMNY,CHIME,CHINE,CHYME,HEMIN,HYMEN,MEINY,MICHE,MINCE,NICHE,HYMNIC,CHIMNEY;'
defb 'CEHNORV,CHORE,CORVE,COVER,CRONE,ECHON,HERON,HOVEN,HOVER,OCHER,OCHRE,ROCHE,CORVEN,CHEVRON;'
defb 'CEILMOP,CLIME,CLOMP,EOLIC,IMPEL,MELIC,MOILE,OLEIC,PLOCE,POMEL,COMPEL,PELIOM,POLICE,COMPILE,POLEMIC;'
defb 'CELLOSY,CELLO,CLOSE,COLLY,COSEY,LOSEL,SCOLE,SCYLE,SOCLE,SOYLE,CELLOS,COLLEY,SCOLEY,SOLELY,CLOSELY;'
defb 'CELRTTU,CRUEL,CRUET,CURLE,ERUCT,LUCRE,LUTER,TRUCE,TUCET,ULCER,UTTER,CULTER,CUTLER,CUTLET,CUTTER,CUTTLE,RELUCT,RUTTLE,TURTLE,CLUTTER;'
defb 'CEORRSY,CORER,CORSE,COSEY,CRORE,CROYS,CRYER,ROSER,SCORE,SERRY,SORRY,ROSERY,SCORER,SORCERY;'
defb 'CGINORS,CROIS,GROIN,INCOG,ORCIN,ROSIN,SCION,SCORN,SCROG,SIROC,CORING,GRISON,SIGNOR,SCORING;'
defb 'CINRSTU,CRUST,CURST,CUTIN,CUTIS,ICTUS,INCUR,INCUS,INUST,RUNIC,RUTIC,RUTIN,SCRIT,SINTU,SUINT,TUNIC,USNIC,CITRUS,RICTUS,RUSTIC,INCRUST;'
defb 'DDEEIRV,DIVED,DIVER,DRIED,DRIVE,EDDER,EIDER,REDDE,REVIE,RIVED,DERIDE,DERIVE,DERIVED;'
defb 'DEEFMOR,DEFER,DOREE,DROME,ERODE,FERDE,FERME,FORME,FREED,FREMD,MODER,DEFORM,FORMED,FREMED,FREEDOM;'
defb 'DEEIMPR,EIDER,IMPED,MIRED,PREDE,PRIDE,PRIED,PRIME,RIMED,EMPIRE,IMPEDE,MERIDE,PERDIE,PRIMED,DEMIREP,EPIDERM,REMIPED;'
defb 'DEEIOPS,EPODE,PEDES,PEISE,POISE,POSED,SPEED,SPIED,DEPOSE,ESPIED,POISED,POSIED,EPISODE;'
defb 'DEEKORV,DOREE,DROVE,ERODE,EVOKE,KERVE,KEVED,KEVER,ROKEE,ROVED,VEDRO,EVOKED,REVOKE,REVOKED;'
defb 'EEERRSV,REEVE,SERVE,SEVER,VERSE,EVERSE,REVERE,SERVER,SEVERE,VERSER,RESERVE,REVERSE;'
defb 'EEMPSTT,EMPTE,METTE,SPEET,STEEM,STEEP,TEEST,TEMPS,TEMPT,TEMSE,TESTE,SEPTET,TEMPSE,TEMPEST;'
defb 'EHIPRSW,HIRES,PERIS,PRISE,SHIRE,SHREW,SPEIR,SPIRE,SPREW,SWIPE,WHISP,WIPER,PERISH,RESHIP,SERIPH,WISHER,WHISPER;'
defb 'EIILNOV,ELOIN,LEVIN,NOVEL,OLEIN,OLIVE,OVILE,OVINE,VIOLE,INLIVE,INVEIL,INVILE,OLIVIN,VIOLIN,OLIVINE,VIOLINE;'
defb 'EINPPRS,PENIS,PERIS,PIPER,PRISE,REINS,RESIN,RINSE,RIPEN,RISEN,SERIN,SIREN,SNIPE,SPEIR,SPINE,SPIRE,NIPPER,PEPSIN,SIPPER,NIPPERS,SNIPPER;'
defb 'ELMOPRY,LEPRY,LOPER,MOREL,MOYLE,MYOPE,PLYER,POLER,POLEY,POMEL,POMEY,PROEM,REPLY,EMPLOY,POLEMY,POMELY,POLYMER;'
defb 'HLOSTUY,HOTLY,HOULT,LOTUS,LOUSY,LUSTY,SHOUT,SLOTH,SOUTH,YOUTH,YOUTHS,SOUTHLY;'









lexiLevel10  ; 8/8 lettres
defb 'AABCILST,ABAIST,ABATIS,ALTAIC,BALTIC,BASALT,ABACIST,BAALIST,BASALTIC,CABALIST;'
defb 'AABDLORR,ABOARD,ABORAL,ABROAD,ARROBA,BORDAR,DOLABRA,LABRADOR,LARBOARD;'
defb 'AABEFLMR,AFLAME,AMBLER,ARABLE,BLAMER,FABLER,FAMBLE,MARBLE,RAMBLE,RAMEAL,FARMABLE,FRAMABLE;'
defb 'AABEGILT,AGIBLE,AIGLET,ALBEIT,ALBITE,ALGATE,BEGILT,GABLET,GIBLET,LIGATE,TAGLIA,BAALITE,LABIATE,TAILAGE,ABLIGATE,AGITABLE;'
defb 'AABELSTT,ASTATE,BASALT,BATLET,BATTEL,BATTLE,STABLE,STATAL,TABLET,TASLET,ABETTAL,SALTATE,STATABLE,TASTABLE;'
defb 'AABCEINR,ARABIC,ARABIN,ARCANE,ARNICA,BERAIN,CARIBE,CARINA,CRANIA,NARICA,ACARINE,CARBINE,CABIREAN,CARABINE;'
defb 'AACDERST,ACATER,ACATES,ACRASE,ADARCE,ARCADE,CAESAR,CARTED,CASTER,CEDRAT,CRATED,RECAST,REDACT,RESCAT,SACRED,SCARED,STARED,TRACED,SACRATE,CADASTER,CADASTRE;'
defb 'AACILNTU,ACTUAL,ALAUNT,ALTAIC,ANICUT,ANTLIA,CANULA,INCULT,LACTIN,LACUNA,LATIAN,NATICA,NAUTIC,TINCAL,UNCIAL,ACTINAL,ALICANT,LUNATIC,ACTINULA,NAUTICAL;'
defb 'AAEGINTV,AGNATE,ANTIAE,EATING,GAVIAE,INGATE,NATIVE,TAENIA,VAGINA,AGATINE,VAGIENT,VAGINAE,VANTAGE,VINTAGE,NAVIGATE,VAGINATE;'
defb 'AAEILRSS,AERIAL,ARAISE,ASSAIL,LASSIE,RELAIS,RESAIL,SAILER,SERIAL,AIRLESS,ALIASES,ASSAILER,SALARIES;'
defb 'AAEILSTV,AVESTA,SALITE,SALIVA,SALVIA,SATIVE,SILVAE,VALISE,VASTEL,VESTAL,VITALS,ESTIVAL,SILVATE,AESTIVAL,SALIVATE;'
defb 'AAEMNPRS,ARENAS,ASMEAR,MARENA,RAMEAN,SAMARE,SAMPAN,SEAMAN,SPAEMAN,PARMESAN,SPEARMAN;'
defb 'AAILNNOT,ANOINT,ANTLIA,AONIAN,LATIAN,LATION,LOANIN,NAIANT,NATION,TALION,ALANTIN,ALATION,NATALOIN,NATIONAL;'
defb 'ABEERRTT,BARRET,BARTER,BATTER,BEARER,BEATER,BERATE,BETTER,RATTER,REBATE,TABRET,TEARER,TERRET,ABETTER,BERETTA,RETREAT,TABRERE,TEREBRA,TREATER,BATTERER,BERRETTA;'
defb 'ABDEHORR,ADORER,BARRED,BORDAR,BORDER,HARBOR,HARDER,HERBAR,HOARED,ROARED,ARBORED,BOARDER,HOARDER,ABHORRED,HARBORED;'
defb 'ACCEHILM,CALICE,CELIAC,CHEMIC,CLICHE,HAEMIC,HELIAC,MALEIC,MALICE,CHALICE,ALCHEMIC,CHEMICAL;'
defb 'ACDEIILT,CITIED,DELICT,DELTIC,DETAIL,DIETIC,DILATE,ELICIT,ITALIC,TAILED,CILIATE,CITADEL,DELTAIC,DIALECT,EDICTAL,ELAIDIC,LACTIDE,CILIATED,DIETICAL;'
defb 'ACDINSTY,CYSTID,DAINTY,DICAST,DYNAST,INCYST,SANITY,SATINY,SCANTY,SYNDIC,DISCANT,DISTANCY,DYNASTIC;'
defb 'ACDIRSTT,ARTIST,DICAST,STATIC,STRAIT,STRICT,ASTRICT,DRASTIC,ADSTRICT,DISTRACT;'
defb 'ACEEERTX,AXTREE,CERATE,CREATE,ECARTE,EXACTER,EXCRETA,EXCRETE,EXCREATE,EXECRATE;'
defb 'ACEGHINT,ACETIN,ACHING,ACTING,ANETIC,ANIGHT,CANTHI,CHANGE,EATING,ETHNIC,HATING,INCAGE,INGATE,ETCHING,GAHNITE,GNATHIC,HEATING,CHEATING,TEACHING;'
defb 'ACEOORTV,AVOCET,CAVORT,COOTER,CORVET,COVERT,OCTAVE,OCTAVO,TORACE,VECTOR,OVERACT,EVOCATOR,OVERCOAT;'
defb 'ACGGILNN,ANGLIC,CAGING,CANING,GINGAL,LACING,ANGLING,LANCING,CLANGING,GLANCING;'
defb 'ACIMOSTT,ATOMIC,MASCOT,MASTIC,MATICO,MOSAIC,MOSTIC,SAMIOT,SCOTIA,STATIC,TAOISM,TOMCAT,ATOMIST,COMTIST,SOMATIC,MASTICOT,STOMATIC;'
defb 'ADEENOTT,ATONED,ATTEND,ATTONE,DENOTE,DETENT,DONATE,DOTANT,NETTED,NOTATE,TEATED,TEETAN,TENTED,DENTATE,DENOTATE,DETONATE;'
defb 'ADEILTTU,DETAIL,DILATE,DILUTE,LITATE,TAILED,TILTED,TITLED,TITULED,ALTITUDE,LATITUDE;'
defb 'AEEILRRT,EARLET,ELATER,RAILER,REITER,RELATE,RELIER,RETAIL,RETIRE,TEARER,TERREL,ATELIER,RELATER,RETRIAL,TRAILER,IRRELATE,RETAILER;'
defb 'AEEINNTV,ANIENT,ETNEAN,INNATE,INVENT,NATIVE,TINEAN,VENITE,NAIVETE,AVENTINE,VENETIAN;'
defb 'AEENORTV,ATONER,AVENER,AVENOR,ORNATE,RENATE,TAVERN,VENTER,AVENTRE,NERVATE,ONERATE,OVEREAT,VERNATE,VETERAN,OVERNEAT,RENOVATE;'
defb 'AEFLSTTU,ASTUTE,ESTUFA,FESTAL,FLATUS,FLUATE,FUSTET,SALUTE,SETULA,STATUE,SUTTLE,TASLET,STATEFUL,TASTEFUL;'
defb 'AEILMTTU,AMULET,LITATE,TITMAL,ULMATE,ULTIMA,ULTIME,MUTILATE,ULTIMATE;'
defb 'AGILLNSY,GAINLY,GALLIN,LAYING,SAYING,SIGNAL,SINGLY,SLANGY,ALLYING,SLAYING,SALLYING,SIGNALLY;'
defb 'AIILMRTY,AIRILY,MITRAL,TRIMLY,TYLARI,MILIARY,MILITAR,LIMITARY,MILITARY;'
defb 'BDEGIINT,BIDENT,BIDING,BITING,IGNITE,INDEBT,INDITE,NIDGET,TIDING,TINEID,TINGED,TINGID,DIETING,EDITING,IGNITED,BETIDING,DEBITING;'
defb 'BEEILNST,BELTIN,ENLIST,LISTEN,NESTLE,SENILE,SILENE,SILENT,TINSEL,BELTEIN,TENSILE,STILBENE,TENSIBLE;'
defb 'BEELNOSU,BLOUSE,ENSOUL,NEBULE,NOUSEL,NOUSLE,OBELUS,UNSEEL,BLUENOSE,NEBULOSE;'
defb 'BEGHINRT,BEGIRT,BRIGHT,ENGIRT,GREITH,GRINTE,HENBIT,THRING,TINGER,BENIGHT,RIGHTEN,BERTHING,BRIGHTEN;'
defb 'BELMORSY,BLOSMY,EMBOLY,EMBRYO,MOBLES,MORSEL,ROMBLE,SOMBER,SOMBRE,SORELY,SYMBOL,EMBRYOS,SOBERLY,SOMBERLY,SOMBRELY;'
defb 'CEEILSTT,LETTIC,SCELET,SELECT,SETTLE,STILET,SECTILE,TELESTIC,TESTICLE;'
defb 'CEILOSST,CITESS,CITOLE,CLOSET,COLIES,COSSET,COTISE,OCTILE,TOSSEL,OSSICLE,SOLECIST,SOLSTICE;'
defb 'DDEILNPS,DISPEL,DISPLE,LISPED,PIDDLE,SIDLED,SPINED,SPINEL,SPLINE,DISPEND,SLIDDEN,SPINDLE,SPINDLED,SPLENDID;'
defb 'DEEGIINN,DINING,ENDING,ENGINE,GINNED,GINNEE,INDIGN,NIDING,INGENIE,NEEDING,INDIGEEN,INDIGENE;'
defb 'EIOPRSUV,PERVIS,POISER,RIVOSE,UPRISE,VIROSE,POISURE,PURSIVE,PERVIOUS,PREVIOUS,VIPEROUS;'
defb 'GIIKNRST,GIRKIN,INGIRT,RISING,SIRING,STRING,TINGIS,TIRING,GRISKIN,RISKING,SKIRTING,STRIKING;'
defb 'HILNOPSU,INSOUL,PILOUS,POLISH,PUNISH,SIPHON,UNSHIP,PULSION,SULPHION,UNPOLISH;'
defb 'IMORSTTU,OSTIUM,OUTSIT,RIMOUS,ROMIST,STROUT,SUITOR,TIMOUS,TRUISM,UTMOST,TOURIST,MISTUTOR,TUTORISM;'
defb 'ACDEENRT,CANTERED,CRENATED,DECANTER,NECTARED,RECANTED;'
defb 'DEEILNST,ENLISTED,LINTSEED,LISTENED,TENSILED,TINSELED;'



defb PIPE ; end marker => win the game





charset


print 'fin des donnees ',{hex}$


save 'enec.bin',#100,$-#100



