/*
 * Reginald and the She Vampires for the Amstrad CPC
 * Copyright (C) 2025 Dave Moore
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; If not, see <http://www.gnu.org/licenses/>.
 */

#pragma constseg DATA

#include "dat/tiles.h"

const u8 reginald_m_16x16_00[4 * 16] = {0x00, 0x30, 0xc0, 0x00, 0x00, 0xc3,
	0x3c, 0x00, 0x10, 0x0f, 0x0f, 0x80, 0x10, 0x0f, 0x0f, 0x80, 0x10, 0x0f,
	0x0f, 0x80, 0x10, 0x0f, 0x0f, 0x80, 0x31, 0x0f, 0x0f, 0xc8, 0x10, 0x0f,
	0x0f, 0x80, 0x00, 0x87, 0x1e, 0x00, 0x10, 0xf3, 0xfc, 0x80, 0x21, 0x3c,
	0xc3, 0x48, 0x43, 0x87, 0x1e, 0x2c, 0x43, 0x87, 0x1e, 0x2c, 0x31, 0xf0,
	0xf0, 0xc8, 0x10, 0x87, 0x1e, 0x80, 0x00, 0xf6, 0xf6, 0x00};

const u8 reginald_m_16x16_01[4 * 16] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x30,
	0xc0, 0x00, 0x00, 0xc3, 0x3c, 0x00, 0x10, 0x0f, 0x0f, 0x80, 0x10, 0x0f,
	0x0f, 0x80, 0x10, 0x0f, 0x0f, 0x80, 0x10, 0x0f, 0x0f, 0x80, 0x31, 0x0f,
	0x0f, 0xc8, 0x10, 0x0f, 0x0f, 0x80, 0x00, 0xc3, 0x3c, 0x00, 0x10, 0x3c,
	0xc3, 0x80, 0x31, 0x87, 0x1e, 0xc0, 0x10, 0x87, 0x3d, 0xc8, 0x00, 0xf0,
	0xf0, 0x80, 0x00, 0x96, 0xe4, 0x00, 0x00, 0xf6, 0xc0, 0x00};

const u8 reginald_m_16x16_02[4 * 16] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x30,
	0xc0, 0x00, 0x00, 0xc3, 0x3c, 0x00, 0x10, 0x0f, 0x0f, 0x80, 0x10, 0x0f,
	0x0f, 0x80, 0x10, 0x0f, 0x0f, 0x80, 0x10, 0x0f, 0x0f, 0x80, 0x31, 0x0f,
	0x0f, 0xc8, 0x10, 0x0f, 0x0f, 0x80, 0x00, 0xc3, 0x3c, 0x00, 0x10, 0x3c,
	0xc3, 0x80, 0x30, 0x87, 0x1e, 0xc8, 0x31, 0xcb, 0x1e, 0x80, 0x10, 0xf0,
	0xf0, 0x00, 0x00, 0x72, 0x96, 0x00, 0x00, 0x30, 0xf6, 0x00};

const u8 reginald_m_16x16_03[4 * 16] = {0x00, 0x30, 0xc0, 0x00, 0x00, 0xc3,
	0x3c, 0x00, 0x10, 0x0f, 0x0f, 0x80, 0x10, 0x0f, 0x0f, 0x80, 0x10, 0x0f,
	0x0f, 0x80, 0x10, 0x7f, 0x6f, 0x80, 0x31, 0x7f, 0xef, 0xc8, 0x10, 0xfd,
	0xfb, 0x80, 0x00, 0xf5, 0xfa, 0x00, 0x10, 0xf3, 0xfc, 0x80, 0x21, 0x3c,
	0xc3, 0x48, 0x43, 0x97, 0x9e, 0x2c, 0x43, 0x87, 0x1e, 0x2c, 0x31, 0xf0,
	0xf0, 0xc8, 0x10, 0x87, 0x1e, 0x80, 0x00, 0xf6, 0xf6, 0x00};

const u8 reginald_m_16x16_04[4 * 16] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x30,
	0xc0, 0x00, 0x00, 0xc3, 0x3c, 0x00, 0x10, 0x0f, 0x0f, 0x80, 0x10, 0x0f,
	0x0f, 0x80, 0x10, 0x0f, 0x0f, 0x80, 0x10, 0x6f, 0xef, 0x80, 0x31, 0x7f,
	0xef, 0xc8, 0x10, 0xfd, 0xfb, 0x80, 0x10, 0xf5, 0xfa, 0x80, 0x21, 0x7b,
	0xed, 0x48, 0x30, 0xb4, 0xd2, 0x6c, 0x31, 0xcb, 0x1e, 0xe4, 0x10, 0xf0,
	0xf0, 0x60, 0x00, 0x72, 0x96, 0x00, 0x00, 0x30, 0xf6, 0x00};

const u8 reginald_m_16x16_05[4 * 16] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x10,
	0xe0, 0x00, 0x00, 0x61, 0x1e, 0x80, 0x00, 0x87, 0x0f, 0x48, 0x00, 0x87,
	0x0f, 0x48, 0x00, 0x87, 0x0f, 0x48, 0x00, 0xb7, 0x7f, 0x48, 0x10, 0xbf,
	0xff, 0x6c, 0x00, 0xf6, 0xfd, 0xc8, 0x00, 0xf2, 0xfd, 0xc0, 0x10, 0x3d,
	0xfe, 0x2c, 0x31, 0x5a, 0xe1, 0xe0, 0x31, 0xc3, 0x1e, 0xec, 0x30, 0x70,
	0xf0, 0xc0, 0x00, 0x43, 0xf2, 0x00, 0x00, 0x73, 0xe0, 0x00};

const u8 reginald_m_16x16_06[4 * 16] = {0x00, 0x30, 0xe0, 0x00, 0x00, 0xc3,
	0x1e, 0x80, 0x10, 0x0f, 0x0f, 0x48, 0x10, 0x0f, 0x0f, 0x48, 0x10, 0x0f,
	0x0f, 0x48, 0x10, 0x1f, 0xff, 0x48, 0x10, 0x97, 0xff, 0x80, 0x10, 0xdb,
	0xfd, 0x80, 0x00, 0xf7, 0xfd, 0x80, 0x00, 0x71, 0xfe, 0x00, 0x00, 0x52,
	0xe0, 0x00, 0x00, 0x43, 0x68, 0x00, 0x00, 0x43, 0xa4, 0x00, 0x00, 0x71,
	0xa4, 0x00, 0x00, 0x31, 0xe0, 0x00, 0x00, 0x30, 0xec, 0x00};

const u8 reginald_m_16x16_07[4 * 16] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x30,
	0xe0, 0x00, 0x00, 0xc3, 0x1e, 0x80, 0x10, 0x0f, 0x0f, 0x48, 0x10, 0x0f,
	0x0f, 0x48, 0x10, 0x0f, 0x0f, 0x48, 0x10, 0x1f, 0xff, 0x48, 0x10, 0x97,
	0xff, 0x80, 0x10, 0xdb, 0xfd, 0x80, 0x00, 0xf7, 0xfd, 0x80, 0x00, 0x71,
	0xfe, 0x00, 0x00, 0xd2, 0xf0, 0x00, 0x10, 0xcb, 0x3f, 0x80, 0x00, 0x87,
	0x78, 0x00, 0x00, 0xf0, 0xe0, 0x00, 0x00, 0xf6, 0xf6, 0x00};

const u8 reginald_m_16x16_08[4 * 16] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x30,
	0xe0, 0x00, 0x00, 0xc3, 0x1e, 0x80, 0x10, 0x0f, 0x0f, 0x48, 0x10, 0x0f,
	0x0f, 0x48, 0x10, 0x0f, 0x0f, 0x48, 0x10, 0x1f, 0xff, 0x48, 0x10, 0x97,
	0xff, 0x80, 0x10, 0xdb, 0xfd, 0x80, 0x00, 0xf7, 0xfd, 0x80, 0x00, 0xf1,
	0xfe, 0x00, 0x10, 0x1e, 0xf0, 0x00, 0x10, 0xad, 0x79, 0x80, 0x10, 0xcb,
	0x3c, 0x00, 0x00, 0xf0, 0xe0, 0x00, 0x00, 0xf6, 0xf6, 0x00};

const u8 regina_m_16x16_00[4 * 16] = {0x00, 0x30, 0xc0, 0x00, 0x00, 0xc3, 0x3c,
	0x00, 0x10, 0x87, 0x1e, 0x80, 0x10, 0x0f, 0x0f, 0x80, 0x10, 0x0f, 0x0f,
	0x80, 0x10, 0x0f, 0x0f, 0x80, 0x31, 0x0f, 0x0f, 0xc8, 0x10, 0x1e, 0x87,
	0x80, 0x00, 0xa5, 0x5a, 0x00, 0x00, 0xc3, 0x3c, 0x00, 0x10, 0x4b, 0x2d,
	0x80, 0x10, 0x2d, 0x4b, 0x80, 0x31, 0xd2, 0xb4, 0xc8, 0x73, 0xc3, 0x3c,
	0xec, 0x30, 0xf6, 0xf6, 0xc0, 0x00, 0x72, 0xe4, 0x00};

const u8 regina_m_16x16_01[4 * 16] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0xc0,
	0x00, 0x00, 0xc3, 0x3c, 0x00, 0x10, 0x87, 0x1e, 0x80, 0x10, 0x0f, 0x0f,
	0x80, 0x10, 0x0f, 0x0f, 0x80, 0x10, 0x0f, 0x0f, 0x80, 0x31, 0x0f, 0x0f,
	0xc8, 0x10, 0x1e, 0x87, 0x80, 0x00, 0xa5, 0x5a, 0x00, 0x10, 0x4b, 0x2d,
	0x80, 0x10, 0x4b, 0x78, 0x80, 0x31, 0xe9, 0xf0, 0x80, 0x30, 0xd2, 0xb5,
	0xc8, 0x00, 0xf6, 0xf4, 0x80, 0x00, 0x72, 0xc0, 0x00};

const u8 regina_m_16x16_02[4 * 16] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0xc0,
	0x00, 0x00, 0xc3, 0x3c, 0x00, 0x10, 0x87, 0x1e, 0x80, 0x10, 0x0f, 0x0f,
	0x80, 0x10, 0x0f, 0x0f, 0x80, 0x10, 0x0f, 0x0f, 0x80, 0x31, 0x0f, 0x0f,
	0xc8, 0x10, 0x1e, 0x87, 0x80, 0x00, 0xa5, 0x5a, 0x00, 0x10, 0x4b, 0x2d,
	0x80, 0x10, 0x69, 0x3c, 0x80, 0x10, 0xf0, 0x79, 0xc8, 0x31, 0xda, 0xb4,
	0xc0, 0x10, 0xf2, 0xf6, 0x00, 0x00, 0x30, 0xe4, 0x00};

const u8 regina_m_16x16_03[4 * 16] = {0x00, 0x30, 0xc0, 0x00, 0x00, 0xc3, 0x3c,
	0x00, 0x10, 0x0f, 0x0f, 0x80, 0x10, 0x0f, 0x0f, 0x80, 0x10, 0x1f, 0x0f,
	0x80, 0x10, 0x7f, 0xef, 0x80, 0x31, 0x7f, 0xef, 0xc8, 0x10, 0x7d, 0xeb,
	0x80, 0x00, 0xf5, 0xfa, 0x00, 0x00, 0xf3, 0xfc, 0x00, 0x10, 0x3c, 0xc3,
	0x80, 0x10, 0x1f, 0x8f, 0x80, 0x31, 0xc3, 0x3c, 0xc8, 0x73, 0xc3, 0x3c,
	0xec, 0x30, 0xf6, 0xf6, 0xc0, 0x00, 0x72, 0xe4, 0x00};

const u8 regina_m_16x16_04[4 * 16] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0xc0,
	0x00, 0x00, 0xc3, 0x3c, 0x00, 0x10, 0x0f, 0x0f, 0x80, 0x10, 0x0f, 0x0f,
	0x80, 0x10, 0x1f, 0x0f, 0x80, 0x10, 0x7f, 0xef, 0x80, 0x31, 0x7f, 0xef,
	0xc8, 0x10, 0x7d, 0xeb, 0x80, 0x00, 0xf5, 0xfa, 0x00, 0x10, 0x7b, 0xed,
	0x80, 0x10, 0x78, 0xd2, 0x80, 0x10, 0xc3, 0x3d, 0xc8, 0x31, 0xcb, 0x3c,
	0xc0, 0x10, 0xf2, 0xf6, 0x00, 0x00, 0x30, 0xe4, 0x00};

const u8 regina_m_16x16_05[4 * 16] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0xc0,
	0x00, 0x00, 0xc3, 0x3c, 0x00, 0x10, 0x0f, 0x0f, 0x80, 0x10, 0x0f, 0x0f,
	0x80, 0x10, 0x1f, 0x0f, 0x80, 0x10, 0x7f, 0xef, 0x80, 0x31, 0x7f, 0xef,
	0xc8, 0x10, 0x7d, 0xeb, 0x80, 0x00, 0xf5, 0xfa, 0x00, 0x10, 0x7b, 0xed,
	0x80, 0x10, 0xb4, 0xe1, 0x80, 0x31, 0xcb, 0x3c, 0x80, 0x30, 0xc3, 0x3d,
	0xc8, 0x00, 0xf6, 0xf4, 0x80, 0x00, 0x72, 0xc0, 0x00};

const u8 regina_m_16x16_06[4 * 16] = {0x00, 0x10, 0xf0, 0x00, 0x00, 0x61, 0x0f,
	0xc0, 0x00, 0x87, 0x0f, 0x2c, 0x00, 0x87, 0x0f, 0x2c, 0x00, 0x87, 0x0f,
	0x2c, 0x00, 0x87, 0x1f, 0xac, 0x10, 0x4b, 0x3f, 0xc8, 0x21, 0xe5, 0x3e,
	0xc8, 0x21, 0x7b, 0x3e, 0xc8, 0x10, 0x3c, 0xff, 0x80, 0x10, 0x78, 0xf0,
	0x00, 0x00, 0xd0, 0x69, 0x80, 0x00, 0x10, 0xcb, 0x80, 0x00, 0x10, 0xda,
	0x00, 0x00, 0x10, 0xf6, 0x00, 0x00, 0x00, 0xe4, 0x00};

const u8 regina_m_16x16_07[4 * 16] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xf0,
	0x00, 0x00, 0x61, 0x0f, 0xc0, 0x00, 0x87, 0x0f, 0x2c, 0x00, 0x87, 0x0f,
	0x2c, 0x00, 0x87, 0x0f, 0x2c, 0x00, 0x87, 0x1f, 0xac, 0x10, 0x4b, 0x3f,
	0xc8, 0x21, 0xe5, 0x3e, 0xc8, 0x21, 0x7b, 0x3e, 0xc8, 0x10, 0x3c, 0xff,
	0x80, 0x21, 0x78, 0xf0, 0x00, 0x10, 0xf2, 0xc7, 0x80, 0x00, 0x70, 0xf7,
	0x80, 0x00, 0x31, 0x78, 0x00, 0x00, 0x31, 0xf2, 0x00};

const u8 regina_m_16x16_08[4 * 16] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xf0,
	0x00, 0x00, 0x61, 0x0f, 0xc0, 0x00, 0x87, 0x0f, 0x2c, 0x00, 0x87, 0x0f,
	0x2c, 0x00, 0x87, 0x0f, 0x2c, 0x00, 0x87, 0x1f, 0xac, 0x10, 0x4b, 0x3f,
	0xc8, 0x21, 0xe5, 0x3e, 0xc8, 0x21, 0x7b, 0x3e, 0xc8, 0x10, 0x3c, 0xff,
	0x80, 0x21, 0x78, 0xf0, 0x80, 0x10, 0xf3, 0x87, 0x80, 0x00, 0x72, 0x96,
	0xc8, 0x00, 0x61, 0xf3, 0x80, 0x00, 0x31, 0xf1, 0x80};

const u8 tile_m_16x16_00[4 * 16] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xc0, 0x00, 0x00, 0x12, 0xe8,
	0x00, 0x00, 0x12, 0xec, 0x00, 0x00, 0x12, 0xe0, 0x00, 0x00, 0x01, 0x0c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

const u8 tile_m_16x16_01[4 * 16] = {0x25, 0x35, 0xca, 0x4a, 0x78, 0x7a, 0xe5,
	0xe1, 0x78, 0xf3, 0xfc, 0xe1, 0xf0, 0xf5, 0xfa, 0xf2, 0xf4, 0xf4, 0xf2,
	0xf0, 0xf0, 0xf5, 0xfa, 0xf0, 0xf4, 0xf2, 0xf4, 0xf2, 0xf0, 0xf3, 0xfc,
	0xf0, 0xf4, 0xf2, 0xf4, 0xf2, 0xf4, 0xb4, 0xd2, 0xf2, 0xe5, 0x2d, 0x4b,
	0x7a, 0xc2, 0x25, 0x4a, 0x34, 0xc2, 0x25, 0x4a, 0x34, 0x0e, 0x02, 0x04,
	0x25, 0x00, 0x00, 0x00, 0x4a, 0x00, 0x00, 0x00, 0x04};

const u8 tile_m_16x16_02[4 * 16] = {0x25, 0x00, 0x00, 0x4a, 0x78, 0x0a, 0x05,
	0xe1, 0x78, 0x3d, 0xcb, 0xe1, 0xf0, 0xb5, 0xda, 0xf0, 0xf0, 0xf2, 0xf4,
	0xf2, 0xf0, 0xf3, 0xfc, 0xf0, 0xf4, 0xf4, 0xf2, 0xf2, 0xf4, 0xf5, 0xfa,
	0xf0, 0xf0, 0xf6, 0xf6, 0xf0, 0xf4, 0xf3, 0xfc, 0xf2, 0xc3, 0xf2, 0xf4,
	0x78, 0xc2, 0x7a, 0xe5, 0x34, 0x69, 0x25, 0x4a, 0x69, 0x06, 0x25, 0x4a,
	0x06, 0x00, 0x25, 0x4a, 0x00, 0x00, 0x02, 0x04, 0x00};

const u8 tile_m_16x16_03[4 * 16] = {0x01, 0x07, 0x0d, 0x00, 0x12, 0x78, 0xd2,
	0x08, 0x16, 0xf0, 0xf0, 0x0c, 0x78, 0xfe, 0xfe, 0xc2, 0xf7, 0xff, 0xff,
	0xe9, 0xf7, 0xfe, 0xff, 0xed, 0xf7, 0xff, 0xfe, 0xe1, 0xf7, 0xfe, 0xfe,
	0x4a, 0xf1, 0xfe, 0xfe, 0x84, 0xb5, 0xff, 0xfe, 0x08, 0x78, 0xf0, 0xf0,
	0x08, 0x16, 0xf0, 0xf0, 0x08, 0x12, 0xc3, 0xe1, 0x00, 0x12, 0xe1, 0x0e,
	0x00, 0x12, 0xed, 0x00, 0x00, 0x12, 0xc2, 0x00, 0x00};

const u8 tile_m_16x16_04[4 * 16] = {0x02, 0x78, 0xc2, 0x08, 0x25, 0x78, 0xc3,
	0x84, 0x34, 0xf0, 0xf0, 0x84, 0x79, 0xff, 0xff, 0xc2, 0xf7, 0xff, 0xff,
	0xed, 0xf7, 0xfe, 0xff, 0xed, 0xf6, 0xff, 0xfe, 0xed, 0x78, 0xfe, 0xfe,
	0xc2, 0x7a, 0xff, 0xfe, 0x4a, 0x34, 0xfe, 0xfe, 0x84, 0x12, 0xf0, 0xf0,
	0x08, 0x12, 0xf0, 0xf0, 0x08, 0x12, 0xe1, 0xf0, 0x08, 0x12, 0xed, 0xf6,
	0x08, 0x12, 0xc3, 0x78, 0x08, 0x01, 0x0c, 0x07, 0x00};

const u8 tile_m_16x16_05[4 * 16] = {0x01, 0x07, 0x0d, 0x00, 0x12, 0x78, 0xd2,
	0x08, 0x16, 0xf0, 0xf0, 0x0c, 0x78, 0xfe, 0xfe, 0xc2, 0xf3, 0xff, 0xff,
	0xed, 0xf7, 0xfe, 0xff, 0xed, 0xf0, 0xff, 0xff, 0xed, 0x5a, 0xfe, 0xff,
	0xed, 0x34, 0xfe, 0xff, 0xe1, 0x12, 0xff, 0xff, 0xe5, 0x12, 0xf0, 0xf0,
	0xc2, 0x12, 0xf0, 0xf0, 0x0c, 0x01, 0xe1, 0x78, 0x08, 0x00, 0x0f, 0xf0,
	0x08, 0x00, 0x01, 0x96, 0x08, 0x00, 0x00, 0x78, 0x08};

const u8 tile_m_16x16_06[4 * 16] = {0x01, 0x07, 0x0d, 0x00, 0x12, 0x78, 0xd2,
	0x08, 0x16, 0xf2, 0xf8, 0x0c, 0x78, 0xfa, 0xfa, 0xc2, 0xf6, 0xf9, 0xf2,
	0xe9, 0xf7, 0xfc, 0xf7, 0xed, 0xf7, 0xfe, 0xfc, 0xe1, 0xf6, 0xfe, 0xfd,
	0xca, 0x78, 0xf6, 0xfe, 0x84, 0x7b, 0xf6, 0xfe, 0x08, 0x34, 0xf1, 0xf0,
	0x08, 0x12, 0xf0, 0xf0, 0x08, 0x12, 0xc3, 0xf0, 0x08, 0x12, 0xc2, 0x0f,
	0x00, 0x35, 0xca, 0x00, 0x00, 0x34, 0x84, 0x00, 0x00};

const u8 tile_m_16x16_07[4 * 16] = {0x02, 0x78, 0xc2, 0x08, 0x25, 0x78, 0xc3,
	0x84, 0x34, 0xf2, 0xf8, 0x84, 0x79, 0xf9, 0xf3, 0xc2, 0xf5, 0xfc, 0xf7,
	0xe5, 0xf7, 0xfe, 0xff, 0xed, 0xf6, 0xfe, 0xfe, 0xed, 0x78, 0xfe, 0xfe,
	0xc2, 0x7b, 0xf6, 0xfd, 0xca, 0x34, 0xfe, 0xfe, 0x84, 0x12, 0xf1, 0xf0,
	0x08, 0x12, 0xf0, 0xf0, 0x08, 0x12, 0xe1, 0xf0, 0x08, 0x12, 0xed, 0xf6,
	0x08, 0x12, 0xc2, 0x78, 0x08, 0x01, 0x0c, 0x07, 0x00};

const u8 tile_m_16x16_08[4 * 16] = {0x01, 0x07, 0x0d, 0x00, 0x12, 0x78, 0xd2,
	0x08, 0x16, 0xf2, 0xf8, 0x0c, 0x78, 0xfa, 0xfa, 0xc2, 0xf2, 0xf9, 0xf2,
	0xed, 0xf7, 0xfc, 0xf7, 0xed, 0xf0, 0xf6, 0xff, 0xed, 0x7b, 0xf6, 0xfe,
	0xed, 0x34, 0xfe, 0xfc, 0xc2, 0x12, 0xfe, 0xfd, 0xca, 0x12, 0xf1, 0xf0,
	0x84, 0x12, 0xf0, 0xf0, 0x08, 0x12, 0xe1, 0x78, 0x08, 0x01, 0x0e, 0x78,
	0x08, 0x00, 0x00, 0x7b, 0x84, 0x00, 0x00, 0x34, 0x84};

const u8 tile_m_16x16_09[4 * 16] = {0x1a, 0xf0, 0x84, 0x00, 0x96, 0xfa, 0xca,
	0x00, 0xf0, 0xfd, 0x84, 0x00, 0x96, 0xfc, 0x87, 0x00, 0x3c, 0xf0, 0xf0,
	0x08, 0x35, 0xff, 0xfb, 0x86, 0x35, 0xff, 0xfa, 0xe1, 0x35, 0xf4, 0xf0,
	0xe1, 0x35, 0xff, 0xf8, 0xc2, 0x35, 0xf0, 0xc3, 0x0c, 0x35, 0xff, 0xca,
	0x00, 0x35, 0xff, 0xe1, 0x04, 0x35, 0xfc, 0xf0, 0x4a, 0x35, 0xe9, 0xf0,
	0x84, 0x35, 0xca, 0x78, 0x08, 0x34, 0xe1, 0x25, 0x00};

const u8 tile_m_16x16_10[4 * 16] = {0x16, 0xf0, 0x84, 0x00, 0x5a, 0xfd, 0x84,
	0x00, 0x78, 0xfc, 0xca, 0x00, 0x7a, 0xfe, 0x87, 0x0c, 0x34, 0xf0, 0xf0,
	0xc2, 0x35, 0xff, 0xfd, 0xca, 0x35, 0xff, 0xfd, 0xc2, 0x35, 0xfa, 0xf0,
	0xc2, 0x35, 0xff, 0xf8, 0x84, 0x34, 0xf8, 0xc3, 0x08, 0x35, 0xff, 0x84,
	0x00, 0x34, 0xff, 0x84, 0x00, 0x34, 0xfe, 0x08, 0x00, 0x34, 0xfe, 0x08,
	0x00, 0x34, 0xfe, 0x08, 0x00, 0x34, 0xf0, 0x84, 0x00};

const u8 tile_m_16x16_11[4 * 16] = {0x1a, 0xf0, 0x84, 0x00, 0x96, 0xfa, 0xca,
	0x00, 0xf0, 0xfd, 0x84, 0x00, 0x96, 0xfc, 0x87, 0x0c, 0x3c, 0xf0, 0xf0,
	0xc2, 0x35, 0xff, 0xfe, 0xed, 0x35, 0xff, 0xfe, 0xe9, 0x35, 0xfd, 0xf0,
	0xc2, 0x35, 0xff, 0xf8, 0x0c, 0x34, 0xf4, 0xc3, 0x00, 0x35, 0xff, 0xed,
	0x04, 0x34, 0xfe, 0xfe, 0x4a, 0x34, 0xf0, 0xf3, 0xc2, 0x34, 0xf3, 0xf0,
	0x84, 0x34, 0xf3, 0xf8, 0x08, 0x34, 0xf0, 0xed, 0x00};

const u8 tile_m_16x16_12[4 * 16] = {0x00, 0x12, 0xf0, 0x85, 0x00, 0x35, 0xf5,
	0x96, 0x00, 0x12, 0xfb, 0xf0, 0x03, 0x1e, 0xf3, 0x96, 0x34, 0xf0, 0xf0,
	0xc1, 0x7b, 0xf7, 0xff, 0xca, 0x79, 0xf7, 0xff, 0xca, 0x34, 0xf0, 0xfb,
	0xca, 0x03, 0xf1, 0xff, 0xca, 0x00, 0x3c, 0xf2, 0xc2, 0x02, 0x7b, 0xff,
	0xca, 0x25, 0xf7, 0xf7, 0xc2, 0x34, 0xfc, 0xf0, 0xc2, 0x12, 0xf0, 0x3c,
	0xc2, 0x01, 0xe1, 0x3c, 0xc2, 0x00, 0x4b, 0xf0, 0xc2};

const u8 tile_m_16x16_13[4 * 16] = {0x00, 0x12, 0xf0, 0x86, 0x00, 0x12, 0xfb,
	0xa5, 0x00, 0x35, 0xf3, 0xe1, 0x03, 0x1e, 0xf7, 0xa5, 0x34, 0xf0, 0xf0,
	0xc2, 0x35, 0xfb, 0xff, 0xca, 0x34, 0xfb, 0xff, 0xca, 0x34, 0xf0, 0xf5,
	0xca, 0x12, 0xf1, 0xff, 0xca, 0x01, 0x3c, 0xf1, 0xc2, 0x00, 0x12, 0xff,
	0xca, 0x00, 0x12, 0xff, 0xc2, 0x00, 0x01, 0xf7, 0xc2, 0x00, 0x01, 0xf7,
	0xc2, 0x00, 0x01, 0xf7, 0xc2, 0x00, 0x12, 0xf0, 0xc2};

const u8 tile_m_16x16_14[4 * 16] = {0x00, 0x12, 0xf0, 0x85, 0x00, 0x35, 0xf5,
	0x96, 0x00, 0x12, 0xfb, 0xf0, 0x00, 0x1e, 0xf3, 0x96, 0x01, 0xf0, 0xf0,
	0xc3, 0x16, 0xfd, 0xff, 0xca, 0x78, 0xf5, 0xff, 0xca, 0x78, 0xf0, 0xf2,
	0xca, 0x34, 0xf1, 0xff, 0xca, 0x03, 0x3c, 0xf0, 0xca, 0x00, 0x35, 0xff,
	0xca, 0x02, 0x78, 0xff, 0xca, 0x25, 0xf0, 0xf3, 0xca, 0x12, 0xf0, 0x79,
	0xca, 0x01, 0xe1, 0x35, 0xca, 0x00, 0x4a, 0x78, 0xc2};

const u8 tile_m_16x16_15[4 * 16] = {0x07, 0x3c, 0xe1, 0x00, 0x78, 0xf0, 0xf0,
	0x08, 0x16, 0xf0, 0xf0, 0x84, 0x34, 0xf0, 0xf0, 0x84, 0x69, 0xf0, 0xf0,
	0x84, 0x16, 0xf0, 0xff, 0x84, 0x34, 0xff, 0xff, 0xca, 0x7b, 0xff, 0xff,
	0xed, 0xf7, 0xff, 0xfe, 0xfe, 0xf0, 0xff, 0xfe, 0xf0, 0x1e, 0xfd, 0xfe,
	0x0f, 0xf0, 0xfd, 0xfe, 0x08, 0x7a, 0xf3, 0xed, 0x00, 0x35, 0xff, 0xed,
	0x00, 0x34, 0xff, 0xca, 0x00, 0x03, 0xf0, 0x84, 0x00};

const u8 tile_m_16x16_16[4 * 16] = {0x00, 0x07, 0x0c, 0x00, 0x00, 0x78, 0xc2,
	0x00, 0x01, 0xf0, 0xe1, 0x00, 0x12, 0xf0, 0xf0, 0x08, 0x12, 0xf0, 0xf0,
	0x08, 0x34, 0xf0, 0xf0, 0x86, 0x79, 0xf0, 0xf1, 0xe1, 0xf7, 0xf9, 0xf5,
	0xfe, 0xf1, 0xf9, 0xf5, 0xf8, 0x1e, 0xfb, 0xfd, 0xcb, 0x12, 0xfe, 0xf5,
	0x84, 0x12, 0xfc, 0xfb, 0x84, 0x12, 0xf9, 0xf9, 0x84, 0x01, 0xf7, 0xfe,
	0x84, 0x01, 0xf3, 0xfe, 0x08, 0x00, 0x3c, 0xe1, 0x00};

const u8 tile_m_16x16_17[4 * 16] = {0x00, 0x78, 0xc3, 0x3c, 0x01, 0xf0, 0xf0,
	0xe1, 0x12, 0xf0, 0xf0, 0x86, 0x12, 0xf0, 0xf0, 0xe1, 0x3c, 0xf0, 0xf0,
	0x0f, 0xf0, 0xf0, 0xf0, 0xf0, 0xf7, 0xfe, 0xf1, 0xfe, 0x7b, 0xff, 0xff,
	0xed, 0x35, 0xf7, 0xff, 0xc2, 0x12, 0xf7, 0xff, 0x84, 0x01, 0xf7, 0xfb,
	0x87, 0x01, 0xf7, 0xfb, 0xf0, 0x00, 0x7b, 0xfc, 0xed, 0x00, 0x7b, 0xff,
	0xca, 0x00, 0x34, 0xff, 0xc2, 0x00, 0x12, 0xf0, 0x0c};

const u8 tile_m_16x16_18[4 * 16] = {0x03, 0x3c, 0xe1, 0x08, 0x34, 0xf1, 0xf4,
	0x08, 0x12, 0xf0, 0xf8, 0x84, 0x34, 0xf3, 0xf6, 0x84, 0x03, 0xf0, 0xf8,
	0x84, 0x12, 0xf2, 0xf2, 0x84, 0x34, 0xfc, 0xf9, 0xc2, 0x7b, 0xfe, 0xfb,
	0xed, 0xf7, 0xfe, 0xfb, 0xfe, 0xf0, 0xff, 0xfe, 0xf0, 0x1e, 0xfb, 0xfe,
	0x0f, 0x78, 0xfb, 0xf6, 0x08, 0x7a, 0xfc, 0xe1, 0x00, 0x35, 0xff, 0xed,
	0x00, 0x34, 0xff, 0xc2, 0x00, 0x03, 0xf0, 0x84, 0x00};

const u8 tile_m_16x16_19[4 * 16] = {0x00, 0x07, 0x0c, 0x00, 0x00, 0x78, 0xc2,
	0x00, 0x01, 0xf2, 0xe9, 0x00, 0x12, 0xf1, 0xf0, 0x08, 0x12, 0xf6, 0xfc,
	0x08, 0x34, 0xf1, 0xf0, 0x86, 0x79, 0xf4, 0xf5, 0xe1, 0xf7, 0xf9, 0xf3,
	0xfe, 0xf0, 0xfd, 0xf7, 0xf8, 0x1e, 0xff, 0xff, 0xcb, 0x12, 0xf7, 0xfd,
	0x84, 0x12, 0xf6, 0xfd, 0x84, 0x12, 0xf8, 0xf3, 0x84, 0x01, 0xf7, 0xfe,
	0x84, 0x01, 0xf3, 0xfe, 0x08, 0x00, 0x3c, 0xe1, 0x00};

const u8 tile_m_16x16_20[4 * 16] = {0x00, 0x78, 0xc3, 0x0c, 0x01, 0xf2, 0xf8,
	0xc2, 0x12, 0xf1, 0xf0, 0x84, 0x12, 0xf6, 0xfc, 0xc2, 0x3c, 0xf1, 0xf0,
	0x0f, 0xf0, 0xf4, 0xf4, 0xf0, 0xf7, 0xf9, 0xf3, 0xfe, 0x7b, 0xfd, 0xf7,
	0xed, 0x35, 0xfd, 0xf7, 0xc2, 0x12, 0xf7, 0xff, 0x84, 0x01, 0xf7, 0xfd,
	0x86, 0x01, 0xf6, 0xfd, 0xe1, 0x00, 0x78, 0xf3, 0xe5, 0x00, 0x7b, 0xff,
	0xca, 0x00, 0x34, 0xff, 0xc2, 0x00, 0x12, 0xf0, 0x0c};

const u8 tile_m_16x16_21[4 * 16] = {0x00, 0x16, 0xf0, 0x08, 0x00, 0x78, 0xf0,
	0x84, 0x01, 0xf0, 0xf7, 0xc2, 0x16, 0xf0, 0xf8, 0xca, 0x78, 0xf0, 0xfb,
	0xe5, 0x1e, 0xf1, 0xfc, 0xca, 0xf0, 0xf6, 0xf6, 0xc2, 0x3d, 0xff, 0xf8,
	0xca, 0x7b, 0xfd, 0xfe, 0xe9, 0xf0, 0xf1, 0xfa, 0xfa, 0x0f, 0xf1, 0xf7,
	0xfe, 0x01, 0x79, 0xf7, 0xf6, 0x12, 0xf2, 0xf8, 0xe9, 0x01, 0xf7, 0xff,
	0xca, 0x00, 0x79, 0xfe, 0x84, 0x00, 0x16, 0xf0, 0x08};

const u8 tile_m_16x16_22[4 * 16] = {0x07, 0x3c, 0xf0, 0x08, 0x78, 0xf0, 0xf7,
	0x84, 0x1e, 0xf0, 0xf8, 0xca, 0xf0, 0xf0, 0xfb, 0xe5, 0x78, 0xf1, 0xfc,
	0xca, 0xf0, 0xfa, 0xf6, 0xc2, 0x0f, 0xf7, 0xf8, 0xca, 0x12, 0xfd, 0xfe,
	0xe9, 0x35, 0xf1, 0xfa, 0xfa, 0x78, 0xf1, 0xf7, 0xfe, 0x07, 0x79, 0xf7,
	0xf6, 0x25, 0xf3, 0xf8, 0xe9, 0x34, 0xf7, 0xff, 0x86, 0x12, 0xff, 0xff,
	0x84, 0x01, 0xf7, 0xfe, 0x08, 0x00, 0x78, 0xe1, 0x00};

const u8 tile_m_16x16_23[4 * 16] = {0x34, 0xf0, 0xf0, 0x08, 0x07, 0xf0, 0xf0,
	0x84, 0x78, 0xf0, 0xf6, 0xc2, 0x3c, 0xf0, 0xf8, 0xca, 0xf0, 0xb5, 0xfb,
	0xe5, 0x0f, 0x3c, 0xfc, 0xca, 0x00, 0x7a, 0xf6, 0xc2, 0x01, 0xf3, 0xf8,
	0xca, 0x01, 0xf7, 0xfe, 0xe9, 0x12, 0xfd, 0xfa, 0xfa, 0x3c, 0xf3, 0xf7,
	0xfe, 0x87, 0x7b, 0xf7, 0xf6, 0x78, 0xf5, 0xf8, 0xe9, 0x35, 0xff, 0xff,
	0x86, 0x12, 0xf7, 0xfc, 0x08, 0x01, 0x78, 0xc3, 0x00};

const u8 tile_m_16x16_24[4 * 16] = {0x01, 0xf0, 0xf0, 0xc2, 0x12, 0xf0, 0xf0,
	0x0e, 0x34, 0xf6, 0xf0, 0xe1, 0x35, 0xf1, 0xf0, 0xc3, 0x7a, 0xfd, 0xda,
	0xf0, 0x35, 0xf3, 0xc3, 0x0f, 0x34, 0xf6, 0xe5, 0x00, 0x35, 0xf1, 0xfc,
	0x08, 0x79, 0xf7, 0xfe, 0x08, 0xf5, 0xf5, 0xfb, 0x84, 0xf7, 0xfe, 0xfc,
	0xc3, 0xf6, 0xfe, 0xed, 0x1e, 0x79, 0xf1, 0xfa, 0xe1, 0x16, 0xff, 0xff,
	0xca, 0x01, 0xf3, 0xfe, 0x84, 0x00, 0x3c, 0xe1, 0x08};

const u8 tile_m_16x16_25[4 * 16] = {0x01, 0xf0, 0xc3, 0x0e, 0x12, 0xfe, 0xf0,
	0xe1, 0x35, 0xf1, 0xf0, 0x87, 0x7a, 0xfd, 0xf0, 0xf0, 0x35, 0xf3, 0xf8,
	0xe1, 0x34, 0xf6, 0xf5, 0xf0, 0x35, 0xf1, 0xfe, 0x0f, 0x79, 0xf7, 0xfb,
	0x84, 0xf5, 0xf5, 0xf8, 0xca, 0xf7, 0xfe, 0xf8, 0xe1, 0xf6, 0xfe, 0xe9,
	0x0e, 0x79, 0xf1, 0xfc, 0x4a, 0x16, 0xff, 0xfe, 0xc2, 0x12, 0xff, 0xff,
	0x84, 0x01, 0xf7, 0xfe, 0x08, 0x00, 0x78, 0xe1, 0x00};

const u8 tile_m_16x16_26[4 * 16] = {0x01, 0xf0, 0x86, 0x00, 0x12, 0xf0, 0xe1,
	0x00, 0x34, 0xfe, 0xf0, 0x08, 0x35, 0xf1, 0xf0, 0x86, 0x7a, 0xfd, 0xf0,
	0xe1, 0x35, 0xf3, 0xf8, 0x87, 0x34, 0xf6, 0xf6, 0xf0, 0x35, 0xf1, 0xff,
	0xcb, 0x79, 0xf7, 0xfb, 0xed, 0xf5, 0xf5, 0xf8, 0xf0, 0xf7, 0xfe, 0xf8,
	0x0f, 0xf6, 0xfe, 0xe9, 0x08, 0x79, 0xf1, 0xf4, 0x84, 0x35, 0xff, 0xfe,
	0x08, 0x12, 0xf7, 0xe9, 0x00, 0x01, 0xf0, 0x86, 0x00};

const u8 tile_nm_16x16_00[4 * 16] = {0x00, 0x00, 0x00, 0x00, 0x07, 0x05, 0x0b,
	0x06, 0x07, 0x07, 0x0a, 0x0e, 0x07, 0x07, 0x0a, 0x0e, 0x03, 0x00, 0x00,
	0x0e, 0x07, 0x11, 0xcc, 0x00, 0x07, 0x22, 0x66, 0x0e, 0x00, 0x00, 0xee,
	0x0e, 0x07, 0x22, 0xee, 0x0e, 0x07, 0x00, 0x44, 0x00, 0x07, 0x00, 0x00,
	0x0e, 0x00, 0x00, 0x00, 0x0e, 0x07, 0x0b, 0x0b, 0x06, 0x07, 0x0b, 0x0b,
	0x08, 0x07, 0x0b, 0x0b, 0x06, 0x00, 0x00, 0x00, 0x00};

const u8 tile_nm_16x16_01[4 * 16] = {0x00, 0x00, 0x00, 0x00, 0x0b, 0x0f, 0x07,
	0x07, 0x0b, 0x0d, 0x07, 0x06, 0x0b, 0x0b, 0x00, 0x07, 0x0b, 0x0f, 0x07,
	0x07, 0x00, 0x0f, 0x07, 0x00, 0x0e, 0x0f, 0x07, 0x07, 0x0e, 0x00, 0x07,
	0x07, 0x0e, 0x0d, 0x0f, 0x07, 0x0e, 0x0d, 0x0b, 0x07, 0x00, 0x05, 0x0f,
	0x07, 0x07, 0x00, 0x00, 0x00, 0x07, 0x07, 0x0d, 0x0f, 0x07, 0x07, 0x0d,
	0x0f, 0x07, 0x05, 0x0d, 0x0f, 0x00, 0x00, 0x00, 0x00};

const u8 tile_nm_16x16_02[4 * 16] = {0x07, 0x0e, 0x0e, 0x00, 0x07, 0x0e, 0x0e,
	0x0e, 0x07, 0x06, 0x0e, 0x0e, 0x00, 0x00, 0x0e, 0x0e, 0x07, 0x0e, 0x0e,
	0x0e, 0x07, 0x0e, 0x0e, 0x0e, 0x07, 0x0e, 0x0e, 0x0e, 0x06, 0x0e, 0x00,
	0x00, 0x07, 0x0e, 0x07, 0x0e, 0x03, 0x0e, 0x07, 0x0e, 0x00, 0x00, 0x07,
	0x0c, 0x07, 0x0b, 0x07, 0x0e, 0x07, 0x0b, 0x07, 0x0e, 0x07, 0x0b, 0x06,
	0x00, 0x07, 0x08, 0x00, 0x0e, 0x07, 0x0e, 0x0e, 0x0e};

const u8 tile_nm_16x16_03[4 * 16] = {0x00, 0x00, 0x00, 0x00, 0x01, 0x0d, 0x0b,
	0x08, 0x0d, 0x0d, 0x0b, 0x09, 0x0d, 0x0d, 0x08, 0x01, 0x0c, 0x01, 0x0b,
	0x0d, 0x0d, 0x0d, 0x0b, 0x0d, 0x0d, 0x0c, 0x03, 0x0d, 0x01, 0x0c, 0x00,
	0x00, 0x0d, 0x0d, 0x0f, 0x0b, 0x0d, 0x0d, 0x0f, 0x0b, 0x0c, 0x01, 0x0f,
	0x0b, 0x0c, 0x00, 0x00, 0x03, 0x0d, 0x0f, 0x07, 0x0b, 0x0d, 0x0f, 0x07,
	0x0b, 0x0d, 0x0f, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00};

const u8 tile_nm_16x16_04[4 * 16] = {0x00, 0x01, 0x0f, 0x0e, 0x07, 0x0d, 0x0f,
	0x0e, 0x07, 0x0d, 0x0f, 0x0e, 0x07, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x07,
	0x0c, 0x03, 0x0f, 0x07, 0x0c, 0x03, 0x0f, 0x07, 0x0c, 0x01, 0x00, 0x07,
	0x0c, 0x07, 0x0e, 0x00, 0x00, 0x07, 0x0e, 0x0f, 0x06, 0x07, 0x0e, 0x0f,
	0x07, 0x07, 0x0e, 0x0f, 0x06, 0x00, 0x00, 0x00, 0x06, 0x03, 0x09, 0x0f,
	0x06, 0x03, 0x0b, 0x0f, 0x07, 0x03, 0x08, 0x00, 0x00};

const u8 tile_nm_16x16_05[4 * 16] = {0x09, 0x00, 0x00, 0x02, 0x04, 0x03, 0xcc,
	0x00, 0x00, 0x0c, 0x33, 0x01, 0x09, 0x0c, 0x13, 0x88, 0x03, 0x0e, 0x07,
	0xcc, 0x02, 0x0f, 0x1f, 0x44, 0x03, 0x07, 0x2e, 0xcd, 0x09, 0x03, 0x4c,
	0x88, 0x01, 0x01, 0x88, 0x89, 0x01, 0x0d, 0xbb, 0x88, 0x08, 0x07, 0x6e,
	0x00, 0x00, 0x05, 0xaa, 0x00, 0x09, 0x07, 0x6e, 0x88, 0x03, 0x02, 0x44,
	0xcc, 0x0e, 0x0a, 0x45, 0x37, 0x02, 0x08, 0x01, 0x44};

const u8 tile_nm_16x16_06[4 * 16] = {0x07, 0x0f, 0x0f, 0x06, 0x05, 0x0f, 0x0f,
	0x0e, 0x07, 0x08, 0x00, 0x00, 0x00, 0x03, 0x0f, 0x0c, 0x03, 0x0f, 0x0f,
	0x04, 0x00, 0x00, 0x0f, 0x04, 0x07, 0x0e, 0x00, 0x00, 0x05, 0x0f, 0x0f,
	0x0e, 0x05, 0x0f, 0x0e, 0x00, 0x07, 0x08, 0x00, 0x0c, 0x00, 0x07, 0x0f,
	0x0c, 0x03, 0x0f, 0x0f, 0x04, 0x02, 0x0f, 0x0f, 0x0c, 0x00, 0x00, 0x07,
	0x04, 0x07, 0x0f, 0x00, 0x00, 0x05, 0x0f, 0x0f, 0x0e};

const u8 tile_nm_16x16_07[4 * 16] = {0x00, 0x00, 0x00, 0x00, 0x0c, 0x03, 0x0e,
	0x03, 0x05, 0x0a, 0x06, 0x0a, 0x0d, 0x0b, 0x0e, 0x0b, 0x0d, 0x0b, 0x0e,
	0x0b, 0x09, 0x0b, 0x04, 0x0b, 0x0d, 0x0b, 0x0e, 0x0b, 0x0d, 0x0b, 0x0c,
	0x0b, 0x09, 0x0b, 0x0d, 0x0b, 0x0b, 0x0b, 0x0d, 0x09, 0x0b, 0x09, 0x0d,
	0x0d, 0x0b, 0x0d, 0x05, 0x0d, 0x0a, 0x0d, 0x0d, 0x05, 0x0b, 0x0d, 0x0d,
	0x0d, 0x08, 0x01, 0x0c, 0x01, 0x00, 0x00, 0x00, 0x00};

const u8 tile_nm_16x16_08[4 * 16] = {0x00, 0x00, 0x00, 0x00, 0x0c, 0x03, 0x0e,
	0x03, 0x05, 0x0a, 0x06, 0x0a, 0x0d, 0x0b, 0x0e, 0x0b, 0x0d, 0x0b, 0x0e,
	0x0b, 0x09, 0x0b, 0x04, 0x0b, 0x0d, 0x0b, 0x0e, 0x0b, 0x0d, 0x0b, 0x0c,
	0x0b, 0x09, 0x0b, 0x0d, 0x0b, 0x0b, 0x0b, 0x0d, 0x09, 0x0b, 0x09, 0x0d,
	0x0d, 0x0b, 0x0d, 0x05, 0x0d, 0x0a, 0x0d, 0x0d, 0x05, 0x0b, 0x0d, 0x0d,
	0x0d, 0x08, 0x01, 0x0c, 0x01, 0x00, 0x00, 0x00, 0x00};

const u8 tile_nm_16x16_09[4 * 16] = {0x00, 0x00, 0x00, 0x00, 0x01, 0x0d, 0x0b,
	0x08, 0x0c, 0x00, 0x08, 0x09, 0x04, 0x04, 0x08, 0x01, 0x04, 0x00, 0x0b,
	0x0d, 0x05, 0x0c, 0x08, 0x05, 0x0c, 0x04, 0x00, 0x05, 0x00, 0x04, 0x00,
	0x00, 0x0c, 0x05, 0x0f, 0x00, 0x05, 0x04, 0x00, 0x08, 0x0c, 0x00, 0x00,
	0x08, 0x04, 0x00, 0x00, 0x00, 0x05, 0x0f, 0x03, 0x08, 0x04, 0x01, 0x00,
	0x08, 0x04, 0x01, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00};

const u8 tile_nm_16x16_10[4 * 16] = {0x00, 0x00, 0x0f, 0x0e, 0x07, 0x0c, 0x00,
	0x02, 0x00, 0x04, 0x00, 0x02, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x03,
	0x0c, 0x03, 0x0f, 0x00, 0x04, 0x00, 0x01, 0x00, 0x04, 0x01, 0x00, 0x05,
	0x04, 0x03, 0x0e, 0x00, 0x00, 0x04, 0x02, 0x0f, 0x06, 0x00, 0x02, 0x01,
	0x03, 0x05, 0x06, 0x01, 0x02, 0x00, 0x00, 0x00, 0x02, 0x01, 0x09, 0x0f,
	0x02, 0x00, 0x0a, 0x01, 0x03, 0x02, 0x08, 0x00, 0x00};

const u8 tile_nm_16x16_11[4 * 16] = {0x01, 0x00, 0x08, 0x0b, 0x03, 0x0e, 0x00,
	0x00, 0x04, 0x07, 0x08, 0x08, 0x08, 0x07, 0x0f, 0x0e, 0x08, 0x06, 0x0f,
	0x0e, 0x09, 0x03, 0x0e, 0x0e, 0x09, 0x0b, 0x0f, 0x0d, 0x01, 0x0a, 0x0b,
	0x0c, 0x04, 0x0e, 0x0f, 0x0e, 0x04, 0x04, 0x03, 0x0a, 0x00, 0x08, 0x03,
	0x0c, 0x08, 0x00, 0x01, 0x09, 0x08, 0x0c, 0x04, 0x03, 0x08, 0x0e, 0x06,
	0x01, 0x08, 0x04, 0x00, 0x01, 0x06, 0x00, 0x01, 0x03};

const u8 tile_nm_16x16_12[4 * 16] = {0x70, 0xb0, 0x70, 0xb0, 0x50, 0x50, 0x50,
	0x50, 0x20, 0xa0, 0x20, 0xa0, 0x80, 0x20, 0x80, 0x20, 0x20, 0x90, 0x20,
	0x90, 0x40, 0x20, 0x40, 0x20, 0x00, 0x80, 0x00, 0x80, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x40, 0x00, 0x40, 0x20, 0x00, 0x20, 0x00, 0x00, 0x90, 0x00,
	0x90, 0xa0, 0x00, 0xa0, 0x00, 0x50, 0x40, 0x50, 0x40, 0x00, 0xa0, 0x00,
	0xa0, 0xb0, 0xd0, 0xb0, 0xd0, 0xf0, 0x70, 0xf0, 0x70};

const u8 tile_nm_16x16_13[4 * 16] = {0xc0, 0xa0, 0x10, 0x70, 0xa0, 0x40, 0x20,
	0x90, 0xd0, 0x00, 0x10, 0x70, 0xa0, 0x40, 0x40, 0xf0, 0xe0, 0x90, 0x10,
	0x50, 0xd0, 0x00, 0x20, 0x70, 0xa0, 0xa0, 0x10, 0xa0, 0xe0, 0x40, 0x20,
	0xb0, 0xc0, 0xa0, 0x10, 0x70, 0xa0, 0x40, 0x20, 0x90, 0xd0, 0x00, 0x10,
	0x70, 0xa0, 0x40, 0x40, 0xf0, 0xe0, 0x90, 0x10, 0x50, 0xd0, 0x00, 0x20,
	0x70, 0xa0, 0xa0, 0x10, 0xa0, 0xe0, 0x40, 0x20, 0xb0};

const u8 tile_nm_16x16_14[4 * 16] = {0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00,
	0x10, 0x20, 0x10, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x10,
	0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x90, 0x00, 0x80, 0x00, 0x00, 0x00,
	0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x40, 0x80, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x80,
	0x80, 0x00, 0x00, 0x00, 0x20, 0x10, 0x40, 0x00, 0x00};

const u8 tile_nm_16x16_15[4 * 16] = {0x50, 0x10, 0x40, 0x90, 0x80, 0x60, 0x20,
	0x40, 0x00, 0x00, 0x00, 0x10, 0x80, 0x00, 0x00, 0x80, 0x00, 0x20, 0x80,
	0x00, 0x80, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x10, 0x80, 0x40, 0x40,
	0x40, 0x00, 0x00, 0x20, 0x00, 0xc0, 0x20, 0x80, 0x00, 0x00, 0x10, 0x00,
	0x10, 0x80, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x10, 0x80, 0x00, 0x20,
	0x00, 0x50, 0x10, 0x00, 0x10, 0x00, 0x40, 0x00, 0x40};

const u8 tile_nm_16x16_16[4 * 16] = {0xd0, 0xb0, 0xe0, 0xd0, 0xd0, 0xb0, 0xe0,
	0xd0, 0x10, 0x80, 0x00, 0x00, 0xd0, 0xb0, 0x60, 0xf0, 0xc0, 0x00, 0x00,
	0xf0, 0x10, 0xb0, 0xc0, 0x00, 0xd0, 0xb0, 0xd0, 0xd0, 0xd0, 0xb0, 0xd0,
	0xd0, 0x00, 0x30, 0xd0, 0xc0, 0xf0, 0xb0, 0xc0, 0x10, 0xf0, 0x80, 0x10,
	0xd0, 0xf0, 0xb0, 0x50, 0xd0, 0xf0, 0xb0, 0x40, 0x10, 0x00, 0x30, 0x60,
	0xc0, 0xd0, 0x80, 0x00, 0xd0, 0xd0, 0xb0, 0xe0, 0xd0};

const u8 tile_nm_16x16_17[4 * 16] = {0xf0, 0x20, 0xf0, 0x00, 0xf0, 0x00, 0xf0,
	0x20, 0xf0, 0x40, 0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x40, 0x00, 0xf0, 0x00,
	0xf0, 0x00, 0xf0, 0x20, 0xf0, 0x50, 0xf0, 0x40, 0xf0, 0x00, 0xf0, 0x10,
	0xf0, 0xf0, 0x00, 0xf0, 0x20, 0xf0, 0x20, 0xf0, 0x00, 0xf0, 0x00, 0xf0,
	0x40, 0xf0, 0x40, 0xf0, 0x00, 0x00, 0xf0, 0x00, 0xf0, 0x20, 0xf0, 0x00,
	0xf0, 0x40, 0xf0, 0x50, 0xf0, 0x10, 0xf0, 0x00, 0xf0};

const u8 tile_nm_16x16_18[4 * 16] = {0x00, 0x80, 0x40, 0x00, 0xf0, 0x70, 0xa0,
	0xf0, 0xf0, 0x70, 0xb0, 0xf0, 0x00, 0x80, 0x40, 0x00, 0xb0, 0xd0, 0xd0,
	0xf0, 0xb0, 0xf0, 0xd0, 0x70, 0xc0, 0x10, 0x30, 0x70, 0xe0, 0xf0, 0xd0,
	0x20, 0xe0, 0xb0, 0x90, 0xf0, 0x80, 0xf0, 0x60, 0x00, 0x70, 0x00, 0x70,
	0xf0, 0x50, 0xf0, 0x70, 0xf0, 0x70, 0xf0, 0x40, 0x00, 0x80, 0x00, 0xb0,
	0xf0, 0xb0, 0xf0, 0xa0, 0xf0, 0xb0, 0xf0, 0xb0, 0xf0};

const u8 tile_nm_16x16_19[4 * 16] = {0xf0, 0x70, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
	0xf0, 0x00, 0x00, 0x00, 0x00, 0x40, 0xb0, 0xf0, 0xf0, 0xf0, 0xf0, 0x80,
	0xb0, 0xf0, 0xf0, 0xf0, 0xf0, 0x00, 0x00, 0x10, 0xf0, 0xf0, 0xf0, 0xe0,
	0x00, 0xf0, 0xf0, 0x70, 0xf0, 0xa0, 0x70, 0xf0, 0xd0, 0xf0, 0xf0, 0xf0,
	0xf0, 0x00, 0x00, 0x00, 0x00, 0xb0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
	0xf0, 0xf0, 0xb0, 0xf0, 0xc0, 0x00, 0x00, 0x00, 0x00};

const u8 tile_nm_16x16_20[4 * 16] = {0xd0, 0x70, 0xe0, 0xf0, 0xb0, 0x00, 0x20,
	0xf0, 0xf0, 0x70, 0x80, 0x10, 0xc0, 0xf0, 0xb0, 0xc0, 0x30, 0x70, 0x60,
	0xd0, 0xf0, 0xb0, 0x70, 0xd0, 0x70, 0xb0, 0x10, 0xb0, 0xe0, 0x00, 0xc0,
	0x70, 0xe0, 0xf0, 0xd0, 0x90, 0x00, 0xb0, 0xd0, 0xc0, 0xd0, 0xf0, 0xd0,
	0x50, 0x50, 0xc0, 0x30, 0xd0, 0x60, 0xd0, 0x70, 0xd0, 0xf0, 0x10, 0x70,
	0x10, 0x70, 0x70, 0x80, 0xe0, 0x80, 0xf0, 0xf0, 0x70};

const u8 tile_nm_16x16_21[4 * 16] = {0xf0, 0xf0, 0xf0, 0xf0, 0x40, 0x00, 0x80,
	0x80, 0x40, 0x20, 0x80, 0x90, 0x40, 0x40, 0xf0, 0x80, 0x40, 0x00, 0x80,
	0x80, 0xf0, 0x00, 0x80, 0xf0, 0x10, 0x00, 0x80, 0x80, 0x10, 0xf0, 0x80,
	0x80, 0x10, 0x20, 0x00, 0x80, 0x10, 0x20, 0x40, 0x80, 0xf0, 0xa0, 0x00,
	0x80, 0x80, 0xf0, 0xf0, 0xf0, 0x80, 0x80, 0x20, 0x00, 0x80, 0x80, 0x20,
	0x00, 0x80, 0xa0, 0x20, 0x00, 0xf0, 0xf0, 0xf0, 0xf0};

const u8 tile_nm_16x16_22[4 * 16] = {0xf0, 0xf0, 0xf0, 0xf0, 0x20, 0xa0, 0x70,
	0xe0, 0xf0, 0xf0, 0xd0, 0x30, 0x30, 0x30, 0x70, 0xf0, 0xf0, 0xf0, 0xf0,
	0xf0, 0xc0, 0x90, 0x20, 0xe0, 0xf0, 0xf0, 0xf0, 0xf0, 0x20, 0x90, 0xf0,
	0xf0, 0xf0, 0xe0, 0x60, 0x80, 0x20, 0x70, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
	0xf0, 0x00, 0xc0, 0xa0, 0x40, 0xf0, 0xf0, 0xf0, 0xf0, 0x90, 0x90, 0x70,
	0x40, 0xf0, 0xf0, 0xc0, 0xf0, 0x10, 0xa0, 0xb0, 0x90};

const u8 tile_nm_16x16_23[4 * 16] = {0x70, 0xb0, 0xd0, 0xf0, 0xf0, 0xf0, 0xf0,
	0xf0, 0xb0, 0xe0, 0xf0, 0x60, 0xf0, 0x70, 0xf0, 0xf0, 0xf0, 0xf0, 0x50,
	0xf0, 0xe0, 0xf0, 0xf0, 0xd0, 0xf0, 0xd0, 0xf0, 0xf0, 0x70, 0xf0, 0xf0,
	0xf0, 0xe0, 0x70, 0xb0, 0x70, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xd0, 0xf0,
	0xb0, 0x70, 0xf0, 0xb0, 0xf0, 0xe0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
	0xf0, 0xb0, 0xd0, 0xf0, 0x70, 0xf0, 0xf0, 0xb0, 0xd0};

const u8 tile_nm_16x16_24[4 * 16] = {0x00, 0x00, 0x00, 0x00, 0x09, 0x01, 0x09,
	0x01, 0x0a, 0x00, 0x0a, 0x01, 0x08, 0x0a, 0x08, 0x0b, 0x0c, 0x08, 0x0c,
	0x09, 0x0b, 0x04, 0x0b, 0x05, 0x0a, 0x00, 0x0a, 0x01, 0x0f, 0x0e, 0x0f,
	0x0f, 0x00, 0x00, 0x08, 0x00, 0x09, 0x01, 0x00, 0x01, 0x0a, 0x00, 0xcc,
	0x33, 0x08, 0x0a, 0x6e, 0x67, 0x0c, 0x08, 0x66, 0x67, 0x0b, 0x04, 0x33,
	0xcd, 0x0a, 0x00, 0x15, 0x8b, 0x0f, 0x0e, 0x3b, 0xcd};

const u8 tile_nm_16x16_25[4 * 16] = {0x00, 0x00, 0x00, 0x00, 0x02, 0x03, 0x02,
	0x03, 0x04, 0x01, 0x04, 0x01, 0x01, 0x05, 0x01, 0x05, 0x09, 0x01, 0x09,
	0x01, 0x06, 0x09, 0x06, 0x09, 0x04, 0x01, 0x04, 0x01, 0x0f, 0x0d, 0x0f,
	0x0d, 0x00, 0x00, 0x00, 0x01, 0x02, 0x03, 0x02, 0x02, 0x04, 0x01, 0x04,
	0x01, 0x01, 0x05, 0x01, 0x05, 0x09, 0x01, 0x09, 0x00, 0x06, 0x09, 0x06,
	0x08, 0x04, 0x01, 0x04, 0x00, 0x0f, 0x0d, 0x0f, 0x0d};

const u8 tile_nm_16x16_26[4 * 16] = {0x00, 0x00, 0x00, 0x00, 0x09, 0x01, 0x09,
	0x01, 0x0a, 0x00, 0x0a, 0x00, 0x08, 0x0a, 0x08, 0x0a, 0x0c, 0x08, 0x0c,
	0x08, 0x0b, 0x04, 0x0b, 0x04, 0x0a, 0x00, 0x0a, 0x00, 0x0f, 0x0e, 0x0f,
	0x0e, 0x08, 0x01, 0x00, 0x00, 0x00, 0x00, 0x09, 0x01, 0xcc, 0x33, 0x0a,
	0x00, 0x6e, 0x67, 0x08, 0x0a, 0x66, 0x66, 0x0c, 0x08, 0x33, 0xcc, 0x0b,
	0x04, 0x15, 0x8a, 0x0a, 0x00, 0x3b, 0xcd, 0x0f, 0x0e};

const u8 tile_nm_16x16_27[4 * 16] = {0x7f, 0xef, 0x00, 0x00, 0xcc, 0x33, 0x09,
	0x01, 0xaa, 0x55, 0x0a, 0x00, 0xaa, 0x55, 0x08, 0x0a, 0xff, 0xff, 0x0c,
	0x08, 0x66, 0x66, 0x0b, 0x04, 0x33, 0xcc, 0x0a, 0x00, 0x15, 0x8a, 0x0f,
	0x0e, 0x08, 0x01, 0x00, 0x00, 0x09, 0x01, 0x09, 0x01, 0x0a, 0x00, 0x0a,
	0x00, 0x08, 0x0a, 0x08, 0x0a, 0x0c, 0x08, 0x0c, 0x08, 0x0b, 0x04, 0x0b,
	0x04, 0x0a, 0x00, 0x0a, 0x00, 0x0f, 0x0e, 0x0f, 0x0e};

const u8 tile_nm_16x16_28[4 * 16] = {0x00, 0x00, 0x7f, 0xef, 0x09, 0x01, 0xcc,
	0x33, 0x0a, 0x00, 0xaa, 0x55, 0x08, 0x0a, 0xaa, 0x55, 0x0c, 0x08, 0xff,
	0xff, 0x0b, 0x04, 0x66, 0x66, 0x0a, 0x00, 0x33, 0xcc, 0x0f, 0x0e, 0x15,
	0x8a, 0x00, 0x00, 0x08, 0x01, 0x09, 0x01, 0x09, 0x01, 0x0a, 0x00, 0x0a,
	0x00, 0x08, 0x0a, 0x08, 0x0a, 0x0c, 0x08, 0x0c, 0x08, 0x0b, 0x04, 0x0b,
	0x04, 0x0a, 0x00, 0x0a, 0x00, 0x0f, 0x0e, 0x0f, 0x0e};

const u8 tile_nm_16x16_29[4 * 16] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x11,
	0x00, 0x00, 0xee, 0x33, 0x88, 0x00, 0xbb, 0x66, 0x88, 0x00, 0x99, 0xcc,
	0x88, 0x00, 0xaa, 0xaa, 0x88, 0x00, 0xdd, 0xdd, 0x88, 0x00, 0x77, 0xff,
	0x00, 0x00, 0xbb, 0x66, 0x88, 0x11, 0xbb, 0xee, 0xcc, 0x11, 0x22, 0x22,
	0x44, 0x00, 0xaa, 0xaa, 0x88, 0x00, 0x11, 0xcc, 0x00, 0x33, 0x44, 0x11,
	0x66, 0x55, 0x11, 0xcc, 0x55, 0x99, 0x33, 0xee, 0x44};

const u8 tile_nm_16x16_30[4 * 16] = {0x11, 0x33, 0xee, 0x44, 0x11, 0x33, 0xee,
	0x44, 0x11, 0x33, 0xee, 0x44, 0x11, 0x33, 0x66, 0x44, 0x11, 0x33, 0x66,
	0x44, 0x11, 0x33, 0x66, 0x44, 0x11, 0x22, 0xaa, 0x44, 0x11, 0x11, 0xcc,
	0x44, 0x11, 0x33, 0xee, 0x44, 0x11, 0x33, 0xee, 0x44, 0x11, 0x33, 0xee,
	0x44, 0x11, 0x33, 0xee, 0x44, 0x11, 0x33, 0xee, 0x44, 0x11, 0x33, 0xee,
	0x44, 0x11, 0x33, 0x66, 0x44, 0x00, 0x00, 0x00, 0x00};

const u8 tile_nm_16x16_31[4 * 16] = {0x11, 0x33, 0xee, 0x44, 0x11, 0x33, 0xee,
	0x44, 0x11, 0x11, 0xcc, 0x44, 0x11, 0x00, 0x88, 0x44, 0x11, 0x00, 0x00,
	0x44, 0x11, 0x00, 0x00, 0x44, 0x11, 0x00, 0x00, 0x44, 0x11, 0x22, 0x22,
	0x44, 0x11, 0x33, 0x66, 0x44, 0x11, 0x33, 0x66, 0x44, 0x11, 0x33, 0x66,
	0x44, 0x11, 0x33, 0x66, 0x44, 0x11, 0x00, 0x00, 0x44, 0x00, 0x88, 0x00,
	0xaa, 0x22, 0x88, 0x00, 0xaa, 0x22, 0x88, 0x00, 0xaa};

const u8 tile_nm_16x16_32[4 * 16] = {0x00, 0x00, 0x00, 0x00, 0x02, 0x06, 0x00,
	0x04, 0x01, 0x0f, 0x02, 0x0e, 0x0c, 0x0d, 0x00, 0x00, 0x05, 0x09, 0x08,
	0x04, 0x03, 0x0f, 0x08, 0x00, 0x06, 0x0f, 0x08, 0x00, 0x04, 0x0e, 0x0c,
	0x00, 0x07, 0x0d, 0x0c, 0x00, 0x09, 0x08, 0x0d, 0x00, 0x00, 0x0d, 0x0e,
	0x09, 0x00, 0x07, 0x0e, 0x06, 0x00, 0x08, 0x06, 0x08, 0x00, 0x04, 0x0e,
	0x00, 0x03, 0x01, 0x02, 0x00, 0x0f, 0x0c, 0x02, 0x00};

const u8 tile_nm_16x16_33[4 * 16] = {0x0f, 0x0c, 0x07, 0x00, 0x0f, 0x08, 0x03,
	0x08, 0x0c, 0x09, 0x09, 0x08, 0x09, 0x0f, 0x0e, 0x0c, 0x01, 0x0d, 0x0f,
	0x04, 0x01, 0x0d, 0x0d, 0x0a, 0x00, 0x0b, 0x0e, 0x0c, 0x00, 0x0b, 0x06,
	0x0f, 0x00, 0x03, 0x0e, 0x0f, 0x00, 0x05, 0x0d, 0x0f, 0x00, 0x02, 0x03,
	0x0e, 0x02, 0x01, 0x0f, 0x0d, 0x00, 0x01, 0x0f, 0x0b, 0x00, 0x00, 0x0e,
	0x06, 0x01, 0x00, 0x05, 0x08, 0x00, 0x00, 0x03, 0x00};

const u8 tile_nm_16x16_34[4 * 16] = {0x02, 0x00, 0x06, 0x05, 0x00, 0x00, 0x04,
	0x03, 0x00, 0x00, 0x08, 0x0f, 0x00, 0x00, 0x01, 0x04, 0x00, 0x00, 0x03,
	0x00, 0x00, 0x00, 0x0c, 0x02, 0x00, 0x03, 0x08, 0x08, 0x02, 0x0f, 0x08,
	0x00, 0x03, 0x08, 0x08, 0x02, 0x06, 0x02, 0x00, 0x09, 0x0c, 0x08, 0x02,
	0x00, 0x02, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x02, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00};

const u8 tile_nm_16x16_35[4 * 16] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

const u8 tile_nm_16x16_36[4 * 16] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

const u8 tile_nm_16x16_37[4 * 16] = {0x80, 0x00, 0x00, 0xb0, 0xe0, 0x07, 0xcc,
	0x50, 0x00, 0x08, 0x33, 0x30, 0x01, 0x13, 0x4c, 0x98, 0x01, 0x07, 0xee,
	0xa8, 0x02, 0x17, 0x6e, 0x54, 0x82, 0x0e, 0xff, 0x54, 0x04, 0x0c, 0x77,
	0x22, 0x05, 0x0e, 0xff, 0xaa, 0x05, 0x0e, 0x7f, 0xaa, 0x85, 0x0f, 0xff,
	0xba, 0x05, 0x1f, 0x7f, 0xaa, 0x84, 0x0f, 0xff, 0x22, 0x04, 0x1f, 0x7f,
	0x76, 0x04, 0x0f, 0xff, 0x44, 0x04, 0x1f, 0x7f, 0x54};

const u8 tile_nm_16x16_38[4 * 16] = {0x84, 0x0f, 0xff, 0x54, 0x04, 0x1f, 0x7f,
	0x74, 0x00, 0x0f, 0xff, 0x54, 0x82, 0x17, 0x6e, 0x54, 0x02, 0x07, 0xee,
	0xdc, 0x80, 0x17, 0x6e, 0xd8, 0x02, 0x07, 0xee, 0xb8, 0x80, 0x00, 0x00,
	0x98, 0x82, 0x01, 0x00, 0xf8, 0x00, 0x00, 0x22, 0xb8, 0x60, 0x00, 0x00,
	0xd8, 0x81, 0x01, 0x22, 0xb8, 0xa0, 0x00, 0x00, 0xd0, 0x50, 0x04, 0xba,
	0xf0, 0xa0, 0xa0, 0xb0, 0xf0, 0x50, 0xf0, 0xb0, 0xb0};

const u8 tile_nm_16x16_39[4 * 16] = {0x80, 0x00, 0x00, 0xb0, 0xe0, 0x70, 0xc0,
	0x50, 0x00, 0x80, 0x30, 0x30, 0x10, 0x03, 0x0c, 0x90, 0x10, 0x04, 0x02,
	0xa0, 0x20, 0x04, 0x02, 0x50, 0xa0, 0x09, 0x0d, 0x50, 0x41, 0x03, 0x05,
	0x20, 0x41, 0x07, 0x06, 0x28, 0x41, 0x04, 0x0e, 0x28, 0xc1, 0x07, 0x0a,
	0x38, 0x41, 0x01, 0x0c, 0x28, 0xc1, 0x00, 0x00, 0x28, 0x40, 0x2a, 0x01,
	0x70, 0x40, 0x22, 0x01, 0x40, 0x11, 0xee, 0x01, 0x50};

const u8 tile_nm_16x16_40[4 * 16] = {0x80, 0x07, 0x01, 0x50, 0x41, 0x0f, 0x01,
	0x70, 0x01, 0x01, 0x01, 0x50, 0x80, 0x04, 0x02, 0x50, 0x20, 0x04, 0x02,
	0xd0, 0x80, 0x04, 0x02, 0xd0, 0x20, 0x07, 0x0e, 0xb0, 0x80, 0x00, 0x00,
	0x90, 0xa0, 0x01, 0x00, 0xf0, 0x00, 0x00, 0x02, 0xb0, 0x60, 0x00, 0x00,
	0xd0, 0x90, 0x01, 0x02, 0xb0, 0xa0, 0x00, 0x00, 0xd0, 0x50, 0x40, 0xb0,
	0xf0, 0xa0, 0xa0, 0xb0, 0xf0, 0x50, 0xf0, 0xb0, 0xb0};

const u8 tile_nm_16x16_41[4 * 16] = {0xc0, 0x00, 0x00, 0x00, 0x40, 0xee, 0xff,
	0xdd, 0xc0, 0xff, 0xbb, 0x33, 0x91, 0xee, 0xaa, 0xdd, 0x91, 0xff, 0xcc,
	0xdd, 0x91, 0xdd, 0xbb, 0xff, 0x33, 0xff, 0xbb, 0xff, 0x33, 0xff, 0x33,
	0xff, 0x11, 0x55, 0x11, 0x55, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x04, 0x0a,
	0x06, 0x40, 0x0f, 0x0f, 0x0f, 0x80, 0x04, 0x00, 0x00, 0x81, 0x0f, 0x0f,
	0x0f, 0x01, 0x0b, 0x09, 0x0f, 0x00, 0x00, 0x00, 0x00};

const u8 tile_nm_16x16_42[4 * 16] = {0x00, 0x00, 0x00, 0x10, 0xff, 0xff, 0xff,
	0x20, 0xff, 0x88, 0xff, 0x10, 0xdd, 0xdd, 0xbb, 0x98, 0xcc, 0x00, 0x33,
	0x98, 0xdd, 0xdd, 0xbb, 0x88, 0xff, 0x88, 0xff, 0xcc, 0xff, 0xff, 0xff,
	0xcc, 0xdd, 0x55, 0x55, 0x44, 0x00, 0x00, 0x00, 0x00, 0x05, 0x02, 0x0d,
	0x10, 0x0f, 0x0b, 0x0f, 0x30, 0x00, 0x00, 0x00, 0x10, 0x0f, 0x07, 0x0f,
	0x08, 0x0e, 0x07, 0x0f, 0x18, 0x00, 0x00, 0x00, 0x00};

const u8 tile_nm_16x16_43[4 * 16] = {0xe0, 0x40, 0x00, 0x00, 0xa0, 0xc1, 0x0f,
	0x0f, 0xa0, 0x81, 0x00, 0x00, 0xf0, 0x03, 0x00, 0x00, 0xd0, 0x02, 0x00,
	0x00, 0xa0, 0x06, 0x00, 0x00, 0xa0, 0x04, 0x00, 0x00, 0xa0, 0x07, 0x0f,
	0x00, 0x80, 0x07, 0x0f, 0x08, 0xa0, 0x07, 0x0f, 0x0e, 0xc0, 0x06, 0x0a,
	0x06, 0x40, 0x0f, 0x0f, 0x0f, 0x80, 0x04, 0x00, 0x00, 0x81, 0x0f, 0x0f,
	0x0f, 0x01, 0x0b, 0x09, 0x0f, 0x00, 0x00, 0x00, 0x00};

const u8 tile_nm_16x16_44[4 * 16] = {0x00, 0x00, 0x10, 0xf0, 0x0f, 0x0f, 0x0c,
	0xb0, 0x00, 0x00, 0x04, 0xf0, 0x00, 0x00, 0x06, 0x50, 0x00, 0x00, 0x02,
	0x20, 0x00, 0x00, 0x03, 0x10, 0x00, 0x00, 0x01, 0x20, 0x01, 0x0c, 0x0f,
	0x10, 0x01, 0x0c, 0x07, 0x20, 0x03, 0x0e, 0x07, 0x10, 0x05, 0x02, 0x05,
	0x30, 0x07, 0x0b, 0x07, 0x18, 0x00, 0x00, 0x00, 0x10, 0x07, 0x07, 0x0f,
	0x08, 0x0e, 0x07, 0x0f, 0x18, 0x00, 0x00, 0x00, 0x00};

const u8 tile_nm_16x16_45[4 * 16] = {0x80, 0x00, 0x10, 0x10, 0x22, 0x77, 0xcc,
	0x54, 0xb3, 0x33, 0xff, 0x54, 0x33, 0xbb, 0xff, 0x44, 0xb3, 0x77, 0x77,
	0xdc, 0xb3, 0xcc, 0x11, 0xcc, 0x33, 0xff, 0x77, 0xdc, 0x33, 0xff, 0x77,
	0xcc, 0x33, 0xff, 0xff, 0xdc, 0x33, 0xff, 0xff, 0xcc, 0x33, 0xff, 0xff,
	0xcc, 0x77, 0x11, 0x44, 0x66, 0x77, 0x55, 0x55, 0x66, 0x77, 0x33, 0x44,
	0xee, 0x77, 0x55, 0x55, 0xee, 0x77, 0xff, 0xff, 0xaa};

const u8 tile_nm_16x16_46[4 * 16] = {0x77, 0xff, 0xff, 0xee, 0x77, 0xff, 0xdd,
	0xaa, 0x55, 0xff, 0xdd, 0xee, 0x77, 0xff, 0xff, 0xee, 0x77, 0xff, 0xff,
	0xee, 0x22, 0xaa, 0xaa, 0xaa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x81, 0x05, 0x05, 0x18, 0x80, 0x0a, 0x0f, 0x18, 0x81, 0x07, 0x0f,
	0x18, 0x00, 0x00, 0x00, 0x00, 0x03, 0x0f, 0x0f, 0x1c, 0x01, 0x07, 0x0d,
	0x04, 0x01, 0x0d, 0x0f, 0x0c, 0x00, 0x00, 0x00, 0x00};

const u8 tile_nm_16x16_47[4 * 16] = {0xc0, 0x00, 0x00, 0x30, 0x01, 0x0f, 0x0f,
	0x18, 0x81, 0x00, 0x00, 0x18, 0xc1, 0x00, 0x00, 0x18, 0x01, 0x00, 0x00,
	0x18, 0x81, 0x00, 0x00, 0x18, 0x81, 0x00, 0x02, 0x18, 0x81, 0x07, 0x0e,
	0x18, 0x80, 0x00, 0x00, 0x18, 0x03, 0x00, 0x00, 0x18, 0x03, 0x0a, 0x00,
	0x08, 0x03, 0x0f, 0x00, 0x08, 0x07, 0x0b, 0x08, 0x08, 0x07, 0x09, 0x08,
	0x08, 0x06, 0x0a, 0x0e, 0x08, 0x07, 0x0f, 0x0c, 0x18};

const u8 tile_nm_16x16_48[4 * 16] = {0x07, 0x0f, 0x0a, 0x18, 0x07, 0x0f, 0x04,
	0x08, 0x06, 0x00, 0x08, 0x18, 0x00, 0x05, 0x00, 0x08, 0x01, 0x00, 0x00,
	0x38, 0x81, 0x0f, 0x0f, 0x18, 0x80, 0x04, 0x02, 0x00, 0x80, 0x0a, 0x05,
	0x08, 0x81, 0x05, 0x05, 0x18, 0x80, 0x0a, 0x0f, 0x18, 0x81, 0x07, 0x0f,
	0x18, 0x00, 0x00, 0x00, 0x00, 0x03, 0x0f, 0x0f, 0x1c, 0x01, 0x07, 0x0d,
	0x04, 0x01, 0x0d, 0x0f, 0x0c, 0x00, 0x00, 0x00, 0x00};

const u8 tile_nm_16x16_49[4 * 16] = {0x10, 0x00, 0x00, 0x90, 0x20, 0x50, 0xd0,
	0x40, 0x40, 0xa0, 0xf0, 0x20, 0x40, 0x00, 0x00, 0x10, 0x80, 0x0f, 0x1f,
	0x50, 0x81, 0x0f, 0x0d, 0x98, 0x81, 0x0f, 0x1f, 0x98, 0x03, 0x03, 0x04,
	0x4c, 0x03, 0x03, 0x04, 0xcc, 0x03, 0x05, 0x15, 0x5c, 0x03, 0x0f, 0x0f,
	0xcc, 0x03, 0x0f, 0x1f, 0x4c, 0x03, 0x07, 0x07, 0xcc, 0x03, 0x0f, 0x1f,
	0x4c, 0x02, 0x0a, 0x2a, 0xcc, 0x00, 0x04, 0x1b, 0x00};

const u8 tile_nm_16x16_50[4 * 16] = {0x00, 0x00, 0x00, 0x00, 0x40, 0x80, 0x08,
	0xd0, 0xa0, 0x81, 0x66, 0x30, 0x50, 0x02, 0x11, 0x88, 0x20, 0x04, 0x00,
	0x66, 0x40, 0x08, 0x00, 0x55, 0x41, 0x08, 0x00, 0xbb, 0x00, 0x06, 0x11,
	0x77, 0xc0, 0x01, 0x2a, 0xff, 0x00, 0x00, 0x55, 0xbb, 0x40, 0x00, 0x33,
	0x33, 0x40, 0x00, 0x33, 0xee, 0x00, 0x00, 0x33, 0xcc, 0x60, 0x00, 0x33,
	0x98, 0x30, 0x80, 0x33, 0x20, 0x60, 0xa0, 0x22, 0x00};

const u8 tile_nm_16x16_51[4 * 16] = {0x40, 0x00, 0x00, 0x50, 0xa0, 0x07, 0x0a,
	0x20, 0xc0, 0x07, 0x0a, 0x80, 0x50, 0x00, 0x04, 0x50, 0x00, 0x03, 0x0c,
	0x00, 0x80, 0x07, 0x0e, 0x00, 0x00, 0x0d, 0x0f, 0x20, 0x00, 0x0f, 0x0f,
	0x10, 0x80, 0x78, 0xe1, 0x00, 0x00, 0x7a, 0xe1, 0x20, 0x40, 0x7a, 0xe1,
	0x00, 0x80, 0x7a, 0xe1, 0x00, 0x00, 0x7a, 0xe1, 0x10, 0x80, 0x3c, 0xc3,
	0x40, 0x00, 0x07, 0x0e, 0x20, 0x00, 0x00, 0x00, 0x10};

const u8 tile_nm_16x16_52[4 * 16] = {0x00, 0x6e, 0x00, 0x10, 0x01, 0xbb, 0x10,
	0x40, 0x13, 0x13, 0x88, 0x00, 0x26, 0x6e, 0x88, 0x00, 0x44, 0x89, 0x88,
	0x10, 0x67, 0x9b, 0x10, 0x00, 0x33, 0x37, 0x88, 0x00, 0x11, 0xdd, 0xcc,
	0x00, 0x00, 0x00, 0xee, 0x10, 0x40, 0x00, 0x77, 0x00, 0x00, 0x00, 0x33,
	0x88, 0x10, 0x00, 0x23, 0xcc, 0x80, 0x40, 0xce, 0xcc, 0x00, 0x80, 0x9d,
	0x98, 0xa0, 0x00, 0x77, 0x00, 0x20, 0x20, 0x22, 0x00};

const u8 tile_nm_16x16_53[4 * 16] = {0x00, 0x6e, 0x00, 0x10, 0x00, 0x00, 0xee,
	0x20, 0xa0, 0x41, 0x88, 0x40, 0x10, 0x00, 0x00, 0x20, 0x40, 0x01, 0x88,
	0x10, 0x80, 0x01, 0x88, 0x00, 0x20, 0x03, 0xcc, 0x50, 0x40, 0x0c, 0xff,
	0x00, 0x00, 0x09, 0xff, 0x10, 0x81, 0x01, 0xff, 0x88, 0x01, 0x22, 0x77,
	0x98, 0x01, 0x11, 0x22, 0x88, 0x80, 0x08, 0x11, 0x00, 0x80, 0x0c, 0x33,
	0x30, 0x40, 0x03, 0xcc, 0x40, 0xa0, 0x00, 0x00, 0x30};

const u8 tile_nm_16x16_54[4 * 16] = {0x03, 0x1f, 0xff, 0x98, 0x06, 0x0f, 0xee,
	0xcc, 0x0c, 0x17, 0xcc, 0x66, 0x08, 0x07, 0xcc, 0x22, 0x08, 0x13, 0x88,
	0x33, 0x19, 0x03, 0x99, 0x33, 0x08, 0x13, 0x88, 0x33, 0x0c, 0x03, 0x88,
	0x77, 0x0f, 0x1f, 0xff, 0xff, 0x0f, 0x05, 0x66, 0xff, 0x06, 0x1d, 0x66,
	0x66, 0x00, 0x0f, 0xee, 0x88, 0x80, 0x0a, 0xbb, 0x10, 0x40, 0x08, 0x22,
	0x20, 0xa0, 0x08, 0x22, 0x50, 0x40, 0x04, 0x44, 0xb0};

const u8 tile_nm_16x16_55[4 * 16] = {0x40, 0x0f, 0xff, 0x20, 0x81, 0x08, 0x11,
	0xb8, 0x41, 0x00, 0x00, 0x98, 0x81, 0x00, 0x00, 0xa8, 0x81, 0x08, 0x11,
	0x98, 0x00, 0x0f, 0xff, 0x00, 0x04, 0x00, 0x00, 0xcc, 0x02, 0x0a, 0xbb,
	0xee, 0x0d, 0x17, 0x7f, 0xee, 0x08, 0x0f, 0xff, 0xee, 0x0d, 0x17, 0x7f,
	0xee, 0x08, 0x0f, 0xff, 0xee, 0x04, 0x06, 0x7f, 0xcc, 0x02, 0x03, 0xff,
	0xcc, 0x01, 0x15, 0x3b, 0x98, 0x80, 0x00, 0x22, 0x10};

const u8 tile_nm_16x16_56[4 * 16] = {0x70, 0xb0, 0x70, 0xb0, 0xd0, 0x50, 0xd0,
	0x50, 0x20, 0xa0, 0x20, 0xa0, 0x80, 0x20, 0x80, 0x20, 0x20, 0x90, 0x20,
	0x90, 0x40, 0x20, 0x40, 0x20, 0x00, 0x80, 0x00, 0x80, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x04, 0x0c, 0x0e, 0x01, 0x0f, 0x02,
	0x05, 0x0e, 0x02, 0x07, 0x0a, 0x05, 0x03, 0x0d, 0x03, 0x0f, 0x05, 0x03,
	0x0e, 0x03, 0x07, 0x0c, 0x06, 0x00, 0x00, 0x00, 0x00};

const u8 tile_nm_16x16_57[4 * 16] = {0x06, 0x0a, 0x10, 0x70, 0x07, 0x0e, 0x20,
	0x90, 0x06, 0x0c, 0x10, 0x70, 0x05, 0x0e, 0x40, 0xf0, 0x07, 0x06, 0x10,
	0x50, 0x07, 0x06, 0x20, 0x70, 0x05, 0x04, 0x10, 0xa0, 0x07, 0x0c, 0x20,
	0xb0, 0x07, 0x0c, 0x10, 0x70, 0x05, 0x06, 0x20, 0x90, 0x05, 0x04, 0x10,
	0x70, 0x07, 0x06, 0x40, 0xf0, 0x07, 0x0e, 0x10, 0x50, 0x05, 0x0a, 0x20,
	0x70, 0x05, 0x0e, 0x10, 0xa0, 0x05, 0x0a, 0x20, 0xb0};

const u8 tile_nm_16x16_58[4 * 16] = {0x70, 0xb0, 0x70, 0xb0, 0xd0, 0x50, 0xd0,
	0x50, 0x20, 0xa0, 0x20, 0xa0, 0x80, 0x20, 0x80, 0x20, 0x20, 0x90, 0x20,
	0x90, 0x40, 0x20, 0x40, 0x20, 0x00, 0x80, 0x00, 0x80, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x33, 0x01, 0x0c, 0x0e, 0x55, 0x89, 0x02,
	0x05, 0xbb, 0xcd, 0x07, 0x0a, 0x99, 0x45, 0x0d, 0x03, 0x44, 0x89, 0x03,
	0x0e, 0x33, 0x01, 0x0c, 0x06, 0x00, 0x00, 0x00, 0x00};

const u8 tile_nm_16x16_59[4 * 16] = {0x70, 0xb0, 0x70, 0xb0, 0xd0, 0x50, 0xd0,
	0x50, 0x20, 0xa0, 0x20, 0xa0, 0x80, 0x20, 0x80, 0x20, 0x20, 0x90, 0x20,
	0x90, 0x40, 0x20, 0x40, 0x20, 0x00, 0x80, 0x00, 0x80, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x04, 0x08, 0xcc, 0x01, 0x0f, 0x19,
	0xaa, 0x0e, 0x02, 0x3b, 0xdd, 0x05, 0x03, 0x2a, 0x99, 0x0f, 0x05, 0x19,
	0x22, 0x03, 0x07, 0x08, 0xcc, 0x00, 0x00, 0x00, 0x00};

const u8 tile_nm_16x16_60[4 * 16] = {0x11, 0x88, 0x10, 0x70, 0x22, 0xcc, 0x20,
	0x90, 0x55, 0xee, 0x10, 0x70, 0x44, 0xaa, 0x40, 0xf0, 0x22, 0x44, 0x10,
	0x50, 0x11, 0x88, 0x20, 0x70, 0x00, 0x00, 0x10, 0xa0, 0x0f, 0x0f, 0x20,
	0xb0, 0x07, 0x0c, 0x10, 0x70, 0x05, 0x06, 0x20, 0x90, 0x05, 0x04, 0x10,
	0x70, 0x07, 0x06, 0x40, 0xf0, 0x07, 0x0e, 0x10, 0x50, 0x05, 0x0a, 0x20,
	0x70, 0x05, 0x0e, 0x10, 0xa0, 0x05, 0x0a, 0x20, 0xb0};

const u8 tile_nm_16x16_61[4 * 16] = {0x06, 0x0a, 0x10, 0x70, 0x07, 0x0e, 0x20,
	0x90, 0x06, 0x0c, 0x10, 0x70, 0x05, 0x0e, 0x40, 0xf0, 0x07, 0x06, 0x10,
	0x50, 0x07, 0x06, 0x20, 0x70, 0x05, 0x04, 0x10, 0xa0, 0x07, 0x0c, 0x20,
	0xb0, 0x0f, 0x0f, 0x10, 0x70, 0x00, 0x00, 0x20, 0x90, 0x11, 0x88, 0x10,
	0x70, 0x22, 0xcc, 0x40, 0xf0, 0x55, 0xee, 0x10, 0x50, 0x44, 0xaa, 0x20,
	0x70, 0x22, 0x44, 0x10, 0xa0, 0x11, 0x88, 0x20, 0xb0};

const u8 gui_nm_16x16_00[4 * 16] = {0x00, 0x00, 0x00, 0x00, 0x55, 0xbb, 0xee,
	0xff, 0x22, 0xff, 0xee, 0xff, 0x55, 0x77, 0xbb, 0xff, 0x66, 0xbb, 0xff,
	0xff, 0x77, 0x55, 0xbb, 0xff, 0x77, 0xaa, 0xbb, 0xff, 0x11, 0xdd, 0x00,
	0x00, 0x77, 0xee, 0x08, 0x05, 0x77, 0xee, 0x09, 0x0a, 0x77, 0xee, 0x09,
	0x07, 0x77, 0xee, 0x09, 0x0b, 0x77, 0xcc, 0x09, 0x0e, 0x33, 0x33, 0x09,
	0x0f, 0x77, 0x88, 0x09, 0x0e, 0x77, 0xee, 0x09, 0x0d};

const u8 gui_nm_16x16_01[4 * 16] = {0x00, 0x00, 0x00, 0x00, 0x77, 0xbb, 0xff,
	0x77, 0x77, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdd, 0xff, 0x77, 0xff, 0xdd,
	0xff, 0xff, 0xee, 0xff, 0xee, 0x77, 0xee, 0xff, 0xee, 0x00, 0x00, 0x00,
	0x00, 0x09, 0x09, 0x06, 0x0f, 0x06, 0x06, 0x09, 0x04, 0x0f, 0x0d, 0x0f,
	0x0f, 0x0d, 0x0f, 0x0b, 0x0d, 0x0f, 0x0d, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f,
	0x0f, 0x0a, 0x0a, 0x0a, 0x0a, 0x05, 0x05, 0x05, 0x05};

const u8 gui_nm_16x16_02[4 * 16] = {0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xdd,
	0xaa, 0xff, 0xff, 0xff, 0x44, 0xff, 0x77, 0xee, 0xaa, 0xff, 0xff, 0xdd,
	0x66, 0xff, 0xff, 0xaa, 0xee, 0xff, 0x77, 0x55, 0xee, 0x00, 0x00, 0xbb,
	0x88, 0x09, 0x05, 0x77, 0xee, 0x0f, 0x06, 0x77, 0xee, 0x07, 0x0a, 0x77,
	0xee, 0x0c, 0x0d, 0x77, 0xee, 0x0f, 0x0d, 0x77, 0xee, 0x0f, 0x06, 0x88,
	0xcc, 0x0f, 0x0f, 0x11, 0xee, 0x0f, 0x0a, 0x77, 0xee};

const u8 gui_nm_16x16_03[4 * 16] = {0x0f, 0x0f, 0x77, 0xee, 0x0f, 0x0a, 0x77,
	0xee, 0x0e, 0x0e, 0x77, 0xee, 0x0f, 0x0d, 0x77, 0xee, 0x0f, 0x0b, 0x77,
	0xee, 0x0f, 0x0a, 0x77, 0xee, 0x0f, 0x0e, 0x22, 0xee, 0x0f, 0x0d, 0x77,
	0xee, 0x0f, 0x05, 0x77, 0xee, 0x0f, 0x06, 0x77, 0xee, 0x0f, 0x0e, 0x77,
	0xee, 0x0f, 0x0d, 0x33, 0x88, 0x0f, 0x0d, 0x77, 0xee, 0x0f, 0x06, 0x77,
	0xee, 0x0f, 0x0f, 0x55, 0x00, 0x0f, 0x0a, 0x77, 0xee};

const u8 gui_nm_16x16_04[4 * 16] = {0x02, 0x0f, 0x77, 0xee, 0x06, 0x0a, 0x77,
	0xee, 0x0c, 0x0e, 0x11, 0xee, 0x0f, 0x0d, 0x77, 0xaa, 0x0f, 0x0b, 0x77,
	0xee, 0x00, 0x00, 0x77, 0xee, 0x00, 0x00, 0x77, 0xee, 0x0f, 0x0d, 0x77,
	0xee, 0x00, 0x00, 0xbb, 0xee, 0xff, 0xff, 0x55, 0x44, 0xff, 0xff, 0xaa,
	0xee, 0xff, 0x77, 0xdd, 0x66, 0xff, 0xff, 0xee, 0xaa, 0xff, 0xff, 0xff,
	0x44, 0xff, 0x77, 0xff, 0xaa, 0x00, 0x00, 0x00, 0x00};

const u8 gui_nm_16x16_05[4 * 16] = {0x0a, 0x0a, 0x0a, 0x0a, 0x05, 0x05, 0x05,
	0x05, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f,
	0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x0f, 0x0f,
	0x0f, 0x00, 0x00, 0x00, 0x00, 0xee, 0xff, 0xbb, 0xff, 0x66, 0xff, 0xff,
	0xff, 0xff, 0xee, 0xff, 0xff, 0xff, 0xff, 0xff, 0x77, 0x77, 0xff, 0xff,
	0x77, 0x77, 0xee, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00};

const u8 gui_nm_16x16_06[4 * 16] = {0x77, 0xee, 0x09, 0x0e, 0x77, 0xee, 0x09,
	0x0f, 0x77, 0x88, 0x09, 0x0f, 0x55, 0xee, 0x09, 0x0f, 0x77, 0xee, 0x09,
	0x0f, 0x77, 0xee, 0x08, 0x00, 0x77, 0xcc, 0x08, 0x00, 0x77, 0xee, 0x0f,
	0x0f, 0x77, 0xdd, 0x11, 0x00, 0x22, 0xaa, 0xee, 0xff, 0x77, 0x55, 0xee,
	0xff, 0x66, 0xbb, 0xbb, 0xff, 0x55, 0x77, 0xff, 0xff, 0x22, 0xff, 0xbb,
	0xff, 0x55, 0xdd, 0xbb, 0xff, 0x00, 0x00, 0x00, 0x00};

const u8 gui_nm_16x16_07[4 * 16] = {0x77, 0xee, 0x09, 0x0e, 0x77, 0xee, 0x09,
	0x0d, 0x77, 0xee, 0x09, 0x0e, 0x77, 0xee, 0x09, 0x0d, 0x22, 0xcc, 0x09,
	0x0e, 0x77, 0xee, 0x09, 0x0d, 0x77, 0xee, 0x09, 0x0e, 0x77, 0x66, 0x09,
	0x0d, 0x77, 0xee, 0x09, 0x0e, 0x77, 0xee, 0x09, 0x0d, 0x77, 0xee, 0x09,
	0x0e, 0x33, 0xcc, 0x09, 0x0d, 0x77, 0xee, 0x09, 0x0e, 0x77, 0xee, 0x09,
	0x0d, 0x77, 0xee, 0x09, 0x0e, 0x77, 0xee, 0x09, 0x0d};

const u8 weems_m_24x24_03[6 * 24] = {0x00, 0x03, 0x0f, 0x0e, 0x00, 0x00, 0x00,
	0x12, 0x78, 0xc3, 0x08, 0x00, 0x00, 0x16, 0xf3, 0xfc, 0x0c, 0x00, 0x00,
	0x34, 0xf3, 0xff, 0x86, 0x00, 0x00, 0x35, 0xf0, 0xf2, 0xc2, 0x00, 0x00,
	0x35, 0xf6, 0xfc, 0xca, 0x00, 0x00, 0x16, 0xfe, 0xf2, 0xc2, 0x00, 0x00,
	0x1e, 0xff, 0xf7, 0x86, 0x00, 0x01, 0x79, 0xf7, 0xf8, 0x0c, 0x00, 0x03,
	0xf0, 0xf9, 0xfe, 0x08, 0x00, 0x12, 0xf2, 0xf4, 0xe1, 0x08, 0x00, 0x12,
	0xfa, 0xf2, 0xcb, 0x00, 0x00, 0x12, 0xfb, 0xf1, 0xed, 0x00, 0x00, 0x12,
	0xfc, 0xf8, 0xe9, 0x0c, 0x00, 0x12, 0xf7, 0xf0, 0xf8, 0x84, 0x00, 0x03,
	0xf0, 0xf0, 0xf0, 0x0c, 0x00, 0x01, 0xf0, 0xf0, 0xc3, 0x08, 0x00, 0x01,
	0x7b, 0xfe, 0xca, 0x00, 0x00, 0x00, 0x78, 0xf0, 0xc2, 0x00, 0x00, 0x01,
	0x78, 0xf0, 0xc3, 0x00, 0x00, 0x01, 0xf0, 0xe1, 0xe1, 0x00, 0x00, 0x01,
	0xf0, 0x96, 0xe1, 0x00, 0x00, 0x01, 0xc3, 0x09, 0xe1, 0x08, 0x00, 0x01,
	0x84, 0x01, 0xf0, 0x08, 0x00};

const u8 weems_m_24x24_04[6 * 24] = {0x00, 0x12, 0x78, 0xc3, 0x00, 0x00, 0x00,
	0x12, 0xf3, 0xfc, 0x08, 0x00, 0x00, 0x34, 0xf3, 0xff, 0x86, 0x00, 0x00,
	0x35, 0xf0, 0xf2, 0xc2, 0x00, 0x00, 0x35, 0xf6, 0xfc, 0xca, 0x00, 0x00,
	0x16, 0xfe, 0xf2, 0xc2, 0x00, 0x00, 0x16, 0xff, 0xf7, 0x86, 0x00, 0x00,
	0x3d, 0xf3, 0xf8, 0x0c, 0x00, 0x00, 0x78, 0xf8, 0xfe, 0x08, 0x00, 0x01,
	0x78, 0xf4, 0xe1, 0x08, 0x00, 0x01, 0xf1, 0xf2, 0xfa, 0x08, 0x00, 0x01,
	0xf2, 0xf1, 0xfc, 0x08, 0x00, 0x01, 0xf2, 0xf0, 0xf8, 0x0e, 0x00, 0x01,
	0xf2, 0xf0, 0xf8, 0xc2, 0x00, 0x01, 0xf4, 0xf0, 0xf0, 0xc2, 0x00, 0x01,
	0xf0, 0xf0, 0xe1, 0x0e, 0x00, 0x01, 0xf4, 0xf0, 0xe1, 0x00, 0x00, 0x01,
	0x7b, 0xfd, 0xca, 0x00, 0x00, 0x00, 0x78, 0xf0, 0xc2, 0x00, 0x00, 0x00,
	0x78, 0xf0, 0x84, 0x00, 0x00, 0x01, 0x78, 0xf0, 0x84, 0x00, 0x00, 0x01,
	0xf0, 0x78, 0x08, 0x00, 0x00, 0x01, 0xf0, 0x78, 0x08, 0x00, 0x00, 0x01,
	0xc3, 0x78, 0x84, 0x00, 0x00};

const u8 weems_m_24x24_05[6 * 24] = {0x00, 0x03, 0x0f, 0x0e, 0x00, 0x00, 0x00,
	0x12, 0x78, 0xc3, 0x08, 0x00, 0x00, 0x16, 0xf3, 0xfc, 0x08, 0x00, 0x00,
	0x34, 0xf3, 0xff, 0x86, 0x00, 0x00, 0x35, 0xf0, 0xf2, 0xc2, 0x00, 0x00,
	0x35, 0xf6, 0xfc, 0xca, 0x00, 0x00, 0x16, 0xfe, 0xf2, 0xc2, 0x00, 0x01,
	0x3d, 0xf3, 0xf7, 0x86, 0x00, 0x03, 0xf0, 0xf9, 0xf8, 0x0c, 0x00, 0x12,
	0xf0, 0xf4, 0xfe, 0x08, 0x00, 0x12, 0xf3, 0xf4, 0xe1, 0x08, 0x00, 0x12,
	0xf4, 0xf2, 0xfa, 0x08, 0x00, 0x12, 0xf4, 0xf1, 0xfc, 0x0c, 0x00, 0x12,
	0xf8, 0xf0, 0xf8, 0x87, 0x00, 0x03, 0xf0, 0xf0, 0xf8, 0xe1, 0x00, 0x01,
	0xf0, 0xf0, 0xf0, 0xe1, 0x00, 0x01, 0xf6, 0xf0, 0xe1, 0x0f, 0x00, 0x01,
	0x79, 0xfe, 0xcb, 0x00, 0x00, 0x03, 0x78, 0xf0, 0xc3, 0x00, 0x00, 0x12,
	0xe1, 0xf0, 0xe1, 0x00, 0x00, 0x12, 0xf0, 0x3c, 0xe1, 0x00, 0x00, 0x12,
	0xc3, 0x03, 0xe1, 0x00, 0x00, 0x12, 0x0c, 0x01, 0xe1, 0x08, 0x00, 0x03,
	0x08, 0x01, 0xf0, 0x08, 0x00};

/*/
const u8 map_m_8x8_00[2 * 8] = {0x00, 0x00, 0x03, 0x0c, 0x24, 0x82, 0x14, 0x52,
0x24, 0x92, 0x14, 0x52, 0x03, 0x3c, 0x10, 0xe0};

const u8 map_m_8x8_01[2 * 8] = {0x00, 0x00, 0x03, 0x0c, 0x25, 0x86, 0x16, 0x5a,
0x25, 0x96, 0x16, 0x5a, 0x03, 0x3c, 0x10, 0xe0};

const u8 map_m_8x8_02[2 * 8] = {0x00, 0x00, 0x03, 0x0c, 0x35, 0xc6, 0x36, 0xda,
0x35, 0xd6, 0x36, 0xda, 0x03, 0x3c, 0x10, 0xe0};

const u8 map_m_8x8_03[2 * 8] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x10, 0x80, 0x21, 0x48, 0x53, 0xac, 0x00, 0x00};

const u8 map_m_8x8_04[2 * 8] = {0x00, 0x00, 0x53, 0xac, 0x21, 0x48, 0x10, 0x80,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

const u8 map_m_8x8_05[2 * 8] = {0x00, 0x00, 0x40, 0x00, 0x24, 0x00, 0x56, 0x00,
0x56, 0x00, 0x24, 0x00, 0x40, 0x00, 0x00, 0x00};

const u8 map_m_8x8_06[2 * 8] = {0x00, 0x00, 0x00, 0x20, 0x00, 0x42, 0x00, 0xa6,
0x00, 0xa6, 0x00, 0x42, 0x00, 0x20, 0x00, 0x00};

*/
