/*
 * Reginald and the She Vampires for the Amstrad CPC
 * Copyright (C) 2025 Dave Moore
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; If not, see <http://www.gnu.org/licenses/>.
 */

#include "dat/music.h"

#ifdef MUSIC

__at(0x0400) const u8 m_music[2964] = {0x41, 0x54, 0x31, 0x30, 0x01, 0x40, 0x42,
	0x0f, 0x02, 0x09, 0x00, 0x03, 0x24, 0x04, 0x2d, 0x04, 0xa0, 0x04, 0x39,
	0x05, 0x53, 0x05, 0x74, 0x05, 0x92, 0x05, 0x99, 0x05, 0xaf, 0x05, 0x9f,
	0x06, 0xac, 0x06, 0xf2, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d,
	0x26, 0x04, 0x02, 0x00, 0x10, 0x54, 0x03, 0x18, 0x5c, 0x03, 0x20, 0x60,
	0x03, 0x24, 0x64, 0x03, 0x24, 0x68, 0x03, 0x28, 0x68, 0x03, 0x2c, 0x6c,
	0x03, 0x30, 0x70, 0x03, 0x30, 0x70, 0x03, 0x34, 0x74, 0x03, 0x34, 0x74,
	0x03, 0x38, 0x74, 0x03, 0x30, 0x6c, 0x03, 0x2c, 0x68, 0x03, 0x28, 0x68,
	0x03, 0x24, 0x64, 0x03, 0x24, 0x64, 0x03, 0x20, 0x60, 0x03, 0x20, 0x5c,
	0x03, 0x1c, 0x5c, 0x03, 0x1c, 0x58, 0x03, 0x18, 0x58, 0x03, 0x18, 0x54,
	0x03, 0x14, 0x54, 0x03, 0x14, 0x50, 0x03, 0x10, 0x50, 0x03, 0x10, 0x50,
	0x03, 0x10, 0x50, 0x03, 0x10, 0x4c, 0x03, 0x0c, 0x48, 0x03, 0x08, 0x48,
	0x03, 0x08, 0x48, 0x03, 0x08, 0x48, 0x03, 0x08, 0x48, 0x03, 0x04, 0x44,
	0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x26, 0x04, 0x01, 0x00, 0x04,
	0x04, 0x04, 0x04, 0x08, 0x08, 0x08, 0x08, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c,
	0x10, 0x10, 0x10, 0x10, 0x14, 0x14, 0x14, 0x14, 0x14, 0x18, 0x18, 0x18,
	0x18, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x1c, 0x1c, 0x1c, 0x1c, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x28, 0x28, 0x28, 0x28, 0x28,
	0x28, 0x2c, 0x2c, 0x2c, 0x2c, 0x2c, 0x2c, 0x2c, 0x30, 0x30, 0x30, 0x30,
	0x30, 0x30, 0x2c, 0x2c, 0x2c, 0x2c, 0x2c, 0x28, 0x28, 0x28, 0x28, 0x28,
	0x28, 0x28, 0x28, 0x24, 0x24, 0x24, 0x24, 0x24, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x10, 0x10, 0x10, 0x10,
	0x10, 0x10, 0x10, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x08, 0x08,
	0x08, 0x08, 0x08, 0x08, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x0d, 0x26, 0x04, 0x01, 0x00, 0x7e, 0x25, 0x18, 0x7a,
	0x27, 0x0c, 0x36, 0x21, 0x30, 0x2c, 0x28, 0x24, 0x20, 0x1c, 0x18, 0x14,
	0x10, 0x0c, 0x08, 0x04, 0x00, 0x0d, 0x26, 0x04, 0x01, 0x00, 0x7e, 0x25,
	0x0c, 0x3a, 0x27, 0x76, 0x21, 0x0c, 0x30, 0x6c, 0x0c, 0x28, 0x64, 0x0c,
	0x20, 0x5c, 0x0c, 0x18, 0x54, 0x0c, 0x10, 0x4c, 0x0c, 0x08, 0x44, 0x0c,
	0x00, 0x00, 0x0d, 0x26, 0x04, 0x01, 0x00, 0x7c, 0x0c, 0x38, 0x74, 0x0c,
	0x30, 0x6c, 0x0c, 0x28, 0x64, 0x0c, 0x20, 0x5c, 0x0c, 0x18, 0x54, 0x0c,
	0x10, 0x4c, 0x0c, 0x08, 0x44, 0x0c, 0x00, 0x00, 0x0d, 0x26, 0x04, 0x01,
	0x00, 0x05, 0x3a, 0x0d, 0x94, 0x05, 0x01, 0x00, 0x3c, 0x38, 0x34, 0x30,
	0x2c, 0x28, 0x24, 0x20, 0x1c, 0x18, 0x14, 0x10, 0x0c, 0x08, 0x04, 0x00,
	0x00, 0x0d, 0x26, 0x04, 0x01, 0x00, 0x54, 0x03, 0x54, 0x07, 0x50, 0x0c,
	0x50, 0x03, 0x50, 0x07, 0x50, 0x0c, 0x54, 0x03, 0x54, 0x07, 0x54, 0x0c,
	0x54, 0x03, 0x58, 0x07, 0x58, 0x0c, 0x58, 0x03, 0x58, 0x07, 0x58, 0x0c,
	0x5c, 0x03, 0x5c, 0x07, 0x5c, 0x0c, 0x5c, 0x03, 0x5c, 0x07, 0x60, 0x0c,
	0x60, 0x03, 0x60, 0x07, 0x60, 0x0c, 0x60, 0x03, 0x60, 0x07, 0x64, 0x0c,
	0x64, 0x03, 0x64, 0x07, 0x64, 0x0c, 0x64, 0x03, 0x64, 0x07, 0x68, 0x0c,
	0x68, 0x03, 0x6c, 0x07, 0x6c, 0x0c, 0x70, 0x03, 0x70, 0x07, 0x74, 0x0c,
	0x74, 0x03, 0x74, 0x07, 0x74, 0x0c, 0x74, 0x03, 0x74, 0x07, 0x78, 0x0c,
	0x78, 0x03, 0x78, 0x07, 0x74, 0x0c, 0x74, 0x03, 0x74, 0x07, 0x70, 0x0c,
	0x70, 0x03, 0x70, 0x07, 0x70, 0x0c, 0x70, 0x03, 0x6c, 0x07, 0x6c, 0x0c,
	0x6c, 0x03, 0x6c, 0x07, 0x68, 0x0c, 0x68, 0x03, 0x68, 0x07, 0x64, 0x0c,
	0x64, 0x03, 0x64, 0x07, 0x60, 0x0c, 0x5c, 0x03, 0x5c, 0x07, 0x5c, 0x0c,
	0x58, 0x03, 0x58, 0x07, 0x58, 0x0c, 0x58, 0x03, 0x54, 0x07, 0x54, 0x0c,
	0x50, 0x03, 0x50, 0x07, 0x50, 0x0c, 0x50, 0x03, 0x50, 0x07, 0x50, 0x0c,
	0x4c, 0x03, 0x4c, 0x07, 0x4c, 0x0c, 0x4c, 0x03, 0x4c, 0x07, 0x4c, 0x0c,
	0x4c, 0x03, 0x4c, 0x07, 0x48, 0x0c, 0x48, 0x03, 0x48, 0x07, 0x48, 0x0c,
	0x48, 0x03, 0x48, 0x07, 0x48, 0x0c, 0x48, 0x03, 0x48, 0x07, 0x44, 0x0c,
	0x44, 0x03, 0x44, 0x07, 0x44, 0x0c, 0x44, 0x03, 0x44, 0x07, 0x44, 0x0c,
	0x44, 0x03, 0x44, 0x07, 0x44, 0x0c, 0x44, 0x03, 0x44, 0x07, 0x44, 0x0c,
	0x44, 0x03, 0x44, 0x07, 0x44, 0x0c, 0x44, 0x03, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x0d, 0x26, 0x04, 0x01, 0x00, 0x3c, 0xbc, 0xff, 0xff, 0x3c, 0xbc,
	0x01, 0x00, 0x0d, 0xa1, 0x06, 0x02, 0x00, 0x20, 0xa4, 0xe6, 0xff, 0xac,
	0xd7, 0xff, 0xb0, 0xce, 0xff, 0x00, 0x9c, 0x14, 0x00, 0xa0, 0xf6, 0xff,
	0xa8, 0xe5, 0xff, 0xac, 0xde, 0xff, 0x00, 0x00, 0x98, 0x2a, 0x00, 0x9c,
	0x09, 0x00, 0xa4, 0xfe, 0xff, 0xa8, 0xea, 0xff, 0x00, 0x00, 0x94, 0x44,
	0x00, 0x98, 0x1d, 0x00, 0xa0, 0x04, 0x00, 0xa4, 0xf9, 0xff, 0x00, 0x00,
	0x8c, 0x61, 0x00, 0x90, 0x29, 0x00, 0x98, 0x16, 0x00, 0x9c, 0x02, 0x00,
	0x0d, 0x26, 0x04, 0x04, 0x00, 0xbc, 0xfe, 0xff, 0xb8, 0x02, 0x00, 0x34,
	0x30, 0x2c, 0x28, 0x24, 0x20, 0x1c, 0x18, 0x14, 0x10, 0x0c, 0x08, 0x04,
	0x00, 0x00, 0x0d, 0x26, 0x04, 0x24, 0x00, 0x00, 0x00, 0xeb, 0x07, 0x10,
	0x1e, 0x0e, 0x36, 0x0e, 0x75, 0x0e, 0x24, 0x00, 0x5f, 0x08, 0x77, 0x08,
	0xb5, 0x08, 0x00, 0xcd, 0x08, 0xe5, 0x08, 0x53, 0x09, 0x20, 0x45, 0x0a,
	0x60, 0x0a, 0xce, 0x0a, 0x12, 0x08, 0x30, 0x69, 0x09, 0xb3, 0x09, 0xfb,
	0x09, 0x20, 0x53, 0x08, 0x20, 0xef, 0x0a, 0x39, 0x0b, 0x8c, 0x0b, 0x10,
	0x08, 0x00, 0xd6, 0x0b, 0x20, 0x0c, 0x56, 0x0c, 0x00, 0xef, 0x0a, 0xc7,
	0x0d, 0xfb, 0x09, 0x20, 0xa0, 0x0c, 0xc9, 0x0c, 0xd6, 0x0c, 0x49, 0x08,
	0x30, 0xe4, 0x0c, 0x03, 0x0d, 0x23, 0x0d, 0x11, 0x4b, 0x08, 0x30, 0x41,
	0x0d, 0x50, 0x0d, 0x63, 0x0d, 0x19, 0x10, 0x08, 0x30, 0x76, 0x0d, 0x89,
	0x0d, 0x9c, 0x0d, 0x18, 0x34, 0x08, 0x3e, 0x01, 0x01, 0x01, 0x8b, 0x0e,
	0xb5, 0x0e, 0x23, 0x0f, 0x24, 0x12, 0x08, 0x30, 0xd6, 0x0b, 0x20, 0x0c,
	0x56, 0x0c, 0x20, 0x53, 0x08, 0x20, 0x69, 0x09, 0xb3, 0x09, 0xfb, 0x09,
	0x10, 0x08, 0x00, 0xef, 0x0a, 0x39, 0x0b, 0x8c, 0x0b, 0x00, 0x69, 0x09,
	0xc7, 0x0d, 0xfb, 0x09, 0x0e, 0xfe, 0xfe, 0xfe, 0xd6, 0x0b, 0x20, 0x0c,
	0x56, 0x0c, 0x00, 0x69, 0x09, 0x39, 0x0b, 0xfb, 0x09, 0x00, 0xef, 0x0a,
	0xc7, 0x0d, 0x8c, 0x0b, 0x10, 0xd6, 0x0b, 0x20, 0x0c, 0x56, 0x0c, 0x02,
	0x3e, 0xff, 0x01, 0x00, 0x41, 0x0d, 0x50, 0x0d, 0x63, 0x0d, 0x10, 0x4b,
	0x08, 0x32, 0x00, 0x50, 0x0d, 0x63, 0x0d, 0x41, 0x0d, 0x1b, 0xeb, 0x07,
	0x14, 0x00, 0x85, 0x0f, 0x8a, 0x0f, 0x8f, 0x0f, 0x40, 0x01, 0x12, 0x07,
	0x29, 0x25, 0x29, 0x25, 0x29, 0x25, 0x29, 0x25, 0x29, 0x25, 0x29, 0x25,
	0x29, 0x25, 0x29, 0x25, 0x29, 0x25, 0x29, 0x25, 0x29, 0x25, 0x29, 0x25,
	0x29, 0x25, 0x29, 0x25, 0x29, 0x25, 0x29, 0x25, 0x29, 0x25, 0x29, 0x25,
	0x00, 0x21, 0x00, 0x29, 0x25, 0x29, 0x25, 0x29, 0x25, 0x29, 0x25, 0x29,
	0x25, 0x29, 0x25, 0x29, 0x25, 0x29, 0x25, 0x29, 0x25, 0x29, 0x25, 0x29,
	0x25, 0x04, 0x29, 0x25, 0x04, 0x21, 0x25, 0x02, 0x21, 0x25, 0x21, 0x25,
	0x21, 0x09, 0x7d, 0x04, 0x11, 0x7d, 0x04, 0x09, 0x7d, 0x04, 0x0d, 0x7d,
	0x39, 0x02, 0x35, 0x02, 0x31, 0x02, 0x2d, 0x02, 0x29, 0x00, 0x29, 0x00,
	0x19, 0x02, 0x15, 0x04, 0x11, 0x06, 0x29, 0x00, 0x25, 0x21, 0x02, 0x25,
	0x21, 0x04, 0x25, 0x21, 0x06, 0x25, 0x21, 0x00, 0x7c, 0xeb, 0x00, 0x00,
	0x01, 0x0e, 0xaa, 0x67, 0x02, 0x08, 0x42, 0x0d, 0x42, 0x11, 0x42, 0x15,
	0x86, 0x67, 0x01, 0x0e, 0xa2, 0x60, 0x02, 0x00, 0x5a, 0xe9, 0x00, 0x00,
	0x03, 0x02, 0x5a, 0x4d, 0x02, 0x5a, 0x4f, 0x02, 0x5a, 0x4b, 0x02, 0x5a,
	0x47, 0x02, 0x5a, 0x4d, 0x02, 0x5a, 0x4f, 0x02, 0x5a, 0x4b, 0x02, 0x5a,
	0x47, 0x02, 0x5a, 0x4d, 0x02, 0x5a, 0x4f, 0x02, 0x5a, 0x4b, 0x02, 0x5a,
	0x47, 0x02, 0x5a, 0x4d, 0x02, 0x5a, 0x4f, 0x02, 0x5a, 0x4b, 0x02, 0x5a,
	0x47, 0x72, 0x6b, 0x04, 0x5a, 0x65, 0x03, 0x7a, 0x69, 0x04, 0xac, 0xe5,
	0x00, 0x00, 0x02, 0x1e, 0xb2, 0x43, 0x06, 0x42, 0x80, 0x02, 0x00, 0x42,
	0x00, 0x42, 0x80, 0x00, 0x00, 0x0a, 0xaa, 0x6b, 0x01, 0x00, 0x7c, 0xe7,
	0x00, 0x00, 0x01, 0x0e, 0xc2, 0x69, 0x02, 0x08, 0x42, 0x0d, 0x42, 0x11,
	0x42, 0x15, 0x86, 0x67, 0x01, 0x0e, 0xba, 0x60, 0x02, 0x00, 0x72, 0xe7,
	0x00, 0x00, 0x03, 0x8c, 0x69, 0x05, 0x5a, 0x6b, 0x03, 0x8a, 0x67, 0x05,
	0x5a, 0x6d, 0x03, 0x96, 0x67, 0x05, 0x5a, 0x6b, 0x03, 0x94, 0x65, 0x05,
	0x72, 0x67, 0x03, 0xbc, 0x60, 0x05, 0xba, 0x69, 0x04, 0x7c, 0x6b, 0x05,
	0x5a, 0x6d, 0x03, 0xac, 0x65, 0x05, 0x5a, 0x6b, 0x03, 0xb0, 0x65, 0x05,
	0x5a, 0x67, 0x03, 0xc2, 0x63, 0x05, 0xc4, 0x65, 0x04, 0xc8, 0x67, 0x05,
	0x5a, 0x6d, 0x03, 0x94, 0x6b, 0x05, 0x94, 0x69, 0x04, 0x92, 0x67, 0x05,
	0x5a, 0x60, 0x03, 0x72, 0x65, 0x05, 0x72, 0x69, 0x04, 0x7a, 0x67, 0x05,
	0x5a, 0x6d, 0x03, 0x8a, 0x6b, 0x05, 0x8a, 0x69, 0x04, 0x92, 0x67, 0x05,
	0x5a, 0x60, 0x03, 0xa2, 0x65, 0x05, 0xa2, 0x63, 0x04, 0xaa, 0x60, 0x05,
	0xc4, 0xe7, 0x00, 0x00, 0x02, 0x1e, 0xca, 0x45, 0x06, 0x42, 0x80, 0x02,
	0x00, 0x42, 0x80, 0x00, 0x00, 0x0c, 0xc2, 0x6f, 0x01, 0x00, 0x94, 0xe0,
	0x00, 0x00, 0x06, 0xc4, 0x6b, 0x07, 0x7b, 0x8a, 0x60, 0x06, 0x55, 0xba,
	0x60, 0x07, 0x73, 0x9a, 0x60, 0x06, 0xa2, 0x60, 0x07, 0x86, 0x60, 0x06,
	0xb6, 0x60, 0x07, 0x71, 0x9e, 0x60, 0x06, 0xb6, 0x60, 0x07, 0x71, 0x6b,
	0xa4, 0x60, 0x06, 0x35, 0xb0, 0x60, 0x07, 0x6b, 0x92, 0x60, 0x06, 0xb6,
	0x60, 0x07, 0x71, 0x6b, 0x86, 0x60, 0x06, 0xaa, 0x60, 0x07, 0x71, 0x92,
	0x60, 0x06, 0x59, 0xb6, 0x60, 0x07, 0x8a, 0x60, 0x06, 0xbc, 0x60, 0x07,
	0x5a, 0xe7, 0x00, 0x00, 0x03, 0xc4, 0x61, 0x04, 0xc4, 0x69, 0x05, 0xba,
	0x45, 0x5a, 0x67, 0x03, 0xca, 0x65, 0x05, 0xc8, 0x47, 0xc0, 0x60, 0x04,
	0xc4, 0x43, 0xd2, 0x67, 0x05, 0x0a, 0x93, 0xd4, 0x61, 0x04, 0xd4, 0x63,
	0x05, 0xd2, 0x49, 0x5a, 0x67, 0x03, 0xce, 0x6b, 0x04, 0xca, 0x65, 0x05,
	0x02, 0xc8, 0x60, 0x04, 0xc4, 0x43, 0xc2, 0x61, 0x05, 0x5a, 0x67, 0x03,
	0xa4, 0x65, 0x05, 0xa2, 0x69, 0x04, 0xa0, 0x63, 0x05, 0xa2, 0x45, 0x6b,
	0xc4, 0xe9, 0x00, 0x00, 0x03, 0x7b, 0xb2, 0x60, 0x07, 0x6d, 0xba, 0x60,
	0x03, 0xb2, 0x60, 0x07, 0x6d, 0xa2, 0x60, 0x03, 0x7d, 0xb6, 0x60, 0x07,
	0xb0, 0x60, 0x03, 0xaa, 0x60, 0x07, 0xb6, 0x60, 0x03, 0xb0, 0x60, 0x07,
	0x6b, 0x65, 0xb6, 0x60, 0x03, 0xb0, 0x60, 0x07, 0x6b, 0xa2, 0x60, 0x03,
	0x77, 0xb0, 0x60, 0x07, 0x6b, 0xa2, 0x60, 0x03, 0x6b, 0xb0, 0x60, 0x07,
	0xb6, 0x60, 0x03, 0xb0, 0x60, 0x07, 0xb6, 0x60, 0x03, 0xba, 0x60, 0x07,
	0x7d, 0x83, 0x7c, 0xe7, 0x00, 0x00, 0x01, 0x0e, 0xce, 0x61, 0x02, 0x08,
	0x42, 0x0b, 0x42, 0x0f, 0x42, 0x13, 0x86, 0x67, 0x01, 0x0e, 0xc8, 0x65,
	0x02, 0x14, 0x7c, 0x60, 0x06, 0x72, 0xe7, 0x00, 0x00, 0x03, 0xa4, 0x69,
	0x05, 0x5a, 0x6b, 0x03, 0xa2, 0x67, 0x05, 0x5a, 0x6d, 0x03, 0xae, 0x67,
	0x05, 0x5a, 0x6b, 0x03, 0xac, 0x65, 0x05, 0x72, 0x67, 0x03, 0xbc, 0x60,
	0x05, 0xba, 0x69, 0x04, 0x94, 0x6b, 0x05, 0x5a, 0x6d, 0x03, 0xac, 0x65,
	0x05, 0x5a, 0x6b, 0x03, 0xb0, 0x65, 0x05, 0x5a, 0x67, 0x03, 0xc2, 0x63,
	0x05, 0xc4, 0x65, 0x04, 0xc8, 0x67, 0x05, 0x5a, 0x6d, 0x03, 0xac, 0x6b,
	0x05, 0xac, 0x69, 0x04, 0xaa, 0x60, 0x05, 0x5a, 0x67, 0x03, 0x8a, 0x65,
	0x05, 0x8a, 0x69, 0x04, 0x92, 0x67, 0x05, 0x5a, 0x6d, 0x03, 0xa2, 0x6b,
	0x05, 0xa2, 0x69, 0x04, 0xaa, 0x67, 0x05, 0x5a, 0x60, 0x03, 0xba, 0x65,
	0x05, 0xba, 0x63, 0x04, 0xc2, 0x60, 0x05, 0xd2, 0xe7, 0x00, 0x00, 0x02,
	0x14, 0xc8, 0x6b, 0x01, 0x02, 0x42, 0x0d, 0x42, 0x11, 0x42, 0x15, 0xca,
	0x65, 0x02, 0x06, 0x42, 0x80, 0xfa, 0xff, 0x42, 0x80, 0x00, 0x00, 0x0c,
	0xda, 0x6d, 0x01, 0x00, 0x94, 0xe0, 0x00, 0x00, 0x06, 0xc4, 0x6b, 0x07,
	0x7b, 0x8a, 0x60, 0x06, 0x47, 0xba, 0x60, 0x07, 0x73, 0x8a, 0x60, 0x06,
	0xa2, 0x60, 0x07, 0x9a, 0x60, 0x06, 0xb6, 0x60, 0x07, 0x71, 0x98, 0x60,
	0x06, 0xb6, 0x60, 0x07, 0x71, 0x6b, 0x8c, 0x60, 0x06, 0x65, 0xb0, 0x60,
	0x07, 0x6b, 0x92, 0x60, 0x06, 0xb6, 0x60, 0x07, 0x71, 0x6b, 0x8a, 0x60,
	0x06, 0xaa, 0x60, 0x07, 0x71, 0x98, 0x60, 0x06, 0x53, 0xb6, 0x60, 0x07,
	0x92, 0x60, 0x06, 0xbc, 0x60, 0x07, 0x5a, 0xe3, 0x00, 0x00, 0x03, 0xba,
	0x61, 0x04, 0xc4, 0x69, 0x05, 0xd2, 0x45, 0x5a, 0x6b, 0x03, 0xca, 0x65,
	0x05, 0xc8, 0x47, 0xca, 0x60, 0x04, 0xd2, 0x43, 0xce, 0x67, 0x05, 0x5a,
	0x69, 0x03, 0xc8, 0x63, 0x05, 0x5a, 0x6b, 0x03, 0x04, 0xd2, 0x60, 0x05,
	0xda, 0x61, 0x04, 0xd4, 0x63, 0x05, 0xd2, 0x49, 0x5a, 0x67, 0x03, 0xce,
	0x6b, 0x04, 0xca, 0x65, 0x05, 0x02, 0xc8, 0x60, 0x04, 0xc4, 0x43, 0xc2,
	0x61, 0x05, 0x5a, 0x69, 0x03, 0xa4, 0x65, 0x05, 0xa2, 0x69, 0x04, 0xa0,
	0x63, 0x05, 0xa2, 0x45, 0x71, 0xc4, 0xe9, 0x00, 0x00, 0x03, 0x7b, 0xb2,
	0x60, 0x07, 0x6d, 0xba, 0x60, 0x03, 0xb2, 0x60, 0x07, 0x6d, 0xa2, 0x60,
	0x03, 0x7d, 0xb6, 0x60, 0x07, 0xb0, 0x60, 0x03, 0xaa, 0x60, 0x07, 0xb6,
	0x60, 0x03, 0xb0, 0x60, 0x07, 0x6b, 0x65, 0xb6, 0x60, 0x03, 0xb0, 0x60,
	0x07, 0x6b, 0xa2, 0x60, 0x03, 0x77, 0xb0, 0x60, 0x07, 0x6b, 0xa2, 0x60,
	0x03, 0x6b, 0xb0, 0x60, 0x07, 0xb6, 0x60, 0x03, 0xb0, 0x60, 0x07, 0xb6,
	0x60, 0x03, 0xba, 0x60, 0x07, 0x7d, 0x83, 0x94, 0xe0, 0x00, 0x00, 0x06,
	0xac, 0x65, 0x05, 0x02, 0x8a, 0x60, 0x06, 0x55, 0x42, 0x60, 0x00, 0x02,
	0x9a, 0x60, 0x06, 0xbc, 0x61, 0x05, 0x86, 0x65, 0x06, 0x42, 0x60, 0x00,
	0x02, 0x9e, 0x60, 0x06, 0x42, 0x60, 0x00, 0x04, 0xa4, 0x60, 0x06, 0xb0,
	0x60, 0x05, 0x42, 0x60, 0x00, 0x02, 0x92, 0x60, 0x06, 0x42, 0x60, 0x00,
	0x04, 0x86, 0x60, 0x06, 0xba, 0x60, 0x05, 0x02, 0x92, 0x60, 0x06, 0x59,
	0xd2, 0x60, 0x05, 0x8a, 0x60, 0x06, 0x42, 0x60, 0x00, 0xac, 0xe1, 0x00,
	0x00, 0x05, 0xc4, 0x69, 0x07, 0x7b, 0x73, 0x6d, 0x7b, 0x73, 0x85, 0x63,
	0xbc, 0x65, 0x05, 0xb6, 0x69, 0x07, 0x71, 0x6b, 0x77, 0x71, 0x6b, 0xb0,
	0x61, 0x05, 0xb6, 0x69, 0x07, 0x71, 0x6b, 0x63, 0x77, 0x71, 0x6b, 0xba,
	0x61, 0x05, 0xaa, 0x65, 0x07, 0x71, 0x77, 0xd2, 0x63, 0x05, 0xb6, 0x65,
	0x07, 0x7b, 0x7d, 0xc4, 0xe7, 0x00, 0x00, 0x03, 0x7b, 0xb2, 0x60, 0x07,
	0x6d, 0xba, 0x60, 0x03, 0xb2, 0x60, 0x07, 0x6d, 0xa2, 0x60, 0x03, 0x7d,
	0xb6, 0x60, 0x07, 0xb0, 0x60, 0x03, 0xaa, 0x60, 0x07, 0xb6, 0x60, 0x03,
	0xb0, 0x60, 0x07, 0x6b, 0x65, 0xb6, 0x60, 0x03, 0xb0, 0x60, 0x07, 0x6b,
	0xa2, 0x60, 0x03, 0x77, 0xb0, 0x60, 0x07, 0x6b, 0xa2, 0x60, 0x03, 0x6b,
	0xb0, 0x60, 0x07, 0xb6, 0x60, 0x03, 0xb0, 0x60, 0x07, 0xb6, 0x60, 0x03,
	0xba, 0x60, 0x07, 0x7d, 0x83, 0x7c, 0xe1, 0x00, 0x00, 0x02, 0x0a, 0x42,
	0x09, 0x42, 0x0d, 0x42, 0x13, 0xc8, 0x41, 0x04, 0x42, 0x03, 0x42, 0x05,
	0x42, 0x07, 0x42, 0x89, 0x04, 0x00, 0x42, 0x8b, 0x08, 0x00, 0x42, 0x8d,
	0x04, 0x00, 0x8a, 0xc1, 0x00, 0x00, 0x0a, 0x90, 0x47, 0x00, 0xc4, 0xe1,
	0x00, 0x00, 0x08, 0x0e, 0xb6, 0x60, 0x02, 0x16, 0xa8, 0x45, 0x00, 0xac,
	0xe5, 0x00, 0x00, 0x01, 0x42, 0x03, 0x42, 0x01, 0x1a, 0xba, 0x60, 0x02,
	0x00, 0x42, 0x80, 0x00, 0x00, 0x02, 0x88, 0x73, 0x09, 0x42, 0x0f, 0x02,
	0x9a, 0x4d, 0x04, 0xac, 0x4b, 0x08, 0x42, 0x80, 0x02, 0x00, 0x42, 0x00,
	0x42, 0x80, 0x04, 0x00, 0x42, 0x80, 0x06, 0x00, 0x42, 0x80, 0x00, 0x00,
	0x82, 0x73, 0x09, 0x42, 0x0f, 0x02, 0x94, 0x40, 0x42, 0x0b, 0x02, 0xa6,
	0x40, 0x0a, 0x42, 0x80, 0x02, 0x00, 0x42, 0x00, 0x42, 0x80, 0x04, 0x00,
	0x42, 0x80, 0x06, 0x00, 0x7c, 0xf5, 0x00, 0x00, 0x09, 0x42, 0x11, 0x02,
	0x8e, 0x40, 0x42, 0x0d, 0x02, 0xa0, 0x4b, 0x0c, 0x42, 0x80, 0x02, 0x00,
	0x42, 0x00, 0x42, 0x80, 0x04, 0x00, 0x42, 0x80, 0x06, 0x00, 0x7c, 0xe5,
	0x00, 0x00, 0x0a, 0x0a, 0x90, 0x40, 0x06, 0x94, 0x40, 0x0a, 0x4c, 0x47,
	0x00, 0x42, 0x80, 0x08, 0x00, 0x8a, 0xe3, 0x00, 0x00, 0x0a, 0x0c, 0x90,
	0x4f, 0x04, 0x94, 0x4b, 0x0a, 0x4c, 0x4d, 0x00, 0x42, 0x80, 0x08, 0x00,
	0x90, 0xe7, 0x00, 0x00, 0x0a, 0x0a, 0x90, 0x4b, 0x08, 0x94, 0x4f, 0x0a,
	0x4c, 0x51, 0x00, 0xa6, 0xe7, 0x00, 0x00, 0x0b, 0x06, 0x67, 0x06, 0x67,
	0x06, 0xa6, 0x4b, 0x08, 0x76, 0x51, 0x8c, 0x60, 0x01, 0x00, 0x42, 0x80,
	0x00, 0x00, 0xcc, 0x67, 0x0b, 0x06, 0x8d, 0x06, 0xcc, 0x49, 0x06, 0xcc,
	0x4b, 0x08, 0xa6, 0x4d, 0x00, 0x76, 0xef, 0x00, 0x00, 0x0b, 0x06, 0x37,
	0x06, 0x37, 0x06, 0x76, 0x51, 0x02, 0x6c, 0x6d, 0x03, 0x84, 0x60, 0x07,
	0x6e, 0x6b, 0x03, 0x86, 0x60, 0x07, 0x70, 0x69, 0x03, 0x88, 0x60, 0x07,
	0x72, 0x60, 0x03, 0x8a, 0x60, 0x07, 0x74, 0x67, 0x03, 0x82, 0x60, 0x07,
	0x5a, 0xe7, 0x00, 0x00, 0x03, 0xc4, 0x61, 0x04, 0xc4, 0x69, 0x05, 0xba,
	0x45, 0x5a, 0x67, 0x03, 0xca, 0x65, 0x05, 0xc8, 0x47, 0xc0, 0x60, 0x04,
	0xc4, 0x43, 0xd2, 0x67, 0x05, 0xc8, 0xe0, 0xfc, 0xff, 0x07, 0xc8, 0xc9,
	0x00, 0x00, 0xce, 0x45, 0xba, 0x49, 0xb6, 0x43, 0xd2, 0x67, 0x05, 0xd4,
	0x61, 0x04, 0xd4, 0x63, 0x05, 0xd2, 0x49, 0x5a, 0x67, 0x03, 0xce, 0x6b,
	0x04, 0xca, 0x65, 0x05, 0x02, 0xc8, 0x60, 0x04, 0xc4, 0x43, 0xc2, 0x61,
	0x05, 0x5a, 0x67, 0x03, 0xa4, 0x65, 0x05, 0xa2, 0x69, 0x04, 0xa0, 0x43,
	0xa2, 0x45, 0x6b, 0x7c, 0xef, 0x00, 0x00, 0x01, 0x0e, 0xb0, 0x69, 0x02,
	0x08, 0x42, 0x0d, 0x42, 0x11, 0x42, 0x15, 0x86, 0x69, 0x01, 0x0e, 0xba,
	0x67, 0x02, 0x00, 0xac, 0xe1, 0x00, 0x00, 0x02, 0x42, 0x03, 0x42, 0x05,
	0x42, 0x07, 0x42, 0x09, 0x42, 0x0b, 0x42, 0x0d, 0x42, 0x0f, 0x42, 0x11,
	0x42, 0x13, 0xc2, 0x43, 0x42, 0x05, 0x42, 0x07, 0x42, 0x09, 0x42, 0x0b,
	0x42, 0x0d, 0x42, 0x0f, 0x42, 0x11, 0x42, 0x13, 0x42, 0x15, 0x96, 0x65,
	0x0a, 0x0a, 0x5a, 0x77, 0x03, 0x02, 0x5a, 0x55, 0x02, 0x5a, 0x53, 0x02,
	0x5a, 0x51, 0x02, 0x5a, 0x4d, 0x00, 0xb2, 0xe9, 0x00, 0x00, 0x02, 0x1e,
	0xca, 0x45, 0x06, 0x42, 0x80, 0x02, 0x00, 0x42, 0x80, 0x00, 0x00, 0x0c,
	0x92, 0x69, 0x01, 0x00, 0xc4, 0xef, 0x00, 0x00, 0x01, 0x06, 0x42, 0x80,
	0x02, 0x00, 0x42, 0x00, 0x42, 0x00, 0x42, 0x00, 0x42, 0x00, 0xbc, 0xe3,
	0x00, 0x00, 0x02, 0x0c, 0x42, 0x80, 0x02, 0x00, 0x42, 0x80, 0x00, 0x00,
	0x06, 0xb0, 0x45, 0x10, 0xba, 0x41, 0x08, 0x8a, 0x60, 0x06, 0x72, 0xe7,
	0x00, 0x00, 0x03, 0x74, 0x69, 0x05, 0x5a, 0x6b, 0x03, 0x8a, 0x67, 0x07,
	0x5a, 0x6d, 0x03, 0x7e, 0x67, 0x05, 0x5a, 0x6b, 0x03, 0x7c, 0x65, 0x05,
	0x72, 0x67, 0x03, 0xa4, 0x60, 0x05, 0xa2, 0x69, 0x04, 0x82, 0x6b, 0x07,
	0x5a, 0x6d, 0x03, 0x94, 0x65, 0x05, 0x5a, 0x6b, 0x03, 0x8a, 0x65, 0x07,
	0x5a, 0x67, 0x03, 0xaa, 0x63, 0x05, 0xac, 0x65, 0x04, 0xa2, 0x67, 0x07,
	0x5a, 0x6d, 0x03, 0x7c, 0x6b, 0x05, 0x7c, 0x69, 0x04, 0x8a, 0x67, 0x07,
	0x5a, 0x60, 0x03, 0x5a, 0x65, 0x05, 0x5a, 0x69, 0x04, 0x8a, 0x67, 0x07,
	0x5a, 0x6d, 0x03, 0x72, 0x6b, 0x05, 0x72, 0x69, 0x04, 0x92, 0x65, 0x07,
	0x5a, 0x60, 0x03, 0x8a, 0x63, 0x05, 0x8a, 0x61, 0x06, 0x92, 0x60, 0x05,
	0x8a, 0xe7, 0x00, 0x00, 0x07, 0xa4, 0x69, 0x05, 0x92, 0x60, 0x07, 0xa2,
	0x67, 0x05, 0x02, 0xae, 0x40, 0x94, 0x60, 0x07, 0xac, 0x65, 0x05, 0x82,
	0x60, 0x07, 0xd4, 0x67, 0x05, 0xd2, 0x69, 0x04, 0x94, 0x6b, 0x05, 0x86,
	0x60, 0x07, 0xc4, 0x65, 0x05, 0x02, 0xc8, 0x40, 0x02, 0xda, 0x43, 0xdc,
	0x65, 0x04, 0xe0, 0x67, 0x05, 0x8a, 0x60, 0x07, 0xac, 0x6b, 0x05, 0xac,
	0x69, 0x04, 0xaa, 0x67, 0x05, 0x02, 0x8a, 0x45, 0x8a, 0x67, 0x04, 0x92,
	0x65, 0x05, 0x8a, 0x60, 0x07, 0xa2, 0x69, 0x05, 0xa2, 0x67, 0x04, 0xaa,
	0x65, 0x05, 0x8a, 0x60, 0x07, 0xba, 0x63, 0x05, 0xba, 0x61, 0x04, 0xc2,
	0x60, 0x05, 0x42, 0x80, 0x00, 0x00, 0x00, 0x42, 0x80, 0x00, 0x00, 0x00,
	0x42, 0x80, 0x00, 0x00, 0x00};

__at(0x1000) const u8 g_sfx[378] = {0x41, 0x54, 0x31, 0x30, 0x01, 0x40, 0x42,
	0x0f, 0x02, 0xff, 0x58, 0x01, 0x28, 0x04, 0x31, 0x04, 0x3c, 0x04, 0x5b,
	0x04, 0x68, 0x04, 0x90, 0x04, 0xa1, 0x04, 0xb0, 0x04, 0xd8, 0x04, 0xea,
	0x04, 0xf1, 0x04, 0x1c, 0x05, 0x48, 0x05, 0x55, 0x05, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x0d, 0x2a, 0x04, 0x01, 0x00, 0x3e, 0x21, 0xb2, 0x21,
	0x07, 0x00, 0x0d, 0x2a, 0x04, 0x01, 0x00, 0x7e, 0x21, 0xf0, 0x7e, 0x28,
	0xef, 0x7a, 0x22, 0xeb, 0x76, 0x30, 0xf6, 0x72, 0x22, 0xf5, 0x6e, 0x22,
	0xf4, 0x66, 0x30, 0xed, 0x1e, 0x3f, 0x5a, 0x27, 0x07, 0x0d, 0x2a, 0x04,
	0x01, 0x00, 0x7e, 0x25, 0x0c, 0x3e, 0x21, 0x78, 0x07, 0x34, 0x0d, 0x2a,
	0x04, 0x01, 0x00, 0x7e, 0x21, 0x0c, 0x78, 0x18, 0x76, 0x21, 0x10, 0x70,
	0x1c, 0x7a, 0x21, 0x13, 0x7c, 0x1f, 0x25, 0x28, 0xf4, 0x3c, 0x25, 0x28,
	0xf4, 0x3c, 0x25, 0x28, 0xf4, 0x3c, 0x25, 0x28, 0xe8, 0x3c, 0x25, 0x28,
	0xe8, 0x3c, 0x0d, 0x2a, 0x04, 0x01, 0x00, 0x7e, 0x21, 0x0c, 0x36, 0x3f,
	0x7a, 0x21, 0x05, 0x1e, 0x2f, 0x36, 0x21, 0x0d, 0x2a, 0x04, 0x01, 0x00,
	0x3e, 0x28, 0x6a, 0x21, 0xf6, 0x74, 0xf1, 0x72, 0x21, 0xef, 0x0d, 0x2a,
	0x04, 0x01, 0x00, 0x7e, 0x26, 0xee, 0x3e, 0x21, 0x3e, 0x22, 0x3e, 0x21,
	0x7c, 0xfa, 0x25, 0x38, 0x0c, 0x3c, 0x25, 0x38, 0x0c, 0x3c, 0x25, 0x38,
	0x0c, 0x3c, 0x25, 0x38, 0x0c, 0x3c, 0x25, 0x38, 0x0c, 0x3c, 0x25, 0x38,
	0x0c, 0x3c, 0x0d, 0x2a, 0x04, 0x01, 0x00, 0x3e, 0x21, 0x7c, 0x0d, 0x7e,
	0x21, 0x02, 0x7c, 0x0e, 0x7c, 0x03, 0x7c, 0x0f, 0x0d, 0x2a, 0x04, 0x01,
	0x00, 0x02, 0x20, 0x0d, 0x2a, 0x04, 0x01, 0x00, 0x05, 0x5a, 0x45, 0x3a,
	0xfd, 0xff, 0x45, 0x5a, 0xf9, 0xff, 0x45, 0x3a, 0xf7, 0xff, 0x45, 0x5a,
	0xf5, 0xff, 0x45, 0x3a, 0xf3, 0xff, 0x45, 0x5a, 0xf0, 0xff, 0x45, 0x3a,
	0xed, 0xff, 0x45, 0x5a, 0xe9, 0xff, 0x45, 0x3a, 0xe7, 0xff, 0x0d, 0x2a,
	0x04, 0x01, 0x00, 0x25, 0x38, 0x26, 0x25, 0x38, 0x1c, 0x25, 0x38, 0x24,
	0x25, 0x38, 0x14, 0x25, 0x38, 0x1c, 0x25, 0x38, 0x0c, 0x25, 0x38, 0x14,
	0x25, 0x38, 0x04, 0x25, 0x38, 0x0c, 0x25, 0x38, 0xfc, 0x25, 0x38, 0x04,
	0x25, 0x38, 0xf2, 0x25, 0x38, 0xeb, 0x0d, 0x2a, 0x04, 0x01, 0x00, 0x3e,
	0x21, 0xb4, 0x0e, 0x00, 0xb0, 0x1b, 0x00, 0x0d, 0x2a, 0x04, 0x01, 0x00,
	0x26, 0x1b, 0x2e, 0x05, 0x3e, 0x08, 0x36, 0x10, 0x2e, 0x05, 0x0d, 0x2a,
	0x04, 0x40, 0x00, 0x00, 0x00, 0x74, 0x05, 0x00, 0x75, 0x05, 0x75, 0x05,
	0x75, 0x05, 0x01, 0x6a, 0x05, 0x00, 0x42, 0x80, 0x00, 0x00, 0x00};

#endif