;;-----------------------------LICENSE NOTICE------------------------------------
;;  This file is part of Nightmare Fortress: An Amstrad CPC Game 
;;  Copyright (C) 2017 Natalia Bernal Pérez / Álvaro Esteve Bernabeu / Plácido Antonio López Ávila
;;
;;  Nightmare Fortress is free software: you can redistribute it and/or modify
;;  it under the terms of the GNU Lesser General Public License as published by
;;  the Free Software Foundation, either version 3 of the License, or
;;  (at your option) any later version.
;;
;;  Nightmare Fortress is distributed in the hope that it will be useful,
;;  but WITHOUT ANY WARRANTY; without even the implied warranty of
;;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;  GNU Lesser General Public License for more details.
;;
;;  You should have received a copy of the GNU Lesser General Public License
;;  along with Nightmare Fortress.  If not, see <http://www.gnu.org/licenses/>.
;;-------------------------------------------------------------------------------

.area _DATA
.area _CODE


;;-----------------------------------------------------------------------
;;PRIVATE DATA 
;;-----------------------------------------------------------------------
.include "cpctelera.h.s"
.include "utils.h.s"
.include "macros.h.s"
.include "sprites/sprites.h.s"
.include "gameController.h.s"
.include "dobleBuffer.h.s"
.include "gameController.h.s"
.include "stage.h.s"
.include "actors/enemy.h.s"
.include "actors/object.h.s"
.include "interface.h.s"
.include "actors/character.h.s"


.macro createStageAux name, arrayEnemigos, arrayObjetos 
	name'_data_aux::
		name'_array_enemigos:: .dw arrayEnemigos
		name'_array_objetos::  .dw arrayObjetos
.endm

.macro entityRecovery x, y, tipoEntidad
	.db x
	.db y
	.db tipoEntidad
.endm 


.equ xr, 0 ;; LA X
.equ yr, 1 ;; LA Y
.equ tr, 2 ;; LA T

.equ enemies_aux_l, 0
.equ enemies_aux_h, 1

.equ items_aux_l, 2
.equ items_aux_h, 3



beg_recover::

createStageAux level01, #level01_enemies_aux, #level01_items_aux 
createStageAux level02, #level02_enemies_aux, #level02_items_aux 
createStageAux level03, #level03_enemies_aux, #level03_items_aux 
createStageAux level04, #level04_enemies_aux, #level04_items_aux 
createStageAux level05, #level05_enemies_aux, #level05_items_aux 
createStageAux level06, #level06_enemies_aux, #level06_items_aux 
createStageAux level07, #level07_enemies_aux, #level07_items_aux 
createStageAux level08, #level08_enemies_aux, #level08_items_aux 
createStageAux level09, #level09_enemies_aux, #level09_items_aux 
createStageAux level10, #level10_enemies_aux, #level10_items_aux 
createStageAux level11, #level11_enemies_aux, #level11_items_aux 
createStageAux level12, #level12_enemies_aux, #level12_items_aux 
createStageAux level13, #level13_enemies_aux, #level13_items_aux 
createStageAux level14, #level14_enemies_aux, #level14_items_aux 
createStageAux level15, #level15_enemies_aux, #level15_items_aux 
createStageAux level16, #level16_enemies_aux, #level16_items_aux 
createStageAux level17, #level17_enemies_aux, #level17_items_aux 
createStageAux level18, #level18_enemies_aux, #level18_items_aux 
createStageAux level19, #level19_enemies_aux, #level19_items_aux 
createStageAux level20, #level20_enemies_aux, #level20_items_aux 
;; 1 RANA
;; 2 CABALLERO
;; 3 MAGO
;; 4 JEFE

;; 5 COIN
;; 6 POLLO
;; 7 CORAZON
;; 8 LLAVE
;; 9 PUERTA_DERECHA
;; 10 PUERTA_ARRIBA
;; 11 PUERTA_ABAJO





level20_items_aux:
	entityRecovery #0x0C, #0xA4, #11
	entityRecovery #0xFE, #0x50, #8

	.db #0xFF

level20_enemies_aux:
	entityRecovery #0x27, #0x56, #3
	entityRecovery #0x07, #0x96, #2
	entityRecovery #0x43, #0x96, #2
	

	.db #0xFF

level19_items_aux:

	.db #0xFF

level19_enemies_aux:
	entityRecovery #0x27, #0x56, #4
	entityRecovery #0x23, #0x0C, #2
	entityRecovery #0x23, #0x9A, #2
	entityRecovery #0x47, #0x54, #2

	.db #0xFF

level18_items_aux:


	entityRecovery #0x4A, #0x58, #9
	entityRecovery #0x13, #0x5E, #6
	entityRecovery #0x06, #0x5E, #6
	entityRecovery #0x15, #0x3A, #6
	entityRecovery #0x06, #0x3A, #6
	entityRecovery #0x0D, #0x4C, #6

	.db #0xFF

level18_enemies_aux:

	.db #0xFF

level17_items_aux:

	entityRecovery #0x24, #0x14, #5
	entityRecovery #0x1D, #0x3A, #6
	entityRecovery #0x2D, #0x3C, #5
	entityRecovery #0x24, #0x3A, #8

	.db #0xFF

level17_enemies_aux:

	entityRecovery #0x0F, #0x5E, #2
	entityRecovery #0x40, #0x3E, #2
	entityRecovery #0x25, #0x54, #2

	.db #0xFF

level16_items_aux:
	entityRecovery #0x26, #0x6E, #6
	entityRecovery #0x26, #0x22, #6
	entityRecovery #0x0E, #0x8A, #6
	entityRecovery #0x3E, #0x1A, #7

	.db #0xFF

level16_enemies_aux:
	entityRecovery #0x44, #0x45, #2
	entityRecovery #0x15, #0x48, #2

	.db #0xFF


level15_items_aux:
	entityRecovery #0x3F, #0x14, #5
	entityRecovery #0x24, #0x1A, #6
	entityRecovery #0x0B, #0x1A, #5
	
	.db #0xFF

level15_enemies_aux:
	entityRecovery #0x44, #0x36, #2
	entityRecovery #0x1E, #0x5E, #2
	entityRecovery #0x0B, #0x54, #2

	.db #0xFF



level14_items_aux:
	entityRecovery #0x13, #0x7A, #5
	entityRecovery #0x13, #0x26, #6

	.db #0xFF

level14_enemies_aux:
	entityRecovery #0x3A, #0x28, #2

	.db #0xFF

level13_items_aux:
	entityRecovery #0x1D, #0x98, #7

	.db #0xFF

level13_enemies_aux:
	entityRecovery #0x25, #0x16, #2
	entityRecovery #0x28, #0x70, #2
	entityRecovery #0x40, #0x5E, #2

	.db #0xFF

level12_items_aux:
	entityRecovery #0x37, #0x12, #5
	entityRecovery #0x47, #0x14, #5

	.db #0xFF

level12_enemies_aux:
	entityRecovery #0x11, #0x88, #2
	entityRecovery #0x20, #0x38, #2
	entityRecovery #0x3F, #0x3E, #2

	.db #0xFF


level11_items_aux:
	entityRecovery #0x25, #0x76, #8
	entityRecovery #0x06, #0x98, #6
	entityRecovery #0x35, #0x96, #5
	entityRecovery #0x09, #0x12, #5
	
	.db #0xFF

level11_enemies_aux:
	entityRecovery #0x0E, #0x84, #2
	entityRecovery #0x37, #0x12, #2
	entityRecovery #0x3D, #0x90, #2

	.db #0xFF


level10_items_aux:
	entityRecovery #0x05, #0x14, #5
	
	.db #0xFF

level10_enemies_aux:
	entityRecovery #0x2F, #0x3E, #2
	entityRecovery #0x34, #0x98, #2
	entityRecovery #0x2A, #0x68, #2

	.db #0xFF

level09_items_aux:
	entityRecovery #0x22, #0x3C, #5
	entityRecovery #0x0B, #0x1E, #6

	.db #0xFF

level09_enemies_aux:
	entityRecovery #0x0A, #0x80, #2
	entityRecovery #0x0B, #0x48, #2
	entityRecovery  #0x3B, #0x13, #2

	.db #0xFF



level08_items_aux:
	entityRecovery #0x26, #0x00, #10
	entityRecovery #0x08, #0x6A, #7
	
	.db #0xFF

level08_enemies_aux:
	entityRecovery #0x1D, #0x7E, #1
	entityRecovery #0x1E, #0x24, #1
	entityRecovery #0x3D, #0x76, #1
	entityRecovery #0x47, #0x2A, #1

	.db #0xFF

level07_items_aux:
	entityRecovery #0x0A, #0x72, #5
	entityRecovery #0x3F, #0x92, #5
	entityRecovery #0x09, #0x1E, #5
	entityRecovery #0x1E, #0x72, #6
	
	.db #0xFF

level07_enemies_aux:
	entityRecovery #0x19, #0x98, #1
	entityRecovery #0x33, #0x68, #1
	entityRecovery #0x21, #0x25, #1
	entityRecovery #0x3A, #0x10, #1
	
	.db #0xFF

level06_items_aux:
	entityRecovery #0x4A, #0x80, #9
	entityRecovery #70, #16, #5
	entityRecovery #71, #152, #8
	entityRecovery #71, #105, #7

	.db #0xFF

level06_enemies_aux:
	entityRecovery #0x3B, #0x7C, #1
	entityRecovery #0x1E, #0x98, #1
	entityRecovery #0x25, #0x72, #1
	entityRecovery #0x33, #0x34, #1
	
	.db #0xFF

level05_items_aux:
	entityRecovery #70, #14, #5
	entityRecovery #7, #14, #6
	entityRecovery #70, #154, #5

	.db #0xFF

level05_enemies_aux:
	entityRecovery #0x24, #0x58, #1
	entityRecovery #0x23, #0x0C, #1
	entityRecovery #0x3D, #0x58, #1
	
	.db #0xFF

level04_items_aux:
	entityRecovery #25, #150, #6
	entityRecovery #7, #14, #5
	entityRecovery #64, #14, #5
	entityRecovery #64, #150, #5
	entityRecovery #7, #150, #5
	entityRecovery #50, #150, #7

	.db #0xFF

level04_enemies_aux:
	.db #0xFF

level03_items_aux:
	entityRecovery #68, #29, #8
	entityRecovery #8, #153, #6

	.db #0xFF

level03_enemies_aux:
	entityRecovery #0x05, #0x44, #1
	entityRecovery #0x0D, #0x42, #1
	entityRecovery #0x38, #0x7E, #1
	entityRecovery #0x1B, #0x32, #1
	
	.db #0xFF

level02_items_aux:
	entityRecovery #67, #150, #5
	entityRecovery #72, #27, #5

	.db #0xFF

level02_enemies_aux:
	entityRecovery #40, #99, #1
	entityRecovery #45, #19, #1
	entityRecovery #62, #150, #1
	
	.db #0xFF

level01_items_aux:
	entityRecovery #16, #0, #10
	entityRecovery #5, #115, #5
	entityRecovery #70, #25, #5

	.db #0xff

level01_enemies_aux:
	entityRecovery #10, #10, #1
	entityRecovery #45, #14, #1
	entityRecovery #70, #55, #1	

	.db #0xFF

end_recover::


recovery::
	ld de, #level01_enemies_aux
	ld ix, #level01_data
	ld h, enemies_h(ix)
	ld l, enemies_l(ix)

	call copy_arrays_enemies

	ld de, #level01_items_aux
	ld ix, #level01_data
	ld h, objects_h(ix)
	ld l, objects_l(ix)

	call copy_arrays_items

	ld de, #level02_enemies_aux
	ld ix, #level02_data
	ld h, enemies_h(ix)
	ld l, enemies_l(ix)

	call copy_arrays_enemies

	ld de, #level02_items_aux
	ld ix, #level02_data
	ld h, objects_h(ix)
	ld l, objects_l(ix)

	call copy_arrays_items

	ld de, #level03_enemies_aux
	ld ix, #level03_data
	ld h, enemies_h(ix)
	ld l, enemies_l(ix)

	call copy_arrays_enemies

	ld de, #level03_items_aux
	ld ix, #level03_data
	ld h, objects_h(ix)
	ld l, objects_l(ix)

	call copy_arrays_items

	ld de, #level04_enemies_aux
	ld ix, #level04_data
	ld h, enemies_h(ix)
	ld l, enemies_l(ix)

	call copy_arrays_enemies

	ld de, #level04_items_aux
	ld ix, #level04_data
	ld h, objects_h(ix)
	ld l, objects_l(ix)

	call copy_arrays_items

	ld de, #level05_enemies_aux
	ld ix, #level05_data
	ld h, enemies_h(ix)
	ld l, enemies_l(ix)

	call copy_arrays_enemies

	ld de, #level05_items_aux
	ld ix, #level05_data
	ld h, objects_h(ix)
	ld l, objects_l(ix)

	call copy_arrays_items

	ld de, #level06_enemies_aux
	ld ix, #level06_data
	ld h, enemies_h(ix)
	ld l, enemies_l(ix)

	call copy_arrays_enemies

	ld de, #level06_items_aux
	ld ix, #level06_data
	ld h, objects_h(ix)
	ld l, objects_l(ix)

	call copy_arrays_items

	ld de, #level07_enemies_aux
	ld ix, #level07_data
	ld h, enemies_h(ix)
	ld l, enemies_l(ix)

	call copy_arrays_enemies

	ld de, #level07_items_aux
	ld ix, #level07_data
	ld h, objects_h(ix)
	ld l, objects_l(ix)

	call copy_arrays_items

	ld de, #level08_enemies_aux
	ld ix, #level08_data
	ld h, enemies_h(ix)
	ld l, enemies_l(ix)

	call copy_arrays_enemies

	ld de, #level08_items_aux
	ld ix, #level08_data
	ld h, objects_h(ix)
	ld l, objects_l(ix)

	call copy_arrays_items

	ld de, #level09_enemies_aux
	ld ix, #level09_data
	ld h, enemies_h(ix)
	ld l, enemies_l(ix)

	call copy_arrays_enemies

	ld de, #level09_items_aux
	ld ix, #level09_data
	ld h, objects_h(ix)
	ld l, objects_l(ix)

	call copy_arrays_items

	ld de, #level10_enemies_aux
	ld ix, #level10_data
	ld h, enemies_h(ix)
	ld l, enemies_l(ix)

	call copy_arrays_enemies

	ld de, #level10_items_aux
	ld ix, #level10_data
	ld h, objects_h(ix)
	ld l, objects_l(ix)

	call copy_arrays_items

	ld de, #level11_enemies_aux
	ld ix, #level11_data
	ld h, enemies_h(ix)
	ld l, enemies_l(ix)

	call copy_arrays_enemies

	ld de, #level11_items_aux
	ld ix, #level11_data
	ld h, objects_h(ix)
	ld l, objects_l(ix)

	call copy_arrays_items

	ld de, #level12_enemies_aux
	ld ix, #level12_data
	ld h, enemies_h(ix)
	ld l, enemies_l(ix)

	call copy_arrays_enemies

	ld de, #level12_items_aux
	ld ix, #level12_data
	ld h, objects_h(ix)
	ld l, objects_l(ix)

	call copy_arrays_items

	ld de, #level13_enemies_aux
	ld ix, #level13_data
	ld h, enemies_h(ix)
	ld l, enemies_l(ix)

	call copy_arrays_enemies

	ld de, #level13_items_aux
	ld ix, #level13_data
	ld h, objects_h(ix)
	ld l, objects_l(ix)

	call copy_arrays_items

	ld de, #level14_enemies_aux
	ld ix, #level14_data
	ld h, enemies_h(ix)
	ld l, enemies_l(ix)

	call copy_arrays_enemies

	ld de, #level14_items_aux
	ld ix, #level14_data
	ld h, objects_h(ix)
	ld l, objects_l(ix)

	call copy_arrays_items

	ld de, #level15_enemies_aux
	ld ix, #level15_data
	ld h, enemies_h(ix)
	ld l, enemies_l(ix)

	call copy_arrays_enemies

	ld de, #level15_items_aux
	ld ix, #level15_data
	ld h, objects_h(ix)
	ld l, objects_l(ix)

	call copy_arrays_items

	ld de, #level16_enemies_aux
	ld ix, #level16_data
	ld h, enemies_h(ix)
	ld l, enemies_l(ix)

	call copy_arrays_enemies

	ld de, #level16_items_aux
	ld ix, #level16_data
	ld h, objects_h(ix)
	ld l, objects_l(ix)

	call copy_arrays_items

	ld de, #level17_enemies_aux
	ld ix, #level17_data
	ld h, enemies_h(ix)
	ld l, enemies_l(ix)

	call copy_arrays_enemies

	ld de, #level17_items_aux
	ld ix, #level17_data
	ld h, objects_h(ix)
	ld l, objects_l(ix)

	call copy_arrays_items

	ld de, #level18_enemies_aux
	ld ix, #level18_data
	ld h, enemies_h(ix)
	ld l, enemies_l(ix)

	call copy_arrays_enemies

	ld de, #level18_items_aux
	ld ix, #level18_data
	ld h, objects_h(ix)
	ld l, objects_l(ix)

	call copy_arrays_items

	ld de, #level19_enemies_aux
	ld ix, #level19_data
	ld h, enemies_h(ix)
	ld l, enemies_l(ix)

	call copy_arrays_enemies

	ld de, #level19_items_aux
	ld ix, #level19_data
	ld h, objects_h(ix)
	ld l, objects_l(ix)

	call copy_arrays_items

	ld de, #level20_enemies_aux
	ld ix, #level20_data
	ld h, enemies_h(ix)
	ld l, enemies_l(ix)

	call copy_arrays_enemies

	ld de, #level20_items_aux
	ld ix, #level20_data
	ld h, objects_h(ix)
	ld l, objects_l(ix)

	call copy_arrays_items

	ld hl, #level01_data
	ld (currentStage), hl

	BREAKPOINT::
	ld h, #0
	ld l, #80
	ld (hp_number), hl
	ld (maxhp_number), hl
	ld hl, #0x0000
	ld (score_number), hl
	ld a, #0
	ld (numberkeys_number), a

	call character_getPtrIX
	ld a, #12
	ld b, #150 
	ld x(ix), a
	ld y(ix), b

	ret


copy_arrays_items:
	ld bc, (object_size_in_bytes)
	ld b, #0

	loop_recovery_items:
		ld a, (de)
		cp #0xFF
		ret z

		ld (hl), a

		inc hl
		inc de

		ld a, (de)
		ld (hl), a

		dec hl
		dec de 

		add hl, bc
		 
		inc de
		inc de
		inc de 

		jp loop_recovery_items
	
		ret

copy_arrays_enemies:
	ld bc, (enemy_size_in_bytes)
	ld b, #0
	loop_recovery_enemy:
		ld a, (de)
		cp #0xFF
		ret z

		ld (hl), a

		inc hl
		inc de

		ld a, (de)
		ld (hl), a


		dec hl
		dec de 
		push hl
		pop ix

		ld a, #1
		ld vivo_muerto(ix), a

		ld a, #0
		ld state(ix), a
		ld last_state(ix), a 

		push de
		pop iy

		ld a, tr(iy)
		cp #1
		call z, esRana
		cp #2
		call z, esCaballero
		cp #3
		call z, esMago
		cp #4
		call z, esJefe


		

		add hl, bc
		inc de 
		inc de 
		inc de 

		jp loop_recovery_enemy
	ret




esRana:
	ld life(ix), #30
	ret
esCaballero:
	ld life(ix), #40
	ret
esMago:
	ld life(ix), #190
	ret
esJefe:
	ld life(ix), #240
	ret

fin_RECOVERY::
