;;-----------------------------LICENSE NOTICE------------------------------------
;;  This file is part of Nightmare Fortress: An Amstrad CPC Game 
;;  Copyright (C) 2017 Natalia Bernal Pérez / Álvaro Esteve Bernabeu / Plácido Antonio López Ávila
;;
;;  Nightmare Fortress is free software: you can redistribute it and/or modify
;;  it under the terms of the GNU Lesser General Public License as published by
;;  the Free Software Foundation, either version 3 of the License, or
;;  (at your option) any later version.
;;
;;  Nightmare Fortress is distributed in the hope that it will be useful,
;;  but WITHOUT ANY WARRANTY; without even the implied warranty of
;;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;  GNU Lesser General Public License for more details.
;;
;;  You should have received a copy of the GNU Lesser General Public License
;;  along with Nightmare Fortress.  If not, see <http://www.gnu.org/licenses/>.
;;-------------------------------------------------------------------------------

.area _DATA
.area _CODE
    .globl _g_palette
 
 .include "tilesets/tilesets.h.s"

.include "actors/character.h.s"
.include "cpctelera.h.s"
.include "utils.h.s"
.include "actors/enemy.h.s"
.include "gameController.h.s"
.include "dobleBuffer.h.s"
.include "sprites/sprites.h.s"
.include "interface.h.s"
.include "actors/object.h.s"
.include "actors/shoot.h.s"
.include "stage.h.s"
.include "menu.h.s"
hzmusic: .db #6
hzmusic50: .db #3

.globl _g_song_game
;;--------------------------------------------------------------------------------------------------------


_main::
  
    ;; IMPORTANTE: Es necesario cambiar la pila de sitio antes de hacer nada mas. Debe ser lo primero en el main.
    ld hl, #0x8000 ;; Lugar de la memoria al que se va a mover la pila
    call cpct_setStackLocation_asm ;; Cambia la pila de sitio

    call initialize                   ;;Se inicializa la paleta, modo de video, etc

    

    call menu_loop
    ld hl, #isr
    call cpct_setInterruptHandler_asm
    ;; Interrupciones para la musica
    call cpct_akp_stop_asm
    ld de, #_g_song_game
    call cpct_akp_musicInit_asm

    



    ld hl, #_g_garden_tileset                ;;HL = puntero a tileset a utilizar
    call cpct_etm_setTileset2x4_asm   ;;Se establece el tileset de la linea de arriba como el que se va a usar

    ld ix, (currentStage)
    ld h, tilemap_h(ix)
    ld l, tilemap_l(ix)


    call descomprimir_tilemap
    call background_paint             ;;Se pinta el tilemap en C000
    call init_interface		      ;; Se pinta la interfaz en C000
    call switchBuffers	  	      ;; Se cambian los buffers
    call background_paint	      ;; Se pinta el tilemap en 8000
    call init_interface		      ;; Se pinta la interfaz en 8000
    call switchBuffers		      ;; Se vuelven a cambiar los buffers para que comience el juego

    call check_door

beg:  

    call stage_check_exits
    call check_player_hp

    call character_erase
    call erase_shoots
    call erase_enemies

   

    call character_check_input
    
    call update_objects
    call update_enemies
    call update_shoots
    

    call draw_objects
    call character_draw
    call draw_enemies
    call draw_shoots

    call shoot_update_xy
    call enemy_update_xy

    call character_getPtrIX
    call character_update_xy

    call special_stage_function
    call update_maxhp_interface
    call update_hp_interface
    call update_score_interface
    call update_key_interface
 
    call cpct_waitVSYNC_asm           ;;Esperamos al vsync 
    call switchBuffers
    jp beg                            ;;Se vuelve a comenzar
    




isr::

  ex af, af'
  exx
  push af
  push bc
  push de
  push hl
  push iy

  ld a, (hzmusic)
  dec a
  ld (hzmusic), a
  jr nz, return

  call cpct_akp_musicPlay_asm
  ld a, #6
  ld (hzmusic), a

  return:
    pop iy
    pop hl
    pop de
    pop bc
    pop af
    exx
    ex af, af'

  ret

  isr50::

  ex af, af'
  exx
  push af
  push bc
  push de
  push hl
  push iy

  ld a, (hzmusic50)
  dec a
  ld (hzmusic50), a
  jr nz, return50

  call cpct_akp_musicPlay_asm
  ld a, #5
  ld (hzmusic50), a

  return50:
    pop iy
    pop hl
    pop de
    pop bc
    pop af
    exx
    ex af, af'

  ret

isr_void::
  ret







