;;-----------------------------LICENSE NOTICE------------------------------------
;;  This file is part of Nightmare Fortress: An Amstrad CPC Game 
;;  Copyright (C) 2017 Natalia Bernal Pérez / Álvaro Esteve Bernabeu / Plácido Antonio López Ávila
;;
;;  Nightmare Fortress is free software: you can redistribute it and/or modify
;;  it under the terms of the GNU Lesser General Public License as published by
;;  the Free Software Foundation, either version 3 of the License, or
;;  (at your option) any later version.
;;
;;  Nightmare Fortress is distributed in the hope that it will be useful,
;;  but WITHOUT ANY WARRANTY; without even the implied warranty of
;;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;  GNU Lesser General Public License for more details.
;;
;;  You should have received a copy of the GNU Lesser General Public License
;;  along with Nightmare Fortress.  If not, see <http://www.gnu.org/licenses/>.
;;-------------------------------------------------------------------------------

.area _DATA
.area _CODE
    

.include "cpctelera.h.s"
.include "utils.h.s"
.include "gameController.h.s"
.include "sprites/sprites.h.s"
.include "dobleBuffer.h.s"
.include "actors/character.h.s"
.include "recover.h.s"
.include "stage.h.s"
.globl _g_song_game

game_over: .asciz "Game Over"
reset_label: .asciz "Use R to reset"
reset: .asciz "Reset to play again"
 scoreL: .asciz "SCORE"
 
 score_string: .asciz "00000"
 score_number:: .dw #0000

 hpL: .asciz "HP"

 hp_string: .asciz "000"
 hp_number:: .dw #80

 barra: .asciz "/"

 maxhp_string: .asciz "000"
 maxhp_number::  .dw #80
numberkeys_number::  .db #0
numberkeys_string: .asciz "0"

cero: .asciz "0"
uno: .asciz "1"
dos: .asciz "2"
tres: .asciz "3"
letterX: .asciz "x"
.globl isr_void
.globl isr

;;------------------------------------------------
;; Rutina para pintar toda la interfaz al inicio del juego 
;; (AQUI NO SE ACTUALIZA, SOLO SE PINTA POR PRIMERA VEZ)
;;------------------------------------------------
init_interface::

      
  ld a, #0xC3
  push af
  ld hl, (pointerScreen)
  ex de, hl
  ld c, #0
  ld b, #180
  call cpct_getScreenPtr_asm 
  ex de, hl
  pop af
  ld c, #64
  ld b, #20
  call cpct_drawSolidBox_asm 


  ld a, #0xC3
  push af
  ld hl, (pointerScreen)
  ex de, hl
  ld c, #64
  ld b, #180
  call cpct_getScreenPtr_asm 
  ex de, hl
  pop af
  ld c, #64
  ld b, #20
  call cpct_drawSolidBox_asm 

                            ;; Escribimos en la interfaz SCORE
  ld hl, (pointerScreen)
  ex de, hl
  ld c, #59
  ld b, #182
  ;ld c, #31
  ;ld b, #130
  call cpct_getScreenPtr_asm 
  ex de, hl
  ld   hl, #scoreL              ;; HL = Pointer to the start of the string
  ld   bc, #0x090D              ;; B = Background colour, C = Foreground colour
  call cpct_drawStringM0_asm    ;; Call the string drawing function


  


  call update_score_interface     ;; Escribimos en la interfaz cuanto score llevamos
   



                          ;; Pintamos el sprite del corazon al lado de los numeros que indican los HP
  ld hl, (pointerScreen)
  ex de, hl
  ld c, #22
  ld b, #182
  call cpct_getScreenPtr_asm 
  ex de, hl
  ld c, #4
  ld b, #16
  ld hl, #_g_heart
  call cpct_drawSpriteMasked_asm 

  call update_hp_interface

                          ;; Escribimos una barra entre HP  y HP MAX
  ld hl, (pointerScreen)
  ex de, hl
  ld c, #40
  ld b, #187
  call cpct_getScreenPtr_asm 
  ex de, hl
  ld   hl, #barra           ;; HL = Pointer to the start of the string
  ld   bc, #0x090F          ;; B = Background colour, C = Foreground colour
  call cpct_drawStringM0_asm



  call update_maxhp_interface

  ;; Pintamos el sprite de la llave
  ld hl, (pointerScreen)
  ex de, hl
  ld c, #6
  ld b, #183
  call cpct_getScreenPtr_asm 
  ex de, hl
  ld c, #4
  ld b, #16
  ld hl, #_g_key
  call cpct_drawSpriteMasked_asm 

  ld hl, (pointerScreen)
  ex de, hl
  ld c, #10
  ld b, #187
  call cpct_getScreenPtr_asm 
  ex de, hl
  ld   hl, #letterX           ;; HL = Pointer to the start of the string
  ld   bc, #0x090F          ;; B = Background colour, C = Foreground colour
  call cpct_drawStringM0_asm

  call update_key_interface

  ret


;;------------------------------------------------
;; Rutina para repintar en la interfaz el valor de HP
;;------------------------------------------------
update_hp_interface::
	ld hl, (hp_number)      ;; Escribimos en la interfaz cuanta vida nos queda
  	ld de, #hp_string 
  	call Num2Dec8b
  	ld hl, (pointerScreen)
  ex de, hl
  	ld c, #28
  	ld b, #187
  	call cpct_getScreenPtr_asm 
  	ex de, hl
  	ld   hl, #hp_string           ;; HL = Pointer to the start of the string
    ld a, (hp_number)
    cp #21
    jp nc, mayorDeDiez
      ld bc, #0x0906
      jp pinta_texto
    mayorDeDiez:
  	ld   bc, #0x090F              ;; B = Background colour, C = Foreground colour

    pinta_texto:
  	call cpct_drawStringM0_asm    ;; Call the string drawing function
		ret


;;------------------------------------------------
;; Rutina para repintar en la interfaz el valor de Max HP
;;------------------------------------------------
update_maxhp_interface::
  ld hl, (maxhp_number)   ;; Escribimos en la interfaz cuanta vida maxima tenemos
  ld de, #maxhp_string 
  call Num2Dec8b
  ld hl, (pointerScreen)
  ex de, hl
  ld c, #43
  ld b, #187
  call cpct_getScreenPtr_asm 
  ex de, hl
  ld   hl, #maxhp_string      ;; HL = Pointer to the start of the string
  ld   bc, #0x090F            ;; B = Background colour, C = Foreground colour
  call cpct_drawStringM0_asm  ;; Call the string drawing function
	ret

;;------------------------------------------------
;; Rutina para repintar en la interfaz el valor de Score
;;------------------------------------------------
update_score_interface::
  ld hl, (score_number)     ;; Escribimos en la interfaz cuanto score llevamos
  ld de, #score_string
  call Num2Dec16b
  ld hl, (pointerScreen)
  ex de, hl
  ld c, #59
  ld b, #191
  call cpct_getScreenPtr_asm 
  ex de, hl
  ld   hl, #score_string        ;; HL = Pointer to the start of the string
  ld   bc, #0x090F              ;; B = Background colour, C = Foreground colour
  call cpct_drawStringM0_asm    ;; Call the string drawing function
  ret

;;------------------------------------------------
;; Rutina para repintar en la interfaz el valor de keys
;;------------------------------------------------
update_key_interface::
  ld a, (numberkeys_number)     ;; Escribimos en la interfaz cuantas keys tenemos
  dec a
  jr z, unaLlave
  dec a
  jr z, dosLlaves
  dec a
  jr z, tresLlaves
  jp noLlave

  unaLlave:
    ld a, (uno)
    ld (numberkeys_string), a
    jp draw_number_key

  dosLlaves:
    ld a, (dos)
    ld (numberkeys_string), a
    jp draw_number_key

  tresLlaves:
    ld a, (tres)
    ld (numberkeys_string), a
    jp draw_number_key

  noLlave:
    ld a, (cero)
    ld (numberkeys_string), a
    jp draw_number_key
    
  draw_number_key:
  ld hl, (pointerScreen)
  ex de, hl
  ld c, #14
  ld b, #187
  call cpct_getScreenPtr_asm 
  ex de, hl
  ld   hl, #numberkeys_string        ;; HL = Pointer to the start of the string
  ld   bc, #0x090F              ;; B = Background colour, C = Foreground colour
  call cpct_drawStringM0_asm    ;; Call the string drawing function
  ret



print_game_over:
  ld hl, #isr_void
  call cpct_setInterruptHandler_asm
  call cpct_akp_stop_asm

  ld hl, (pointerScreen)
  ex de, hl
  ld c, #22
  ld b, #96
  ;ld c, #31
  ;ld b, #130
  call cpct_getScreenPtr_asm 
  ex de, hl
  ld   hl, #game_over              ;; HL = Pointer to the start of the string
  ld   bc, #0x0906              ;; B = Background colour, C = Foreground colour
  call cpct_drawStringM0_asm 

  call switchBuffers

  ld hl, (pointerScreen)
  ex de, hl
  ld c, #22
  ld b, #96
  ;ld c, #31
  ;ld b, #130
  call cpct_getScreenPtr_asm 
  ex de, hl
  ld   hl, #game_over              ;; HL = Pointer to the start of the string
  ld   bc, #0x0906              ;; B = Background colour, C = Foreground colour
  call cpct_drawStringM0_asm 

  call switchBuffers

  call print_reset

  juego_terminado:
    call check_reset_key
    cp #1
    jp z, reiniciaJuego
    jp juego_terminado        ;; BUCLE FINAL

  ret

reiniciaJuego::
  call recovery
  ld hl, #level01_data
  call inyectaPunteroMapa

  ld a, #1
  ld (only_once_4), a
  ld (only_once_20), a
  ld (only_once_18), a
  ld (only_once_19), a

  ld a, #0
  ld (es18), a
  ld (cambio_musica), a


  

  ld de, #_g_song_game
  call cpct_akp_musicInit_asm

  ld hl, #isr
  call cpct_setInterruptHandler_asm


  ret 

check_player_hp::
  ld a, (hp_number)
  cp #0
  call z, print_game_over
  ret



print_reset::

  ld a, #2

  bucle_pintado:
    push af 
    ld hl, (pointerScreen)
    ex de, hl
    ld c, #12
    ld b, #105
    ;ld c, #31
    ;ld b, #130
    call cpct_getScreenPtr_asm 
    ex de, hl
    ld   hl, #reset_label              ;; HL = Pointer to the start of the string
    ld   bc, #0x090F             ;; B = Background colour, C = Foreground colour
    call cpct_drawStringM0_asm 
  
    call switchBuffers
    pop af
    dec a
    cp #0
    ret z
    jp bucle_pintado
    
  
    ret
