;;-----------------------------LICENSE NOTICE------------------------------------
;;  This file is part of Nightmare Fortress: An Amstrad CPC Game 
;;  Copyright (C) 2017 Natalia Bernal Pérez / Álvaro Esteve Bernabeu / Plácido Antonio López Ávila
;;
;;  Nightmare Fortress is free software: you can redistribute it and/or modify
;;  it under the terms of the GNU Lesser General Public License as published by
;;  the Free Software Foundation, either version 3 of the License, or
;;  (at your option) any later version.
;;
;;  Nightmare Fortress is distributed in the hope that it will be useful,
;;  but WITHOUT ANY WARRANTY; without even the implied warranty of
;;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;  GNU Lesser General Public License for more details.
;;
;;  You should have received a copy of the GNU Lesser General Public License
;;  along with Nightmare Fortress.  If not, see <http://www.gnu.org/licenses/>.
;;-------------------------------------------------------------------------------

.area _DATA
.area _CODE


;;-----------------------------------------------------------------------
;;PRIVATE DATA 
;;-----------------------------------------------------------------------
.include "cpctelera.h.s"
.include "utils.h.s"
.include "macros.h.s"
.include "sprites/sprites.h.s"
.include "actors/character.h.s"
.include "interface.h.s"
.include "gameController.h.s"


;;TIPOS DE OBETO: (almacenado en el state del objeto)(El ultimo valor del objeto es el valor que se incrementara segun su tipo)
;;	- 1 = Objetos que dan puntos
;;	- 2 = Objetos que dan vida
;;	- 3 = Objetos que aumentan la vida maxima
;;	- 4 = Objetos que abren puertas (llaves)
;;	- 5 = Objetos que se abren con llaves (puertas)

object_size_in_bytes::  .db #12



;;-----------------------------------------------------------------------
;; Rutina para dibujar el objeto. 
;; -> IX debe apuntar al objeto que se quiere pintar
;;-----------------------------------------------------------------------
object_draw::
	ld a, x(ix)
	cp #0
	ret z
	call  entity_draw
	ret


;;-----------------------------------------------------------------------
;; Rutina para borrar el objeto y dejar lo de detras como estaba
;; -> IX debe apuntar al objeto que se quiere borrar
;;-----------------------------------------------------------------------
object_erase::
	call entity_erase
	ret


;;-----------------------------------------------------------------------
;; Rutina para comprobar si el jugador ha cogido el objeto. En caso afirmativo, se destruirá
;; -> IX debe apuntar al objeto que se quiere actualizar
;;-----------------------------------------------------------------------
object_update::
	ld a, x(ix)
	cp #0
	ret z
	cp #0xFE
	jp z, borrar_objeto

	push ix 
	call character_getPtrIX
	push ix
	pop hl
	pop ix
	push ix
	pop de

	call check_collision
	cp #0 
	ret z
	ld a, state(ix)
	cp #5
	jr z, is_door
	destruir_objeto:
		call object_destroy
		ret
	borrar_objeto:
		call entity_erase
		call entity_destroy
		ret
	is_door:
		ld a, (numberkeys_number)
		cp #0
		jr z, cant_open
		call open_door
		call object_destroy
		ret
	cant_open:	
		ret



;;-----------------------------------------------------------------------
;; Rutina para eliminar del juego un objeto
;; -> IX debe apuntar al objeto que se quiere borrar
;;-----------------------------------------------------------------------
object_destroy::
	call object_picked
	call entity_erase
	call entity_destroy
	ret


object_picked:
	ld e, score_or_hp(ix)
	ld a, state(ix)
	dec a
	jp z, esUno
	dec a
	jp z, esDos
	dec a
	jp z, esTres
	dec a
	jp z, esCuatro
	jp dec_number_keys

	esUno:
		jp sumar_score
	esDos:
		jp sumar_hp
	
	esTres: 
		jp sumar_max_hp

	esCuatro:
		jp sumar_number_keys

	sumar_score:
		ld hl, (score_number)
		ld d, #0
		add hl, de
		ld (score_number), hl
		ret

	sumar_hp:
		ld a, (hp_number)
		add e
		ld e, a
		

		ld a, (maxhp_number)
		cp e
		jp c, maxHpSuperado
			ld a, e

		maxHpSuperado:
			ld (hp_number), a
			ret

	sumar_max_hp:
		ld a, (maxhp_number)
		add e
		ld (maxhp_number), a
		ret

	sumar_number_keys:
		ld a, (numberkeys_number)
		ld b, #1
		add b
		ld (numberkeys_number), a
		ret

	dec_number_keys:
		ld a, (numberkeys_number)
		dec a
		ld (numberkeys_number), a
		ret
