##-----------------------------LICENSE NOTICE------------------------------------
##  This file is part of CPCtelera: An Amstrad CPC Game Engine 
##  Copyright (C) 2016 ronaldo / Fremos / Cheesetea / ByteRealms (@FranGallegoBR)
##
##  This program is free software: you can redistribute it and/or modify
##  it under the terms of the GNU Lesser General Public License as published by
##  the Free Software Foundation, either version 3 of the License, or
##  (at your option) any later version.
##
##  This program is distributed in the hope that it will be useful,
##  but WITHOUT ANY WARRANTY; without even the implied warranty of
##  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##  GNU Lesser General Public License for more details.
##
##  You should have received a copy of the GNU Lesser General Public License
##  along with this program.  If not, see <http://www.gnu.org/licenses/>.
##------------------------------------------------------------------------------

############################################################################
##                        CPCTELERA ENGINE                                ##
##                 Automatic image conversion file                        ##
##------------------------------------------------------------------------##
## This file is intended for users to automate image conversion from JPG, ##
## PNG, GIF, etc. into C-arrays.                                          ##
##                                                                        ##
## Macro used for conversion is IMG2SPRITES, which has up to 9 parameters:##
##  (1): Image file to be converted into C sprite (PNG, JPG, GIF, etc)    ##
##  (2): Graphics mode (0,1,2) for the generated C sprite                 ##
##  (3): Prefix to add to all C-identifiers generated                     ##
##  (4): Width in pixels of each sprite/tile/etc that will be generated   ##
##  (5): Height in pixels of each sprite/tile/etc that will be generated  ##
##  (6): Firmware palette used to convert the image file into C values    ##
##  (7): (mask / tileset /)                                               ##
##     - "mask":    generate interlaced mask for all sprites converted    ##
##     - "tileset": generate a tileset array with pointers to all sprites ##
##  (8): Output subfolder for generated .C/.H files (in project folder)   ##
##  (9): (hwpalette)                                                      ##
##     - "hwpalette": output palette array with hardware colour values    ##
## (10): Aditional options (you can use this to pass aditional modifiers  ##
##       to cpct_img2tileset)                                             ##
##                                                                        ##
## Macro is used in this way (one line for each image to be converted):   ##
##  $(eval $(call IMG2SPRITES,(1),(2),(3),(4),(5),(6),(7),(8),(9), (10))) ##
##                                                                        ##
## Important:                                                             ##
##  * Do NOT separate macro parameters with spaces, blanks or other chars.##
##    ANY character you put into a macro parameter will be passed to the  ##
##    macro. Therefore ...,src/sprites,... will represent "src/sprites"   ##
##    folder, whereas ...,  src/sprites,... means "  src/sprites" folder. ##
##                                                                        ##
##  * You can omit parameters but leaving them empty. Therefore, if you   ##
##  wanted to specify an output folder but do not want your sprites to    ##
##  have mask and/or tileset, you may omit parameter (7) leaving it empty ##
##     $(eval $(call IMG2SPRITES,imgs/1.png,0,g,4,8,$(PAL),,src/))        ##
############################################################################

## Example firmware palette definition as variable in cpct_img2tileset format

PALETTE={ 14 1 2 3 4 5 6 9 13 0 15 18 20 24 25 26 }

## Example image conversion
##    This example would convert img/example.png into src/example.{c|h} files.
##    A C-array called pre_example[24*12*2] would be generated with the definition
##    of the image example.png in mode 0 screen pixel format, with interlaced mask.
##    The palette used for conversion is given through the PALETTE variable and
##    a pre_palette[16] array will be generated with the 16 palette colours as 
##	  hardware colour values.

#Tiles
$(eval $(call IMG2SPRITES,img/tiles.png,0,g,4,4,$(PALETTE),tileset,src/tilesets/,hwpalette))
$(eval $(call IMG2SPRITES,img/tiles_menu.png,0,g_menu,4,4,$(PALETTE),tileset,src/tilesets/,))
$(eval $(call IMG2SPRITES,img/tiles_garden.png,0,g_garden,4,4,$(PALETTE),tileset,src/tilesets/,))


#Sprites del personaje
$(eval $(call IMG2SPRITES,img/sprite_front_1.png,0,g,8,16,$(PALETTE),mask,src/sprites/,))
$(eval $(call IMG2SPRITES,img/sprite_front_2.png,0,g,8,16,$(PALETTE),mask,src/sprites/,))
$(eval $(call IMG2SPRITES,img/sprite_side_1.png,0,g,8,16,$(PALETTE),mask,src/sprites/,))
$(eval $(call IMG2SPRITES,img/sprite_side_2.png,0,g,8,16,$(PALETTE),mask,src/sprites/,))
$(eval $(call IMG2SPRITES,img/sprite_back_1.png,0,g,8,16,$(PALETTE),mask,src/sprites/,))
$(eval $(call IMG2SPRITES,img/sprite_back_2.png,0,g,8,16,$(PALETTE),mask,src/sprites/,))
$(eval $(call IMG2SPRITES,img/sprite_left_1.png,0,g,8,16,$(PALETTE),mask,src/sprites/,))
$(eval $(call IMG2SPRITES,img/sprite_left_2.png,0,g,8,16,$(PALETTE),mask,src/sprites/,))


#Sprites de warrior1
$(eval $(call IMG2SPRITES,img/warrior1_front_1.png,0,g,8,16,$(PALETTE),mask,src/sprites/,))
$(eval $(call IMG2SPRITES,img/warrior1_front_2.png,0,g,8,16,$(PALETTE),mask,src/sprites/,))
$(eval $(call IMG2SPRITES,img/warrior1_side_1.png,0,g,8,16,$(PALETTE),mask,src/sprites/,))
$(eval $(call IMG2SPRITES,img/warrior1_side_2.png,0,g,8,16,$(PALETTE),mask,src/sprites/,))
$(eval $(call IMG2SPRITES,img/warrior1_back_1.png,0,g,8,16,$(PALETTE),mask,src/sprites/,))
$(eval $(call IMG2SPRITES,img/warrior1_back_2.png,0,g,8,16,$(PALETTE),mask,src/sprites/,))
$(eval $(call IMG2SPRITES,img/warrior1_left_1.png,0,g,8,16,$(PALETTE),mask,src/sprites/,))
$(eval $(call IMG2SPRITES,img/warrior1_left_2.png,0,g,8,16,$(PALETTE),mask,src/sprites/,))

#Sprites de warrior2
$(eval $(call IMG2SPRITES,img/warrior2_front_1.png,0,g,8,16,$(PALETTE),mask,src/sprites/,))
$(eval $(call IMG2SPRITES,img/warrior2_front_2.png,0,g,8,16,$(PALETTE),mask,src/sprites/,))
$(eval $(call IMG2SPRITES,img/warrior2_side_1.png,0,g,8,16,$(PALETTE),mask,src/sprites/,))
$(eval $(call IMG2SPRITES,img/warrior2_side_2.png,0,g,8,16,$(PALETTE),mask,src/sprites/,))
$(eval $(call IMG2SPRITES,img/warrior2_back_1.png,0,g,8,16,$(PALETTE),mask,src/sprites/,))
$(eval $(call IMG2SPRITES,img/warrior2_back_2.png,0,g,8,16,$(PALETTE),mask,src/sprites/,))
$(eval $(call IMG2SPRITES,img/warrior2_left_1.png,0,g,8,16,$(PALETTE),mask,src/sprites/,))
$(eval $(call IMG2SPRITES,img/warrior2_left_2.png,0,g,8,16,$(PALETTE),mask,src/sprites/,))

#Sprites de items
$(eval $(call IMG2SPRITES,img/pollo.png,0,g,8,16,$(PALETTE),mask,src/sprites/,))
$(eval $(call IMG2SPRITES,img/coin.png,0,g,8,16,$(PALETTE),mask,src/sprites/,))
$(eval $(call IMG2SPRITES,img/mas_hp.png,0,g,8,16,$(PALETTE),mask,src/sprites/,))
$(eval $(call IMG2SPRITES,img/fireball.png,0,g,4,8,$(PALETTE),mask,src/sprites/,))
$(eval $(call IMG2SPRITES,img/heart.png,0,g,8,16,$(PALETTE),mask,src/sprites/,))
$(eval $(call IMG2SPRITES,img/key.png,0,g,8,16,$(PALETTE),mask,src/sprites/,))
$(eval $(call IMG2SPRITES,img/door.png,0,g,12,16,$(PALETTE),mask,src/sprites/,))
$(eval $(call IMG2SPRITES,img/door_right.png,0,g,12,16,$(PALETTE),mask,src/sprites/,))
$(eval $(call IMG2SPRITES,img/door_down.png,0,g,12,16,$(PALETTE),mask,src/sprites/,))

#Sprites del brujo malvado
$(eval $(call IMG2SPRITES,img/evilwizard_front_1.png,0,g,8,16,$(PALETTE),mask,src/sprites/,))
$(eval $(call IMG2SPRITES,img/evilwizard_front_2.png,0,g,8,16,$(PALETTE),mask,src/sprites/,))
$(eval $(call IMG2SPRITES,img/evilwizard_side_1.png,0,g,8,16,$(PALETTE),mask,src/sprites/,))
$(eval $(call IMG2SPRITES,img/evilwizard_side_2.png,0,g,8,16,$(PALETTE),mask,src/sprites/,))
$(eval $(call IMG2SPRITES,img/evilwizard_back_1.png,0,g,8,16,$(PALETTE),mask,src/sprites/,))
$(eval $(call IMG2SPRITES,img/evilwizard_back_2.png,0,g,8,16,$(PALETTE),mask,src/sprites/,))
$(eval $(call IMG2SPRITES,img/evilwizard_left_1.png,0,g,8,16,$(PALETTE),mask,src/sprites/,))
$(eval $(call IMG2SPRITES,img/evilwizard_left_2.png,0,g,8,16,$(PALETTE),mask,src/sprites/,))


#$(eval $(call IMG2SPRITES,img/hombre_lobo.png,0,g,16,32,$(PALETTE),mask,src/sprites/,))
#$(eval $(call IMG2SPRITES,img/esqueleto.png,0,g,16,32,$(PALETTE),mask,src/sprites/,))

#Sprites de rana
$(eval $(call IMG2SPRITES,img/rana_side_1.png,0,g,8,16,$(PALETTE),mask,src/sprites/,))
$(eval $(call IMG2SPRITES,img/rana_side_2.png,0,g,8,16,$(PALETTE),mask,src/sprites/,))
$(eval $(call IMG2SPRITES,img/rana_left_1.png,0,g,8,16,$(PALETTE),mask,src/sprites/,))
$(eval $(call IMG2SPRITES,img/rana_left_2.png,0,g,8,16,$(PALETTE),mask,src/sprites/,))
$(eval $(call IMG2SPRITES,img/rana_front_1.png,0,g,8,16,$(PALETTE),mask,src/sprites/,))
$(eval $(call IMG2SPRITES,img/rana_front_2.png,0,g,8,16,$(PALETTE),mask,src/sprites/,))
$(eval $(call IMG2SPRITES,img/rana_back_1.png,0,g,8,16,$(PALETTE),mask,src/sprites/,))
$(eval $(call IMG2SPRITES,img/rana_back_2.png,0,g,8,16,$(PALETTE),mask,src/sprites/,))

#Sprite de flecha menu
#$(eval $(call IMG2SPRITES,img/arrow.png,0,g,8,16,$(PALETTE),mask,src/sprites/,))





